/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicToggleable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.JavaCoroutines;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedPsiElements(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            ToolActions.$$$reportNull$$$0(0);
        }
        if ((element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof SqlElement) {
            JBIterable jBIterable = SqlPsiFacade.getInstance((Project)element.getProject()).findRelatedDbElements(element, true).filter(PsiElement.class);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        if (element != null) {
            JBIterable jBIterable = JBIterable.of((Object)element);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        Object[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            JBIterable jBIterable = JBIterable.of((Object[])elements);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        VirtualFile vfile = file == null ? null : file.getViewProvider().getVirtualFile();
        DbElement fileElement = vfile == null ? null : DbSrcUtilsCore.findDbElement(file.getProject(), vfile.getPath(), DbElement.class);
        JBIterable jBIterable = JBIterable.of(fileElement);
        if (jBIterable == null) {
            ToolActions.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToolActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToolActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPsiElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class EnableConstraintsAction
    extends ScriptingActionBase {
        public EnableConstraintsAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.EnableConstraintsAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.EnableConstraintsAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.EnableConstraintsAction.description", new Object[0]), AllIcons.Actions.Selectall);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.ENABLE_CONSTRAINTS;
            if (scriptCategory == null) {
                EnableConstraintsAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        @Override
        protected boolean isSupported(@NotNull ScriptGenerator service, @NotNull BasicElement element) {
            BasicToggleable tog;
            if (service == null) {
                EnableConstraintsAction.$$$reportNull$$$0(1);
            }
            if (element == null) {
                EnableConstraintsAction.$$$reportNull$$$0(2);
            }
            return super.isSupported(service, element) && element instanceof BasicToggleable && (tog = (BasicToggleable)element).isDisabled();
        }

        @Override
        protected void fillContext(@NotNull DatabaseRefactoringHandler handler2, Collection<BasicElement> elements) {
            if (handler2 == null) {
                EnableConstraintsAction.$$$reportNull$$$0(3);
            }
            super.fillContext(handler2, elements);
            handler2.include(elements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$EnableConstraintsAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$EnableConstraintsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DisableConstraintsAction
    extends ScriptingActionBase {
        public DisableConstraintsAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.DisableConstraintsAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.DisableConstraintsAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.DisableConstraintsAction.description", new Object[0]), AllIcons.Actions.Suspend);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.DISABLE_CONSTRAINTS;
            if (scriptCategory == null) {
                DisableConstraintsAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        @Override
        protected boolean isSupported(@NotNull ScriptGenerator service, @NotNull BasicElement element) {
            BasicToggleable tog;
            if (service == null) {
                DisableConstraintsAction.$$$reportNull$$$0(1);
            }
            if (element == null) {
                DisableConstraintsAction.$$$reportNull$$$0(2);
            }
            return super.isSupported(service, element) && element instanceof BasicToggleable && !(tog = (BasicToggleable)element).isDisabled();
        }

        @Override
        protected void fillContext(@NotNull DatabaseRefactoringHandler handler2, Collection<BasicElement> elements) {
            if (handler2 == null) {
                DisableConstraintsAction.$$$reportNull$$$0(3);
            }
            super.fillContext(handler2, elements);
            handler2.include(elements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$DisableConstraintsAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$DisableConstraintsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RefreshMatViewAction
    extends ScriptingActionBase {
        public RefreshMatViewAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.description", new Object[0]), DatabaseIcons.RefreshMaterializedView);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.REFRESH;
            if (scriptCategory == null) {
                RefreshMatViewAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$RefreshMatViewAction", "getCategory"));
        }
    }

    public static class TruncateTablesAction
    extends ScriptingActionBase {
        public TruncateTablesAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.description", new Object[0]), AllIcons.Actions.GC);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.TRUNCATE;
            if (scriptCategory == null) {
                TruncateTablesAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getCategory"));
        }
    }

    public static abstract class ScriptingActionBase
    extends DumbAwareAction {
        @NlsContexts.DialogTitle
        private final String myTitle;

        public ScriptingActionBase(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @Nullable String text, @NlsActions.ActionDescription @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                ScriptingActionBase.$$$reportNull$$$0(0);
            }
            super(text, description, icon);
            this.myTitle = title;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ScriptingActionBase.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public JBIterable<BasicElement> getSelectedElements(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(2);
            }
            DataContext dataContext = e.getDataContext();
            if (e.getPlace().equals("DatabaseViewPopup")) {
                return this.filterOrExpandElements(DatabaseContextFun.getSelectedElements(dataContext));
            }
            JBIterable selectedDbElements1 = ToolActions.getSelectedPsiElements(e.getDataContext()).flatten(ScriptingActionBase::expandIfNeeded).filter(DbElement.class);
            return this.filterOrExpandElements((JBIterable<BasicElement>)selectedDbElements1.map(DbElement::getDelegate).filter(BasicElement.class));
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<BasicElement> elements;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(3);
            }
            Presentation p2 = e.getPresentation();
            try {
                elements = this.getSelectedElements(e);
            }
            catch (IndexNotReadyException inr) {
                p2.setEnabledAndVisible(false);
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                p2.setEnabledAndVisible(false);
                return;
            }
            ActionStatus s = ScriptingActionBase.checkApplicabilityStatus(elements, project);
            p2.setVisible(s.visible);
            p2.setEnabled(s.enabled);
        }

        @NotNull
        private static ActionStatus checkApplicabilityStatus(@NotNull JBIterable<BasicElement> elements, @NotNull Project project) {
            BasicElement first2;
            if (elements == null) {
                ScriptingActionBase.$$$reportNull$$$0(4);
            }
            if (project == null) {
                ScriptingActionBase.$$$reportNull$$$0(5);
            }
            if ((first2 = (BasicElement)elements.first()) == null) {
                ActionStatus actionStatus = ActionStatus.HIDDEN;
                if (actionStatus == null) {
                    ScriptingActionBase.$$$reportNull$$$0(6);
                }
                return actionStatus;
            }
            DbDataSource dbDataSource = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource(first2);
            LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dbDataSource);
            if (localDataSource == null) {
                ActionStatus actionStatus = ActionStatus.HIDDEN;
                if (actionStatus == null) {
                    ScriptingActionBase.$$$reportNull$$$0(7);
                }
                return actionStatus;
            }
            DbElement dbFirst = DbImplUtilCore.findElement(dbDataSource, first2);
            boolean en = DbImplUtilCore.canConnectTo(localDataSource) && ImportUtil.canModify(dbFirst);
            ActionStatus actionStatus = en ? ActionStatus.ENABLED : ActionStatus.DISABLED;
            if (actionStatus == null) {
                ScriptingActionBase.$$$reportNull$$$0(8);
            }
            return actionStatus;
        }

        protected boolean isSupported(@NotNull ScriptGenerator service, @NotNull BasicElement element) {
            if (service == null) {
                ScriptingActionBase.$$$reportNull$$$0(9);
            }
            if (element == null) {
                ScriptingActionBase.$$$reportNull$$$0(10);
            }
            return service.capabilities(element).get(this.getCategory()).get(null);
        }

        @NotNull
        protected abstract ScriptCategory getCategory();

        @NotNull
        private static Iterable<? extends PsiElement> expandIfNeeded(PsiElement x) {
            DbModelRegistry modelRegistry = (DbModelRegistry)x.getProject().getService(DbModelRegistry.class);
            Set<PsiElement> set = Collections.singleton(x);
            if (set == null) {
                ScriptingActionBase.$$$reportNull$$$0(11);
            }
            return set;
        }

        @NotNull
        private JBIterable<BasicElement> filterOrExpandElements(@NotNull JBIterable<BasicElement> elements) {
            BasicElement first2;
            if (elements == null) {
                ScriptingActionBase.$$$reportNull$$$0(12);
            }
            if ((first2 = (BasicElement)elements.first()) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(13);
                }
                return jBIterable;
            }
            BasicModel model = first2.getModel();
            if (model == null || !this.getCategory().getApplicableDbs().value((Object)model.getDbms())) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(14);
                }
                return jBIterable;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable dsElements = elements.filter(o -> o.getModel() == model);
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoots((Iterable)dsElements)).expandAndSkip(o -> o == null || !this.isSupported(service, (BasicElement)o))).unique()).bfsTraversal();
            if (jBIterable == null) {
                ScriptingActionBase.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<BasicElement> selection;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(16);
            }
            if ((selection = this.getSelectedElements(e)).isEmpty()) {
                return;
            }
            BasicElement firstElement = (BasicElement)selection.first();
            BasicModel model = firstElement.getModel();
            if (model == null) {
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            DbDataSource firstDbDataSource = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource(firstElement);
            if (firstDbDataSource == null) {
                return;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            ScriptCategory category = this.getCategory();
            ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(model, category);
            DasNamespace path = DbImplUtilCore.getSearchPathObjectForSwitch(firstDbDataSource, (DasObject)firstElement);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(path), BasicNamespace.class);
            builder.setCurrentNamespace(namespace);
            builder.addElements((Iterable<? extends BasicElement>)selection);
            new MyDatabaseScriptDialog(firstDbDataSource, namespace, builder, service).initAndShow();
        }

        protected void fillContext(@NotNull DatabaseRefactoringHandler handler2, Collection<BasicElement> elements) {
            if (handler2 == null) {
                ScriptingActionBase.$$$reportNull$$$0(17);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6, 7, 8, 11, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 2: 
                case 3: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkApplicabilityStatus";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandIfNeeded";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterOrExpandElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "checkApplicabilityStatus";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "filterOrExpandElements";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "fillContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6, 7, 8, 11, 13, 14, 15 -> new IllegalStateException(string);
            };
        }

        private class MyDatabaseScriptDialog
        extends DatabaseScriptDialog {
            private final ScriptingSingleModelTaskBuilder myBuilder;
            private final ScriptGenerator myService;

            public MyDatabaseScriptDialog(DbDataSource dataSource, BasicNamespace namespace, ScriptingSingleModelTaskBuilder builder, ScriptGenerator service) {
                super(dataSource.getProject(), dataSource.getDelegateDataSource(), ObjectPaths.searchPathOf(namespace), ScriptingActionBase.this.myTitle);
                this.myBuilder = builder;
                this.myService = service;
            }

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myBuilder.build();
            }

            @Override
            @Nullable
            protected Object applyAndGetTask(@NotNull @NotNull Continuation<? super @NotNull ScriptingTask> $completion) {
                if ($completion == null) {
                    MyDatabaseScriptDialog.$$$reportNull$$$0(0);
                }
                return JavaCoroutines.suspendJava(c2 -> c2.resume((Object)this.getTask()), $completion);
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                this.myBuilder.setOptions(options);
                this.generate();
            }

            @Override
            protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
                if (handler2 == null) {
                    MyDatabaseScriptDialog.$$$reportNull$$$0(1);
                }
                Collection<BasicElement> elements = this.myBuilder.getElements();
                ScriptingActionBase.this.fillContext(handler2, elements);
            }

            private void generate() {
                ScriptingResult script2 = this.myService.makeScript(this.myProject, this.getTask());
                this.updateText(script2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "$completion";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/actions/ToolActions$ScriptingActionBase$MyDatabaseScriptDialog";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyAndGetTask";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fillContext";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

