/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.session.DatabaseConsoleHistoryController;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00060\u0015R\u00020\u0001H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/console/session/DatabaseConsoleHistoryController;", "Lcom/intellij/execution/console/ConsoleHistoryController;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "client", "Lcom/intellij/database/console/client/DatabaseScriptingSessionClient;", "<init>", "(Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/database/console/client/DatabaseScriptingSessionClient;)V", "insertTextMultiline", "", "text", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "install", "", "createBrowseAction", "Lcom/intellij/execution/console/ConsoleHistoryController$BrowseAction;", "DatabaseBrowseAction", "Companion", "intellij.database.impl"})
public final class DatabaseConsoleHistoryController
extends ConsoleHistoryController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDataSource dataSource;
    @NotNull
    private final DatabaseScriptingSessionClient client;

    public DatabaseConsoleHistoryController(@NotNull LocalDataSource dataSource, @NotNull LanguageConsoleView consoleView, @NotNull DatabaseScriptingSessionClient client) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        ConsoleRootType consoleRootType = DbConsoleRootType.getInstance();
        DbConsoleRootType dbConsoleRootType = DbConsoleRootType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dbConsoleRootType, (String)"getInstance(...)");
        super(consoleRootType, DatabaseConsoleHistoryController.Companion.getFileExtension(dbConsoleRootType, dataSource), dataSource.getUniqueId(), consoleView);
        this.dataSource = dataSource;
        this.client = client;
    }

    protected int insertTextMultiline(@NotNull CharSequence text, @NotNull Editor editor2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange textRange = ScriptModelUtil.getSelectedStatementsRange(this.client, editor2, DatabaseSettings.getDefaultExecOption());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getSelectedStatementsRange(...)");
        TextRange range = textRange;
        document.replaceString(range.getStartOffset(), range.getEndOffset(), text);
        editor2.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text.length());
        return range.getStartOffset();
    }

    public void install() {
        this.setMultiline(true);
        super.install();
    }

    @NotNull
    protected ConsoleHistoryController.BrowseAction createBrowseAction() {
        return new DatabaseBrowseAction();
    }

    public static final /* synthetic */ VirtualFile access$getContentFile$s372273881(ConsoleRootType p0, String p1, String p2, ScratchFileService.Option p3) {
        return ConsoleHistoryController.getContentFile((ConsoleRootType)p0, (String)p1, (String)p2, (ScratchFileService.Option)p3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/console/session/DatabaseConsoleHistoryController$Companion;", "", "<init>", "()V", "getContentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "option", "Lcom/intellij/ide/scratch/ScratchFileService$Option;", "migrateConsolesIfNeeded", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "getRootPath", "Ljava/nio/file/Path;", "getFileExtension", "", "rootType", "Lcom/intellij/database/console/DbConsoleRootType;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile getContentFile(@NotNull DasDataSource dataSource, @NotNull ScratchFileService.Option option) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            ConsoleRootType consoleRootType = DbConsoleRootType.getInstance();
            DbConsoleRootType dbConsoleRootType = DbConsoleRootType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)dbConsoleRootType, (String)"getInstance(...)");
            return DatabaseConsoleHistoryController.access$getContentFile$s372273881(consoleRootType, this.getFileExtension(dbConsoleRootType, dataSource), dataSource.getUniqueId(), option);
        }

        public final void migrateConsolesIfNeeded(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DbConsoleRootType dbConsoleRootType = DbConsoleRootType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)dbConsoleRootType, (String)"getInstance(...)");
            DbConsoleRootType rootType = dbConsoleRootType;
            String string = rootType.getDefaultFileExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultFileExtension(...)");
            String defaultFileExtension = string;
            String fileExtension = this.getFileExtension(rootType, dataSource);
            if (Intrinsics.areEqual((Object)fileExtension, (Object)defaultFileExtension)) {
                return;
            }
            Path path = this.getRootPath(dataSource);
            if (path == null) {
                return;
            }
            Path rootPath = path;
            if (Files.exists(rootPath, new LinkOption[0])) {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(defaultFileExtension, fileExtension){
                    final /* synthetic */ String $defaultFileExtension;
                    final /* synthetic */ String $fileExtension;
                    {
                        this.$defaultFileExtension = $defaultFileExtension;
                        this.$fileExtension = $fileExtension;
                    }

                    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                        if (attrs.isDirectory() || !Intrinsics.areEqual((Object)PathUtilRt.getFileExtension((String)PathsKt.getName((Path)filePath)), (Object)this.$defaultFileExtension)) {
                            return FileVisitResult.CONTINUE;
                        }
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(((Object)filePath).toString());
                        if (virtualFile == null) {
                            return FileVisitResult.CONTINUE;
                        }
                        VirtualFile file = virtualFile;
                        ApplicationManager.getApplication().invokeLater(() -> migrateConsolesIfNeeded.1.visitFile$lambda$1(file, this.$defaultFileExtension, this.$fileExtension, this));
                        return FileVisitResult.CONTINUE;
                    }

                    private static final void visitFile$lambda$1$lambda$0(VirtualFile $file, migrateConsolesIfNeeded.1 this$0, String $newFileName) {
                        try {
                            $file.rename((Object)this$0, $newFileName);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    private static final void visitFile$lambda$1(VirtualFile $file, String $defaultFileExtension, String $fileExtension, migrateConsolesIfNeeded.1 this$0) {
                        String string = $file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String curFileName = string;
                        String curFileExtension = PathUtilRt.getFileExtension((String)curFileName);
                        if (!Intrinsics.areEqual((Object)curFileExtension, (Object)$defaultFileExtension)) {
                            return;
                        }
                        String string2 = curFileName.substring(0, curFileName.length() - curFileExtension.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String curFileNameWithoutExtension = string2;
                        String newFileName = curFileNameWithoutExtension + "." + $fileExtension;
                        ApplicationManager.getApplication().runWriteAction(() -> migrateConsolesIfNeeded.1.visitFile$lambda$1$lambda$0($file, this$0, newFileName));
                    }
                });
            }
        }

        private final Path getRootPath(DasDataSource dataSource) {
            String string = DbConsoleRootType.getInstance().getContentRootPath(dataSource.getUniqueId());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContentRootPath(...)");
            String rootPathAsString = string;
            try {
                return Paths.get(rootPathAsString, new String[0]);
            }
            catch (InvalidPathException e) {
                return null;
            }
        }

        private final String getFileExtension(DbConsoleRootType rootType, DasDataSource dataSource) {
            Dbms dbms = dataSource.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            if (dbms2.isMongo()) {
                return "js";
            }
            String string = rootType.getDefaultFileExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultFileExtension(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/database/console/session/DatabaseConsoleHistoryController$DatabaseBrowseAction;", "Lcom/intellij/execution/console/ConsoleHistoryController$BrowseAction;", "Lcom/intellij/execution/console/ConsoleHistoryController;", "<init>", "(Lcom/intellij/database/console/session/DatabaseConsoleHistoryController;)V", "getTitle", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.database.impl"})
    private final class DatabaseBrowseAction
    extends ConsoleHistoryController.BrowseAction {
        public DatabaseBrowseAction() {
            super((ConsoleHistoryController)DatabaseConsoleHistoryController.this);
        }

        @NotNull
        protected String getTitle() {
            Object[] objectArray = new Object[]{DatabaseConsoleHistoryController.this.dataSource.getName()};
            String string = DatabaseBundle.message("dialog.title.query.history", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

