/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackend;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DbSrcStorage {
    public static final String STORAGE_SUBDIR = "storage_v2";
    private final String myProjectId;
    private final String myDataSourceId;
    private final DbSrcBackend myBackend;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirs;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirsRec;
    private final AtomicReference<Set<ObjectPath>> myDirtySrc;
    private final Alarm myFlusher;
    private final boolean myCheckSanity;

    public DbSrcStorage(@Nullable Project project, @NotNull String rootPath, @NotNull String dataSourceId) {
        if (rootPath == null) {
            DbSrcStorage.$$$reportNull$$$0(0);
        }
        if (dataSourceId == null) {
            DbSrcStorage.$$$reportNull$$$0(1);
        }
        this.myDirtyDirs = new AtomicReference<Set>(ConcurrentCollectionFactory.createConcurrentSet());
        this.myDirtyDirsRec = new AtomicReference<Set>(ConcurrentCollectionFactory.createConcurrentSet());
        this.myDirtySrc = new AtomicReference<Set>(ConcurrentCollectionFactory.createConcurrentSet());
        this.myCheckSanity = ApplicationManager.getApplication().isUnitTestMode();
        this.myProjectId = DbSrcUtils.getProjectId(project);
        this.myFlusher = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
        this.myDataSourceId = dataSourceId;
        this.myBackend = new DbSrcBackend(rootPath + File.separator + dataSourceId + File.separator + STORAGE_SUBDIR, new DbSrcBackend.Listener(){

            @Override
            public void fileChanged(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DbSrcStorage.this.myDirtySrc.get().add(object)) {
                    this.scheduleFlush();
                }
            }

            @Override
            public void dirChanged(@Nullable ObjectPath object, boolean staging, boolean recursive) {
                if ((recursive ? DbSrcStorage.this.myDirtyDirsRec : DbSrcStorage.this.myDirtyDirs).get().add((ObjectPath)ObjectUtils.chooseNotNull((Object)object, (Object)ObjectPath.ROOT))) {
                    this.scheduleFlush();
                }
            }

            @Override
            public void fileMoved(@NotNull ObjectPath from, @NotNull ObjectPath to) {
                if (from == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (to == null) {
                    1.$$$reportNull$$$0(3);
                }
                DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
                ArrayList<Object> events = new ArrayList<Object>();
                boolean move = from.parent != to.parent;
                boolean rename = !from.matches(to);
                for (DbSrcFileSystemCore.ItemTypeOrFolder item : (DbSrcFileSystemCore.ItemTypeOrFolder[])ContainerUtil.ar((Object[])new DbSrcFileSystemCore.ItemTypeOrFolder[]{DbSrcFileSystemCore.ItemType.FOLDER, DbSrcFileSystemCore.ItemType.SRC, DbSrcFileSystemCore.ItemType.USER_BASE, DbSrcFileSystemCore.ItemType.ORIG})) {
                    VirtualFile cached = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)from, (DbSrcFileSystemCore.ItemTypeOrFolder)item)).first;
                    VirtualFile cachedTarget = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)to, (DbSrcFileSystemCore.ItemTypeOrFolder)item)).first;
                    if (cached == null) continue;
                    if (cachedTarget != null) {
                        events.add(new VFileDeleteEvent((Object)fs, cachedTarget));
                    }
                    if (rename) {
                        String fromName = DbSrcFileSystem.getFileName(from, item);
                        String toName = DbSrcFileSystem.getFileName(to, item);
                        events.add(new VFilePropertyChangeEvent((Object)fs, cached, "name", (Object)fromName, (Object)toName));
                    }
                    if (!move) continue;
                    VirtualFile target2 = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)to.parent, (ObjectKind)to.kind)).first;
                    events.add(new VFileMoveEvent((Object)fs, cached, target2));
                }
                if (!events.isEmpty()) {
                    RefreshQueue.getInstance().processEvents(true, events);
                }
            }

            private void scheduleFlush() {
                if (DbSrcStorage.this.myFlusher.isDisposed()) {
                    return;
                }
                DbSrcStorage.this.myFlusher.cancelAllRequests();
                DbSrcStorage.this.myFlusher.addRequest(() -> DbSrcStorage.this.flushToFs(false), 800);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileChanged";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public String getDataSourceId() {
        String string = this.myDataSourceId;
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(3);
        }
        return this.myBackend.hasGroup(object, group, false) || this.myBackend.hasGroup(object, group, true);
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        return this.myBackend.hasChildren(object, false) || this.myBackend.hasChildren(object, true);
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type, boolean force) {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(4);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(5);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            if (!force && this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null) {
                return null;
            }
            return DbSrcStorage.overrideWritable(this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL), false);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            if (!force && this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null) {
                return null;
            }
            return DbSrcStorage.overrideWritable(this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER_BASE), false);
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            FileAttributes baseAttrs = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            FileAttributes attrs = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER);
            if (attrs == null || baseAttrs == null) {
                return attrs == null ? DbSrcStorage.overrideWritable(baseAttrs, true) : attrs;
            }
            return attrs;
        }
        return null;
    }

    public void listGroups(@Nullable ObjectPath object, @NotNull Consumer<? super ObjectKind> consumer) {
        if (consumer == null) {
            DbSrcStorage.$$$reportNull$$$0(6);
        }
        this.myBackend.listGroups(object, false, consumer);
        this.myBackend.listGroups(object, true, consumer);
    }

    public void list(@Nullable ObjectPath object, @NotNull ObjectKind group, @NotNull ListingConsumer consumer) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            DbSrcStorage.$$$reportNull$$$0(8);
        }
        this.myBackend.list(object, group, false, consumer);
        this.myBackend.list(object, group, true, consumer);
    }

    public void putUserContent(@NotNull ObjectPath object, byte @Nullable [] content) throws IOException {
        boolean differs;
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(9);
        }
        if ((metaData = this.myBackend.getMetaData(object)) == null) {
            metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        int hc = metaData.contentHash == 0 ? 0 : DbSrcUtilsCore.StringHashBuilder.hashStep(0, content);
        boolean bl = differs = content == null || !this.myCheckSanity && hc != metaData.contentHash;
        if (!differs) {
            try (InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);){
                boolean bl2 = differs = stream == null;
                if (!differs) {
                    differs = DbSrcUtils.contentDiffers(stream, content);
                    if (this.myCheckSanity && hc != metaData.contentHash && !differs) {
                        throw new AssertionError((Object)"wrong hash code stored");
                    }
                }
            }
            catch (FileNotFoundException e) {
                differs = true;
            }
        }
        if (!differs) {
            content = null;
        }
        if (content == null) {
            this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
        }
        this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER, content, null);
    }

    private void putContentOrRemove(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content, @Nullable DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        boolean remove2;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(10);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(11);
        }
        boolean bl = remove2 = content == null && DbSrcStorageDsMetadata.MetaData.isEmpty(metaData) && !this.myBackend.hasChildren(object, DbSrcBackendUtils.isStaging(type));
        if (remove2 && (type != DbSrcBackendUtils.SrcType.USER_BASE || this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null)) {
            this.myBackend.dropObject(object, DbSrcBackendUtils.isStaging(type));
        } else {
            this.myBackend.putContent(object, type, content, metaData);
        }
    }

    public void setTimestamp(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, long timestamp) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(12);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(13);
        }
        this.myBackend.setTimestamp(object, type, timestamp);
    }

    public void dropObject(@NotNull ObjectPath object, boolean original) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(14);
        }
        if (original) {
            this.introduceUserBases(object);
        }
        this.myBackend.dropObject(object, !original);
    }

    private void introduceUserBases(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(15);
        }
        this.introduceUserBase(object);
        this.myBackend.listGroups(object, true, (Consumer<? super ObjectKind>)((Consumer)kind -> this.myBackend.list(object, (ObjectKind)kind, true, (child, type) -> {
            if (type == DbSrcBackendUtils.SrcType.USER) {
                this.introduceUserBases(child);
            }
        })));
    }

    private void introduceUserBase(@NotNull ObjectPath object) {
        boolean hasUserChanges;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(16);
        }
        boolean bl = hasUserChanges = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) != null;
        if (hasUserChanges) {
            try {
                byte[] original = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
                if (original != null) {
                    this.myBackend.putContent(object, DbSrcBackendUtils.SrcType.USER_BASE, original, null);
                }
            }
            catch (IOException e) {
                DbSrcBackendFiles.LOG.warn("Backup removed user-modified object: " + object, (Throwable)e);
            }
        }
    }

    public void removeBaseContent(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(17);
        }
        this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
    }

    public void putOriginalContent(@NotNull ObjectPath object, byte @Nullable [] content, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        boolean shouldExist;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(18);
        }
        if (metaData == null) {
            DbSrcStorage.$$$reportNull$$$0(19);
        }
        int hash = content == null ? 0 : DbSrcUtilsCore.StringHashBuilder.hashStep(0, content);
        DbSrcStorageDsMetadata.MetaData curMetaData = this.myBackend.getMetaData(object);
        DbSrcStorageDsMetadata.MetaData newMetaData = new DbSrcStorageDsMetadata.MetaData(metaData.srcVersion, hash, metaData.offsets, metaData.kinds, metaData.introContentVersion, metaData.genContentVersion);
        boolean looksSimilar = newMetaData.equals(curMetaData);
        boolean exists = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL) != null;
        boolean bl = shouldExist = content != null;
        if (looksSimilar && exists == shouldExist) {
            return;
        }
        try (DbSrcBackendFiles.Locker lock = this.myBackend.writeLock();){
            boolean addUserBase;
            this.removeContentIfMatched(object, DbSrcBackendUtils.SrcType.USER, content);
            if (this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) != null) {
                addUserBase = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER_BASE) == null;
                this.removeContentIfMatched(object, DbSrcBackendUtils.SrcType.USER_BASE, content);
            } else {
                addUserBase = false;
                this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
            }
            if (addUserBase) {
                this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL), null);
            }
            this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.ORIGINAL, content, newMetaData);
        }
    }

    private void removeContentIfMatched(@NotNull ObjectPath object, DbSrcBackendUtils.SrcType type, byte @Nullable [] content) throws IOException {
        boolean differs;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(20);
        }
        if (content == null) {
            return;
        }
        try (InputStream stream = this.myBackend.getContentInputStream(object, type);){
            differs = stream == null || DbSrcUtils.contentDiffers(stream, content);
        }
        catch (FileNotFoundException ignore) {
            differs = true;
        }
        if (!differs) {
            this.putContentOrRemove(object, type, null, null);
        }
    }

    @Nullable
    public OutputStream getContentOutputStream(final @NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(21);
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    DbSrcStorage.this.putUserContent(object, this.toByteArray());
                }
            }
        };
    }

    public void moveAll(@NotNull ObjectPath from, @NotNull ObjectPath to) throws IOException {
        if (from == null) {
            DbSrcStorage.$$$reportNull$$$0(22);
        }
        if (to == null) {
            DbSrcStorage.$$$reportNull$$$0(23);
        }
        this.myBackend.moveAll(from, to);
    }

    public void putMetaData(@NotNull ObjectPath path, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(24);
        }
        if (metaData == null) {
            DbSrcStorage.$$$reportNull$$$0(25);
        }
        this.myBackend.putMetaData(path, false, metaData);
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath path) {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(26);
        }
        return this.myBackend.getMetaData(path);
    }

    @NotNull
    public String getRoot() {
        String string = this.myBackend.getRoot();
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(27);
        }
        return string;
    }

    public byte @Nullable [] getContent(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(28);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(29);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            return this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            byte[] content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.USER_BASE);
            if (content == null) {
                content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
            return content;
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            byte[] content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.USER);
            if (content == null) {
                content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
            return content;
        }
        return null;
    }

    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(30);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(31);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            try {
                InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.USER_BASE);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException stream) {
                // empty catch block
            }
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            try {
                InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.USER);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        return null;
    }

    public void finish() {
        this.myBackend.finish();
    }

    public void drop() {
        this.myBackend.drop();
    }

    @TestOnly
    public void resetCaches() {
        this.myBackend.resetCaches();
    }

    @TestOnly
    public DbSrcBackend getBackend() {
        return this.myBackend;
    }

    public void flushToFs(boolean async2) {
        Set<ObjectPath> dirtySrc = this.myDirtySrc.getAndSet(ConcurrentCollectionFactory.createConcurrentSet());
        Set<ObjectPath> dirtyDirs = this.myDirtyDirs.getAndSet(ConcurrentCollectionFactory.createConcurrentSet());
        Set<ObjectPath> dirtyDirsRec = this.myDirtyDirsRec.getAndSet(ConcurrentCollectionFactory.createConcurrentSet());
        DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
        HashMap<VirtualFile, Boolean> needSynchronise = new HashMap<VirtualFile, Boolean>();
        for (ObjectPath path : dirtySrc) {
            for (int i2 = 0; i2 < 2; ++i2) {
                NewVirtualFile p2;
                boolean needRecursive;
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, i2 == 0 ? DbSrcFileSystemCore.ItemType.SRC : DbSrcFileSystemCore.ItemType.ORIG));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
                boolean bl = needRecursive = cached.first == null;
                if (vfile == null || !DbSrcStorage.addToMap(needSynchronise, vfile, needRecursive)) continue;
                VfsUtil.markDirty((boolean)needRecursive, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                needSynchronise.put(vfile, needRecursive);
                NewVirtualFile newVirtualFile = p2 = cached.first == null ? null : ((NewVirtualFile)cached.first).getParent();
                if (p2 == null || !DbSrcStorage.addToMap(needSynchronise, (VirtualFile)p2, false)) continue;
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{p2});
            }
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            boolean recursive = i3 == 0;
            for (ObjectPath path : recursive ? dirtyDirsRec : dirtyDirs) {
                boolean needRecursive;
                if (path == ObjectPath.ROOT) {
                    path = null;
                }
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, DbSrcFileSystemCore.ItemType.FOLDER));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
                boolean bl = needRecursive = recursive && cached.first != null;
                if (vfile == null || !DbSrcStorage.addToMap(needSynchronise, vfile, needRecursive)) continue;
                VfsUtil.markDirty((boolean)needRecursive, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
            }
        }
        if (!needSynchronise.isEmpty()) {
            RefreshQueue.getInstance().refresh(async2, true, null, needSynchronise.keySet());
        }
    }

    private static boolean addToMap(Map<VirtualFile, Boolean> map2, VirtualFile vfile, boolean recursive) {
        Boolean existing2 = map2.get(vfile);
        if (existing2 != null && existing2.equals(recursive)) {
            return false;
        }
        map2.put(vfile, recursive);
        return true;
    }

    @NotNull
    private String getPath(@Nullable ObjectPath path, @NotNull DbSrcFileSystemCore.ItemTypeOrFolder t) {
        if (t == null) {
            DbSrcStorage.$$$reportNull$$$0(32);
        }
        String string = DbSrcFileSystem.getPathFromNormalized(this.myProjectId, this.myDataSourceId, path, t);
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private String getPath(@Nullable ObjectPath path, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(34);
        }
        String string = DbSrcFileSystem.getPathFromNormalized(this.myProjectId, this.myDataSourceId, path, group);
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(35);
        }
        return string;
    }

    public void consume(DbSrcStorage src) throws IOException {
        src.myBackend.finish();
        try (DbSrcBackendFiles.Locker lock1 = this.myBackend.writeLock();
             DbSrcBackendFiles.Locker lock2 = src.myBackend.writeLock();){
            this.moveArea(src, false);
            this.moveArea(src, true);
            this.myBackend.resetCaches();
            src.myBackend.drop();
        }
    }

    private void moveArea(DbSrcStorage src, boolean staging) throws IOException {
        this.myBackend.dropObject(null, staging);
        File srcDir = DbSrcBackendUtils.getDir(src.myBackend.getRoot(), staging, null, null, null).toFile();
        File dstDir = DbSrcBackendUtils.getDir(this.myBackend.getRoot(), staging, null, null, null).toFile();
        if (srcDir.exists()) {
            FileUtil.copyDir((File)srcDir, (File)dstDir);
        }
    }

    private static FileAttributes overrideWritable(@Nullable FileAttributes attrs, boolean writable) {
        if (attrs == null || attrs.isWritable() == writable) {
            return attrs;
        }
        return new FileAttributes(attrs.isDirectory(), attrs.isSpecial(), attrs.isSymLink(), attrs.isHidden(), attrs.length, attrs.lastModified, writable, attrs.areChildrenCaseSensitive());
    }

    @NotNull
    private static <T> Collection<T> cheapConcat(@Nullable List<T> l1, @Nullable List<T> l2) {
        boolean e2;
        boolean e1 = l1 == null || l1.isEmpty();
        boolean bl = e2 = l2 == null || l2.isEmpty();
        if (e1 && e2) {
            Set set = Collections.emptySet();
            if (set == null) {
                DbSrcStorage.$$$reportNull$$$0(36);
            }
            return set;
        }
        if (e1) {
            List<T> list = l2;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (e2) {
            List<T> list = l1;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(38);
            }
            return list;
        }
        HashSet<T> res2 = new HashSet<T>();
        res2.addAll(l1);
        res2.addAll(l2);
        HashSet<T> hashSet = res2;
        if (hashSet == null) {
            DbSrcStorage.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @TestOnly
    void putContentDirect(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(40);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(41);
        }
        this.myBackend.putContent(object, type, content, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 27, 33, 35, 36, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 2: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 3: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 28: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 29: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceId";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "cheapConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putUserContent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putContentOrRemove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "introduceUserBases";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "introduceUserBase";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeBaseContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putOriginalContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeContentIfMatched";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContentOutputStream";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveAll";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "putContentDirect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 27, 33, 35, 36, 37, 38, 39 -> new IllegalStateException(string);
        };
    }

    public static interface ListingConsumer {
        public void consume(@NotNull ObjectPath var1, @NotNull DbSrcBackendUtils.SrcTypeOrFolder var2);
    }
}

