/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseUIUtils {
    public static final int ROW_LENGTH = 6;

    public static GridConstraints createLabelConstraints(int row, int col, double width) {
        return DatabaseUIUtils.createConstraints(row, col, 1, 0, 3, (int)width, false);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int colSpan) {
        return DatabaseUIUtils.createConstraints(row, col, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createSimpleConstraints(int row, int col, int rowSpan, int colSpan) {
        return DatabaseUIUtils.createConstraints(row, col, rowSpan, colSpan, 0, 1, -1, true);
    }

    public static GridConstraints createRowConstraints(int row) {
        return DatabaseUIUtils.createRowConstraints(row, false);
    }

    public static GridConstraints createRowConstraints(int row, boolean rubber) {
        return DatabaseUIUtils.createRowConstraints(row, rubber, 6);
    }

    public static GridConstraints createRowConstraints(int row, boolean rubber, int length) {
        return DatabaseUIUtils.createConstraints(row, 0, length, 9, 1, -1, rubber);
    }

    public static GridConstraints createAlignedConstraints(int row, int col, int colSpan, int anchor) {
        return DatabaseUIUtils.createConstraints(row, col, colSpan, anchor, 1, -1, false);
    }

    @Nullable
    public static JLabel getLabelOf(JComponent component) {
        return DatabaseUIUtils.getLabelComponentOf(component, JLabel.class);
    }

    @Nullable
    public static <C extends JComponent> C getLabelComponentOf(JComponent component, Class<C> clazz) {
        return (C)((JComponent)ObjectUtils.tryCast((Object)component.getClientProperty("labeledBy"), clazz));
    }

    public static GridConstraints createConstraints(int row, int col, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        return DatabaseUIUtils.createConstraints(row, col, 1, colSpan, anchor, fill, prefWidth, rubber);
    }

    public static GridConstraints createConstraints(int row, int col, int rowSpan, int colSpan, int anchor, int fill, int prefWidth, boolean rubber) {
        return DatabaseUIUtils.createConstraints(row, col, rowSpan, colSpan, anchor, fill, prefWidth, rubber, false);
    }

    public static GridConstraints createConstraints(int row, int col, int rowSpan, int colSpan, int anchor, int fill, int prefWidth, boolean rubber, boolean vrubber) {
        Dimension nonPref = new Dimension(-1, -1);
        Dimension pref = new Dimension(prefWidth == -1 ? 100 : prefWidth, -1);
        return new GridConstraints(row, col, rowSpan, colSpan, anchor, fill, DatabaseUIUtils.getPolicy(rubber), DatabaseUIUtils.getPolicy(vrubber), nonPref, pref, nonPref, 0, true);
    }

    public static int getPolicy(boolean rubber) {
        return rubber ? 7 : 0;
    }

    @NotNull
    public static Border innerLabelBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyLeft((int)10);
        if (jBEmptyBorder == null) {
            DatabaseUIUtils.$$$reportNull$$$0(0);
        }
        return jBEmptyBorder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/DatabaseUIUtils", "innerLabelBorder"));
    }
}

