/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvPreviewComponent
extends DataPreviewComponent<CsvPreviewInfo, TableEditorComponent.TableEditorComponentInfo> {
    private Disposable myPreviewDisposable;
    private final Disposable myDisposable;
    private final Project myProject;
    private final CsvPreviewModel myModel;
    private CsvFormat myFormat;
    private TableCsvFormatPreview myPreview;
    private GraphObservable.ObserverListener<?> myListener;
    private boolean myForceLoadData;

    public CsvPreviewComponent(@NotNull Disposable disposable, @NotNull Project project, @NotNull CsvPreviewModel model) {
        if (disposable == null) {
            CsvPreviewComponent.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CsvPreviewComponent.$$$reportNull$$$0(1);
        }
        if (model == null) {
            CsvPreviewComponent.$$$reportNull$$$0(2);
        }
        this.myForceLoadData = false;
        this.myDisposable = disposable;
        this.myProject = project;
        this.myModel = model;
    }

    @NotNull
    private TableCsvFormatPreview recreatePreview(@Nullable ImportEditorContext context) {
        if (this.myPreviewDisposable != null) {
            Disposer.dispose((Disposable)this.myPreviewDisposable);
        }
        this.myPreviewDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPreviewDisposable);
        return this.createPreview(this.myFormat, context);
    }

    @NotNull
    private TableCsvFormatPreview createPreview(@NotNull CsvFormat selectedFormat, @Nullable ImportEditorContext context) {
        if (selectedFormat == null) {
            CsvPreviewComponent.$$$reportNull$$$0(3);
        }
        return new TableCsvFormatPreview(this.myProject, selectedFormat, (CharSequence)this.myModel.getText(), this.myPreviewDisposable, () -> {
            if (this.myListener != null) {
                this.myListener.changed(this, TableEditorComponent.TableEditorComponentInfo.create(this.getGrid(), context, false));
            }
        });
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            CsvPreviewComponent.$$$reportNull$$$0(4);
        }
        this.myListener = listener2;
    }

    @Override
    @NotNull
    public CompletionStage<TableEditorComponent.TableEditorComponentInfo> notifyChanged(@NotNull CsvPreviewInfo object) {
        if (object == null) {
            CsvPreviewComponent.$$$reportNull$$$0(5);
        }
        boolean isCharset = object instanceof CharsetInfo;
        boolean isFormat = object instanceof FormatInfo;
        if (!isFormat && !isCharset) {
            throw new IllegalArgumentException(object + " must be CharsetInfo or FormatInfo");
        }
        if (object instanceof FormatInfo) {
            return this.formatChanged((FormatInfo)object);
        }
        this.myModel.setCharset(((CharsetInfo)object).myCharset);
        return this.resetGrid(null);
    }

    @NotNull
    private CompletionStage<TableEditorComponent.TableEditorComponentInfo> formatChanged(@NotNull FormatInfo object) {
        if (object == null) {
            CsvPreviewComponent.$$$reportNull$$$0(6);
        }
        this.myFormat = object.getFormat();
        this.myCurrentContext = object.getContext();
        if (this.myPreview == null) {
            return this.resetGrid(object.myContext);
        }
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> future = new CompletableFuture<TableEditorComponent.TableEditorComponentInfo>();
        GridRequestSource requestSource = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myPreview.getGrid()));
        this.registerRequestListener(requestSource, () -> future.complete(TableEditorComponent.TableEditorComponentInfo.create(this.myPreview.getGrid(), object.myContext, false)));
        this.myPreview.setFormat(Objects.requireNonNull(this.myFormat), requestSource);
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> completableFuture = future;
        if (completableFuture == null) {
            CsvPreviewComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    private void registerRequestListener(final GridRequestSource requestSource, final Runnable runnable) {
        GridDataHookUp hookUp = this.myPreview.getGrid().getDataHookup();
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myPreviewDisposable, (Disposable)disposable);
        hookUp.addRequestListener((GridDataHookUp.RequestListener)new GridDataHookUp.RequestListener<GridRow, GridColumn>(){

            public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errorInfo == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (requestSource == source) {
                    CsvPreviewComponent.this.myDataLoaded = true;
                    Disposer.dispose((Disposable)disposable);
                    runnable.run();
                }
            }

            public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
                if (source == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (requestSource == source) {
                    CsvPreviewComponent.this.myDataLoaded = true;
                    Disposer.dispose((Disposable)disposable);
                    runnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorInfo";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    public void setForceLoadData(boolean value) {
        this.myForceLoadData = value;
    }

    @NotNull
    private CompletableFuture<TableEditorComponent.TableEditorComponentInfo> resetGrid(@Nullable ImportEditorContext context) {
        this.myPreview = this.recreatePreview(context);
        DataGrid grid = this.myPreview.getGrid();
        this.setGrid(grid);
        GridRequestSource requestSource = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> future = new CompletableFuture<TableEditorComponent.TableEditorComponentInfo>();
        if (grid.getPanel().getComponent().isShowing() || this.myForceLoadData) {
            this.registerRequestListener(requestSource, () -> future.complete(TableEditorComponent.TableEditorComponentInfo.create(this.getGrid(), context)));
            grid.getDataHookup().getLoader().loadFirstPage(requestSource);
        } else {
            future.complete(TableEditorComponent.TableEditorComponentInfo.create(this.getGrid(), context));
        }
        CompletableFuture<TableEditorComponent.TableEditorComponentInfo> completableFuture = future;
        if (completableFuture == null) {
            CsvPreviewComponent.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CsvPreviewComponent.$$$reportNull$$$0(9);
        }
        return observer instanceof CsvTableEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFormat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resetGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPreview";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatChanged";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class CharsetInfo
    extends CsvPreviewInfo {
        private final Charset myCharset;

        public CharsetInfo(@NotNull Charset charset) {
            if (charset == null) {
                CharsetInfo.$$$reportNull$$$0(0);
            }
            this.myCharset = charset;
        }

        @Override
        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$CharsetInfo", "<init>"));
        }
    }

    public static class FormatInfo
    extends CsvPreviewInfo {
        private final CsvFormat myFormat;
        private final ImportEditorContext myContext;

        public FormatInfo(@NotNull CsvFormat format, @NotNull ImportEditorContext context) {
            if (format == null) {
                FormatInfo.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FormatInfo.$$$reportNull$$$0(1);
            }
            this.myFormat = format;
            this.myContext = context;
        }

        @NotNull
        public ImportEditorContext getContext() {
            ImportEditorContext importEditorContext = this.myContext;
            if (importEditorContext == null) {
                FormatInfo.$$$reportNull$$$0(2);
            }
            return importEditorContext;
        }

        @Override
        @Nullable
        public CsvFormat getFormat() {
            return this.myFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$FormatInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$FormatInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class CsvPreviewInfo {
        @Nullable
        public Charset getCharset() {
            return null;
        }

        @Nullable
        public CsvFormat getFormat() {
            return null;
        }
    }
}

