/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.ForbidFragmentOptionProvider;
import com.intellij.database.dataSource.ForbidIncrementalOptionProvider;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.introspection.CheckUptodatenessIntrospectionTask;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.IntrospectionMetricKey;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.SchemaFragmentIntrospectionTask;
import com.intellij.database.introspection.ServerFragmentIntrospectionTask;
import com.intellij.database.introspection.query.PreprocessedQuery;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelRoot;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.Level;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.ApplicationFun;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.BooleanFun;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.Conclusion;
import com.intellij.database.util.common.ConclusionBuilder;
import com.intellij.database.util.common.Conclusions;
import com.intellij.database.util.common.Okay;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.rmi.RemoteException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00010\u0007:\b\u00a4\u0001\u00a5\u0001\u00a6\u0001\u00a7\u0001B)\b\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u001a\u00105\u001a\u0002062\u0006\u00100\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u000108H\u0002J9\u00109\u001a\u0002H\u0001\"\u0004\b\u0003\u0010\u00012\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H\u00010;2\u0016\b\u0002\u0010<\u001a\u0010\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>\u0018\u00010\u0017H\u0004\u00a2\u0006\u0002\u0010?JB\u0010@\u001a\u000206\"\u0004\b\u0003\u0010A2\u0014\u0010:\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HA0B0;2\b\b\u0002\u0010C\u001a\u00020\u00132\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002HA\u0012\u0004\u0012\u0002060EH\u0004J \u0010F\u001a\u0004\u0018\u0001HG\"\u0006\b\u0003\u0010G\u0018\u00012\u0006\u0010H\u001a\u00020=H\u0084\b\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020LH\u0014J\u0018\u0010M\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020OH\u0014J\u001e\u0010P\u001a\u0002062\u0006\u0010K\u001a\u00020L2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0002J\u001b\u0010T\u001a\u0002062\f\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VH\u0016\u00a2\u0006\u0002\u0010XJ\b\u0010Y\u001a\u000206H\u0016J\u0010\u0010Z\u001a\u0002062\u0006\u0010[\u001a\u00020LH$J\b\u0010\\\u001a\u000206H\u0016J\u0006\u0010]\u001a\u000206J\u0010\u0010^\u001a\u0002062\u0006\u0010[\u001a\u00020LH\u0004J\u0010\u0010_\u001a\u0002062\u0006\u0010[\u001a\u00020LH\u0014J0\u0010`\u001a\u0014\u0012\u0004\u0012\u00020S\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0V0\u00172\f\u0010a\u001a\b\u0012\u0004\u0012\u00020S0B2\u0006\u0010b\u001a\u00020\u001cH\u0016J8\u0010`\u001a\u0002062\f\u0010a\u001a\b\u0012\u0004\u0012\u00020S0B2\u0006\u0010b\u001a\u00020\u001c2\u0018\u0010c\u001a\u0014\u0012\u0004\u0012\u00020S\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0V0dH&J.\u0010e\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010f\u001a\u00020=2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h0R2\u0006\u0010i\u001a\u00020\u001cH\u0014J.\u0010j\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00020l2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h0R2\u0006\u0010i\u001a\u00020\u001cH\u0014J\u0018\u0010m\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020nH\u0014J(\u0010m\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00020l2\u0006\u0010o\u001a\u00020p2\u0006\u0010N\u001a\u00020nH\u0004J-\u0010q\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00028\u00012\u0006\u0010o\u001a\u00028\u00022\u0006\u0010N\u001a\u00020nH\u0014\u00a2\u0006\u0002\u0010rJ4\u0010s\u001a\b\u0012\u0004\u0012\u00020=0t2\u0006\u0010k\u001a\u00020l2\u0006\u0010o\u001a\u00020p2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h0R2\u0006\u0010i\u001a\u00020\u001cH\u0014J%\u0010u\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00028\u00012\u0006\u0010o\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010vJ\u001d\u0010w\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010o\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010xJ\u0018\u0010y\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020zH\u0014J;\u0010{\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010|R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010}J<\u0010~\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010\u007fR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010K\u001a\u00020L2\u0006\u0010k\u001a\u00028\u0001H$\u00a2\u0006\u0003\u0010\u0080\u0001J>\u0010\u0081\u0001\u001a!\u0012\u0006\b\u0001\u0012\u00028\u00020\u0082\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010K\u001a\u00020L2\u0006\u0010o\u001a\u00028\u0002H$\u00a2\u0006\u0003\u0010\u0083\u0001J\t\u0010\u0084\u0001\u001a\u000206H\u0004J\u0012\u0010\u0085\u0001\u001a\u0002062\u0007\u0010\u0086\u0001\u001a\u00020\u0002H\u0002J\u001f\u0010\u0087\u0001\u001a\u0002062\u0010\b\u0004\u0010\u0088\u0001\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0084\b\u00f8\u0001\u0000J\u000b\u0010\u008a\u0001\u001a\u0004\u0018\u00010=H\u0016J\u0019\u0010\u008b\u0001\u001a\u0004\u0018\u00010=2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020S0BH\u0016J\u0011\u0010\u008c\u0001\u001a\u00020\u001c2\u0006\u0010o\u001a\u00020pH\u0014J,\u0010\u008d\u0001\u001a\u0002062\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020=2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0004J-\u0010\u0092\u0001\u001a\u0002062\u0007\u0010\u0093\u0001\u001a\u00020=2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010=2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0004J\"\u0010\u0094\u0001\u001a\u0002062\u0007\u0010\u0090\u0001\u001a\u00020=2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0004J\u001d\u0010\u0095\u0001\u001a\u00020=2\u0007\u0010\u0096\u0001\u001a\u00020=2\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010=H\u0002J#\u0010\u0098\u0001\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020\u001c0\u00172\f\u0010a\u001a\b\u0012\u0004\u0012\u00020S0BH\u0014J\u0011\u0010\u0099\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u009a\u0001H\u0016J\t\u0010\u009c\u0001\u001a\u000206H\u0016J\u001c\u0010\u009d\u0001\u001a\u0002062\r\u0010D\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0086\b\u00f8\u0001\u0000J\u001c\u0010\u009e\u0001\u001a\u0002062\r\u0010D\u001a\t\u0012\u0004\u0012\u0002060\u0089\u0001H\u0086\b\u00f8\u0001\u0000J\r\u0010\u009f\u0001\u001a\u00020=*\u00020=H\u0004J>\u0010\u00a0\u0001\u001a\b\u0012\u0004\u0012\u0002HG0V\"\u0004\b\u0003\u0010G*\b\u0012\u0004\u0012\u0002HG0V2\u0013\u0010\u00a1\u0001\u001a\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u0002HG0EH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a2\u0001J:\u0010\u00a0\u0001\u001a\t\u0012\u0004\u0012\u0002HG0\u00a3\u0001\"\u0004\b\u0003\u0010G*\t\u0012\u0004\u0012\u0002HG0\u00a3\u00012\u0013\u0010\u00a1\u0001\u001a\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u0002HG0EH\u0084\b\u00f8\u0001\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0014\u0010$\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001eR\u0014\u0010&\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00a8\u0001"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModRoot;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "introspectorVersion", "", "getIntrospectorVersion", "()I", "introspectorKindVersions", "", "Lcom/intellij/database/model/ObjectKind;", "getIntrospectorKindVersions", "()Ljava/util/Map;", "forbidIncremental", "", "getForbidIncremental", "()Z", "setForbidIncremental", "(Z)V", "forbidFragment", "getForbidFragment", "setForbidFragment", "considerSystemSchemasReinstrospection", "getConsiderSystemSchemasReinstrospection", "sqlHelper", "Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "getSqlHelper", "()Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "dasTypeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "getDasTypeSystem", "()Lcom/intellij/database/types/DasTypeSystemBase;", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "adjustRootIntrospectionLevel", "", "dataSourceIntrospectionLevel", "Lcom/intellij/database/model/properties/Level;", "performQuery", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "namedParameters", "", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;)Ljava/lang/Object;", "performQueryHandleEachRow", "X", "", "packSize", "action", "Lkotlin/Function1;", "parseStatement", "T", "src", "(Ljava/lang/String;)Ljava/lang/Object;", "introspectGeneral", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "introspectServerFragments", "task", "Lcom/intellij/database/introspection/ServerFragmentIntrospectionTask;", "introspectElementsInCompatibleMode", "elementsToRefresh", "", "Lcom/intellij/database/model/basic/BasicElement;", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectNamespaces", "introspectNamespacesInTran", "tran", "introspectSessionState", "introspectServerObjects", "introspectServerObjectsInTran", "introspectAllServerObjects", "introspectNativeDefinitions", "elements", "withNestedElements", "result", "", "introspectRootFragments", "databaseName", "fragments", "Lcom/intellij/database/introspection/FamilyFragment;", "checkForDroppedObjects", "introspectDatabaseFragments", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "introspectSchemaFragments", "Lcom/intellij/database/introspection/SchemaFragmentIntrospectionTask;", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "introspectSchemaFragmentsInner", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;Lcom/intellij/database/model/basic/BasicModSchema;Lcom/intellij/database/introspection/SchemaFragmentIntrospectionTask;)V", "checkFragmentIntrospectionExpedience", "Lcom/intellij/database/util/common/Conclusion;", "detectAndRemoveDroppedObjects", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;Lcom/intellij/database/model/basic/BasicModSchema;)V", "performFragmentIntrospectionPreceders", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)V", "checkUptodate", "Lcom/intellij/database/introspection/CheckUptodatenessIntrospectionTask;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "root", "writeSources", "r", "Lkotlin/Function0;", "getCurrentDatabase", "collectDiagnosticInfo", "isSchemaSystem", "measureAndHandleErrors", "metricKey", "Lcom/intellij/database/introspection/IntrospectionMetricKey;", "operationName", "operation", "doSectionAndHandleErrors", "sectionName", "handleErrors", "concatErrorContextPrefixWithMessage", "prefix", "message", "checkElementsUptodate", "listDeferredTasks", "", "Lcom/intellij/database/introspection/IntrospectionTask;", "processDeferredTasks", "continueOnDbError", "continueOnAnyError", "dbIntern", "inplace", "t", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "", "AbstractRetriever", "AbstractDatabaseRetriever", "AbstractNativeRetriever", "AbstractSchemaRetriever", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 2 DataSourceBriefConfig.kt\ncom/intellij/database/dataSource/DataSourceBriefConfigs\n+ 3 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 4 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 5 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 9 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 10 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,843:1\n41#2,2:844\n39#2:846\n41#2,2:847\n39#2:849\n36#3:850\n26#4:851\n368#5,2:852\n1#6:854\n37#7,2:855\n1057#8:857\n1151#8,2:858\n1058#8,5:860\n1156#8,2:865\n1063#8,2:867\n1068#8:869\n1152#8:870\n1069#8,5:871\n1156#8,2:876\n1074#8,2:878\n1039#8:886\n13474#9,3:880\n1872#10,3:883\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n*L\n94#1:844,2\n94#1:846\n96#1:847,2\n96#1:849\n106#1:850\n135#1:851\n188#1:852,2\n310#1:855,2\n367#1:857\n367#1:858,2\n367#1:860,5\n367#1:865,2\n367#1:867,2\n383#1:869\n383#1:870\n383#1:871,5\n383#1:876,2\n383#1:878,2\n378#1:886\n839#1:880,3\n840#1:883,3\n*E\n"})
public abstract class BaseNativeIntrospector<R extends BasicModRoot, D extends BasicModDatabase, S extends BasicModSchema>
extends BaseIntrospector<R> {
    private final int introspectorVersion;
    @NotNull
    private final Map<ObjectKind, Integer> introspectorKindVersions;
    private boolean forbidIncremental;
    private boolean forbidFragment;
    private final boolean considerSystemSchemasReinstrospection;
    @NotNull
    private final IntrospectorSqlHelper sqlHelper;
    @NotNull
    private final DasTypeSystemBase dasTypeSystem;

    protected int getIntrospectorVersion() {
        return this.introspectorVersion;
    }

    @NotNull
    protected Map<ObjectKind, Integer> getIntrospectorKindVersions() {
        return this.introspectorKindVersions;
    }

    protected final boolean getForbidIncremental() {
        return this.forbidIncremental;
    }

    protected final void setForbidIncremental(boolean bl) {
        this.forbidIncremental = bl;
    }

    protected final boolean getForbidFragment() {
        return this.forbidFragment;
    }

    protected final void setForbidFragment(boolean bl) {
        this.forbidFragment = bl;
    }

    protected final boolean getConsiderSystemSchemasReinstrospection() {
        return this.considerSystemSchemasReinstrospection;
    }

    @NotNull
    protected final IntrospectorSqlHelper getSqlHelper() {
        return this.sqlHelper;
    }

    @NotNull
    protected final DasTypeSystemBase getDasTypeSystem() {
        return this.dasTypeSystem;
    }

    protected BaseNativeIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
        this.introspectorKindVersions = MapsKt.emptyMap();
        this.considerSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
        this.sqlHelper = new IntrospectorSqlHelper(context.getProject(), dbms);
        this.dasTypeSystem = DasTypeSystems.getTypeSystem(dbms);
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model, @NotNull DataSourceBriefConfig dsConfig, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        BasicModModel m = super.init(model, dsConfig, introspectionScope);
        this.trace("Introspector version: " + this.getIntrospectorVersion());
        DataSourceBriefConfig $this$getBooleanOptionValue_u24default$iv = dsConfig;
        boolean default$iv = false;
        boolean $i$f$getBooleanOptionValue = false;
        DataSourceBriefConfig $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        boolean $i$f$getOptionValue = false;
        Boolean bl = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(ForbidIncrementalOptionProvider.class);
        boolean bl2 = this.forbidIncremental = bl != null ? bl : default$iv;
        if (this.forbidIncremental) {
            this.trace("Incremental introspection is disabled");
        }
        $this$getBooleanOptionValue_u24default$iv = dsConfig;
        default$iv = false;
        $i$f$getBooleanOptionValue = false;
        $this$getOptionValue$iv$iv = $this$getBooleanOptionValue_u24default$iv;
        $i$f$getOptionValue = false;
        Boolean bl3 = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(ForbidFragmentOptionProvider.class);
        boolean bl4 = this.forbidFragment = bl3 != null ? bl3 : default$iv;
        if (this.forbidFragment) {
            this.trace("Fragment introspection is disabled");
        }
        this.adjustRootIntrospectionLevel(m, dsConfig.getIntrospectionLevel());
        return m;
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustRootIntrospectionLevel(BasicModModel model, Level dataSourceIntrospectionLevel) {
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicRoot modelRoot = basicRoot;
        if (modelRoot instanceof BasicModMultiLevelRoot && ((BasicModMultiLevelRoot)modelRoot).getExplicitIntrospectionLevel() != dataSourceIntrospectionLevel) {
            void $this$modify$iv;
            BasicModModel basicModModel = model;
            ModelModifier<BasicModMultiLevelRoot> modifier$iv = arg_0 -> BaseNativeIntrospector.adjustRootIntrospectionLevel$lambda$0(this, dataSourceIntrospectionLevel, arg_0);
            boolean $i$f$modify = false;
            $this$modify$iv.modify(BasicModMultiLevelRoot.class, modifier$iv);
        }
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query, @Nullable Map<String, ? extends Object> namedParameters) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, namedParameters, null, 4, null);
        return (R)this.inTransaction(arg_0 -> BaseNativeIntrospector.performQuery$lambda$1(this, pq, arg_0));
    }

    public static /* synthetic */ Object performQuery$default(BaseNativeIntrospector baseNativeIntrospector, SqlQuery sqlQuery, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQuery");
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        return baseNativeIntrospector.performQuery(sqlQuery, map2);
    }

    protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, null, null, 6, null);
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseNativeIntrospector.performQueryHandleEachRow$lambda$2(this, pq, packSize, action, arg_0)));
    }

    public static /* synthetic */ void performQueryHandleEachRow$default(BaseNativeIntrospector baseNativeIntrospector, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
        }
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        baseNativeIntrospector.performQueryHandleEachRow(sqlQuery, n, function1);
    }

    protected final /* synthetic */ <T> T parseStatement(String src) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        boolean $i$f$parseStatement = false;
        try {
            IntrospectorSqlHelper this_$iv = this.sqlHelper;
            boolean $i$f$statements = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = this_$iv.statements(src, Object.class).first();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e);
            }
            this.log.warn("Failed to parse sources", (Throwable)e);
            object = null;
        }
        return (T)object;
    }

    @Override
    protected void introspectGeneral(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.introspectNamespaces();
        this.introspectAutoInTran(transaction, null);
        this.introspectServerObjectsInTran(transaction);
    }

    @Override
    protected void introspectServerFragments(@NotNull DBTransaction transaction, @NotNull ServerFragmentIntrospectionTask task) {
        boolean canFragment;
        Collection fragments2;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Collection collection = task.getFragments();
        if (collection == null) {
            collection = fragments2 = (Collection)CollectionsKt.emptyList();
        }
        boolean bl = this.nature.getSupportFragmentIntrospection() && !task.getAll() && !fragments2.isEmpty() ? true : (canFragment = false);
        if (canFragment) {
            for (FamilyFragment e : fragments2) {
                if (this.nature.getSupportFragmentKinds().contains(e.getKind())) continue;
                canFragment = false;
            }
        }
        if (canFragment) {
            this.introspectRootFragments(transaction, task.getDatabaseName(), fragments2, true);
        } else {
            this.introspectServerObjectsInTran(transaction);
        }
    }

    private final void introspectElementsInCompatibleMode(DBTransaction transaction, Collection<? extends BasicElement> elementsToRefresh) {
        Set schemas = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementsToRefresh), BaseNativeIntrospector::introspectElementsInCompatibleMode$lambda$3));
        this.introspectAutoInTran(transaction, schemas);
    }

    @Override
    public void introspectAuto(@NotNull BasicNamespace[] namespaces2) {
        Intrinsics.checkNotNullParameter((Object)namespaces2, (String)"namespaces");
        int n = namespaces2.length;
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            IntrospectionQueryContext.access$trace(introspectionQueryContext, (String)(n > 0 ? "Introspect Automatically, the following " + n + " namespaces are specified: " + ArraysKt.joinToString$default((Object[])namespaces2, (CharSequence)"", null, null, (int)0, null, (Function1)introspectAuto.1.1.INSTANCE, (int)30, null) : "Introspection Automatically, namespaces are not specified"));
        }
        this.introspectServerAndSessionInfo();
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (BasicNamespace ns : namespaces2) {
                boolean bl = this.getModel().contains(ns);
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Namespaces must be from this model";
                    throw new AssertionError((Object)string);
                }
                theNamespaces.add(ns);
            }
        }
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseNativeIntrospector.introspectAuto$lambda$6(this, theNamespaces, arg_0)));
    }

    @Override
    public void introspectNamespaces() {
        this.introspectServerAndSessionInfo();
        this.logFlow("Introspect namespaces");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseNativeIntrospector.introspectNamespaces$lambda$7(this, arg_0)));
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        this.trace("Asked to introspect server and session state");
        this.introspectServerAndSessionInfo();
    }

    @Override
    public final void introspectServerObjects() {
        this.trace("Asked to introspect server and database objects");
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> BaseNativeIntrospector.introspectServerObjects$lambda$8(this, arg_0)));
    }

    protected final void introspectServerObjectsInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        if (this.nature.getSupportServerObjects() && !this.getServerObjectsDone()) {
            this.trace("Introspecting the server objects");
            this.introspectAllServerObjects(tran);
            this.setServerObjectsDone(true);
        }
    }

    protected void introspectAllServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Map result2 = new LinkedHashMap();
        this.introspectNativeDefinitions(elements, withNestedElements, result2);
        return result2;
    }

    public abstract void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> var1, boolean var2, @NotNull Map<BasicElement, String[]> var3);

    protected void introspectRootFragments(@NotNull DBTransaction transaction, @NotNull String databaseName, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
    }

    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull BasicDatabase database, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
    }

    @Override
    protected void introspectSchemaFragments(@NotNull DBTransaction transaction, @NotNull SchemaFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        BasicDatabase basicDatabase = ModelFun.lookupDatabase((BasicRoot)this.getRoot(), task.getDatabaseName());
        if (basicDatabase == null) {
            IntrospectionQueryContext.logError$default(this, "Cannot refresh schema fragment because no database " + task.getDatabaseName(), null, 2, null);
            return;
        }
        BasicDatabase database = basicDatabase;
        BasicSchema basicSchema = ModelFun.lookupSchema(database, task.getSchemaName());
        if (basicSchema == null) {
            IntrospectionQueryContext.logError$default(this, "Cannot refresh schema fragment because no schema " + task.getSchemaName(), null, 2, null);
            return;
        }
        BasicSchema schema = basicSchema;
        this.introspectSchemaFragments(transaction, database, schema, task);
    }

    protected final void introspectSchemaFragments(@NotNull DBTransaction transaction, @NotNull BasicDatabase database, @NotNull BasicSchema schema, @NotNull SchemaFragmentIntrospectionTask task) {
        Conclusion<String> fragmentConclusion;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Conclusion<String> conclusion = fragmentConclusion = task.getForceFragmentMode() ? (Conclusion<String>)Okay.INSTANCE : this.checkFragmentIntrospectionExpedience(database, schema, task.getFragments(), task.getCheckForDroppedObjects());
        if (fragmentConclusion.getOk()) {
            BasicModDatabase cfr_ignored_0 = (BasicModDatabase)database;
            BasicModSchema cfr_ignored_1 = (BasicModSchema)schema;
            this.introspectSchemaFragmentsInner(transaction, (BasicModDatabase)database, (BasicModSchema)schema, task);
        } else {
            this.logFlow("Concluded to fall back to non-fragment introspection because of: " + fragmentConclusion.toString((Function1<String, CharSequence>)((Function1)BaseNativeIntrospector::introspectSchemaFragments$lambda$9)));
            this.introspectAutoInTran(transaction, (Collection<BasicNamespace>)CollectionFun.asSingleSet(schema));
        }
    }

    protected void introspectSchemaFragmentsInner(@NotNull DBTransaction transaction, @NotNull D database, @NotNull S schema, @NotNull SchemaFragmentIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.performFragmentIntrospectionPreceders(transaction, schema);
        if (task.getCheckForDroppedObjects()) {
            this.detectAndRemoveDroppedObjects(transaction, database, schema);
        }
        AbstractSchemaRetriever<S> retriever = this.createSchemaRetriever(transaction, schema);
        retriever.setupForFragments();
        for (FamilyFragment fragment : task.getFragments()) {
            Collection $this$toTypedArray$iv = fragment.getNames();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            retriever.retrieveNamedFragments(fragment.getKind(), thisCollection$iv.toArray(new String[0]));
        }
    }

    @NotNull
    protected Conclusion<String> checkFragmentIntrospectionExpedience(@NotNull BasicDatabase database, @NotNull BasicSchema schema, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        return Conclusions.conclude(arg_0 -> BaseNativeIntrospector.checkFragmentIntrospectionExpedience$lambda$10(this, schema, fragments2, arg_0));
    }

    protected void detectAndRemoveDroppedObjects(@NotNull DBTransaction transaction, @NotNull D database, @NotNull S schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
    }

    protected void performFragmentIntrospectionPreceders(@NotNull DBTransaction transaction, @NotNull S schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
    }

    @Override
    protected void checkUptodate(@NotNull DBTransaction transaction, @NotNull CheckUptodatenessIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Collection elements = SequencesKt.toList(this.derefElements(task.getElementsToCheck()));
        this.checkElementsUptodate(elements);
    }

    @NotNull
    protected abstract AbstractDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractNativeRetriever<? extends D> createNativeRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, new ModelModifier(this){
            final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;
            {
                this.this$0 = $receiver;
            }

            public final void perform(BasicModRoot r) {
                Intrinsics.checkNotNull((Object)r);
                BaseNativeIntrospector.access$postIntrospectionProcessWithModel(this.this$0, r);
            }
        });
    }

    private final void postIntrospectionProcessWithModel(BasicModRoot root) {
        for (BasicModSchema basicModSchema : root.getAllSchemas()) {
            Intrinsics.checkNotNull((Object)basicModSchema);
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void writeSources(@NotNull Function0<Unit> r) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(r, (String)"r");
        boolean $i$f$writeSources = false;
        BaseIntrospector baseIntrospector = this;
        String name$iv = "WriteSources";
        boolean $i$f$doSection = false;
        CharSequence message$iv$iv = null;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv, message$iv$iv) : null;
        try {
            boolean bl = false;
            this.getModel().writeSources(new Runnable(r){
                final /* synthetic */ Function0<Unit> $r;
                {
                    this.$r = $r;
                }

                public final void run() {
                    this.$r.invoke();
                }
            });
        }
        finally {
            InlineMarker.finallyStart((int)1);
            void this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    @Nullable
    public String getCurrentDatabase() {
        return this.getDbConnectionInfo().databaseName;
    }

    @Override
    @Nullable
    public String collectDiagnosticInfo(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.getClass().getSimpleName();
    }

    protected boolean isSchemaSystem(@NotNull BasicSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return false;
    }

    protected final void measureAndHandleErrors(@NotNull IntrospectionMetricKey metricKey, @NotNull String operationName, @NotNull Function0<Unit> operation) {
        Intrinsics.checkNotNullParameter((Object)metricKey, (String)"metricKey");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.handleErrors(operationName, (Function0<Unit>)((Function0)() -> BaseNativeIntrospector.measureAndHandleErrors$lambda$12(this, metricKey, operation)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doSectionAndHandleErrors(@NotNull String sectionName, @Nullable String operationName, @NotNull Function0<Unit> operation) {
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        BaseIntrospector this_$iv = this;
        boolean $i$f$doSection = false;
        BaseIntrospector this_$iv$iv = this_$iv;
        boolean $i$f$logSectionBegin = false;
        DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv);
        DiagnosticSectionReference ref$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(sectionName, operationName) : null;
        try {
            boolean bl = false;
            String string = operationName;
            if (string == null) {
                string = sectionName;
            }
            this.handleErrors(string, operation);
        }
        finally {
            this_$iv$iv = this_$iv;
            boolean $i$f$logSectionEnd = false;
            if (ref$iv != null) {
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder(this_$iv$iv);
                if (dataSourceDiagnosticRecorder2 != null) {
                    DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv, null, 2, null);
                }
            }
        }
    }

    protected final void handleErrors(@NotNull String operationName, @NotNull Function0<Unit> operation) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        try {
            operation.invoke();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (DBException d) {
            String prefix = "Error encountered when performing " + operationName;
            String message = this.concatErrorContextPrefixWithMessage(prefix, d.getMessage());
            this.logWarn(message, (Exception)((Object)d));
            this.getErrorSink().accept(message, d);
        }
        catch (NullPointerException npe) {
            String message = "NPE encountered when performing " + operationName;
            this.logError(message, npe);
            this.getErrorSink().accept(message, npe);
        }
        catch (RemoteException e) {
            String prefix = "RMI error (" + e.getClass().getSimpleName() + ") encountered when performing " + operationName;
            String message = this.concatErrorContextPrefixWithMessage(prefix, e.getMessage());
            this.trace(message);
            throw e;
        }
        catch (Exception e) {
            String prefix = "Unexpected error (" + e.getClass().getSimpleName() + ") encountered when performing " + operationName;
            String message = this.concatErrorContextPrefixWithMessage(prefix, e.getMessage());
            this.logError(message, e);
            this.getErrorSink().accept(message, e);
        }
    }

    private final String concatErrorContextPrefixWithMessage(String prefix, String message) {
        return message == null ? prefix : (StringsKt.contains$default((CharSequence)message, (char)'\n', (boolean)false, (int)2, null) ? prefix + ":\n" + message : prefix + ": " + message);
    }

    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
        return map2;
    }

    @Override
    @NotNull
    public List<IntrospectionTask> listDeferredTasks() {
        return CollectionsKt.toList((Iterable)this.getDeferredTasks());
    }

    @Override
    public void processDeferredTasks() {
        if (this.getDeferredTasks().isEmpty()) {
            this.trace("No deferred tasks to process.");
            return;
        }
        int n = this.getDeferredTasks().size();
        Collection tasksToProcess = CollectionFun.extract((Collection)this.getDeferredTasks(), arg_0 -> BaseNativeIntrospector.processDeferredTasks$lambda$14(this, arg_0));
        if (tasksToProcess.isEmpty()) {
            IntrospectionQueryContext.logWarn$default(this, "There are " + n + " deferred tasks but none of them can be processed with the current connection", null, 2, null);
            return;
        }
        this.trace(StringFun.centerAndPadAsTitle("PROCESS " + tasksToProcess.size() + " OF " + n + " DEFERRED TASKS", 140, '='));
        this.trace("Tasks to process:\n\t" + CollectionsKt.joinToString$default((Iterable)tasksToProcess, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null));
        this.introspectTheTasks(tasksToProcess);
    }

    public final void continueOnDbError(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$continueOnDbError = false;
        try {
            action.invoke();
        }
        catch (DBException e) {
            this.getErrorSink().accept(null, e);
        }
    }

    public final void continueOnAnyError(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$continueOnAnyError = false;
        try {
            action.invoke();
        }
        catch (Exception e) {
            this.getErrorSink().accept(null, e);
        }
    }

    @NotNull
    protected final String dbIntern(@NotNull String $this$dbIntern) {
        Intrinsics.checkNotNullParameter((Object)$this$dbIntern, (String)"<this>");
        String string = DbUtil.intern($this$dbIntern);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intern(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> T[] inplace(@NotNull T[] $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        T[] TArray;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        boolean $i$f$inplace = false;
        T[] $this$inplace_u24lambda_u2416 = TArray = $this$inplace;
        boolean bl = false;
        T[] $this$forEachIndexed$iv = $this$inplace_u24lambda_u2416;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            T t2 = item$iv;
            int i2 = n;
            boolean bl2 = false;
            $this$inplace_u24lambda_u2416[i2] = t.invoke((Object)s);
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> List<T> inplace(@NotNull List<T> $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$inplace, (String)"<this>");
        Intrinsics.checkNotNullParameter(t, (String)"t");
        boolean $i$f$inplace = false;
        List<T> $this$inplace_u24lambda_u2418 = list = $this$inplace;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$inplace_u24lambda_u2418;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t2 = item$iv;
            int i2 = n;
            boolean bl2 = false;
            $this$inplace_u24lambda_u2418.set(i2, t.invoke((Object)s));
        }
        return list;
    }

    private static final void adjustRootIntrospectionLevel$lambda$0(BaseNativeIntrospector this$0, Level $dataSourceIntrospectionLevel, BasicModMultiLevelRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this$0.trace("Copying the explicitly set introspection level " + $dataSourceIntrospectionLevel + " from the data source to the model root");
        root.setExplicitIntrospectionLevel($dataSourceIntrospectionLevel);
    }

    private static final Object performQuery$lambda$1(BaseNativeIntrospector this$0, PreprocessedQuery $pq, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        IntrospectionQueryContext introspectionQueryContext = this$0;
        SqlQuery sqlQuery = $pq.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        return IntrospectionQueryContext.runQuery$default(introspectionQueryContext, transaction, sqlQuery, $pq.bindableParameters, null, 4, null);
    }

    private static final Unit performQueryHandleEachRow$lambda$2(BaseNativeIntrospector this$0, PreprocessedQuery $pq, int $packSize, Function1 $action, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        SqlQuery sqlQuery = $pq.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        this$0.runQueryHandleEachRow(transaction, sqlQuery, $pq.bindableParameters, $packSize, null, null, $action);
        return Unit.INSTANCE;
    }

    private static final BasicSchema introspectElementsInCompatibleMode$lambda$3(BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSchema();
    }

    private static final Unit introspectAuto$lambda$6(BaseNativeIntrospector this$0, ArrayList $theNamespaces, DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this$0.introspectAutoInTran(tran, $theNamespaces);
        return Unit.INSTANCE;
    }

    private static final Unit introspectNamespaces$lambda$7(BaseNativeIntrospector this$0, DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.introspectNamespacesInTran(it);
        return Unit.INSTANCE;
    }

    private static final Unit introspectServerObjects$lambda$8(BaseNativeIntrospector this$0, DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this$0.introspectServerObjectsInTran(transaction);
        return Unit.INSTANCE;
    }

    private static final CharSequence introspectSchemaFragments$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\n\t- " + it;
    }

    private static final Unit checkFragmentIntrospectionExpedience$lambda$10(BaseNativeIntrospector this$0, BasicSchema $schema, Collection $fragments, ConclusionBuilder $this$conclude) {
        Intrinsics.checkNotNullParameter((Object)$this$conclude, (String)"$this$conclude");
        if (this$0.forbidFragment) {
            $this$conclude.opposeObjection("Forbidden");
        }
        if (!ModelFun.isNotEmpty($schema)) {
            $this$conclude.opposeObjection("The schema is empty");
        }
        for (FamilyFragment fragment : $fragments) {
            if (this$0.nature.getSupportFragmentKinds().contains(fragment.getKind())) continue;
            $this$conclude.opposeObjection("Fragment introspection of kind " + fragment.getKind() + " is not supported");
        }
        return Unit.INSTANCE;
    }

    private static final Unit measureAndHandleErrors$lambda$12(BaseNativeIntrospector this$0, IntrospectionMetricKey $metricKey, Function0 $operation) {
        BaseIntrospector this_$iv = this$0;
        boolean $i$f$measure = false;
        BaseIntrospector.access$getTimeMeter(this_$iv).measure($metricKey, $operation);
        return Unit.INSTANCE;
    }

    private static final boolean processDeferredTasks$lambda$14(BaseNativeIntrospector this$0, IntrospectionTask it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.checkConnectionApplicable(it).compareTo((Enum)BaseIntrospector.ConnectionApplicability.connApplicablePartial) >= 0;
    }

    public static final /* synthetic */ void access$postIntrospectionProcessWithModel(BaseNativeIntrospector $this, BasicModRoot root) {
        $this.postIntrospectionProcessWithModel(root);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u000e0\u0012H\u0004R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "retrieveSchemas", "", "retrieveServerAndDatabaseObjects", "inDatabase", "modifier", "Lkotlin/Function1;", "intellij.database.dialects.base"})
    protected static abstract class AbstractDatabaseRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        protected AbstractDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super(transaction);
            this.database = database;
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        public void retrieveSchemas() {
        }

        public void retrieveServerAndDatabaseObjects() {
        }

        protected final void inDatabase(@NotNull Function1<? super D, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.database, BasicModDatabase.class, new ModelModifier(modifier){
                final /* synthetic */ Function1<D, Unit> $modifier;
                {
                    this.$modifier = $modifier;
                }

                public final void perform(BasicModDatabase it) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type D of com.intellij.database.dialects.base.introspector.BaseNativeIntrospector.AbstractDatabaseRetriever");
                    this.$modifier.invoke((Object)it);
                }
            });
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J0\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015H\u0014J8\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015H\u0014R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "retrieveNativeDefinitions", "", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "withNestedElements", "", "result", "", "", "", "expandElementsBeforeRetrievingNativeDefinitions", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,843:1\n1485#2:844\n1510#2,3:845\n1513#2,3:855\n381#3,7:848\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractNativeRetriever\n*L\n604#1:844\n604#1:845,3\n604#1:855,3\n604#1:848,7\n*E\n"})
    protected static abstract class AbstractNativeRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        protected AbstractNativeRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super(transaction);
            this.database = database;
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        public void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> elementsToProcess = withNestedElements ? this.expandElementsBeforeRetrievingNativeDefinitions(elements) : elements;
            this.retrieveNativeDefinitions(elementsToProcess, result2);
        }

        @NotNull
        protected Iterable<BasicElement> expandElementsBeforeRetrievingNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return CollectionsKt.toList(elements);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Iterable<? extends BasicElement> $this$groupBy$iv = elements;
            boolean $i$f$groupBy = false;
            Iterable<? extends BasicElement> iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                BasicElement it = (BasicElement)element$iv$iv;
                boolean bl = false;
                ObjectKind key$iv$iv = it.getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (Map.Entry entry : groups.entrySet()) {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                ObjectKind kind = (ObjectKind)k;
                List kindElements = (List)entry.getValue();
                this.retrieveNativeDefinitionsFor(kind, kindElements, result2);
            }
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0003\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016JK\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0003\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001c\"\u00020\u001aH\u0004\u00a2\u0006\u0002\u0010\u001dJL\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0003\u0010 2\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H 0!0\u00152\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\b\b\u0002\u0010\"\u001a\u00020#H\u0014JB\u0010$\u001a\u00020\u0011\"\u0004\b\u0003\u0010\u00132\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00130!0\u00152\b\b\u0002\u0010\"\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00110&H\u0004J/\u0010'\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0003\u0010\u0013*\u00020\u001a2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010(\u001a\u00020\u0019H\u0004\u00a2\u0006\u0002\u0010)J2\u0010*\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0003\u0010 2\u0014\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H 0!0\u00152\u0006\u0010(\u001a\u00020\u0019H\u0004J\u0014\u0010+\u001a\u00020,2\n\u0010-\u001a\u00060.j\u0002`/H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00060"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "getTransaction", "()Lcom/intellij/database/layoutedQueries/DBTransaction;", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "searchCache", "Lcom/intellij/database/model/ElementSearchCache;", "getSearchCache", "()Lcom/intellij/database/model/ElementSearchCache;", "process", "", "performQuery", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "namedParameters", "", "", "", "freeParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;[Ljava/lang/Object;)Ljava/lang/Object;", "performQueryForList", "", "R", "", "packSize", "", "performQueryHandleEachRow", "action", "Lkotlin/Function1;", "performQuerySafe", "introspectionScopeRemark", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/lang/String;)Ljava/lang/Object;", "performQuerySafeList", "queryPostPreprocess", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.database.dialects.base"})
    protected abstract class AbstractRetriever
    extends IntrospectionQueryContext {
        @NotNull
        private final DBTransaction transaction;
        @NotNull
        private final BasicModModel model;
        @NotNull
        private final ElementSearchCache searchCache;

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(BaseNativeIntrospector.this, null, 2, null);
            this.transaction = transaction;
            this.model = BaseNativeIntrospector.this.getModel();
            BaseNativeIntrospector.this.logMemory(true);
            this.searchCache = new ElementSearchCache();
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        @NotNull
        protected final BasicModModel getModel() {
            return this.model;
        }

        @NotNull
        public final ElementSearchCache getSearchCache() {
            return this.searchCache;
        }

        public void process() {
            String message = "Called method AbstractRetriever.process() in retriever " + this.getClass().getSimpleName();
            if (ApplicationFun.isApplicationInternalMode()) {
                this.logWarn(message, new RuntimeException("Inheritors must NOT call this method"));
            } else {
                this.trace(message);
            }
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuery(this.transaction, query);
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query, @Nullable Map<String, ? extends Object> namedParameters, Object ... freeParameters) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)freeParameters, (String)"freeParameters");
            return this.performQuery(this.transaction, query, namedParameters, Arrays.copyOf(freeParameters, freeParameters.length));
        }

        @NotNull
        protected <R> List<R> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQueryForList(this.transaction, query, namedParameters, packSize);
        }

        public static /* synthetic */ List performQueryForList$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, Map map2, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryForList");
            }
            if ((n2 & 2) != 0) {
                map2 = null;
            }
            if ((n2 & 4) != 0) {
                n = 4096;
            }
            return abstractRetriever.performQueryForList(sqlQuery, map2, n);
        }

        protected final <X> void performQueryHandleEachRow(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.performQueryHandleEachRow(this.transaction, query, packSize, action);
        }

        public static /* synthetic */ void performQueryHandleEachRow$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
            }
            if ((n2 & 2) != 0) {
                n = 1000;
            }
            abstractRetriever.performQueryHandleEachRow(sqlQuery, n, function1);
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query, @NotNull String introspectionScopeRemark) {
            X x;
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                x = this.performQuery(query);
            }
            catch (DBException e) {
                this.log.error(StringsKt.trimMargin$default((String)("|Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n                     |" + e.getMessage() + "\n                     |SQL statement:\n                     |" + e.statementText), null, (int)1, null));
                x = null;
            }
            return x;
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @NotNull String introspectionScopeRemark) {
            List list;
            Intrinsics.checkNotNullParameter(query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                list = AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            }
            catch (DBException e) {
                this.log.error(StringsKt.trimMargin$default((String)("|Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n                     |" + e.getMessage() + "\n                     |SQL statement:\n                     |" + e.statementText), null, (int)1, null));
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        protected boolean queryPostPreprocess(@NotNull StringBuilder buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return BaseNativeIntrospector.this.queryPostPreprocess(buf);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0019\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0004\b\b\u0010\tB#\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c002\u0006\u00106\u001a\u000207H\u0002J\u001d\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u000202H\u0017J\"\u0010<\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u0002H?0=\"\b\b\u0004\u0010>*\u00020@\"\u0004\b\u0005\u0010?J\u001c\u0010A\u001a\u0002022\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u0002020CH\u0004J'\u0010D\u001a\u0004\u0018\u0001HE\"\b\b\u0004\u0010E*\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0HH\u0004\u00a2\u0006\u0002\u0010IJ*\u0010J\u001a\b\u0012\u0004\u0012\u0002HL0K\"\u0004\b\u0004\u0010L2\u0014\u0010G\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HL0M0HH\u0004J\b\u0010N\u001a\u000202H\u0016J\b\u0010O\u001a\u000202H\u0016J\u0006\u0010P\u001a\u000202J\u0016\u0010Q\u001a\u0002022\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0016J#\u0010U\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u000202H\u0014J\b\u0010X\u001a\u000202H\u0014J\b\u0010Y\u001a\u000202H\u0014J\b\u0010Z\u001a\u000202H\u0014J\b\u0010[\u001a\u000202H\u0014J\b\u0010\\\u001a\u00020]H\u0014J\b\u0010^\u001a\u000202H\u0014R\u0013\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010(\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c00X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "getSchema", "()Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/model/basic/BasicModSchema;", "newMode", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "setMode", "(Lcom/intellij/database/introspection/IntrospectionMode;)V", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "introspectionBeginLocalTimestamp", "Ljava/time/Instant;", "getIntrospectionBeginLocalTimestamp", "()Ljava/time/Instant;", "setIntrospectionBeginLocalTimestamp", "(Ljava/time/Instant;)V", "outdatedKinds", "", "setupForFragments", "", "modeIsChanged", "oldMode", "checkOutdatedKinds", "existentVersion", "", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Z", "prepareParameters", "searchInSchema", "Lcom/intellij/database/model/ElementChecker;", "T", "D", "Lcom/intellij/database/model/basic/BasicElement;", "inSchema", "modifier", "Lkotlin/Function1;", "performQuerySafe", "X", "", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "performQuerySafeList", "", "R", "", "process", "processPreliminaryPhase", "processMainPhase", "retrieveSpecificFragments", "fragments", "", "Lcom/intellij/database/model/basic/BasicMajorObject;", "retrieveNamedFragments", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "analyzeBriefInfo", "analyzeCurrentContent", "retrieveMajorNames", "retrieveMainContent", "finishSchema", "getSchemaStateNumber", "", "clearSchema", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseNativeIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 SequenceFun.kt\ncom/intellij/database/util/common/SequenceFun\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,843:1\n1#2:844\n368#3,2:845\n368#3,2:847\n1485#4:849\n1510#4,3:850\n1513#4,3:860\n381#5,7:853\n9#6:863\n37#7,2:864\n*S KotlinDebug\n*F\n+ 1 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever\n*L\n666#1:845,2\n678#1:847,2\n791#1:849\n791#1:850,3\n791#1:860,3\n791#1:853,7\n797#1:863\n797#1:864,2\n*E\n"})
    protected abstract class AbstractSchemaRetriever<S extends BasicModSchema>
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Instant introspectionBeginLocalTimestamp;
        @NotNull
        private final Set<ObjectKind> outdatedKinds;
        final /* synthetic */ BaseNativeIntrospector<R, D, S> this$0;

        @NotNull
        public final S getSchema() {
            return this.schema;
        }

        @NotNull
        public final IntrospectionMode getMode() {
            return this.mode;
        }

        public final void setMode(@NotNull IntrospectionMode newMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
            if (this.mode != newMode) {
                IntrospectionMode oldMode = this.mode;
                this.mode = newMode;
                this.modeIsChanged(oldMode, newMode);
            }
        }

        public final boolean getWithSources() {
            return this.withSources;
        }

        public final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        public final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        public final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        public final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        public final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        protected final Instant getIntrospectionBeginLocalTimestamp() {
            return this.introspectionBeginLocalTimestamp;
        }

        protected final void setIntrospectionBeginLocalTimestamp(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.introspectionBeginLocalTimestamp = instant;
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            IntrospectionMode introspectionMode;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            IntrospectionMode introspectionMode2 = introspectionMode = IntrospectionMode.FULL;
            S s = schema;
            DBTransaction dBTransaction = transaction;
            reference var8_8 = this$0;
            AbstractSchemaRetriever abstractSchemaRetriever = this;
            boolean bl = false;
            boolean bl2 = this$0.getForbidIncremental();
            abstractSchemaRetriever(var8_8, dBTransaction, (BasicModSchema)s, bl2 ? introspectionMode : null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, @Nullable S schema, IntrospectionMode mode) {
            boolean bl;
            IntrospectionQueryContext introspectionQueryContext;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super(transaction);
            this.mode = IntrospectionMode.FULL;
            ObjectKind objectKind = ObjectKind.NONE;
            Intrinsics.checkNotNull((Object)objectKind);
            this.fragmentKind = objectKind;
            this.fragmentNames = new String[0];
            this.introspectionBeginLocalTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
            this.schema = schema;
            this.trace(StringFun.centerAndPadAsTitle("SCHEMA RETRIEVER: " + schema.getName(), 140, '-'));
            boolean schemaHasChildren = ((BasicMixinElement)schema).hasChildren();
            boolean incrementalIsPossible = this.isPossibleToIntrospectSchemaIncrementally(transaction, schema);
            IntrospectionMode introspectionMode = mode;
            if (introspectionMode == null) {
                introspectionMode = schemaHasChildren && incrementalIsPossible ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            }
            this.setMode(introspectionMode);
            this.withSources = this$0.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            this.trace(StringsKt.trimMargin$default((String)("|Schema has children: " + schemaHasChildren + "\n               |Incremental is possible: " + incrementalIsPossible + "\n               |Asked mode: " + mode + "\n               |Decided mode: " + this.mode + "\n            "), null, (int)1, null));
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                introspectionQueryContext = this_$iv;
                bl = false;
                IntrospectionQueryContext.access$trace(introspectionQueryContext, StringsKt.trimMargin$default((String)("|Configuration info:\n           |    - schema id:             " + (schema instanceof BasicIdentifiedElement ? String.valueOf(((BasicIdentifiedElement)schema).getObjectId()) : "no") + "\n           |    - schema has children:   " + BooleanFun.getYesNo(schemaHasChildren) + "\n           |    - mode:                  " + this.getMode() + "\n           |    - with sources:          " + BooleanFun.getYesNo(this.getWithSources()) + "\n        "), null, (int)1, null));
            }
            this.outdatedKinds = this.checkOutdatedKinds(((BasicSchema)schema).getLastIntrospectionVersion());
            if (schemaHasChildren) {
                this_$iv = this;
                $i$f$trace = false;
                if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                    introspectionQueryContext = this_$iv;
                    bl = false;
                    StringBuilder b = new StringBuilder();
                    b.append("Families before introspection:");
                    List<? extends Family<? extends BasicElement>> list = schema.getFamilies();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
                    List<? extends Family<? extends BasicElement>> families = list;
                    for (ModFamily modFamily : families) {
                        String string;
                        int n = modFamily.size();
                        if (n <= 0) continue;
                        ObjectKind kind = modFamily.getMetaObject().kind;
                        b.append('\n');
                        StringBuilder stringBuilder = b.append("    - ");
                        Intrinsics.checkNotNullExpressionValue((Object)kind.code(), (String)"code(...)");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string2 = string.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        stringBuilder.append(string2);
                        b.append(": ").append(n);
                        if (!this.outdatedKinds.contains(kind)) continue;
                        b.append("  (outdated)");
                    }
                    String string = b.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    IntrospectionQueryContext.access$trace(introspectionQueryContext, string);
                }
            }
        }

        public void setupForFragments() {
            this.setMode(IntrospectionMode.FRAGMENT);
            this.withSources = this.schema instanceof BasicMultiLevelSchema ? ModelFun.effectiveIntrospectionLevel((BasicMultiLevelSchema)this.schema) == Level.L3 : (this.this$0.isSchemaSystem((BasicSchema)this.schema) ? this.this$0.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES : this.this$0.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0);
        }

        private final void modeIsChanged(IntrospectionMode oldMode, IntrospectionMode newMode) {
            this.trace("Introspection mode was changed from " + oldMode + " to " + newMode);
        }

        private final Set<ObjectKind> checkOutdatedKinds(int existentVersion) {
            Map<ObjectKind, Integer> kindVersions = this.this$0.getIntrospectorKindVersions();
            if (kindVersions.isEmpty()) {
                return SetsKt.emptySet();
            }
            TreeSet kinds = new TreeSet();
            for (Map.Entry<ObjectKind, Integer> entry : kindVersions.entrySet()) {
                ObjectKind k = entry.getKey();
                int v = ((Number)entry.getValue()).intValue();
                if (Intrinsics.areEqual((Object)k, (Object)ObjectKind.NONE) || existentVersion >= v) continue;
                ((Collection)kinds).add(k);
            }
            return kinds;
        }

        public abstract boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction var1, @NotNull S var2);

        @ApiStatus.Internal
        public void prepareParameters() {
            block0: {
                BaseIntrospectionFunctions.setupModeParameters(this.mode, this.getParametersMap());
                this.setQueryParameter("SCHEMA_NAME", ((BasicMixinElement)this.schema).getRealName());
                this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
                BasicDatabase basicDatabase = this.schema.getDatabase();
                if (basicDatabase == null) break block0;
                BasicDatabase it = basicDatabase;
                boolean bl = false;
                this.setQueryParameter("DATABASE_NAME", it.getRealName());
            }
        }

        @NotNull
        public final <T extends BasicElement, D> ElementChecker<T, D> searchInSchema() {
            return ElementCacheKt.searchElement(this.getSearchCache());
        }

        protected final void inSchema(@NotNull Function1<? super S, Unit> modifier) {
            Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, ((BasicObjectNode)this.schema).getMetaObject().apiClass, new ModelModifier(modifier){
                final /* synthetic */ Function1<S, Unit> $modifier;
                {
                    this.$modifier = $modifier;
                }

                public final void perform(BasicElement schema) {
                    Intrinsics.checkNotNull((Object)schema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.base.introspector.BaseNativeIntrospector.AbstractSchemaRetriever");
                    this.$modifier.invoke((Object)((BasicModSchema)schema));
                }
            });
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafe(query, "schema " + ((BasicMixinElement)this.schema).getRealName());
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            return this.performQuerySafeList(query, "schema " + ((BasicMixinElement)this.schema).getRealName());
        }

        @Override
        public void process() {
            this.introspectionBeginLocalTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
            BaseIntrospector baseIntrospector = this.this$0;
            String string = this.schema.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            BaseIntrospector.reportIntrospectingSchema$default(baseIntrospector, string, null, null, 6, null);
            this.prepareParameters();
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        /*
         * WARNING - void declaration
         */
        public void retrieveSpecificFragments(@NotNull Collection<? extends BasicMajorObject> fragments2) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
            if (!this.this$0.nature.getSupportFragmentIntrospection()) {
                IntrospectionQueryContext.logWarn$default(this, "Attempted to retrieve " + fragments2.size() + " fragments when the introspector doesn't support it", null, 2, null);
                return;
            }
            Iterable $this$groupBy$iv = fragments2;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                ObjectKind key$iv$iv;
                BasicMajorObject it = (BasicMajorObject)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getKind(), (String)"getKind(...)");
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (Map.Entry entry : groups.entrySet()) {
                void $this$toArray$iv;
                ObjectKind kind = (ObjectKind)entry.getKey();
                List objects = (List)entry.getValue();
                Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)objects), AbstractSchemaRetriever::retrieveSpecificFragments$lambda$5));
                boolean $i$f$toArray = false;
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList((Sequence)$this$toArray$iv);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                String[] names = thisCollection$iv$iv.toArray(new String[0]);
                this.retrieveNamedFragments(kind, names);
            }
        }

        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            IntrospectionQueryContext.logWarn$default(this, "Attempted to retrieve " + fragmentNames.length + " fragments of kind " + fragmentKind + " when the introspector doesn't support it", null, 2, null);
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            this.this$0.reportStatusDetails("Finishing retrieving the schema " + this.schema.getName(), "introspection.report.status.finishingTheSchema");
            this.schema.setLastIntrospectionLocalTimestamp(this.introspectionBeginLocalTimestamp);
            if (this.withSources && this.mode != IntrospectionMode.FRAGMENT) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, this.getSchemaStateNumber());
            }
            if (this.mode.full || this.mode.increment) {
                this.schema.setLastIntrospectionVersion(this.this$0.getIntrospectorVersion());
            }
        }

        protected long getSchemaStateNumber() {
            return 0L;
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)this.schema, BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        private static final String retrieveSpecificFragments$lambda$5(BasicMajorObject it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getNaturalName();
        }
    }
}

