/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.ui;

import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.TypeDescriptorUi;
import com.intellij.database.dataSource.url.TypesRegistryUi;
import com.intellij.database.dataSource.url.ui.BaseTypeDescriptor;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2PathParamEditor
extends TextParamEditor {
    private static final String MV_STORE = "MV_STORE";
    private Boolean myMvStore;
    private static final String MV_EXT = ".mv.db";
    private static final String PAGE_EXT = ".h2.db";
    private static final String[] EXTS = new String[]{".mv.db", ".h2.db"};

    public H2PathParamEditor(@NotNull DataInterchange interchange, @Nls @NotNull String caption) {
        if (interchange == null) {
            H2PathParamEditor.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            H2PathParamEditor.$$$reportNull$$$0(1);
        }
        super(interchange, caption, FieldSize.LARGE, DbActionUtils.getSelectDbAction(true));
    }

    @NotNull
    private String getDbPath() {
        String string = ((JBTextField)this.getEditorComponent()).getText();
        if (string == null) {
            H2PathParamEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        return H2PathParamEditor.toDriver(this.getDbPath());
    }

    @Override
    protected void fireChanged() {
        this.getInterchange().putProperty(MV_STORE, this.getDbPath().endsWith(MV_EXT) ? null : "false");
        super.fireChanged();
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            H2PathParamEditor.$$$reportNull$$$0(3);
        }
        if (((String)text).endsWith(MV_EXT) || ((String)text).endsWith(PAGE_EXT)) {
            this.validatePath();
        } else {
            text = (String)text + (this.isMvStore() ? MV_EXT : PAGE_EXT);
        }
        ((JBTextField)this.getEditorComponent()).setText((String)text);
    }

    private void validatePath() {
        DbUIUtil.invokeLater(() -> {
            this.getInterchange().forceUpdateProperty("path");
            this.getInterchange().forceUpdateProperty(MV_STORE);
        });
    }

    private boolean isMvStore() {
        return !"false".equals(this.getInterchange().getProperty(MV_STORE));
    }

    @NotNull
    private static String toDriver(@NotNull String path) {
        if (path == null) {
            H2PathParamEditor.$$$reportNull$$$0(4);
        }
        for (String ext : EXTS) {
            if (!path.endsWith(ext)) continue;
            String string = path.substring(0, path.length() - ext.length());
            if (string == null) {
                H2PathParamEditor.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            H2PathParamEditor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toDriver";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }

    static final class Factory
    implements TypesRegistryUi.TypeDescriptorUiFactory {
        Factory() {
        }

        @Override
        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptorUi> consumer) {
            if (consumer == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer.consume((Object)new BaseTypeDescriptor("h2_db_file"){

                @Override
                @NotNull
                protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new H2PathParamEditor(interchange, 1.formatFieldCaption(caption));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "caption";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "interchange";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dialects/h2/ui/H2PathParamEditor$Factory$1";
                    objectArray[2] = "createFieldImpl";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/h2/ui/H2PathParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

