/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraLevelAutoSelectionStrategy;
import com.intellij.database.dialects.oracle.model.OraMajorSchemaObject;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/SimpleStrategy;", "Lcom/intellij/database/dialects/oracle/introspector/OraLevelAutoSelectionStrategy;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "selectSchemaLevel", "Lcom/intellij/database/model/properties/Level;", "schema", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "countObjectsInSchema", "", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraLevelAutoSelectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraLevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/oracle/introspector/SimpleStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1863#2,2:179\n1863#2,2:181\n1863#2,2:183\n*S KotlinDebug\n*F\n+ 1 OraLevelAutoSelectionStrategy.kt\ncom/intellij/database/dialects/oracle/introspector/SimpleStrategy\n*L\n154#1:179,2\n155#1:181,2\n156#1:183,2\n*E\n"})
final class SimpleStrategy
extends OraLevelAutoSelectionStrategy {
    @NotNull
    private final String name;

    public SimpleStrategy() {
        super(null);
        this.name = "SIMPLE";
    }

    @Override
    @NotNull
    protected String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Level selectSchemaLevel(@NotNull OraSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        String string = schema.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        boolean isSystem = OraIntrospectorFunctions.getSYSTEM_SCHEMAS().contains(name2);
        boolean isCurrent = schema.isCurrent();
        if (isSystem && !isCurrent) {
            this.trace("Auto-selected level L1 for schema " + name2 + " because this schema is system and not current");
            return Level.L1;
        }
        int count = this.countObjectsInSchema(schema);
        Level level = null;
        Object reason = null;
        if (isCurrent) {
            if (count == 0 && !isSystem) {
                level = Level.L3;
                reason = "schema is current and empty";
            } else if (count <= 3000) {
                if (isSystem) {
                    level = Level.L2;
                    reason = "schema is system but contains " + count + " objects that is not so big";
                } else if (count <= 1000) {
                    level = Level.L3;
                    reason = "schema is current and contains " + count + " objects that looks OK to retrieve them with sources";
                } else {
                    level = Level.L2;
                    reason = "schema is current and contains " + count + " objects that is so-so";
                }
            } else {
                level = Level.L1;
                reason = "schema is current but contains " + count + " objects that is too many";
            }
        } else if (count <= 100) {
            level = Level.L2;
            reason = "schema is not current but contains a small number (" + count + ") of objects";
        } else {
            level = Level.L1;
            reason = "schema is not current and contains a large number (" + count + ") of objects";
        }
        this.trace("Auto-selected level " + level + " for schema " + name2 + " because: " + (String)reason);
        return level;
    }

    private final int countObjectsInSchema(OraSchema schema) {
        OraMajorSchemaObject it;
        int cnt = 0;
        ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = schema.getTables();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
        Iterable $this$forEach$iv = modNamingIdentifyingFamily;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (OraTable)element$iv;
            boolean bl = false;
            cnt += it.getTriggers().size();
        }
        ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily2 = schema.getMatViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getMatViews(...)");
        $this$forEach$iv = modNamingIdentifyingFamily2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (OraMatView)element$iv;
            boolean bl = false;
            cnt += it.getTriggers().size() + 1;
        }
        ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily3 = schema.getViews();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
        $this$forEach$iv = modNamingIdentifyingFamily3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (OraView)element$iv;
            boolean bl = false;
            cnt += it.getTriggers().size() + 1;
        }
        return cnt += schema.getObjectTypes().size() + schema.getPackages().size() + schema.getRoutines().size();
    }
}

