/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntroQueries;
import com.intellij.database.dialects.sybase.introspector.AseIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntrospectorKt;
import com.intellij.database.dialects.sybase.introspector.SrcText;
import com.intellij.database.dialects.sybase.model.AseArgument;
import com.intellij.database.dialects.sybase.model.AseCheck;
import com.intellij.database.dialects.sybase.model.AseDatabase;
import com.intellij.database.dialects.sybase.model.AseForeignKey;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseGrantsHolder;
import com.intellij.database.dialects.sybase.model.AseIndex;
import com.intellij.database.dialects.sybase.model.AseKey;
import com.intellij.database.dialects.sybase.model.AseLikeColumn;
import com.intellij.database.dialects.sybase.model.AseLikeTable;
import com.intellij.database.dialects.sybase.model.AseLogin;
import com.intellij.database.dialects.sybase.model.AseMajorObject;
import com.intellij.database.dialects.sybase.model.AseMajorSchemaObject;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseRole;
import com.intellij.database.dialects.sybase.model.AseRoot;
import com.intellij.database.dialects.sybase.model.AseRoutine;
import com.intellij.database.dialects.sybase.model.AseSchema;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTable;
import com.intellij.database.dialects.sybase.model.AseTableColumn;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.dialects.sybase.model.AseUser;
import com.intellij.database.dialects.sybase.model.AseView;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.database.remote.jdba.util.Strings;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\"#$B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001c\u0010\u001a\u001a\u00060\u001bR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J\u001c\u0010\u001d\u001a\u00060\u001eR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J&\u0010 \u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030!R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "myQueries", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "elements", "", "introspectAllServerObjects", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "retrieveLogins", "transaction", "retrieveRoles", "createDatabaseRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "schema", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Factory", "AseDatabaseRetriever", "AseSchemaRetriever", "intellij.database.dialects.sybase"})
@SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,955:1\n1863#2,2:956\n1863#2,2:960\n216#3,2:958\n178#4,8:962\n178#4,8:970\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n*L\n78#1:956,2\n95#1:960,2\n88#1:958,2\n110#1:962,8\n127#1:970,8\n*E\n"})
public final class AseIntrospector
extends BaseMultiDatabaseIntrospector<AseRoot, AseDatabase, AseSchema> {
    @NotNull
    private final AseIntroQueries myQueries;

    public AseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.SYBASE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SYBASE");
        super(context, nature, dbms, modelFactory);
        AseIntroQueries aseIntroQueries = AseIntroQueries.QUERIES;
        Intrinsics.checkNotNullExpressionValue((Object)aseIntroQueries, (String)"QUERIES");
        this.myQueries = aseIntroQueries;
    }

    @Override
    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        LinkedHashMap res2 = new LinkedHashMap();
        for (BasicDatabase database : JBIterable.from(elements).transform(arg_0 -> AseIntrospector.checkElementsUptodate$lambda$1(AseIntrospector::checkElementsUptodate$lambda$0, arg_0)).toSet()) {
            LinkedHashMap ids = new LinkedHashMap();
            Iterable<? extends BasicElement> $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                BasicElement basicElement;
                BasicElement it = basicElement = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)database) || !AseIntrospectorKt.access$canCheckOutdated(it)) continue;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.dialects.sybase.model.AseSchemaObject");
                AseSchemaObject cfr_ignored_0 = (AseSchemaObject)it;
                ((Map)ids).put(((AseSchemaObject)it).getObjectId(), it);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            Intrinsics.checkNotNull((Object)basicDatabase);
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix(basicDatabase));
            Set set = ids.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            BaseNativeIntrospector baseNativeIntrospector = this;
            SqlQuery<List<AseIntroQueries.OneState>> sqlQuery = AseIntroQueries.QUERIES.retrieveStates;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveStates");
            List states = (List)BaseNativeIntrospector.performQuery$default(baseNativeIntrospector, sqlQuery, null, 2, null);
            Map $this$forEach$iv2 = ids;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = iterator2.next();
                boolean bl = false;
                AseSchemaObject v = (AseSchemaObject)entry.getValue();
                ((Map)res2).put(v, false);
            }
            for (AseIntroQueries.OneState s : states) {
                AseSchemaObject aseSchemaObject;
                if ((AseSchemaObject)ids.get(s.object_id) == null) continue;
                ((Map)res2).put(aseSchemaObject, aseSchemaObject.getStateNumber() == s.state_nr);
            }
        }
        this.inModel(arg_0 -> AseIntrospector.checkElementsUptodate$lambda$5(res2, arg_0));
        return res2;
    }

    @Override
    protected void introspectAllServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveLogins(tran);
        this.retrieveRoles(tran);
    }

    private final void retrieveLogins(DBTransaction transaction) {
        SqlQuery<List<AseIntroQueries.OneLogin>> sqlQuery = this.myQueries.retrieveLogins;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveLogins");
        List<AseIntroQueries.OneLogin> logins = this.performQuery(transaction, sqlQuery);
        this.inModel(arg_0 -> AseIntrospector.retrieveLogins$lambda$8(logins, arg_0));
    }

    private final void retrieveRoles(DBTransaction transaction) {
        block2: {
            try {
                SqlQuery<List<AseIntroQueries.OneRole>> sqlQuery = this.myQueries.retrieveRoles;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveRoles");
                List<AseIntroQueries.OneRole> roles = this.performQuery(transaction, sqlQuery);
                this.inModel(arg_0 -> AseIntrospector.retrieveRoles$lambda$11(roles, arg_0));
            }
            catch (DBException e) {
                this.inModel(AseIntrospector::retrieveRoles$lambda$12);
                String string = e.getMessage();
                if (string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"permission denied", (boolean)true) : false) break block2;
                throw e;
            }
        }
    }

    @NotNull
    protected AseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull AseDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new AseDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected AseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull AseSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new AseSchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<LongIdName, AseDatabase>(this){
            final /* synthetic */ AseIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            protected List<LongIdName> listDatabases(DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                List<LongIdName> list = tran.query(AseIntrospector.access$getMyQueries$p((AseIntrospector)this.this$0).listDatabases).runOnce();
                Intrinsics.checkNotNullExpressionValue(list, (String)"runOnce(...)");
                return list;
            }

            protected AseDatabase applyDatabase(ModNamingFamily<?> databases, LongIdName db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (AseDatabase)this.renew(databases, db.id, db.name);
            }
        };
    }

    private static final BasicDatabase checkElementsUptodate$lambda$0(BasicElement it) {
        return it.getDatabase();
    }

    private static final BasicDatabase checkElementsUptodate$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    private static final Unit checkElementsUptodate$lambda$5(LinkedHashMap $res, AseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $res.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            BasicElement obj2 = (BasicElement)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Boolean ok2 = (Boolean)v;
            Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
            ((BasicModElement)obj2).setOutdated(ok2 == false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveLogins$lambda$8(List $logins, AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = r.getLogins();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        for (AseIntroQueries.OneLogin l : $logins) {
            AseLogin aseLogin;
            Intrinsics.checkNotNullExpressionValue((Object)r.getLogins().renew(l.id, l.name), (String)"renew(...)");
            AseLogin $this$retrieveLogins_u24lambda_u248_u24lambda_u247_u24lambda_u246 = aseLogin;
            boolean bl2 = false;
            $this$retrieveLogins_u24lambda_u248_u24lambda_u247_u24lambda_u246.setDefaultDatabaseRef(BasicNameReference.create(l.default_db));
            $this$retrieveLogins_u24lambda_u248_u24lambda_u247_u24lambda_u246.setLanguage(l.language);
            $this$retrieveLogins_u24lambda_u248_u24lambda_u247_u24lambda_u246.setFullName(l.fullname);
            $this$retrieveLogins_u24lambda_u248_u24lambda_u247_u24lambda_u246.setLoginScriptId(l.procid);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$11(List $roles, AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = r.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        for (AseIntroQueries.OneRole role : $roles) {
            AseRole aseRole;
            Intrinsics.checkNotNullExpressionValue((Object)r.getRoles().renew(role.id, role.name), (String)"renew(...)");
            AseRole $this$retrieveRoles_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = aseRole;
            boolean bl2 = false;
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$12(AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        r.getRoles().clear();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseDatabase;)V", "beforeSchemasRetrieval", "", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "retrieveGrants", "retrieveUsers", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,955:1\n1863#2,2:956\n178#3,8:958\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n*L\n183#1:956,2\n190#1:958,8\n*E\n"})
    protected final class AseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<AseDatabase> {
        public AseDatabaseRetriever(@NotNull DBTransaction transaction, AseDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)AseIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        protected void beforeSchemasRetrieval() {
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix((BasicDatabase)this.getDatabase()));
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveSchemas$lambda$0(this, AseIntrospector.this, arg_0));
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            super.retrieveServerAndDatabaseObjects();
            this.retrieveUsers();
            this.retrieveGrants();
        }

        private final void retrieveGrants() {
            SqlQuery<List<AseIntroQueries.OneGrant>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveDatabaseGrants;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveDatabaseGrants");
            List<AseIntroQueries.OneGrant> grants = this.performQuery(sqlQuery);
            Intrinsics.checkNotNull(grants);
            Iterable $this$forEach$iv = grants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseIntroQueries.OneGrant it = (AseIntroQueries.OneGrant)element$iv;
                boolean bl = false;
                if (it.object_id != 0) continue;
                it.object_id = (int)((AseDatabase)this.getDatabase()).getObjectId();
            }
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveGrants$lambda$2(grants, arg_0));
        }

        private final void retrieveUsers() {
            SqlQuery<List<AseIntroQueries.OneUser>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveUsers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveUsers");
            List<AseIntroQueries.OneUser> users = this.performQuery(sqlQuery);
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveUsers$lambda$5(users, arg_0));
        }

        private static final Unit retrieveSchemas$lambda$0(AseDatabaseRetriever this$0, AseIntrospector this$1, AseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            NamingFamily namingFamily = it.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
            SqlQuery<List<LongIdName>> sqlQuery = ((AseIntrospector)this$1).myQueries.listSchemas;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"listSchemas");
            List<LongIdName> list = this$0.performQuery(sqlQuery);
            Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
            ModelFun.applyNameIds(namingFamily, list);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveGrants$lambda$2(List $grants, AseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AseGrantsHolder aseGrantsHolder = it;
            Intrinsics.checkNotNull((Object)$grants);
            AseIntrospectorKt.access$applyGrants(aseGrantsHolder, $grants);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsers$lambda$5(List $users, AseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getUsers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            for (AseIntroQueries.OneUser user : $users) {
                AseUser aseUser;
                Intrinsics.checkNotNullExpressionValue((Object)db.getUsers().renew(user.id, user.name), (String)"renew(...)");
                AseUser $this$retrieveUsers_u24lambda_u245_u24lambda_u244_u24lambda_u243 = aseUser;
                boolean bl2 = false;
                $this$retrieveUsers_u24lambda_u245_u24lambda_u244_u24lambda_u243.setGroupRef(BasicIdReference.create(user.group_id));
                $this$retrieveUsers_u24lambda_u245_u24lambda_u244_u24lambda_u243.setLoginRef(BasicIdReference.create(user.login_id));
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020\u0014H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\b\u0010,\u001a\u00020\u0014H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u001a\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020\u0014H\u0002J\b\u00106\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseSchema;)V", "schemaId", "", "rewriter", "Lcom/intellij/database/remote/jdba/util/StringOperator;", "wasProcedures", "", "isPossibleToIntrospectSchemaIncrementally", "tran", "clearSchema", "", "analyzeCurrentContent", "retrieveGrants", "retrieveMajorNames", "retrieveMainContent", "retrieveProcedures", "retrieveColumnsAndArguments", "addRoutineArgument", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "ca", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries$OneColumnOrArgument;", "dt", "Lcom/intellij/database/model/DataType;", "retrieveIndicesAndKeys", "peekIndexColumns", "index", "Lcom/intellij/database/dialects/sybase/model/AseIndex;", "keys", "", "peekColumnPositions", "", "retrieveForeignKeys", "retrieveCheckConstraints", "retrieveDefaults", "adjustDef", "", "def", "cleanupTableDefaults", "table", "Lcom/intellij/database/dialects/sybase/model/AseTable;", "columnsWithDef", "Lit/unimi/dsi/fastutil/ints/IntSet;", "retrieveTriggers", "retrieveSources", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n+ 2 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 7 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,955:1\n48#2:956\n38#2:957\n48#2:1091\n38#2:1092\n48#2:1093\n38#2:1094\n48#2:1095\n38#2:1096\n48#2:1105\n38#2:1106\n48#2:1107\n38#2:1108\n48#2:1109\n38#2:1110\n48#2:1111\n38#2:1112\n48#2:1113\n38#2:1114\n295#3,2:958\n1863#3,2:1029\n1557#3:1058\n1628#3,3:1059\n1368#3:1081\n1454#3,5:1082\n1863#3,2:1087\n1863#3,2:1089\n1863#3,2:1097\n1863#3,2:1099\n1863#3,2:1101\n1863#3,2:1103\n1863#3,2:1115\n1863#3,2:1117\n1863#3,2:1119\n1863#3,2:1121\n295#3,2:1169\n1863#3,2:1171\n1863#3,2:1174\n1863#3,2:1176\n1863#3,2:1178\n108#4:960\n80#4,22:961\n108#4:983\n80#4,22:984\n108#4:1006\n80#4,22:1007\n108#4:1123\n80#4,22:1124\n108#4:1146\n80#4,22:1147\n367#5:1031\n368#5,2:1037\n1057#6:1032\n1151#6,2:1033\n1058#6,2:1035\n1062#6:1039\n1156#6,2:1040\n1063#6,2:1042\n195#7,14:1044\n246#7,4:1062\n250#7:1068\n198#7,11:1069\n251#7:1080\n37#8,2:1066\n1#9:1173\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n*L\n374#1:956\n374#1:957\n348#1:1091\n348#1:1092\n349#1:1093\n349#1:1094\n351#1:1095\n351#1:1096\n418#1:1105\n418#1:1106\n419#1:1107\n419#1:1108\n420#1:1109\n420#1:1110\n438#1:1111\n438#1:1112\n442#1:1113\n442#1:1114\n456#1:958,2\n633#1:1029,2\n309#1:1058\n309#1:1059,3\n325#1:1081\n325#1:1082,5\n326#1:1087,2\n327#1:1089,2\n367#1:1097,2\n368#1:1099,2\n369#1:1101,2\n407#1:1103,2\n446#1:1115,2\n486#1:1117,2\n534#1:1119,2\n547#1:1121,2\n568#1:1169,2\n578#1:1171,2\n614#1:1174,2\n646#1:1176,2\n662#1:1178,2\n622#1:960\n622#1:961,22\n624#1:983\n624#1:984,22\n627#1:1006\n627#1:1007,22\n557#1:1123\n557#1:1124,22\n559#1:1146\n559#1:1147,22\n679#1:1031\n679#1:1037,2\n679#1:1032\n679#1:1033,2\n679#1:1035,2\n679#1:1039\n679#1:1040,2\n679#1:1042,2\n262#1:1044,14\n309#1:1062,4\n309#1:1068\n309#1:1069,11\n309#1:1080\n309#1:1066,2\n*E\n"})
    protected final class AseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<AseSchema> {
        private final int schemaId;
        @NotNull
        private final StringOperator rewriter;
        private boolean wasProcedures;

        public AseSchemaRetriever(@NotNull DBTransaction transaction, AseSchema schema) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)AseIntrospector.this, transaction, (BasicModSchema)schema);
            this.schemaId = (int)schema.getObjectId();
            AseDatabase db = schema.getDatabase();
            if (db == null || db.isCurrent()) {
                object = "dbo";
            } else {
                char c2 = '[';
                String string = db.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                object = c2 + string2 + "].dbo";
            }
            String catalogPrefix = object;
            this.rewriter = arg_0 -> AseSchemaRetriever._init_$lambda$0(catalogPrefix, arg_0);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        protected void clearSchema() {
        }

        @Override
        protected void analyzeCurrentContent() {
        }

        private final void retrieveGrants() {
            Object[] objectArray = new Object[]{this.schemaId};
            List grants = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSchemaGrants.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveGrants$lambda$1(grants, arg_0));
        }

        @Override
        protected void retrieveMajorNames() {
            AseIntrospector.this.reportRetrieving("major object names", "introspection.retrieve.majorObjectNames");
            Object[] objectArray = new Object[]{this.schemaId};
            List ms = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveMajorNames$lambda$3(ms, this, arg_0));
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveProcedures();
            this.retrieveColumnsAndArguments();
            this.retrieveDefaults();
            this.retrieveIndicesAndKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveTriggers();
            this.retrieveGrants();
            this.retrieveSources();
            this.finishSchema();
        }

        private final void retrieveProcedures() {
            if (!this.wasProcedures) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ps = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveProcedures$lambda$6(ps, arg_0));
        }

        private final void retrieveColumnsAndArguments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cas = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveColumnsAndArguments$lambda$13(cas, AseIntrospector.this, this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void addRoutineArgument(BasicModRoutine routine2, AseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            BasicModArgument basicModArgument;
            boolean result2;
            void $this$and$iv;
            short s = ca.bits2;
            short that$iv = 2;
            boolean $i$f$and = false;
            short $this$toUnsignedInt$iv$iv = $this$and$iv;
            boolean $i$f$toUnsignedInt = false;
            int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
            $this$toUnsignedInt$iv$iv = that$iv;
            $i$f$toUnsignedInt = false;
            boolean out = (short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0;
            boolean bl = result2 = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            if (result2) {
                basicModArgument = routine2.createOrGetReturnArgument();
            } else {
                AseArgument aseArgument;
                BasicModRoutine basicModRoutine = routine2;
                if (basicModRoutine instanceof AseFunction) {
                    PositioningNamingFamily positioningNamingFamily = ((AseFunction)routine2).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)((Object)positioningNamingFamily);
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else if (basicModRoutine instanceof AseProcedure) {
                    PositioningNamingFamily positioningNamingFamily = ((AseProcedure)routine2).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)((Object)positioningNamingFamily);
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else {
                    return;
                }
                basicModArgument = aseArgument;
            }
            BasicModArgument basicModArgument2 = basicModArgument;
            Intrinsics.checkNotNull((Object)basicModArgument2);
            BasicModArgument argument = basicModArgument2;
            argument.setPosition(ca.colid);
            argument.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
            if (!result2) {
                argument.setArgumentDirection(out ? ArgumentDirection.OUT : ArgumentDirection.IN);
            }
        }

        private final void retrieveIndicesAndKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List inds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveIndicesAndKeys$lambda$16(inds, this, arg_0));
        }

        private final void peekIndexColumns(AseIndex index, byte[] keys) {
            short[] positions = this.peekColumnPositions(keys);
            ImmutableList.Builder names = ImmutableList.builder();
            for (short position : positions) {
                Object v2;
                block2: {
                    if (position == 0) break;
                    AseTable aseTable = index.getTable();
                    Intrinsics.checkNotNull((Object)aseTable);
                    PositioningNamingFamily positioningNamingFamily = aseTable.getColumns();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                    Iterable $this$firstOrNull$iv = positioningNamingFamily;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AseTableColumn column2 = (AseTableColumn)element$iv;
                        boolean bl = false;
                        if (!(column2.getPosition() == position)) continue;
                        v2 = element$iv;
                        break block2;
                    }
                    v2 = null;
                }
                AseTableColumn column3 = v2;
                if (column3 == null) continue;
                names.add((Object)column3.getName());
            }
            index.setColNames((List)names.build());
        }

        private final short[] peekColumnPositions(byte[] keys) {
            int n = (keys.length + 7) / 16;
            short[] positions = new short[n];
            for (int i2 = 0; i2 < n; ++i2) {
                short position;
                int offset = i2 << 4 | 4;
                positions[i2] = position = AseIntrospectorKt.peek16(keys, offset);
                if (position == 0) break;
            }
            return positions;
        }

        private final void retrieveForeignKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List fks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            Ref.BooleanRef wides = new Ref.BooleanRef();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveForeignKeys$lambda$19(fks, wides, arg_0));
            if (wides.element) {
                Object[] objectArray2 = new Object[]{this.schemaId};
                List wfks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(objectArray2).runOnce();
                this.inSchema(arg_0 -> AseSchemaRetriever.retrieveForeignKeys$lambda$20(wfks, arg_0));
            }
            this.inSchema(AseSchemaRetriever::retrieveForeignKeys$lambda$22);
        }

        private final void retrieveCheckConstraints() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cs = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveCheckConstraints$lambda$28(cs, arg_0));
        }

        private final void retrieveDefaults() {
            ObjectKind objectKind = ObjectKind.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DEFAULT");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveDefaults$lambda$33(ds, this, arg_0));
        }

        private final String adjustDef(String def) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String res2;
            String $this$trim$iv = res2 = def;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"DEFAULT", (boolean)false, (int)2, null)) {
                String string = res2.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else if (StringsKt.startsWith$default((String)res2, (String)"AS", (boolean)false, (int)2, null)) {
                String string = res2.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            return res2;
        }

        private final void cleanupTableDefaults(AseTable table, IntSet columnsWithDef) {
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            Iterable $this$forEach$iv = positioningNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTableColumn c2 = (AseTableColumn)element$iv;
                boolean bl = false;
                if (columnsWithDef != null && columnsWithDef.contains((int)c2.getPosition())) continue;
                c2.setDefaultExpression(null);
            }
        }

        private final void retrieveTriggers() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ts2 = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveTriggers$lambda$40(ts2, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveSources() {
            void this_$iv$iv;
            if (AseIntrospector.this.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES) {
                return;
            }
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty() && ((AseSchema)this.getSchema()).getProcedureGroups().isEmpty() && ((AseSchema)this.getSchema()).getFunctions().isEmpty()) {
                return;
            }
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ss = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            if (ss.isEmpty()) {
                return;
            }
            Intrinsics.checkNotNull((Object)ss);
            Iterable ts2 = BaseIntrospectionFunctions.group(ss, AseSchemaRetriever::retrieveSources$lambda$41, retrieveSources.ts.2.INSTANCE, AseSchemaRetriever::retrieveSources$lambda$42);
            BaseNativeIntrospector this_$iv = AseIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, ts2){
                    final /* synthetic */ AseSchemaRetriever this$0;
                    final /* synthetic */ Iterable $ts$inlined;
                    {
                        this.this$0 = aseSchemaRetriever;
                        this.$ts$inlined = iterable;
                    }

                    public final void run() {
                        boolean bl = false;
                        AseSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<AseSchema, Unit>((Iterable<SrcText>)this.$ts$inlined){
                            final /* synthetic */ Iterable<SrcText> $ts;
                            {
                                this.$ts = $ts;
                            }

                            public final void invoke(AseSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                for (SrcText t : this.$ts) {
                                    BasicNode basicNode;
                                    BasicNode basicNode2;
                                    BasicModSourceAware o = t.getMinor_kind() == 'G' ? (BasicModSourceAware)((basicNode2 = AseIntrospectorKt.access$findTableOrView(schema, t.getMajor_kind(), t.getMajor_id())) != null && (basicNode2 = basicNode2.getTriggers()) != null ? (AseTrigger)basicNode2.getByObjectId(t.getMinor_id()) : null) : (t.getMajor_kind() == 'V' ? (BasicModSourceAware)schema.getViews().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'F' ? (BasicModSourceAware)schema.getFunctions().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'P' ? (BasicModSourceAware)((basicNode = (AseProcedureGroup)schema.getProcedureGroups().getByObjectId(t.getMajor_id())) != null && (basicNode = basicNode.getProcedures()) != null ? (AseProcedure)basicNode.getByNaturalPosition((short)t.getMinor_id()) : null) : null)));
                                    if (o == null) continue;
                                    String string = t.getText();
                                    o.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                });
            }
            finally {
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (ref$iv$iv != null) {
                    DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
                    if (dataSourceDiagnosticRecorder2 != null) {
                        DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, ref$iv$iv, null, 2, null);
                    }
                }
            }
        }

        private static final String _init_$lambda$0(String $catalogPrefix, String arg) {
            return Strings.replace((String)arg, (String)"#CAT", (String)$catalogPrefix);
        }

        private static final Unit retrieveGrants$lambda$1(List $grants, AseSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AseGrantsHolder aseGrantsHolder = it;
            Intrinsics.checkNotNull((Object)$grants);
            AseIntrospectorKt.access$applyGrants(aseGrantsHolder, $grants);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveMajorNames$lambda$3(List $ms, AseSchemaRetriever this$0, AseSchema schema) {
            void families$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily[] modFamilyArray = new ModFamily[]{schema.getTables(), schema.getViews(), schema.getFunctions(), schema.getProcedureGroups()};
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            block7: for (AseIntroQueries.OneMajorName m : $ms) {
                AseMajorSchemaObject obj2;
                ModNamingIdentifyingFamily<AseMajorSchemaObject> family = null;
                switch (m.type) {
                    case 'S': 
                    case 'U': {
                        family = schema.getTables();
                        break;
                    }
                    case 'V': {
                        family = schema.getViews();
                        break;
                    }
                    case 'F': {
                        family = schema.getFunctions();
                        break;
                    }
                    case 'P': {
                        family = schema.getProcedureGroups();
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                this$0.wasProcedures = this$0.wasProcedures | m.type == 'P';
                Intrinsics.checkNotNullExpressionValue((Object)family.renew(m.id, m.name), (String)"renew(...)");
                obj2.setStateNumber(m.state_nr);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveProcedures$lambda$6(List $ps, AseSchema schema) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> groups = modNamingIdentifyingFamily;
            Iterable $this$map$iv = groups;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AseProcedureGroup aseProcedureGroup = (AseProcedureGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProcedures());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            for (AseIntroQueries.OneProcedure p2 : $ps) {
                AseProcedureGroup aseProcedureGroup;
                if ((AseProcedureGroup)groups.getByObjectId((long)p2.id) == null) continue;
                Intrinsics.checkNotNull((Object)aseProcedureGroup);
                AseProcedureGroup group = aseProcedureGroup;
                group.getProcedures().createOrGetAt(p2.procedure_position);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnsAndArguments$lambda$13(List $cas, AseIntrospector this$0, AseSchemaRetriever this$1, AseSchema schema) {
            Iterator<Object> $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
            Iterable $this$flatMap$iv = modNamingIdentifyingFamily;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                AseProcedureGroup it = (AseProcedureGroup)element$iv$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends AseProcedure> modPositioningNamingFamily = it.getProcedures();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getProcedures(...)");
                Iterable list$iv$iv = modPositioningNamingFamily;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable procedures = (List)destination$iv$iv;
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            Iterable iterable2 = modNamingIdentifyingFamily2;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
            Iterable $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)modNamingIdentifyingFamily3);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseLikeTable it = (AseLikeTable)element$iv;
                boolean bl = false;
                it.getColumns().markChildrenAsSyncPending();
            }
            ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily4 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getFunctions(...)");
            $this$forEach$iv = CollectionsKt.plus((Iterable)modNamingIdentifyingFamily4, (Iterable)procedures);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseRoutine it = (AseRoutine)element$iv;
                boolean bl = false;
                it.getArguments().markChildrenAsSyncPending();
            }
            AseMajorObject obj2 = null;
            int objId = Integer.MIN_VALUE;
            for (AseIntroQueries.OneColumnOrArgument ca : $cas) {
                if (obj2 == null || objId != ca.id) {
                    obj2 = AseIntrospectorKt.access$findObjectById(schema, ca.id);
                    objId = ca.id;
                    if (obj2 == null) continue;
                }
                DataType dt = AseIntrospectorKt.access$makeDataType(ca.type_name, ca.length, ca.prec, ca.scale, ca.variable, this$0.getServerVersion());
                if (obj2 instanceof AseLikeTable) {
                    short $this$and$iv;
                    AseLikeColumn column2 = (AseLikeColumn)((AseLikeTable)obj2).getColumns().createOrGet(ca.name);
                    column2.setPosition(ca.colid);
                    column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
                    short element$iv$iv = ca.bits1;
                    short that$iv = 8;
                    boolean $i$f$and = false;
                    short $this$toUnsignedInt$iv$iv = $this$and$iv;
                    boolean $i$f$toUnsignedInt = false;
                    int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                    $this$toUnsignedInt$iv$iv = that$iv;
                    $i$f$toUnsignedInt = false;
                    column2.setNotNull((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0);
                    $this$and$iv = ca.bits2;
                    that$iv = 16;
                    $i$f$and = false;
                    $this$toUnsignedInt$iv$iv = $this$and$iv;
                    $i$f$toUnsignedInt = false;
                    int n2 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                    $this$toUnsignedInt$iv$iv = that$iv;
                    $i$f$toUnsignedInt = false;
                    column2.setComputed((short)(n2 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                    if (column2 instanceof AseTableColumn) {
                        $this$and$iv = ca.bits1;
                        that$iv = 128;
                        $i$f$and = false;
                        $this$toUnsignedInt$iv$iv = $this$and$iv;
                        $i$f$toUnsignedInt = false;
                        int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        ((AseTableColumn)column2).setSequenceIdentity((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0 ? SequenceIdentity.UNKNOWN : null);
                    }
                }
                if (obj2 instanceof BasicModRoutine) {
                    BasicModRoutine basicModRoutine = (BasicModRoutine)((Object)obj2);
                    Intrinsics.checkNotNull((Object)ca);
                    this$1.addRoutineArgument(basicModRoutine, ca, dt);
                }
                if (!(obj2 instanceof AseProcedureGroup)) continue;
                AseProcedure procedure = (AseProcedure)((AseProcedureGroup)obj2).getProcedures().createOrGetAt(ca.procedure_position);
                Intrinsics.checkNotNull((Object)procedure);
                BasicModRoutine basicModRoutine = procedure;
                Intrinsics.checkNotNull((Object)ca);
                this$1.addRoutineArgument(basicModRoutine, ca, dt);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily5 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTables(...)");
            Iterable iterable3 = modNamingIdentifyingFamily5;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily6 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getViews(...)");
            Iterable $this$forEach$iv2 = CollectionsKt.plus((Iterable)iterable3, (Iterable)modNamingIdentifyingFamily6);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseLikeTable it = (AseLikeTable)element$iv;
                boolean bl = false;
                PositioningNamingFamily positioningNamingFamily = it.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                AseIntrospectorKt.access$finish((ModFamily)((Object)positioningNamingFamily));
            }
            ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily7 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getFunctions(...)");
            $this$forEach$iv2 = CollectionsKt.plus((Iterable)modNamingIdentifyingFamily7, (Iterable)procedures);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseRoutine it = (AseRoutine)element$iv;
                boolean bl = false;
                PositioningNamingFamily positioningNamingFamily = it.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                AseIntrospectorKt.access$finish((ModFamily)((Object)positioningNamingFamily));
            }
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily8 = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getProcedureGroups(...)");
            $this$forEach$iv2 = modNamingIdentifyingFamily8;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseProcedureGroup it = (AseProcedureGroup)element$iv;
                boolean bl = false;
                it.getProcedures().sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveIndicesAndKeys$lambda$16(List $inds, AseSchemaRetriever this$0, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            AseTable table = null;
            int tableId = Integer.MIN_VALUE;
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Object $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                it.getIndices().markChildrenAsSyncPending();
                it.getKeys().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneIndex ind : $inds) {
                void $this$and$iv;
                short $this$and$iv2;
                if (table == null || tableId != ind.id) {
                    if ((AseTable)schema.getTables().getByObjectId((long)ind.id) == null) continue;
                    tableId = ind.id;
                }
                AseIndex index = (AseIndex)table.getIndices().createOrGet(ind.name);
                index.setPosition(ind.position);
                short element$iv = ind.bits2;
                short that$iv = 8;
                boolean $i$f$and = false;
                short $this$toUnsignedInt$iv$iv = $this$and$iv2;
                boolean $i$f$toUnsignedInt = false;
                int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setNameSurrogate((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                $this$and$iv2 = ind.bits1;
                that$iv = 16;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv2;
                $i$f$toUnsignedInt = false;
                int n2 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setClustering((short)(n2 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                $this$and$iv2 = ind.bits1;
                that$iv = 2;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv2;
                $i$f$toUnsignedInt = false;
                int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setUnique((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                if (ind.keys1 != null) {
                    byte[] keys = null;
                    Object object = ind.keys1;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    byte[] keys1 = (byte[])object;
                    if (ind.keys2 == null) {
                        keys = keys1;
                    } else {
                        Object object2 = ind.keys2;
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                        byte[] keys2 = (byte[])object2;
                        keys = new byte[keys1.length + keys2.length];
                        System.arraycopy(keys1, 0, keys, 0, keys1.length);
                        System.arraycopy(keys2, 0, keys, keys1.length, keys2.length);
                    }
                    Intrinsics.checkNotNull((Object)index);
                    this$0.peekIndexColumns(index, keys);
                }
                short keys = ind.bits2;
                that$iv = 2;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv;
                $i$f$toUnsignedInt = false;
                int n4 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                if ((short)(n4 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0) continue;
                AseKey key2 = (AseKey)table.getKeys().createOrGet(ind.name);
                key2.setNameSurrogate(index.isNameSurrogate());
                key2.setUnderlyingIndexRef(BasicNameReference.create(ind.name));
                that$iv = ind.bits1;
                short that$iv2 = 2048;
                boolean $i$f$and2 = false;
                short $this$toUnsignedInt$iv$iv2 = $this$and$iv;
                boolean $i$f$toUnsignedInt2 = false;
                int n5 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv2);
                $this$toUnsignedInt$iv$iv2 = that$iv2;
                $i$f$toUnsignedInt2 = false;
                key2.setPrimary((short)(n5 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv2)) != 0);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                Family family = it.getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
                AseIntrospectorKt.access$finish((ModFamily)family);
                NamingFamily namingFamily = it.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getKeys(...)");
                AseIntrospectorKt.access$finish((ModFamily)((Object)namingFamily));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$19(List $fks, Ref.BooleanRef $wides, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                it.getForeignKeys().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneForeignKey fk : $fks) {
                AseTable table;
                if ((AseTable)schema.getTables().getByObjectId(fk.source_table_id) == null) continue;
                Object e = table.getForeignKeys().renew(fk.source_constraint_id, fk.source_constraint_name);
                Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                AseForeignKey foreignKey = (AseForeignKey)e;
                foreignKey.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(fk.source_constraint_name, fk.source_constraint_id));
                BasicIdReference idRef = BasicIdReference.create(fk.target_table_id);
                foreignKey.setRefTableRef(BasicIdOrNameReference.create(idRef, BasicMetaUtils.createPortableReference((BasicElement)foreignKey, BasicModForeignKey.REF_TABLE_REF, (BasicReference)idRef)));
                foreignKey.setRefIndexRef(BasicPositionReference.create(fk.target_index_position));
                short n = fk.involved_columns_count;
                if (n <= 4) {
                    short[] columnPositions = new short[n];
                    if (n >= 1) {
                        columnPositions[0] = fk.column_position_1;
                    }
                    if (n >= 2) {
                        columnPositions[1] = fk.column_position_2;
                    }
                    if (n >= 3) {
                        columnPositions[2] = fk.column_position_3;
                    }
                    if (n >= 4) {
                        columnPositions[3] = fk.column_position_4;
                    }
                    AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                    continue;
                }
                $wides.element = true;
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$20(List $wfks, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (int[] wfk : $wfks) {
                AseForeignKey foreignKey;
                int n;
                int constraintId = wfk[0];
                if (AseIntrospectorKt.access$findForeignKeyById(schema, constraintId) == null) continue;
                for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                }
                short[] columnPositions = new short[n];
                int n2 = n;
                for (int i2 = 0; i2 < n2; ++i2) {
                    columnPositions[i2] = (short)wfk[i2 + 1];
                }
                AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$22(AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                NamingFamily namingFamily = it.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getForeignKeys(...)");
                AseIntrospectorKt.access$finish((ModFamily)((Object)namingFamily));
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveCheckConstraints$lambda$28(List $cs, AseSchema schema) {
            AseTable it;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Object $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseTable)element$iv;
                boolean bl = false;
                it.getChecks().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneCheck c2 : $cs) {
                BasicNamedElement basicNamedElement;
                AseTable table;
                if ((AseTable)schema.getTables().getByObjectId(c2.table_id) == null) continue;
                Object e = table.getChecks().renew(c2.constraint_id, c2.constraint_name);
                Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                AseCheck check = (AseCheck)e;
                check.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(c2.constraint_name, c2.constraint_id));
                if (c2.definition != null) {
                    String s;
                    int len;
                    void $this$trim$iv;
                    String string = c2.definition;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"definition");
                    int p2 = StringsKt.indexOf$default((CharSequence)string, (String)"CHECK", (int)0, (boolean)false, (int)6, null);
                    p2 = p2 >= 0 ? p2 + 5 : 0;
                    String string2 = c2.definition;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"definition");
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(p2), (String)"substring(...)");
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if ((len = (s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length()) >= 3 && s.charAt(0) == '(' && s.charAt(len - 1) == ')') {
                        void $this$trim$iv2;
                        Intrinsics.checkNotNullExpressionValue((Object)s.substring(1, len - 1), (String)"substring(...)");
                        boolean $i$f$trim3 = false;
                        CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
                        boolean $i$f$trim4 = false;
                        int startIndex$iv$iv2 = 0;
                        int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        boolean startFound$iv$iv2 = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            char it3 = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        s = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                    }
                    check.setPredicate(s);
                } else {
                    check.setPredicate(null);
                }
                if (c2.column_position > 0) {
                    Object v8;
                    block15: {
                        AseTable aseTable = check.getTable();
                        Intrinsics.checkNotNull((Object)aseTable);
                        PositioningNamingFamily positioningNamingFamily = aseTable.getColumns();
                        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                        Iterable $this$firstOrNull$iv = positioningNamingFamily;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            AseTableColumn col = (AseTableColumn)element$iv2;
                            boolean bl = false;
                            if (!(col.getPosition() == c2.column_position)) continue;
                            v8 = element$iv2;
                            break block15;
                        }
                        v8 = null;
                    }
                    basicNamedElement = v8;
                } else {
                    basicNamedElement = null;
                }
                BasicNamedElement column2 = basicNamedElement;
                BasicNamedElement basicNamedElement2 = column2;
                check.setColNames(basicNamedElement2 != null ? Collections.singletonList(basicNamedElement2.getName()) : CollectionsKt.emptyList());
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseTable)element$iv;
                boolean bl = false;
                NamingFamily namingFamily = it.getChecks();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getChecks(...)");
                AseIntrospectorKt.access$finish((ModFamily)((Object)namingFamily));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDefaults$lambda$33(List $ds, AseSchemaRetriever this$0, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            AseTable obj2 = null;
            int objectId = Integer.MIN_VALUE;
            IntOpenHashSet tablesWithDefs = new IntOpenHashSet();
            IntOpenHashSet columnsWithDefs = new IntOpenHashSet();
            for (AseIntroQueries.OneDefault d : $ds) {
                BasicModNamedElement it;
                if (obj2 == null || objectId != d.id) {
                    if (obj2 != null) {
                        boolean bl = false;
                        this$0.cleanupTableDefaults((AseTable)it, (IntSet)columnsWithDefs);
                    }
                    obj2 = (AseTable)schema.getTables().getByObjectId(d.id);
                    objectId = d.id;
                    if (obj2 == null) continue;
                    columnsWithDefs.clear();
                    tablesWithDefs.add(objectId);
                }
                columnsWithDefs.add((int)d.position);
                String string = d.text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                String def = this$0.adjustDef(string);
                if ((AseTableColumn)obj2.getColumns().getByNaturalPosition(d.position) == null) continue;
                BasicModNamedElement $this$retrieveDefaults_u24lambda_u2433_u24lambda_u2430 = it;
                boolean bl = false;
                $this$retrieveDefaults_u24lambda_u2433_u24lambda_u2430.setDefaultExpression(def);
            }
            AseTable aseTable = obj2;
            if (aseTable != null) {
                AseTable it = aseTable;
                boolean bl = false;
                this$0.cleanupTableDefaults(it, (IntSet)columnsWithDefs);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable tab = (AseTable)element$iv;
                boolean bl = false;
                if (tablesWithDefs.contains((int)tab.getObjectId())) continue;
                Intrinsics.checkNotNull((Object)tab);
                this$0.cleanupTableDefaults(tab, null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTriggers$lambda$40(List $ts, AseSchema schema) {
            AseLikeTable it;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable iterable = modNamingIdentifyingFamily;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily2 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getViews(...)");
            Object $this$forEach$iv = CollectionsKt.plus((Iterable)iterable, (Iterable)modNamingIdentifyingFamily2);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseLikeTable)element$iv;
                boolean bl = false;
                it.getTriggers().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneTrigger t : $ts) {
                AseTrigger trigger2;
                AseLikeTable aseLikeTable;
                AseTable aseTable = (AseTable)schema.getTables().getByObjectId(t.table_id);
                if (aseTable != null) {
                    aseLikeTable = aseTable;
                } else {
                    AseView aseView = (AseView)schema.getViews().getByObjectId(t.table_id);
                    if (aseView == null) continue;
                    aseLikeTable = aseView;
                }
                AseLikeTable table = aseLikeTable;
                Intrinsics.checkNotNullExpressionValue((Object)table.getTriggers().renew(t.trig_id, t.trig_name), (String)"renew(...)");
                TrigEvent event = TrigEvent.of(t.event_code);
                AseIntrospectorKt.access$addEvent(trigger2, event);
                trigger2.setStateNumber(t.state_nr);
                trigger2.setTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily3 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
            Iterable iterable2 = modNamingIdentifyingFamily3;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily4 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getViews(...)");
            $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)modNamingIdentifyingFamily4);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseLikeTable)element$iv;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends AseTrigger> modNamingIdentifyingFamily5 = it.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTriggers(...)");
                AseIntrospectorKt.access$finish(modNamingIdentifyingFamily5);
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveSources$lambda$41(AseIntroQueries.OneSource a, AseIntroQueries.OneSource b) {
            return a.major_id == b.major_id && a.major_kind == b.major_kind && a.minor_id == b.minor_id && a.minor_kind == b.minor_kind;
        }

        private static final SrcText retrieveSources$lambda$42(SrcText x, AseIntroQueries.OneSource os) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return SrcText.copy$default(x, '\u0000', '\u0000', 0, 0, AseIntrospectorKt.access$joinSourceTextParts(x.getText(), os.text), 15, null);
        }

        public static final /* synthetic */ void access$inSchema(AseSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "isIncremental", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.sybase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{15};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new AseIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return AseIntrospectorKt.access$canCheckOutdated(e);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.sybase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

