/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractExplainPlanProvider;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.sybase.plan.AsePlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AseExplainPlanProvider
extends AbstractExplainPlanProvider {
    public AseExplainPlanProvider() {
        super(Dbms.SYBASE);
    }

    @Override
    public AbstractPlanModelBuilder<?, ?> createBuilder(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return new AsePlanModelBuilder();
    }

    @Override
    @Nullable
    public ExplainPlanProvider.RawExplainTask createRawExplainTask(@NotNull LocalDataSource dataSource, final boolean analyze) {
        if (dataSource == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return new ExplainPlanProvider.RawExplainTask(){
            private Set<String> myActive = Collections.emptySet();

            @Override
            public @NotNull DataRequest.RawRequest sqlPreExplainPlan(@NotNull DataRequest.OwnerEx owner) throws UnsupportedOperationException, IllegalArgumentException {
                if (owner == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new DataRequest.RawRequest(owner){

                    @Override
                    public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) throws Exception {
                        myActive = AseExplainPlanProvider.collectActiveFlags(connection2, "statement_cache", "showplan");
                        StringBuilder script2 = new StringBuilder();
                        if (myActive.contains("statement_cache")) {
                            script2.append("set statement_cache off\n");
                        }
                        if (!myActive.contains("showplan")) {
                            script2.append("set showplan on\n");
                        }
                        if (!analyze) {
                            script2.append("set noexec on\n");
                        }
                        BarrenStatement.QuietBarrenStatement<String> stmt = SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().barren().quiet();
                        stmt.execute(script2.toString());
                    }
                };
            }

            @Override
            public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement2) throws UnsupportedOperationException, IllegalArgumentException {
                if (builder == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (statement2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                builder.plain(statement2).newLine();
                builder.keywords("go").newLine();
                return builder;
            }

            @Override
            public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner) throws UnsupportedOperationException, IllegalArgumentException {
                if (owner == null) {
                    1.$$$reportNull$$$0(3);
                }
                return new DataRequest.RawRequest(owner){

                    @Override
                    public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) throws Exception {
                        BarrenStatement.QuietBarrenStatement<String> stmt = SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().barren().quiet();
                        if (!analyze) {
                            stmt.execute("set noexec off");
                        }
                        if (!myActive.contains("showplan")) {
                            stmt.execute("set showplan off");
                        }
                        if (myActive.contains("statement_cache")) {
                            stmt.execute("set statement_cache on");
                        }
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "owner";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AseExplainPlanProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sqlPreExplainPlan";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sqlExplainPlan";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sqlPostExplainPlan";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public boolean isSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean isRawSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(3);
        }
        return true;
    }

    static Set<String> collectActiveFlags(@NotNull DatabaseConnectionCore connection2, String ... flags) throws SQLException {
        if (connection2 == null) {
            AseExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute((CallSite)((Object)("select n.name\nfrom master.dbo.spt_values n\n         join master.dbo.spt_values v\n              on v.type = 'P' and n.type = 'N' and n.number = v.number\nwhere v.low <= datalength(@@options)\n  and convert(tinyint, substring(@@options, v.low, 1)) & v.high != 0\n  and n.name in (" + StringUtil.join((Object[])flags, s -> "'" + s + "'", (String)", ") + ")")), StandardResultsProcessors.collectStrings(new HashSet(), 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AseExplainPlanProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRawExplainTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRawSupported";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectActiveFlags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

