/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.RoutineSqlAccess;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final Logger ourLog = Logger.getInstance(PropertyConverter.class);
    public static final BasicMetaType<Boolean> T_BOOLEAN = BasicMetaType.createType(Boolean.TYPE, PropertyConverter::importBoolean, PropertyConverter::export);
    public static final BasicMetaType<Byte> T_BYTE = BasicMetaType.createType(Byte.TYPE, PropertyConverter::importByte, PropertyConverter::export);
    public static final BasicMetaType<Short> T_SHORT = BasicMetaType.createType(Short.TYPE, PropertyConverter::importShort, PropertyConverter::export);
    public static final BasicMetaType<Short> T_SHORT_GENERIC = BasicMetaType.createType(Short.class, PropertyConverter::importShort, PropertyConverter::export);
    public static final BasicMetaType<Integer> T_INT = BasicMetaType.createType(Integer.TYPE, PropertyConverter::importInt, PropertyConverter::export);
    public static final BasicMetaType<Integer> T_INT_GENERIC = BasicMetaType.createType(Integer.class, PropertyConverter::importInt, PropertyConverter::export);
    public static final BasicMetaType<Long> T_LONG = BasicMetaType.createType(Long.TYPE, PropertyConverter::importLong, PropertyConverter::export);
    public static final BasicMetaType<Long> T_LONG_GENERIC = BasicMetaType.createType(Long.class, PropertyConverter::importLong, PropertyConverter::export);
    public static final BasicMetaType<Float> T_FLOAT = BasicMetaType.createType(Float.TYPE, PropertyConverter::importFloat, PropertyConverter::export);
    public static final BasicMetaType<Double> T_DOUBLE = BasicMetaType.createType(Double.TYPE, PropertyConverter::importDouble, PropertyConverter::export);
    public static final BasicMetaType<String> T_STRING = BasicMetaType.createType(String.class, PropertyConverter::importString, PropertyConverter::export);
    public static final BasicMetaType<OneTimeString> T_ONE_TIME_STRING = BasicMetaType.createType(OneTimeString.class, PropertyConverter::importOneTimeString, PropertyConverter::export);
    public static final BasicMetaType<Date> T_DATE = BasicMetaType.createType(Date.class, PropertyConverter::importDate, PropertyConverter::export);
    public static final BasicMetaType<LocalDateTime> T_LOCAL_DATE_TIME = BasicMetaType.createType(LocalDateTime.class, PropertyConverter::importLocalDateTime, PropertyConverter::export);
    public static final BasicMetaType<Instant> T_INSTANT = BasicMetaType.createType(Instant.class, PropertyConverter::importInstant, PropertyConverter::export);
    public static final BasicMetaType<ObjectKind> T_OBJECT_KIND = BasicMetaType.createType(ObjectKind.class, PropertyConverter::importObjectKind, PropertyConverter::export);
    public static final BasicMetaType<NameValue> T_NAME_VALUE = BasicMetaType.createType(NameValue.class, PropertyConverter::importNameValue, PropertyConverter::export);
    public static final BasicMetaType<NameValueType> T_NAME_VALUE_TYPE = BasicMetaType.createType(NameValueType.class, PropertyConverter::importNameValueType, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<TrigEvent> T_TRIG_EVENT = BasicMetaType.createEnumType(TrigEvent.class, PropertyConverter::importTrigEvent, PropertyConverter::export);
    public static final BasicMetaType<IndexColumn> T_INDEX_COLUMN = BasicMetaType.createType(IndexColumn.class, PropertyConverter::importIndexColumn, PropertyConverter::export);
    public static final BasicMetaType<SourceError> T_SOURCE_ERROR = BasicMetaType.createType(SourceError.class, PropertyConverter::importSourceError, PropertyConverter::export);
    public static final BasicMetaType<BigInteger> T_BIG_INTEGER = BasicMetaType.createType(BigInteger.class, PropertyConverter::importBigInteger, PropertyConverter::export);
    public static final BasicMetaType<DasType> T_DAS_TYPE = BasicMetaType.createType(DasType.class, PropertyConverter::importDasType, PropertyConverter::export, t -> t == null ? "null" : t.getSpecification(), new HashingStrategy<DasType>(){

        public int hashCode(DasType object) {
            return object.toDataType().hashCode();
        }

        public boolean equals(DasType o1, DasType o2) {
            return o1.toDataType().getSpecification().equals(o2.toDataType().getSpecification());
        }
    });
    public static final BasicMetaType.EnumMetaType<Level> T_LEVEL = BasicMetaType.createEnumType(Level.class, PropertyConverter::importLevel, PropertyConverter::export);
    public static final BasicMetaType<SequenceIdentity> T_SEQUENCE_IDENTITY = BasicMetaType.createType(SequenceIdentity.class, PropertyConverter::importSequenceIdentity, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<ArgumentDirection> T_ARGUMENT_DIRECTION = BasicMetaType.createEnumType(ArgumentDirection.class, PropertyConverter::importArgumentDirection, PropertyConverter::export);
    public static final BasicMetaType<Casing> T_CASING = BasicMetaType.createType(Casing.class, PropertyConverter::importCasing, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<CascadeRule> T_CASCADE_RULE = BasicMetaType.createEnumType(CascadeRule.class, PropertyConverter::importCascadeRule, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<DasRoutine.Kind> T_DAS_ROUTINE_KIND = BasicMetaType.createEnumType(DasRoutine.Kind.class, PropertyConverter::importDasRoutineKind, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<TrigTurn> T_TRIG_TURN = BasicMetaType.createEnumType(TrigTurn.class, PropertyConverter::importTrigTurn, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<ColumnKind> T_COLUMN_KIND = BasicMetaType.createEnumType(ColumnKind.class, PropertyConverter::importColumnKind, PropertyConverter::export);
    public static final BasicMetaType.EnumMetaType<ClusterType> T_CLUSTER_TYPE = BasicMetaType.createEnumType(ClusterType.class, PropertyConverter::importClusterType, PropertyConverter::export);
    public static final BasicMetaType<Version> T_VERSION = BasicMetaType.createType(Version.class, PropertyConverter::importVersion, PropertyConverter::export);
    public static final BasicMetaType<Dbms> T_DBMS = BasicMetaType.createType(Dbms.class, PropertyConverter::importDbms, PropertyConverter::export);
    public static final BasicMetaType<List<Short>> T_LIST_OF_SHORT = new BasicMetaType.CollectionMetaType<Short, List<Short>>(List.class, T_SHORT_GENERIC, PropertyConverter::importListOfShort, PropertyConverter::exportListOfShort);
    public static final BasicMetaType<List<Long>> T_LIST_OF_LONG = new BasicMetaType.CollectionMetaType<Long, List<Long>>(List.class, T_LONG_GENERIC, PropertyConverter::importListOfLong, PropertyConverter::exportListOfLong);
    public static final BasicMetaType<List<Integer>> T_LIST_OF_INTEGER = new BasicMetaType.CollectionMetaType<Integer, List<Integer>>(List.class, T_INT_GENERIC, PropertyConverter::importListOfInteger, PropertyConverter::exportListOfInteger);
    public static final BasicMetaType<Set<Long>> T_SET_OF_LONG = new BasicMetaType.CollectionMetaType<Long, Set<Long>>(Set.class, T_LONG_GENERIC, PropertyConverter::importSetOfLong, PropertyConverter::exportSetOfLong);
    public static final BasicMetaType<List<String>> T_LIST_OF_STRING = new BasicMetaType.CollectionMetaType<String, List<String>>(List.class, T_STRING, PropertyConverter::importListOfString, PropertyConverter::exportListOfString);
    public static final BasicMetaType<Set<String>> T_SET_OF_STRING = new BasicMetaType.CollectionMetaType<String, Set<String>>(Set.class, T_STRING, PropertyConverter::importSetOfString, PropertyConverter::exportSetOfString);
    public static final BasicMetaType<List<NameValue>> T_LIST_OF_NAME_VALUE = new BasicMetaType.CollectionMetaType<NameValue, List<NameValue>>(List.class, T_NAME_VALUE, PropertyConverter::importListOfNameValue, PropertyConverter::exportListOfNameValue);
    public static final BasicMetaType<List<NameValueType>> T_LIST_OF_NAME_VALUE_TYPE = new BasicMetaType.CollectionMetaType<NameValueType, List<NameValueType>>(List.class, T_NAME_VALUE_TYPE, PropertyConverter::importListOfNameValueType, PropertyConverter::exportListOfNameValueType);
    public static final BasicMetaType<Set<TrigEvent>> T_SET_OF_TRIG_EVENT = new BasicMetaType.CollectionMetaType<TrigEvent, Set<TrigEvent>>(Set.class, T_TRIG_EVENT, PropertyConverter::importSetOfTrigEvent, PropertyConverter::exportSetOfTrigEvent);
    public static final BasicMetaType<List<IndexColumn>> T_LIST_OF_INDEX_COLUMN = new BasicMetaType.CollectionMetaType<IndexColumn, List<IndexColumn>>(List.class, T_INDEX_COLUMN, PropertyConverter::importListOfIndexColumn, PropertyConverter::exportListOfIndexColumn);
    public static final BasicMetaType<List<SourceError>> T_LIST_OF_SOURCE_ERROR = new BasicMetaType.CollectionMetaType<SourceError, List<SourceError>>(List.class, T_SOURCE_ERROR, PropertyConverter::importListOfSourceError, PropertyConverter::exportListOfSourceError);
    public static final BasicMetaType.EnumMetaType<RoutineSqlAccess> T_ROUTINE_SQL_ACCESS = BasicMetaType.createEnumType(RoutineSqlAccess.class, PropertyConverter::importRoutineSqlAccess, PropertyConverter::export);
    public static final BasicMetaType<BasicReference> T_BASIC_REFERENCE = BasicMetaType.createType(BasicReference.class, s -> null, r -> null, r -> r == null ? "null" : r.getName(), HashingStrategy.canonical());
    public static final BasicMetaType<CompositeText> T_COMPOSITE_TEXT = BasicMetaType.createType(CompositeText.class, s -> null, text -> null);

    public static String export(boolean value) {
        return value ? "1" : "0";
    }

    public static String export(byte value) {
        return Byte.toString(value);
    }

    public static String export(short value) {
        return Short.toString(value);
    }

    public static String export(int value) {
        return Integer.toString(value);
    }

    public static String export(long value) {
        return Long.toString(value);
    }

    public static String export(float value) {
        return Float.toString(value);
    }

    public static String export(double value) {
        return Double.toString(value);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.nullize((String)string);
    }

    @NotNull
    public static String export(@NotNull OneTimeString string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(1);
        }
        String string2 = string.toString(false);
        if (string2 == null) {
            PropertyConverter.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            PropertyConverter.$$$reportNull$$$0(3);
        }
        return CalendarFun.export(timestamp);
    }

    public static String export(@NotNull LocalDateTime time) {
        if (time == null) {
            PropertyConverter.$$$reportNull$$$0(4);
        }
        return CalendarFun.export(time);
    }

    public static String export(@NotNull Instant instant) {
        if (instant == null) {
            PropertyConverter.$$$reportNull$$$0(5);
        }
        return CalendarFun.export(instant, false);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            PropertyConverter.$$$reportNull$$$0(6);
        }
        return kind.code();
    }

    public static String export(@NotNull BigInteger bigInteger) {
        if (bigInteger == null) {
            PropertyConverter.$$$reportNull$$$0(7);
        }
        return bigInteger.toString();
    }

    public static String export(@NotNull Level level) {
        if (level == null) {
            PropertyConverter.$$$reportNull$$$0(8);
        }
        return level.export();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(9);
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull DasType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(10);
        }
        return DasTypeUtilsKt.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            PropertyConverter.$$$reportNull$$$0(11);
        }
        return si.getSpecification(true);
    }

    public static String export(@NotNull Enum<?> item) {
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(12);
        }
        return PropertyConverter.exportEnumValue(item.name());
    }

    @NotNull
    public static String exportEnumValue(String name2) {
        String string = StringUtil.toLowerCase((String)name2).replace('_', '-');
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static String export(@NotNull ArgumentDirection dir) {
        if (dir == null) {
            PropertyConverter.$$$reportNull$$$0(14);
        }
        return Character.toString(dir.code);
    }

    public static String export(@NotNull Casing casing) {
        if (casing == null) {
            PropertyConverter.$$$reportNull$$$0(15);
        }
        return casing.specification();
    }

    public static String export(@NotNull Version version) {
        if (version == null) {
            PropertyConverter.$$$reportNull$$$0(16);
        }
        return version.toString();
    }

    public static String export(@NotNull Dbms dbms) {
        if (dbms == null) {
            PropertyConverter.$$$reportNull$$$0(17);
        }
        return dbms.getName();
    }

    public static String export(@NotNull Grants<?> grants) {
        if (grants == null) {
            PropertyConverter.$$$reportNull$$$0(18);
        }
        return grants.serialize();
    }

    public static String exportEnumCode(@NotNull Enum<?> item) {
        Object value;
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(19);
        }
        Class<?> clazz = item.getClass();
        try {
            Field field = clazz.getField("code");
            value = field.get(item);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize an item " + item.name() + " of class " + clazz.getName(), e);
        }
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static String exportListOfShort(@NotNull List<Short> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(20);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfLong(@NotNull List<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(21);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfInteger(@NotNull List<Integer> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(22);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportSetOfLong(@NotNull Set<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(23);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportCollectionOfNumber(@NotNull Collection<? extends Number> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(24);
        }
        int n = numbers.size();
        return switch (n) {
            case 0 -> null;
            case 1 -> numbers.iterator().next().toString();
            default -> StringUtil.join(numbers, (String)",");
        };
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(25);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportListOfNameValue(@NotNull List<NameValue> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(26);
        }
        if (strings.isEmpty()) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        for (NameValue nv : strings) {
            exporter.append(nv.getName()).newLine().append(nv.getValue()).newLine();
        }
        return exporter.build();
    }

    @Nullable
    public static String exportListOfNameValueType(@NotNull List<NameValueType> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(27);
        }
        if (strings.isEmpty()) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        for (NameValueType nv : strings) {
            exporter.append(nv.getName()).newLine().append(nv.getValue()).newLine().append(nv.getType()).newLine();
        }
        return exporter.build();
    }

    @Nullable
    public static String export(@Nullable NameValueType nvt) {
        if (nvt == null) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        exporter.append(nvt.getName()).newLine().append(nvt.getValue()).newLine().append(nvt.getType()).newLine();
        return exporter.build();
    }

    @Nullable
    public static String export(@Nullable NameValue nv) {
        if (nv == null) {
            return null;
        }
        MultilineExporter exporter = new MultilineExporter();
        exporter.append(nv.getName()).newLine().append(nv.getValue()).newLine();
        return exporter.build();
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(28);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(29);
        }
        int n = strings.size();
        return switch (n) {
            case 0 -> null;
            case 1 -> PropertyConverter.escapeSlashN(strings.iterator().next());
            default -> {
                MultilineExporter exporter = new MultilineExporter();
                for (String string : strings) {
                    exporter.append(string).newLine();
                }
                yield exporter.build();
            }
        };
    }

    @NotNull
    public static <T> String joinAll(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            PropertyConverter.$$$reportNull$$$0(30);
        }
        if (f == null) {
            PropertyConverter.$$$reportNull$$$0(31);
        }
        if (separator == null) {
            PropertyConverter.$$$reportNull$$$0(32);
        }
        StringBuilder res2 = new StringBuilder();
        boolean first2 = true;
        for (T item : items) {
            if (!first2) {
                res2.append(separator);
            } else {
                first2 = false;
            }
            res2.append((String)f.fun(item));
        }
        String string = res2.toString();
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String escapeSlashN(String s) {
        String string = s.replace("\\", "\\\\").replace("\n", "\\n");
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            PropertyConverter.$$$reportNull$$$0(35);
        }
        StringBuilder b = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b.append(event.code);
        }
        return b.toString();
    }

    public static String exportListOfIndexColumn(List<IndexColumn> indexColumns) {
        MultilineExporter exporter = new MultilineExporter();
        for (IndexColumn indexColumn : indexColumns) {
            exporter.append(indexColumn.export()).newLine();
        }
        return exporter.build();
    }

    public static String export(IndexColumn indexColumn) {
        return indexColumn == null ? null : indexColumn.export();
    }

    public static String exportListOfSourceError(List<SourceError> errors) {
        MultilineExporter exporter = new MultilineExporter();
        for (SourceError error : errors) {
            exporter.append(error.export()).newLine();
        }
        return exporter.build();
    }

    public static String export(SourceError error) {
        return error == null ? null : error.export();
    }

    public static boolean importBoolean(String text) {
        char c2 = text != null && !text.isEmpty() ? text.charAt(0) : (char)'\u0000';
        c2 = Character.toUpperCase(c2);
        return c2 >= '1' && c2 <= '9' || c2 == 'Y' || c2 == 'T' || c2 == '+';
    }

    public static byte importByte(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text) {
        if (text == null || text.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static BigInteger importBigInteger(String text) {
        if (text == null || text.isEmpty()) {
            return BigInteger.ZERO;
        }
        try {
            return new BigInteger(text.trim());
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }

    public static String importString(String text) {
        return DbUtil.intern(text);
    }

    public static OneTimeString importOneTimeString(String text) {
        return text == null ? null : new OneTimeString(text);
    }

    public static ObjectKind importObjectKind(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return ObjectKind.getKind(StringUtil.toLowerCase((String)text.trim()));
    }

    public static DasType importDasType(String text) {
        return DasTypeUtilsKt.deserializeDasType(text);
    }

    public static DasType importDasType(String text, BasicModElement context) {
        if (text == null || text.length() == 0) {
            return null;
        }
        DataType dataType = DataTypeFactory.deserialize(text);
        if (dataType.jdbcType != 0) {
            return DasUnresolvedTypeReference.of(dataType);
        }
        return DasTypeUtilsKt.getTypeSystem(context).createDasType(dataType);
    }

    public static <E extends Enum<E>> E importEnumByCode(Class<E> enumClass, String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        Enum enumItem = null;
        try {
            Object o;
            Method methodWithChar = PropertyConverter.getStaticMethod(enumClass, "of", Character.TYPE);
            Method methodWithByte = PropertyConverter.getStaticMethod(enumClass, "of", Byte.TYPE);
            Method methodWithString = PropertyConverter.getStaticMethod(enumClass, "of", String.class);
            if (methodWithChar == null && methodWithByte == null && methodWithString == null) {
                throw new IllegalArgumentException(String.format("Cannot import property of type %s: no static method of.", enumClass));
            }
            if (length == 1) {
                if (methodWithChar != null) {
                    Character c2 = Character.valueOf(text.charAt(0));
                    o = methodWithChar.invoke(null, c2);
                } else if (methodWithByte != null) {
                    char c3 = text.charAt(0);
                    Byte b = PropertyConverter.charDigit(c3);
                    o = methodWithByte.invoke(null, b);
                } else {
                    o = methodWithString.invoke(null, text);
                }
            } else if (methodWithString != null) {
                o = methodWithString.invoke(null, text);
            } else if (methodWithByte != null) {
                Byte b = PropertyConverter.safeParseByte(text);
                o = methodWithByte.invoke(null, b);
            } else {
                Character c4 = Character.valueOf(text.charAt(0));
                o = methodWithChar.invoke(null, c4);
            }
            enumItem = (Enum)o;
        }
        catch (Exception e) {
            String message = String.format("Failed to import property value \"%s\" as enum %s: exception %s: %s", text, enumClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (ourLog.isDebugEnabled()) {
                ourLog.warn(message, (Throwable)e);
            }
            ourLog.warn(message);
        }
        return (E)enumItem;
    }

    public static Byte charDigit(char c2) {
        return c2 >= '0' && c2 <= '9' ? Byte.valueOf((byte)(c2 - 48)) : null;
    }

    public static Byte safeParseByte(String str) {
        String s = str.trim();
        if (s.isEmpty()) {
            return null;
        }
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @NotNull
    public static Level importLevel(String text) {
        Level level = Level.of(text);
        if (level == null) {
            PropertyConverter.$$$reportNull$$$0(36);
        }
        return level;
    }

    public static DasRoutine.Kind importDasRoutineKind(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar(text.charAt(0));
    }

    public static ArgumentDirection importArgumentDirection(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return ArgumentDirection.of(text.charAt(0));
    }

    @Contract(value="null -> null")
    public static Date importDate(String text) {
        if (text == null) {
            return null;
        }
        return CalendarFun.importSqlDateTime(text);
    }

    @Contract(value="null -> null")
    public static LocalDateTime importLocalDateTime(String text) {
        if (text == null) {
            return null;
        }
        return CalendarFun.importLocalDateTime(text);
    }

    @Contract(value="null -> null")
    public static Instant importInstant(String text) {
        if (text == null) {
            return null;
        }
        return CalendarFun.importInstant(text);
    }

    @Contract(value="null -> null")
    public static Version importVersion(String text) {
        if (text == null) {
            return null;
        }
        try {
            return Version.of(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    public static Dbms importDbms(String text) {
        if (text == null) {
            return null;
        }
        return Dbms.byName(text);
    }

    @NotNull
    public static List<Short> importListOfShort(String text) {
        List<Long> listOfLong = PropertyConverter.importListOfLong(text);
        ArrayList<Short> listOfShort = new ArrayList<Short>(listOfLong.size());
        for (long value : listOfLong) {
            if (value < -32768L || value > 32767L) continue;
            listOfShort.add((short)value);
        }
        ArrayList<Short> arrayList = listOfShort;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public static Set<Long> importSetOfLong(String text) {
        return PropertyConverter.convertListToSet(PropertyConverter.importListOfLong(text));
    }

    @NotNull
    public static List<Integer> importListOfInteger(String text) {
        return PropertyConverter.importList(text, Integer::parseInt);
    }

    @NotNull
    public static List<Long> importListOfLong(String text) {
        return PropertyConverter.importList(text, Long::parseLong);
    }

    @NotNull
    public static <T> List<T> importList(@Nullable String text, @NotNull Function<String, T> converter) {
        if (converter == null) {
            PropertyConverter.$$$reportNull$$$0(38);
        }
        if (text == null || text.length() == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(39);
            }
            return list;
        }
        List strings = StringUtil.split((String)text, (String)",");
        int n = strings.size();
        if (n == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(40);
            }
            return list;
        }
        ArrayList values = new ArrayList(n);
        for (String string : strings) {
            try {
                Object value = converter.fun((Object)string);
                values.add(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        List<Object> list = switch (values.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(values.get(0));
            default -> values;
        };
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public static Set<String> importSetOfString(String text) {
        if (text == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(42);
            }
            return set;
        }
        if (text.length() == 0) {
            Set<String> set = Collections.singleton("");
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(43);
            }
            return set;
        }
        return PropertyConverter.convertToSet(new MultilineImporter(text, true));
    }

    @NotNull
    public static <T> Set<T> convertListToSet(@NotNull List<T> items) {
        if (items == null) {
            PropertyConverter.$$$reportNull$$$0(44);
        }
        int n = items.size();
        return switch (n) {
            case 0 -> Collections.emptySet();
            case 1 -> Collections.singleton(items.get(0));
            default -> new TreeSet<T>(items);
        };
    }

    @NotNull
    public static <T> Set<T> convertToSet(@NotNull Iterator<T> items) {
        if (items == null) {
            PropertyConverter.$$$reportNull$$$0(45);
        }
        if (!items.hasNext()) {
            Set set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(46);
            }
            return set;
        }
        T first2 = items.next();
        if (!items.hasNext()) {
            Set<T> set = Collections.singleton(first2);
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(47);
            }
            return set;
        }
        TreeSet<T> set = new TreeSet<T>();
        set.add(first2);
        while (items.hasNext()) {
            set.add(items.next());
        }
        TreeSet<T> treeSet = set;
        if (treeSet == null) {
            PropertyConverter.$$$reportNull$$$0(48);
        }
        return treeSet;
    }

    @NotNull
    public static List<String> importListOfString(String text) {
        if (text == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(49);
            }
            return list;
        }
        if (text.length() == 0) {
            List<String> list = Collections.singletonList("");
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(50);
            }
            return list;
        }
        List list = ContainerUtil.collect((Iterator)((Object)new MultilineImporter(text, true)));
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public static List<NameValue> importListOfNameValue(String text) {
        if (text == null || text.length() == 0) {
            List<NameValue> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(52);
            }
            return list;
        }
        ArrayList<NameValue> res2 = new ArrayList<NameValue>();
        MultilineImporter importer = new MultilineImporter(text, true);
        while (importer.hasNext()) {
            String name2 = (String)importer.next();
            String value = importer.nextOr("");
            res2.add(new NameValue(name2, value));
        }
        ArrayList<NameValue> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public static List<NameValueType> importListOfNameValueType(String text) {
        if (text == null || text.length() == 0) {
            List<NameValueType> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(54);
            }
            return list;
        }
        ArrayList<NameValueType> res2 = new ArrayList<NameValueType>();
        MultilineImporter importer = new MultilineImporter(text, true);
        while (importer.hasNext()) {
            String name2 = (String)importer.next();
            String value = importer.nextOr("");
            String type = importer.nextOr("");
            res2.add(new NameValueType(name2, value, type));
        }
        ArrayList<NameValueType> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @Nullable
    public static NameValueType importNameValueType(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        MultilineImporter importer = new MultilineImporter(text, true);
        if (!importer.hasNext()) {
            return null;
        }
        String name2 = (String)importer.next();
        String value = importer.nextOr("");
        String type = importer.nextOr("");
        return new NameValueType(name2, value, type);
    }

    @Nullable
    public static NameValue importNameValue(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        MultilineImporter importer = new MultilineImporter(text, true);
        if (!importer.hasNext()) {
            return null;
        }
        String name2 = (String)importer.next();
        String value = importer.nextOr("");
        return new NameValue(name2, value);
    }

    public static SequenceIdentity importSequenceIdentity(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            PropertyConverter.$$$reportNull$$$0(56);
        }
        return enumSet;
    }

    public static RoutineSqlAccess importRoutineSqlAccess(String text) {
        return PropertyConverter.importEnum(RoutineSqlAccess.class, text);
    }

    public static TrigEvent importTrigEvent(String text) {
        return PropertyConverter.importEnum(TrigEvent.class, text);
    }

    public static TrigTurn importTrigTurn(String text) {
        return PropertyConverter.importEnum(TrigTurn.class, text);
    }

    public static CascadeRule importCascadeRule(String text) {
        return PropertyConverter.importEnumLC(CascadeRule.class, text);
    }

    public static Casing importCasing(String text) {
        return Casing.of(text);
    }

    public static ClusterType importClusterType(String text) {
        return ClusterType.of(text);
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        String big = StringUtil.toUpperCase((String)text.trim().replace('-', '_'));
        return Enum.valueOf(enumClass, big);
    }

    public static <E extends Enum<E>> E importEnumLC(Class<E> enumClass, String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        String big = text.trim().replace('-', '_');
        return Enum.valueOf(enumClass, big);
    }

    @Nullable
    public static ColumnKind importColumnKind(String kind) {
        return PropertyConverter.importEnum(ColumnKind.class, kind);
    }

    @NotNull
    public static List<IndexColumn> importListOfIndexColumn(String text) {
        if (text == null) {
            List<IndexColumn> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(57);
            }
            return list;
        }
        ArrayList<IndexColumn> res2 = new ArrayList<IndexColumn>();
        MultilineImporter importer = new MultilineImporter(text, false);
        while (importer.hasNext()) {
            res2.add(IndexColumn.read((String)importer.next()));
        }
        ArrayList<IndexColumn> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    @Nullable
    public static IndexColumn importIndexColumn(String text) {
        if (text == null) {
            return null;
        }
        return IndexColumn.read(text);
    }

    @NotNull
    public static List<SourceError> importListOfSourceError(String text) {
        if (text == null) {
            List<SourceError> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(59);
            }
            return list;
        }
        ArrayList<SourceError> res2 = new ArrayList<SourceError>();
        MultilineImporter importer = new MultilineImporter(text, false);
        while (importer.hasNext()) {
            res2.add(SourceError.importError((String)importer.next()));
        }
        ArrayList<SourceError> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @Nullable
    public static SourceError importSourceError(String text) {
        if (text == null) {
            return null;
        }
        return SourceError.importError(text);
    }

    public static void internElements(@NotNull List<String> list) {
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(61);
        }
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String s = list.get(i2);
            if (s == null) continue;
            list.set(i2, DbUtil.intern(s));
        }
    }

    public static <E extends Enum<E>> Method getStaticMethod(@NotNull Class<E> clazz, @NotNull String name2, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            PropertyConverter.$$$reportNull$$$0(62);
        }
        if (name2 == null) {
            PropertyConverter.$$$reportNull$$$0(63);
        }
        try {
            method = clazz.getMethod(name2, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Method %s.%s(%s) must be static", clazz.getSimpleName(), name2, StringUtil.join((Object[])parameterTypes, t -> t.getSimpleName(), (String)", ")));
        }
        method.setAccessible(true);
        return method;
    }

    public static int extractCompact(int compact, int offset, int mask) {
        return (compact & mask) >> offset;
    }

    public static int prepareCompact(int value, int offset, int mask) {
        return value << offset & mask;
    }

    public static int applyCompact(int compact, int value, int offset, int mask) {
        return compact & ~mask | PropertyConverter.prepareCompact(value, offset, mask);
    }

    public static boolean extractBoolean(int compact) {
        return compact != 0;
    }

    public static int compactBoolean(boolean value) {
        return value ? 1 : 0;
    }

    public static <T extends Enum<?>> T extractEnum(int value, BasicMetaType.EnumMetaType<T> type) {
        T[] constants = type.values;
        return constants[value];
    }

    public static int compactEnum(Enum<?> value) {
        return value.ordinal();
    }

    public static <T extends Enum<?>> T extractNullableEnum(int value, BasicMetaType.EnumMetaType<T> type) {
        if (value == 0) {
            return null;
        }
        T[] constants = type.values;
        return constants[value - 1];
    }

    public static int compactNullableEnum(Enum<?> value) {
        return value == null ? 0 : value.ordinal() + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 33, 34, 36, 37, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: 
            case 13: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigInteger";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dt";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "si";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grants";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numbers";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 30: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "export";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "exportEnumValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "joinAll";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashN";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "importLevel";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfShort";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "importList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfString";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToSet";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfString";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValue";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValueType";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfTrigEvent";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfIndexColumn";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfSourceError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 2: 
            case 13: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exportEnumCode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfShort";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfLong";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfInteger";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfLong";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfNumber";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfString";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValueType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfString";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfString";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "joinAll";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfTrigEvent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "importList";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "convertListToSet";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "convertToSet";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "internElements";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 33, 34, 36, 37, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60 -> new IllegalStateException(string);
        };
    }

    public static class MultilineExporter {
        private final StringBuilder builder = new StringBuilder();
        private boolean nl = false;

        public MultilineExporter append(@NotNull String s) {
            if (s == null) {
                MultilineExporter.$$$reportNull$$$0(0);
            }
            this.flushNl();
            this.builder.append(PropertyConverter.escapeSlashN(s));
            return this;
        }

        public MultilineExporter newLine() {
            this.flushNl();
            this.nl = true;
            return this;
        }

        private void flushNl() {
            if (this.nl) {
                this.builder.append('\n');
            }
            this.nl = false;
        }

        public String build() {
            return this.builder.length() == 0 && !this.nl ? null : this.builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/model/properties/PropertyConverter$MultilineExporter", "append"));
        }
    }

    public static class MultilineImporter
    extends JBIterator<String> {
        private final String myText;
        private final boolean myIntern;
        private int cur = 0;

        public MultilineImporter(@Nullable String text, boolean intern) {
            this.myText = text;
            this.myIntern = intern;
        }

        protected String nextImpl() {
            if (this.myText == null || this.cur == -1) {
                return (String)this.stop();
            }
            int nx = StringUtil.indexOf((CharSequence)this.myText, (char)'\n', (int)this.cur);
            String res2 = StringUtil.unescapeStringCharacters((String)this.myText.substring(this.cur, nx == -1 ? this.myText.length() : nx));
            this.cur = nx == -1 ? -1 : nx + 1;
            return this.myIntern ? DbUtil.intern(res2) : res2;
        }

        public String nextOr(String def) {
            return this.hasNext() ? (String)this.next() : def;
        }
    }
}

