/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbObject;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectImpl<D extends DasObject, P extends DbElement>
extends DbElementImpl<D>
implements DbObject {
    private final P myParent;

    public DbObjectImpl(@NotNull P parent, @NotNull D delegate) {
        if (parent == null) {
            DbObjectImpl.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            DbObjectImpl.$$$reportNull$$$0(1);
        }
        super(delegate);
        if (!(delegate instanceof BasicObjectNode)) {
            throw new AssertionError((Object)"Unexpected delegate");
        }
        this.myParent = parent;
    }

    @NotNull
    public P getDasParent() {
        P p2 = this.myParent;
        if (p2 == null) {
            DbObjectImpl.$$$reportNull$$$0(2);
        }
        return p2;
    }

    @NotNull
    public P getParent() {
        P p2 = this.myParent;
        if (p2 == null) {
            DbObjectImpl.$$$reportNull$$$0(3);
        }
        return p2;
    }

    @Override
    public String getName(PsiElement context) {
        return ((DasObject)this.myDelegate).getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((DasObject)this.myDelegate).getName();
        if (string == null) {
            DbObjectImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @Override
    public int getWeight() {
        ObjectKind kind = this.getKind();
        if (kind == ObjectKind.TABLE) {
            return 10000;
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return 11000;
        }
        if (kind == ObjectKind.VIEW) {
            return 12000;
        }
        if (kind == ObjectKind.SEQUENCE) {
            return 13000;
        }
        if (kind == ObjectKind.TRIGGER) {
            return 14000;
        }
        if (kind == ObjectKind.ROUTINE) {
            return 16000;
        }
        if (kind == ObjectKind.PACKAGE) {
            return 17000;
        }
        return super.getWeight();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        SqlElement sqlElement;
        if (name2 == null) {
            DbObjectImpl.$$$reportNull$$$0(5);
        }
        if ((sqlElement = (SqlElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(this), SqlElement.class)) instanceof PsiNamedElement) {
            ((PsiNamedElement)sqlElement).setName(name2);
        } else {
            DasObject delegate = (DasObject)this.getDelegate();
            if (delegate instanceof PsiNamedElement) {
                ((PsiNamedElement)delegate).setName(name2);
            }
        }
        return this;
    }

    @Override
    @Nullable
    public String getComment() {
        return ((DasObject)this.myDelegate).getComment();
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return DbPresentationCore.getIcon((DasObject)this.myDelegate);
    }

    @Nullable
    public Icon getBaseIcon() {
        return DbPresentationCore.getIcon(this.getDbms(), this.getKind());
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ((DasObject)this.myDelegate).getKind();
        if (objectKind == null) {
            DbObjectImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    public String getLocationString() {
        return StringUtil.notNullize((String)StringUtil.nullize((String)QNameUtil.getQualifiedName(this.myParent)), (String)DbPresentationCore.getPresentableName(this.myParent, true)) + " [" + this.getDataSource().getName() + "]";
    }

    public boolean isWritable() {
        DasObject delegate = (DasObject)this.getDelegate();
        if (delegate instanceof PsiElement) {
            return ((PsiElement)delegate).isWritable();
        }
        return this.getDataSource().isWritable();
    }

    @Override
    public boolean isQuoted() {
        return DbSqlUtilCore.isQuoted((DasObject)this.myDelegate);
    }

    public short getPosition() {
        return this.myDelegate instanceof DasPositioned ? ((DasPositioned)this.myDelegate).getPosition() : (short)0;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDataSource().getDbms();
        if (dbms == null) {
            DbObjectImpl.$$$reportNull$$$0(7);
        }
        return dbms;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getDataSource().getProject();
        if (project == null) {
            DbObjectImpl.$$$reportNull$$$0(8);
        }
        return project;
    }

    @Override
    public boolean isValid() {
        return this.getDataSource().isValidImpl(this);
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getDataSource().getLanguage();
        if (language == null) {
            DbObjectImpl.$$$reportNull$$$0(9);
        }
        return language;
    }

    @Override
    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl o = DasUtil.getParentOfClass(this, DbDataSourceImpl.class, true);
        if (o != null) {
            DbDataSourceImpl dbDataSourceImpl = o;
            if (dbDataSourceImpl == null) {
                DbObjectImpl.$$$reportNull$$$0(10);
            }
            return dbDataSourceImpl;
        }
        throw new AssertionError((Object)(this.getTypeName() + ": no datasource"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbObjectImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbObjectImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasParent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

