/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataGridPreviewDmlAction
extends DumbAwareAction
implements DumbAware {
    private static final int REFORMAT_LIMIT = 10000;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(1);
        }
        SubmitMutations.updateAvailability(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        SearchPath searchPath;
        if (e == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(2);
        }
        DataGrid grid = Objects.requireNonNull(GridUtil.getDataGrid((DataContext)e.getDataContext()));
        DatabaseGridDataHookUp hookUp = Objects.requireNonNull(DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)grid));
        DatabaseMutator mutator = Objects.requireNonNull(hookUp.getMutator());
        if (hookUp instanceof DataRequest.CustomSearchPathOwner) {
            DataRequest.CustomSearchPathOwner o = (DataRequest.CustomSearchPathOwner)((Object)hookUp);
            searchPath = o.getSearchPath();
        } else {
            searchPath = null;
        }
        SearchPath searchPath2 = searchPath;
        String statements2 = mutator.getPendingChanges();
        Dbms dbms = hookUp.getDbms();
        DbDataSource dataSource = hookUp.getDataSource();
        Project project = Objects.requireNonNull(e.getProject());
        String text = statements2.length() > 10000 ? statements2 : DataGridPreviewDmlAction.reformat(statements2, dataSource, project);
        EditorTextField area = DatabaseDialogsHelper.createLanguageEditorArea(project, dbms, dataSource, searchPath2, text, true);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)area, "Center");
        DialogBuilder builder = new DialogBuilder();
        builder.setCenterPanel((JComponent)panel2);
        builder.setDimensionServiceKey("data.grid.dml.preview.dialog");
        builder.addOkAction().setText(DatabaseBundle.message("action.Console.TableResult.Submit.text", new Object[0]));
        builder.setOkActionEnabled(!grid.getDataSupport().hasUnparsedValues());
        builder.addCancelAction();
        builder.setTitle(DatabaseBundle.message("grid.preview.dml.action.dialog", new Object[0]));
        if (builder.showAndGet()) {
            SubmitMutations.submitChangesIfExists(e);
        }
    }

    @NotNull
    private static String reformat(@NotNull String statements2, @NotNull DbDataSource dataSource, @NotNull Project project) {
        if (statements2 == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(5);
        }
        CodeStyleSettings codeStyle = SqlCodeStyles.getSettings((Project)project, (String)ScriptingTaskBuilderKt.getCodeStyleName(dataSource));
        DocumentImpl document = new DocumentImpl((CharSequence)StringUtil.convertLineSeparators((String)statements2), true);
        SqlPsiFacade.getInstance((Project)project).format(project, DbSqlUtilCore.getSqlDialect(dataSource), (Document)document, codeStyle);
        String string = document.getText();
        if (string == null) {
            DataGridPreviewDmlAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DataGridPreviewDmlAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DataGridPreviewDmlAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

