/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusSessionState
implements DatabaseSession.State {
    private final long myStart;
    private final long myActivation;
    private final boolean myAllowReset;
    private final List<DatabaseSession.State.Work> myWork;
    private final AtomicLong myDeactivation;

    public MessageBusSessionState() {
        this(0L, 0L, ContainerUtil.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start2, long activation, @NotNull List<DatabaseSession.State.Work> list) {
        void work;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(0);
        }
        this(start2, activation, (List<DatabaseSession.State.Work>)work, false);
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start2, long activation, @NotNull List<DatabaseSession.State.Work> list, boolean bl) {
        void allowReset;
        void work;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(1);
        }
        this.myStart = start2;
        this.myWork = work;
        this.myActivation = activation;
        this.myAllowReset = allowReset;
        this.myDeactivation = new AtomicLong(0L);
    }

    @Override
    public boolean isIdle() {
        return this.getNonFinishedWork().isEmpty();
    }

    @Override
    public boolean isCancelled() {
        return !this.getCancelledWork().isEmpty();
    }

    @Override
    public boolean isFinalized() {
        return this.myAllowReset;
    }

    @Override
    public boolean isEmpty() {
        return this.myWork.isEmpty() || this.myActivation == 0L;
    }

    @Override
    public long getStartTime() {
        return this.myStart;
    }

    @Override
    public long getTimeSpentMs() {
        return this.isIdle() ? this.findLastFinishTime() - this.myActivation : System.currentTimeMillis() - (this.myActivation == 0L ? this.myStart : this.myActivation);
    }

    @Override
    @NotNull
    public List<DatabaseSession.State.Work> getWork() {
        List<DatabaseSession.State.Work> list = this.myWork;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public MessageBusSessionState update() {
        return new MessageBusSessionState(this.myStart, this.myActivation, this.myWork, this.isIdle());
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getWorkFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            MessageBusSessionState.$$$reportNull$$$0(3);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> w.getRequest().getOwner() == owner));
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getWorkFor(@NotNull GridDataRequest request2) {
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(4);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> w.getRequest() == request2));
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getMostRecentWork(@NotNull List<? extends GridDataRequest> requests) {
        if (requests == null) {
            MessageBusSessionState.$$$reportNull$$$0(5);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> requests.contains((Object)w.getRequest())));
    }

    @NotNull
    public MessageBusSessionState resetIfEmpty() {
        MessageBusSessionState messageBusSessionState = this.myAllowReset ? new MessageBusSessionState(0L, 0L, ContainerUtil.emptyList()) : this;
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(6);
        }
        return messageBusSessionState;
    }

    @NotNull
    public MessageBusSessionState plus(@NotNull DataRequest request2, long time) {
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(7);
        }
        return this.plus(new Work(request2, DatabaseSession.State.WorkState.SUBMITTED, PendingStatus.INSTANCE, time, 0L));
    }

    @NotNull
    public MessageBusSessionState error(@NotNull GridDataRequest request2, @Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull @NlsContexts.DetailedDescription String message) {
        Work work;
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(8);
        }
        if (message == null) {
            MessageBusSessionState.$$$reportNull$$$0(9);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, w -> w.getRequest() == request2)) == null ? this : this.remove(request2).add(work.error(navigator, message));
    }

    @NotNull
    public MessageBusSessionState warning(@NotNull GridDataRequest request2, @NotNull @NlsContexts.DetailedDescription String message) {
        Work work;
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(10);
        }
        if (message == null) {
            MessageBusSessionState.$$$reportNull$$$0(11);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, w -> w.getRequest() == request2)) == null ? this : this.remove(request2).add(work.warning(message));
    }

    public MessageBusSessionState cancel(@NotNull GridDataRequest request2) {
        Work work;
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(12);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, w -> w.getRequest() == request2)) == null ? this : this.remove(request2).add(work.cancel());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState activate(long startTime, @NotNull GridDataRequest gridDataRequest) {
        void request2;
        if (gridDataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(13);
        }
        long activation = this.myActivation == 0L ? startTime : this.myActivation;
        Work work = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$activate$6((GridDataRequest)request2, arg_0));
        return work == null ? this : this.remove((GridDataRequest)request2).add(work.running(startTime)).withProperties(this.myStart, activation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState deactivate(long finishTime, @NotNull GridDataRequest gridDataRequest) {
        void request2;
        Work work;
        if (gridDataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(14);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$deactivate$7((GridDataRequest)request2, arg_0))) == null ? this : this.remove((GridDataRequest)request2).add(work.stopped(finishTime));
    }

    @NotNull
    private MessageBusSessionState withProperties(long startTime, long activation) {
        return new MessageBusSessionState(startTime, activation, this.myWork);
    }

    @Nullable
    private DatabaseSession.State.Work getMostRecentWork(@NotNull Condition<DatabaseSession.State.Work> condition) {
        if (condition == null) {
            MessageBusSessionState.$$$reportNull$$$0(15);
        }
        List workByOwner = ContainerUtil.filter(this.myWork, condition);
        List sorted = ContainerUtil.sorted((Collection)workByOwner, (w1, w2) -> {
            DatabaseSession.State.WorkState s2;
            DatabaseSession.State.WorkState s1 = w1.getState();
            return s1 == (s2 = w2.getState()) ? Long.compare(((Work)w2).myFinished, ((Work)w1).myFinished) : (s1.getInProgress() ? -1 : (s2 == DatabaseSession.State.WorkState.FINISHED ? -1 : 1));
        });
        return (DatabaseSession.State.Work)ContainerUtil.getFirstItem((List)sorted);
    }

    private long findLastFinishTime() {
        long value = this.myDeactivation.get();
        if (value != 0L) {
            return value;
        }
        List sorted = ContainerUtil.sorted(this.myWork, Comparator.comparingLong(w -> ((Work)w).myFinished).reversed());
        Work first2 = (Work)ContainerUtil.getFirstItem((List)sorted);
        if (first2 != null) {
            this.myDeactivation.compareAndSet(0L, first2.myFinished);
        }
        return this.myDeactivation.get();
    }

    @NotNull
    private MessageBusSessionState remove(@NotNull GridDataRequest request2) {
        if (request2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(16);
        }
        List work = ContainerUtil.filter(this.myWork, w -> w.getRequest() != request2);
        return new MessageBusSessionState(this.myStart, this.myActivation, work);
    }

    @NotNull
    private MessageBusSessionState plus(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(17);
        }
        List work = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        return new MessageBusSessionState(this.myWork.isEmpty() ? newWork.getStartTime() : this.myStart, this.myActivation, work);
    }

    @NotNull
    private MessageBusSessionState add(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(18);
        }
        List work = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        return new MessageBusSessionState(this.myStart, this.myActivation, work);
    }

    @NotNull
    private List<DatabaseSession.State.Work> getNonFinishedWork() {
        List list = ContainerUtil.filter(this.myWork, w -> !((Work)w).isFinished());
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private List<DatabaseSession.State.Work> getCancelledWork() {
        List list = ContainerUtil.filter(this.myWork, w -> w.getState() == DatabaseSession.State.WorkState.CANCELLING);
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$deactivate$7(GridDataRequest request2, DatabaseSession.State.Work w) {
        return w.getRequest() == request2;
    }

    private static /* synthetic */ boolean lambda$activate$6(GridDataRequest request2, DatabaseSession.State.Work w) {
        return w.getRequest() == request2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "work";
                break;
            }
            case 2: 
            case 6: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWork";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resetIfEmpty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFinishedWork";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelledWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 19: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkFor";
                break;
            }
            case 5: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMostRecentWork";
                break;
            }
            case 7: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 19, 20 -> new IllegalStateException(string);
        };
    }

    private static class Work
    implements DatabaseSession.State.Work {
        private final long myStart;
        private final DataRequest myRequest;
        private final DatabaseSession.State.WorkState myState;
        private final long myFinished;
        private final DatabaseSession.State.WorkStatus myStatus;

        /*
         * WARNING - void declaration
         */
        Work(@NotNull DataRequest request2, @NotNull DatabaseSession.State.WorkState state, @NotNull DatabaseSession.State.WorkStatus status, long start2, long l) {
            void finished;
            if (request2 == null) {
                Work.$$$reportNull$$$0(0);
            }
            if (state == null) {
                Work.$$$reportNull$$$0(1);
            }
            if (status == null) {
                Work.$$$reportNull$$$0(2);
            }
            this.myStart = start2;
            this.myRequest = request2;
            this.myState = state;
            this.myFinished = finished;
            this.myStatus = status;
        }

        @Override
        @NotNull
        public DataRequest getRequest() {
            DataRequest dataRequest = this.myRequest;
            if (dataRequest == null) {
                Work.$$$reportNull$$$0(3);
            }
            return dataRequest;
        }

        @NotNull
        public Work running(long time) {
            DatabaseSession.State.WorkState state = this.myState != DatabaseSession.State.WorkState.CANCELLING ? DatabaseSession.State.WorkState.RUNNING : this.myState;
            return new Work(this.myRequest, state, this.myStatus, time, this.myFinished);
        }

        @NotNull
        public Work error(@Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull @NlsContexts.DetailedDescription String message) {
            if (message == null) {
                Work.$$$reportNull$$$0(4);
            }
            DatabaseSession.State.WorkStatus status = this.myState != DatabaseSession.State.WorkState.CANCELLING ? new ProblemStatus(DatabaseSession.State.WorkStatusType.ERROR, navigator, message) : this.myStatus;
            return new Work(this.myRequest, this.myState, status, this.myStart, this.myFinished);
        }

        @NotNull
        public Work warning(@NotNull @NlsContexts.DetailedDescription String message) {
            if (message == null) {
                Work.$$$reportNull$$$0(5);
            }
            DatabaseSession.State.WorkStatus status = this.myState != DatabaseSession.State.WorkState.CANCELLING ? new ProblemStatus(DatabaseSession.State.WorkStatusType.WARNING, null, message) : this.myStatus;
            return new Work(this.myRequest, this.myState, status, this.myStart, this.myFinished);
        }

        @NotNull
        public Work cancel() {
            DatabaseSession.State.WorkState state = this.myState != DatabaseSession.State.WorkState.FINISHED ? DatabaseSession.State.WorkState.CANCELLING : this.myState;
            return new Work(this.myRequest, state, CancellingStatus.INSTANCE, this.myStart, this.myFinished);
        }

        @NotNull
        public Work stopped(long time) {
            DatabaseSession.State.WorkStatus status = this.myStatus;
            if (status.getType() == DatabaseSession.State.WorkStatusType.UNKNOWN) {
                if (this.myState == DatabaseSession.State.WorkState.CANCELLING) {
                    status = CancelledStatus.INSTANCE;
                } else if (this.myState != DatabaseSession.State.WorkState.SUBMITTED) {
                    status = SuccessStatus.INSTANCE;
                }
            }
            return new Work(this.myRequest, DatabaseSession.State.WorkState.FINISHED, status, this.myStart, this.myState == DatabaseSession.State.WorkState.FINISHED ? this.myFinished : time);
        }

        @Override
        public long getTimeSpentMs() {
            return this.isFinished() ? this.myFinished - this.myStart : System.currentTimeMillis() - this.myStart;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkState getState() {
            DatabaseSession.State.WorkState workState = this.myState;
            if (workState == null) {
                Work.$$$reportNull$$$0(6);
            }
            return workState;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatus getStatus() {
            DatabaseSession.State.WorkStatus workStatus = this.myStatus;
            if (workStatus == null) {
                Work.$$$reportNull$$$0(7);
            }
            return workStatus;
        }

        boolean isFinished() {
            return this.myFinished != 0L;
        }

        long getStartTime() {
            return this.myStart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "warning";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class PendingStatus
    implements DatabaseSession.State.WorkStatus {
        static final PendingStatus INSTANCE = new PendingStatus();

        private PendingStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.UNKNOWN;
            if (workStatusType == null) {
                PendingStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$PendingStatus", "getType"));
        }
    }

    private static class ProblemStatus
    implements DatabaseSession.State.WorkStatus {
        private final DatabaseSession.State.WorkStatusType myType;
        private final DataRequest.CoupledWithEditor.ErrorNavigator myNavigator;
        private final @NlsContexts.DetailedDescription String myMessage;

        ProblemStatus(@NotNull DatabaseSession.State.WorkStatusType type, @Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull @NlsContexts.DetailedDescription String message) {
            if (type == null) {
                ProblemStatus.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ProblemStatus.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myNavigator = navigator;
            this.myMessage = message;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = this.myType;
            if (workStatusType == null) {
                ProblemStatus.$$$reportNull$$$0(2);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return this.myNavigator;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState$ProblemStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState$ProblemStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SuccessStatus
    implements DatabaseSession.State.WorkStatus {
        static final SuccessStatus INSTANCE = new SuccessStatus();

        private SuccessStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.SUCCESS;
            if (workStatusType == null) {
                SuccessStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$SuccessStatus", "getType"));
        }
    }

    private static class CancelledStatus
    implements DatabaseSession.State.WorkStatus {
        static final CancelledStatus INSTANCE = new CancelledStatus();

        private CancelledStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.CANCELLED;
            if (workStatusType == null) {
                CancelledStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return DatabaseBundle.message("query.canceled", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$CancelledStatus", "getType"));
        }
    }

    private static class CancellingStatus
    implements DatabaseSession.State.WorkStatus {
        static final CancellingStatus INSTANCE = new CancellingStatus();

        private CancellingStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.UNKNOWN;
            if (workStatusType == null) {
                CancellingStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return DatabaseBundle.message("cancelling.query", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$CancellingStatus", "getType"));
        }
    }
}

