/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileUtils;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectPaths {
    private static final Map<Dbms, Boolean> ourHasOverloads = ConcurrentFactoryMap.createMap(dbms -> ((JBTreeTraverser)BasicMetaUtils.metaTraverser().withRoot(DbImplUtilCore.getMetaModel((Dbms)dbms).root)).traverse().filter(m -> m.kindOf(DasRoutine.class) && m.kindOf(BasicOverloadable.class)).isNotEmpty());
    public static final HashingStrategy<ObjectPath> SIMPLE_INSENSITIVE_STRATEGY = new SimpleHashingStrategy(false);
    public static final HashingStrategy<ObjectPath> SIMPLE_SENSITIVE_STRATEGY = new SimpleHashingStrategy(true);

    public static int getLength(@Nullable ObjectPath root) {
        return root == null ? 0 : root.getSize();
    }

    @Contract(value="!null->!null;null->null")
    public static ObjectPath of(@Nullable DasObject o) {
        return ObjectPaths.of(o, null);
    }

    @Contract(value="!null,_->!null;null,_->null")
    public static ObjectPath of(@Nullable DasObject o, @Nullable CasingProvider normalizer) {
        if (o == null) {
            return null;
        }
        BasicElement basic = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(o), BasicElement.class);
        if (basic != null) {
            return BasicPaths.of(basic, normalizer);
        }
        DasObject parent = o.getDasParent();
        if (parent != null && parent.getKind() == ObjectKind.ROOT) {
            parent = null;
        }
        ObjectPath parentPath = ObjectPaths.of(parent, normalizer);
        return ObjectPaths.append(o, normalizer, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull DasObject o, @Nullable ObjectPath parentPath) {
        if (o == null) {
            ObjectPaths.$$$reportNull$$$0(0);
        }
        return ObjectPaths.append(o, null, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull DasObject o, @Nullable CasingProvider normalizer, @Nullable ObjectPath parentPath) {
        BasicElement basic;
        if (o == null) {
            ObjectPaths.$$$reportNull$$$0(1);
        }
        if ((basic = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(o), BasicElement.class)) != null) {
            ObjectPath objectPath = BasicPaths.append(basic, normalizer, parentPath);
            if (objectPath == null) {
                ObjectPaths.$$$reportNull$$$0(2);
            }
            return objectPath;
        }
        ObjectPath objectPath = BasicPaths.createNormalized(o, DbSqlUtilCore.isQuoted(o), ObjectPaths.getIdentity(o), parentPath, normalizer);
        if (objectPath == null) {
            ObjectPaths.$$$reportNull$$$0(3);
        }
        return objectPath;
    }

    @Nullable
    public static SearchPath of(@Nullable Iterable<? extends DasObject> o) {
        return o == null ? null : SearchPath.of(JBIterable.from(o).filter(Conditions.notNull()).transform(ObjectPaths::of).toList());
    }

    @Nullable
    public static SearchPath searchPathOf(@Nullable DasObject o) {
        return SearchPath.of(ObjectPaths.of(o));
    }

    @NotNull
    private static String getEscapedName(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPaths.$$$reportNull$$$0(4);
        }
        String string = path.reduce(new StringBuilder(), (sb, p2) -> (sb.length() > 0 ? sb.append(".") : sb).append(DatabaseElementVirtualFileUtils.escape(p2.name))).toString();
        if (string == null) {
            ObjectPaths.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getIdentity(@NotNull DasObject obj2) {
        if (obj2 == null) {
            ObjectPaths.$$$reportNull$$$0(6);
        }
        return ObjectPaths.getIdentity(obj2, false, true);
    }

    @Nullable
    public static String getIdentity(@NotNull DasObject obj2, boolean normalize, boolean withSurrogates) {
        if (obj2 == null) {
            ObjectPaths.$$$reportNull$$$0(7);
        }
        if ((obj2 = (DasObject)ObjectUtils.notNull((Object)((DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(obj2), DasObject.class)), (Object)obj2)) instanceof BasicElement) {
            return BasicPaths.getIdentity((BasicElement)obj2, normalize, withSurrogates);
        }
        if (!(obj2 instanceof PsiElement)) {
            return null;
        }
        Dbms dbms = DbImplUtilCore.getDbms((PsiElement)obj2);
        if (dbms.isSybase() && obj2 instanceof DasRoutine && ((DasRoutine)obj2).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            short pos = ObjectPaths.getSybaseNumber(obj2);
            return ModelUtil.calculateSybProcedureIdentity(pos);
        }
        if (obj2 instanceof DasOperator) {
            return ModelUtil.calculateRoutineIdentityByType("", ((DasOperator)obj2).getArgumentTypes(), ModelUtil.getNormalizer(dbms, normalize));
        }
        if (obj2 instanceof DasRoutine && ObjectPaths.hasOverloads(dbms)) {
            String id = ModelUtil.calculateRoutineIdentity("", ((DasRoutine)obj2).getArguments(), ModelUtil.getNormalizer(dbms, normalize));
            return dbms.in(Dbms.MYSQL_LIKE) ? id + ((DasRoutine)obj2).getRoutineKind().toChar() : id;
        }
        return null;
    }

    private static boolean hasOverloads(Dbms dbms) {
        return ourHasOverloads.get(dbms);
    }

    public static short getSybaseNumber(DasObject obj2) {
        if (obj2 instanceof SqlCreateProcedureStatement) {
            return ObjectPaths.getSybaseNumber(obj2.getName());
        }
        if (obj2 instanceof DasPositioned) {
            return ((DasPositioned)obj2).getPosition();
        }
        return ObjectPaths.getSybaseNumber(obj2.getName());
    }

    private static short getSybaseNumber(String name2) {
        Short num = ObjectPaths.isNumber(name2) ? ObjectPaths.tryConvert(name2) : null;
        return num == null ? (short)1 : num;
    }

    @Nullable
    private static Short tryConvert(@Nullable String sub) {
        if (sub == null) {
            return null;
        }
        try {
            return Short.valueOf(sub);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isDigit(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="!null->!null")
    public static String serialize(@Nullable ObjectPath o) {
        if (o == null) {
            return null;
        }
        return o.kind.code() + "/" + ObjectPaths.getEscapedName(o);
    }

    @Nullable
    public static ObjectPath deserialize(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(8);
        }
        if (o == null) {
            return null;
        }
        int idx = o.indexOf("/");
        if (idx < 0) {
            return ObjectPath.create(o, ObjectKind.NONE);
        }
        ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)metaModel.findKind(o.substring(0, idx)), (Object)ObjectKind.NONE);
        return ObjectPaths.getObjectPath(metaModel, o.substring(idx + 1), kind);
    }

    @Nullable
    private static ObjectPath getObjectPath(@NotNull MetaModel metaModel, String qname, ObjectKind kind) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(9);
        }
        String[] names = DatabaseElementVirtualFileUtils.decodeQName(qname);
        List<ObjectKind> bestPath = ObjectPaths.findBestPath(metaModel, kind, names);
        return ObjectPaths.createPath(names, bestPath);
    }

    @Nullable
    private static ObjectPath createPath(String[] names, List<ObjectKind> kinds) {
        ObjectPath result2 = null;
        int e = names.length;
        for (int i2 = 0; i2 < e; ++i2) {
            int p2 = e - i2 - 1;
            result2 = ObjectPath.create(names[i2], p2 >= kinds.size() ? ObjectKind.NONE : kinds.get(p2), true, null, result2);
        }
        return result2;
    }

    @NotNull
    public static JBIterable<ObjectPath> getObjectPaths(@NotNull MetaModel metaModel, String qname, ObjectKind kind) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(10);
        }
        String[] names = DatabaseElementVirtualFileUtils.decodeQName(qname);
        JBIterable jBIterable = metaModel.getPathsToRoot(kind).filterMap(kinds -> {
            if (kinds.size() < names.length + 1) {
                return null;
            }
            return ObjectPaths.createPath(names, kinds);
        });
        if (jBIterable == null) {
            ObjectPaths.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    private static List<ObjectKind> findBestPath(@NotNull MetaModel metaModel, ObjectKind kind, String[] names) {
        List paths;
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(12);
        }
        if ((paths = metaModel.getPathsToRoot(kind).toList()).isEmpty()) {
            return Collections.emptyList();
        }
        if (paths.size() == 1) {
            return (List)paths.get(0);
        }
        for (int k = 0; k < 2; ++k) {
            boolean up = k == 0;
            int m = -1;
            for (int i2 = 0; i2 < paths.size(); ++i2) {
                int d;
                int size = ((List)paths.get(i2)).size();
                if (size < names.length == up || m != -1 && ((d = ((List)paths.get(m)).size() - ((List)paths.get(i2)).size()) == 0 || d < 0 == up)) continue;
                m = i2;
            }
            if (m == -1) continue;
            return (List)paths.get(m);
        }
        return Collections.emptyList();
    }

    public static int compare(@Nullable ObjectPath p1, @Nullable ObjectPath p2) {
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        return ObjectPaths.compareWithDepth(p1, p2, p1.getSize(), p2.getSize());
    }

    private static int compareWithDepth(@NotNull ObjectPath p1, @NotNull ObjectPath p2, int d1, int d2) {
        if (p1 == null) {
            ObjectPaths.$$$reportNull$$$0(13);
        }
        if (p2 == null) {
            ObjectPaths.$$$reportNull$$$0(14);
        }
        if (d1 == d2) {
            return ObjectPaths.compareSameDepth(p1, p2);
        }
        if (d2 < d1) {
            return -ObjectPaths.compareWithDelta(p2, p1, d1 - d2);
        }
        return ObjectPaths.compareWithDelta(p1, p2, d2 - d1);
    }

    private static int compareWithDelta(@NotNull ObjectPath sht, @NotNull ObjectPath lng, int d) {
        int res2;
        if (sht == null) {
            ObjectPaths.$$$reportNull$$$0(15);
        }
        if (lng == null) {
            ObjectPaths.$$$reportNull$$$0(16);
        }
        return (res2 = ObjectPaths.compareSameDepth(sht, lng.getParent(d))) == 0 ? -1 : res2;
    }

    private static int compareSameDepth(@Nullable ObjectPath p1, @Nullable ObjectPath p2) {
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        int res2 = ObjectPaths.compareSameDepth(p1.parent, p2.parent);
        return res2 == 0 ? ObjectPaths.comparePart(p1, p2) : res2;
    }

    private static int comparePart(@NotNull ObjectPart p1, @NotNull ObjectPart p2) {
        int res2;
        if (p1 == null) {
            ObjectPaths.$$$reportNull$$$0(17);
        }
        if (p2 == null) {
            ObjectPaths.$$$reportNull$$$0(18);
        }
        if ((res2 = Comparing.compare((Comparable)p1.kind, (Comparable)p2.kind)) != 0) {
            return res2;
        }
        res2 = Comparing.compare((Comparable)((Object)p1.name), (Comparable)((Object)p2.name));
        if (res2 != 0) {
            return res2;
        }
        res2 = Comparing.compare((Comparable)((Object)p1.getIdentity()), (Comparable)((Object)p2.getIdentity()));
        if (res2 != 0) {
            return res2;
        }
        res2 = Boolean.compare(p1.isQuoted(), p2.isQuoted());
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sht";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lng";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findBestPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareWithDepth";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareWithDelta";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "comparePart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 11 -> new IllegalStateException(string);
        };
    }

    private static class SimpleHashingStrategy
    implements HashingStrategy<ObjectPath> {
        private final boolean myCaseSensitive;

        private SimpleHashingStrategy(boolean caseSensitive) {
            this.myCaseSensitive = caseSensitive;
        }

        public int hashCode(ObjectPath object) {
            if (object == null) {
                return 0;
            }
            return object.reduce(object.kind.hashCode(), (t, v) -> t * 31 + (this.myCaseSensitive ? v.name.hashCode() : StringUtil.stringHashCodeInsensitive((CharSequence)v.name)));
        }

        public boolean equals(ObjectPath o1, ObjectPath o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null || !Comparing.equal((Object)o1.kind, (Object)o2.kind)) {
                return false;
            }
            while (o1 != null && o2 != null && o1 != o2) {
                if (!Comparing.strEqual((String)o1.name, (String)o2.name, (boolean)this.myCaseSensitive)) {
                    return false;
                }
                o1 = o1.parent;
                o2 = o2.parent;
            }
            return o1 == o2;
        }
    }
}

