/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternEntryKey;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u001a\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\"\u0015\u0010\u0005\u001a\u00020\u0002*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"contains", "", "Lcom/intellij/database/util/TreePattern;", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "treePattern", "getTreePattern", "(Lcom/intellij/database/model/basic/BasicNamespace;)Lcom/intellij/database/util/TreePattern;", "extractMap", "Ljava/util/NavigableMap;", "Lcom/intellij/database/util/TreePatternEntryKey;", "Lcom/intellij/database/util/TreePatternNode;", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.core.impl"})
@JvmName(name="TreePatternFun")
public final class TreePatternFun {
    public static final boolean contains(@NotNull TreePattern $this$contains, @NotNull BasicNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return DataSourceSchemaMapping.matches($this$contains, namespace);
    }

    @NotNull
    public static final TreePattern getTreePattern(@NotNull BasicNamespace $this$treePattern) {
        Intrinsics.checkNotNullParameter((Object)$this$treePattern, (String)"<this>");
        TreePattern treePattern = TreePatternUtils.create(ModelFun.getObjectPath($this$treePattern));
        Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"create(...)");
        return treePattern;
    }

    @NotNull
    public static final NavigableMap<TreePatternEntryKey, TreePatternNode> extractMap(@NotNull TreePatternNode $this$extractMap, @NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)$this$extractMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        TreePatternNode.Group group = $this$extractMap.getGroup(kind);
        if (group == null) {
            NavigableMap<TreePatternEntryKey, TreePatternNode> navigableMap = Collections.emptyNavigableMap();
            Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"emptyNavigableMap(...)");
            return navigableMap;
        }
        TreePatternNode.Group group2 = group;
        if (group2.children == null) {
            NavigableMap<TreePatternEntryKey, TreePatternNode> navigableMap = Collections.emptyNavigableMap();
            Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"emptyNavigableMap(...)");
            return navigableMap;
        }
        TreePatternNode[] children2 = group2.children;
        TreeMap map2 = new TreeMap();
        for (TreePatternNode node : children2) {
            TreePatternNode.BaseNaming nodeNaming = node.naming;
            Object[] names = (ObjectName[])UtilKt.nullize((Object[])nodeNaming.names);
            if (names == null) {
                JBIterable<TreePatternNode.PatternWrapper> regexPatterns;
                SmartPredicate<TreePatternNode.PatternWrapper> nodePattern;
                if (!(nodeNaming instanceof TreePatternNode.NegativeNaming)) continue;
                Intrinsics.checkNotNullExpressionValue(((TreePatternNode.NegativeNaming)nodeNaming).pattern, (String)"pattern");
                if (nodePattern.isAll()) {
                    ((Map)map2).put(TreePatternEntryKey.All.INSTANCE, node);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(SmartPredicate.extractPositiveChecks(nodePattern), (String)"extractPositiveChecks(...)");
                for (TreePatternNode.PatternWrapper regexPattern : regexPatterns) {
                    String string = regexPattern.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    TreePatternEntryKey.Regex key2 = new TreePatternEntryKey.Regex(string);
                    ((Map)map2).put(key2, node);
                }
                continue;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])names);
            while (iterator.hasNext()) {
                String name2;
                ObjectName objName = (ObjectName)iterator.next();
                if (objName.name == null) continue;
                if (Intrinsics.areEqual((Object)name2, (Object)"@")) {
                    ((Map)map2).put(TreePatternEntryKey.Cur.INSTANCE, node);
                    continue;
                }
                ((Map)map2).put(new TreePatternEntryKey.Plain(name2), node);
            }
        }
        return map2;
    }
}

