/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeLayoutLayerKt;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0016\u0010\f\u001a\u0004\u0018\u00010\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00102\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u001c\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010$\u001a\u00060#R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u001c\u0010'\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u00060#R\u00020\u00000\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020&0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "level", "", "getLevel", "()B", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "findParentOf", "parentOfFamily", "family", "Lcom/intellij/database/model/families/HostFamily;", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "childrenOfRoot", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "childrenOfNamespaceOwner", "host", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "parent", "childrenOfFamily", "isInTrueDatabase", "", "Lcom/intellij/database/model/basic/BasicElement;", "isAlwaysLeaf", "presentableNameOf", "", "clearAll", "", "auxiliaryGroups", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup;", "obtainAuxiliaryGroup", "emptyScopeLeaves", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$EmptyScopeLeaf;", "obtainEmptyScopeLeaf", "HostGroup", "AuxiliaryGroup", "EmptyScopeLeaf", "intellij.database.core.impl"})
public final class DvTreeLayoutLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final WeakHashMap<BasicNamespaceOwner, AuxiliaryGroup> auxiliaryGroups = new WeakHashMap();
    @NotNull
    private final WeakHashMap<HostFamily<?>, EmptyScopeLeaf> emptyScopeLeaves = new WeakHashMap();

    @Override
    public byte getLevel() {
        return 4;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode p2 = this.findParentOf(node);
        if (p2 instanceof BasicRoot) {
            DataSourceNode dsn;
            DbDataSource dbDataSource = this.getContext().getModelRegistry().findDbDataSource((BasicElement)p2);
            DataSourceNode dataSourceNode = dsn = dbDataSource != null ? DataSourceNode.Companion.node(dbDataSource) : null;
            if (dsn != null) {
                p2 = dsn;
            }
        }
        return p2;
    }

    private final BasicNode findParentOf(BasicNode node) {
        if (node instanceof AuxiliaryGroup) {
            return ((AuxiliaryGroup)node).getParent();
        }
        if (node instanceof EmptyScopeLeaf) {
            return ((EmptyScopeLeaf)node).getParent();
        }
        BasicNode originalParent = this.baseParentOf(node);
        BasicNode basicNode = originalParent;
        if (basicNode instanceof DataSourceNode) {
            if (node instanceof HostFamily && DvTreeLayoutLayerKt.access$isNamespaceFamily(node)) {
                return originalParent;
            }
            BasicRoot root = ((DataSourceNode)originalParent).getModelRoot();
            if (root != null) {
                return this.obtainAuxiliaryGroup(root, originalParent);
            }
        } else if (basicNode instanceof BasicDatabase) {
            if (node instanceof HostFamily && DvTreeLayoutLayerKt.access$isNamespaceFamily(node)) {
                return originalParent;
            }
            return this.obtainAuxiliaryGroup((BasicNamespaceOwner)originalParent, originalParent);
        }
        return node instanceof HostFamily ? this.parentOfFamily((HostFamily)node) : originalParent;
    }

    private final BasicNode parentOfFamily(HostFamily<?> family) {
        return this.baseParentOf(family);
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DataSourceNode ? this.childrenOfRoot((DataSourceNode)node) : (basicNode instanceof BasicDatabase ? this.childrenOfNamespaceOwner((BasicNamespaceOwner)node, node) : (basicNode instanceof AuxiliaryGroup ? ((AuxiliaryGroup)node).getChildren() : (basicNode instanceof HostFamily ? this.childrenOfFamily((HostFamily)node) : this.getBase().childrenOf(node))));
    }

    private final JBIterable<? extends BasicNode> childrenOfRoot(DataSourceNode dsn) {
        BasicRoot basicRoot = dsn.getModelRoot();
        if (basicRoot == null) {
            return this.getBase().childrenOf(dsn);
        }
        BasicRoot root = basicRoot;
        return this.childrenOfNamespaceOwner(root, dsn);
    }

    private final JBIterable<? extends BasicNode> childrenOfNamespaceOwner(BasicNamespaceOwner host, BasicNode parent) {
        JBIterable jBIterable = this.getBase().childrenOf(host).filter(arg_0 -> DvTreeLayoutLayer.childrenOfNamespaceOwner$lambda$0(childrenOfNamespaceOwner.namespaceFamilies.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable namespaceFamilies2 = jBIterable;
        AuxiliaryGroup auxiliaryGroup = this.obtainAuxiliaryGroup(host, parent);
        if (auxiliaryGroup.isNotEmpty()) {
            ArrayList<AuxiliaryGroup> list = new ArrayList<AuxiliaryGroup>();
            CollectionsKt.addAll((Collection)list, (Iterable)((Iterable)namespaceFamilies2));
            list.add(auxiliaryGroup);
            JBIterable jBIterable2 = JBIterable.from((Iterable)list);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"from(...)");
            return jBIterable2;
        }
        return namespaceFamilies2;
    }

    private final JBIterable<? extends BasicNode> childrenOfFamily(HostFamily<?> family) {
        JBIterable<? extends BasicNode> children2 = this.getBase().childrenOf(family);
        if (children2.isEmpty()) {
            BasicElement basicElement = family.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
            BasicElement host = basicElement;
            if (host instanceof BasicNamespaceOwner && DvTreeLayoutLayerKt.access$isNamespaceFamily(family) && this.isInTrueDatabase(host)) {
                JBIterable jBIterable = JBIterable.of((Object)this.obtainEmptyScopeLeaf((BasicNamespaceOwner)host, family));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
                return jBIterable;
            }
        }
        return children2;
    }

    private final boolean isInTrueDatabase(BasicElement $this$isInTrueDatabase) {
        RawDataSource ds = this.getContext().getModelRegistry().findDataSource($this$isInTrueDatabase);
        return ds != null && ds instanceof LocalDataSource;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof EmptyScopeLeaf || this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    @Override
    public void clearAll() {
        this.auxiliaryGroups.clear();
        this.emptyScopeLeaves.clear();
    }

    private final AuxiliaryGroup obtainAuxiliaryGroup(BasicNamespaceOwner host, BasicNode parent) {
        AuxiliaryGroup group = this.auxiliaryGroups.get(host);
        if (group == null) {
            group = new AuxiliaryGroup(host, parent);
            ((Map)this.auxiliaryGroups).put(host, group);
        }
        return group;
    }

    private final EmptyScopeLeaf obtainEmptyScopeLeaf(BasicNamespaceOwner host, HostFamily<?> family) {
        EmptyScopeLeaf leaf = this.emptyScopeLeaves.get(family);
        if (leaf == null) {
            leaf = new EmptyScopeLeaf(host, family);
            ((Map)this.emptyScopeLeaves).put(family, leaf);
        }
        return leaf;
    }

    private static final boolean childrenOfNamespaceOwner$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup;", "Lcom/intellij/database/view/structure/DvTreeLayoutLayer$HostGroup;", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "host", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeLayoutLayer;Lcom/intellij/database/model/basic/BasicNamespaceOwner;Lcom/intellij/database/model/basic/BasicNode;)V", "getParent", "()Lcom/intellij/database/model/basic/BasicNode;", "isServer", "", "hostKind", "Lcom/intellij/database/model/ObjectKind;", "getHostKind", "()Lcom/intellij/database/model/ObjectKind;", "getChildren", "Lcom/intellij/util/containers/JBIterable;", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "showCount", "getShowCount", "()Z", "toString", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeLayoutLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeLayoutLayer.kt\ncom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,228:1\n14#2:229\n*S KotlinDebug\n*F\n+ 1 DvTreeLayoutLayer.kt\ncom/intellij/database/view/structure/DvTreeLayoutLayer$AuxiliaryGroup\n*L\n163#1:229\n*E\n"})
    public final class AuxiliaryGroup
    extends HostGroup<BasicNamespaceOwner> {
        @NotNull
        private final BasicNode parent;
        private final boolean isServer;

        public AuxiliaryGroup(@NotNull BasicNamespaceOwner host, BasicNode parent) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super((BasicElement)host);
            this.parent = parent;
            this.isServer = host instanceof BasicRoot;
        }

        @NotNull
        public final BasicNode getParent() {
            return this.parent;
        }

        @Override
        @NotNull
        public ObjectKind getHostKind() {
            ObjectKind objectKind = ObjectKind.UNKNOWN_OBJECT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"UNKNOWN_OBJECT");
            return objectKind;
        }

        @Override
        @NotNull
        public JBIterable<? extends BasicNode> getChildren() {
            JBIterable<? extends BasicNode> hostChildren = DvTreeLayoutLayer.this.getBase().childrenOf(this.host);
            JBIterable jBIterable = hostChildren.filter(arg_0 -> AuxiliaryGroup.getChildren$lambda$0(getChildren.1.INSTANCE, arg_0)).filter(arg_0 -> AuxiliaryGroup.getChildren$lambda$1(new Function1(DvTreeLayoutLayer.this){
                final /* synthetic */ DvTreeLayoutLayer this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Boolean invoke(BasicNode it) {
                    return !(it instanceof FamilyWithId) || this.this$0.getBase().countAllChildrenOf(it) != 0;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string;
            if (this.isServer) {
                String string2 = DatabaseBundle.message("database.view.layers.layout.auxiliaryGroup.ServerObjects.name", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else {
                String string3 = DatabaseBundle.message("database.view.layers.layout.auxiliaryGroup.DatabaseObjects.name", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            void var3_3;
            void _true_$iv;
            void $this$choose$iv;
            boolean bl = this.isServer;
            DvTreeIconItem dvTreeIconItem = DvTreeIconItem.GRAY_FOLDER_WITH_SERVER;
            DvTreeIconItem _false_$iv = DvTreeIconItem.GRAY_FOLDER_WITH_DATABASE;
            boolean $i$f$choose = false;
            return $this$choose$iv != false ? _true_$iv : var3_3;
        }

        @Override
        public boolean getShowCount() {
            return false;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.getDisplayName();
            String string2 = ((BasicNamespaceOwner)this.host).getKind().getPresentableName();
            String string3 = ((BasicNamespaceOwner)this.host).getRealName();
            if (string3 == null) {
                string3 = "<unnamed>";
            }
            return string + " (host: " + string2 + " " + string3 + ")";
        }

        private static final boolean getChildren$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean getChildren$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$EmptyScopeLeaf;", "Lcom/intellij/database/view/structure/DvHostNode;", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "host", "parent", "Lcom/intellij/database/model/families/HostFamily;", "<init>", "(Lcom/intellij/database/model/basic/BasicNamespaceOwner;Lcom/intellij/database/model/families/HostFamily;)V", "getParent", "()Lcom/intellij/database/model/families/HostFamily;", "leafKind", "Lcom/intellij/database/model/ObjectKind;", "getLeafKind", "()Lcom/intellij/database/model/ObjectKind;", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getDisplayName", "", "isItselfMeaningful", "", "()Z", "inMainNamespace", "getInMainNamespace", "toString", "intellij.database.core.impl"})
    public static final class EmptyScopeLeaf
    extends DvHostNode<BasicNamespaceOwner> {
        @NotNull
        private final HostFamily<?> parent;

        public EmptyScopeLeaf(@NotNull BasicNamespaceOwner host, @NotNull HostFamily<?> parent) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            super((BasicElement)host);
            this.parent = parent;
        }

        @NotNull
        public final HostFamily<?> getParent() {
            return this.parent;
        }

        @NotNull
        public final ObjectKind getLeafKind() {
            ObjectKind objectKind = this.parent.getChildrenKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
            return objectKind;
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_SYNTHETIC;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            Object[] objectArray = new Object[]{this.getLeafKind().getPluralPresentableName()};
            String string = DatabaseBundle.message("database.view.layers.layout.emptyScopeLeaf.no.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public boolean isItselfMeaningful() {
            return true;
        }

        public final boolean getInMainNamespace() {
            return Intrinsics.areEqual((Object)this.getLeafKind(), (Object)DvTreeLayoutLayerKt.access$getMainNamespaceKind(this.host));
        }

        @Override
        @NotNull
        public String toString() {
            return "EmptyScopeLeaf(" + this.host + ", " + this.getLeafKind() + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH&J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/structure/DvTreeLayoutLayer$HostGroup;", "H", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvHostNode;", "host", "<init>", "(Lcom/intellij/database/model/basic/BasicElement;)V", "getChildren", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicNode;", "isEmpty", "", "isNotEmpty", "intellij.database.core.impl"})
    public static abstract class HostGroup<H extends BasicElement>
    extends DvHostNode<H> {
        public HostGroup(@NotNull H host) {
            Intrinsics.checkNotNullParameter(host, (String)"host");
            super(host);
        }

        @NotNull
        public abstract JBIterable<? extends BasicNode> getChildren();

        public final boolean isEmpty() {
            return this.getChildren().isEmpty();
        }

        public final boolean isNotEmpty() {
            return this.getChildren().isNotEmpty();
        }
    }
}

