/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.database.view.ui.TableSettings;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.model.Pointer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.TextRanges;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 U2\u00020\u0001:\u0003STUB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\r\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0014J\u000e\u0010\u001f\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0017J6\u0010 \u001a\u00020\u00162\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#0\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0082@\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002J\u0016\u0010)\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002J\u0016\u0010*\u001a\u00020+2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070&J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0002J\n\u0010.\u001a\u0004\u0018\u00010\u0007H\u0002J,\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000202002\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u0002040\"2\u0006\u00105\u001a\u000206H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00072\u0006\u00109\u001a\u00020\u0007H\u0002J\u0018\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u0002012\u0006\u0010%\u001a\u000202H\u0002J\u000e\u0010<\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0017J-\u0010=\u001a\u0004\u0018\u00010+2\u001c\u0010!\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010$\u0012\u0006\u0012\u0004\u0018\u00010\u001d0#0\"H\u0002\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020@2\u0006\u00105\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0004J\n\u0010E\u001a\u0004\u0018\u00010\u0014H\u0016J\u000f\u0010F\u001a\t\u0018\u00010\u001d\u00a2\u0006\u0002\bGH\u0016J\b\u0010H\u001a\u00020\u0016H\u0016J\n\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010K\u001a\u00020+2\u0006\u0010L\u001a\u000204H\u0002J0\u0010 \u001a\u00020\u00162\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#0\"2\u0006\u0010M\u001a\u00020NH\u0084@\u00a2\u0006\u0002\u0010OJ*\u0010P\u001a\u00020Q2\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#0\"2\u0006\u0010M\u001a\u00020NH\u0014J\u0016\u0010(\u001a\u00020\u00162\u0006\u0010M\u001a\u00020NH\u0094@\u00a2\u0006\u0002\u0010RR\u0010\u0010\n\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/database/view/ui/GenericEditingResultProcessor;", "Lcom/intellij/database/view/ui/AbstractDbRefactoringDialog$ResultProcessor;", "provider", "Lcom/intellij/database/view/ui/ResultProcessorProvider;", "settings", "Lcom/intellij/database/view/ui/TableSettings;", "insertPos", "Lcom/intellij/openapi/editor/RangeMarker;", "<init>", "(Lcom/intellij/database/view/ui/ResultProcessorProvider;Lcom/intellij/database/view/ui/TableSettings;Lcom/intellij/openapi/editor/RangeMarker;)V", "myProvider", "mySettings", "myInsertPos", "myGenSettings", "Lcom/intellij/database/view/ui/TableDialogSettings;", "getDataSource", "Lcom/intellij/database/psi/DbDataSource;", "getProject", "Lcom/intellij/openapi/project/Project;", "getPreviewWidget", "Ljavax/swing/JComponent;", "process", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processImpl", "processDdl", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "getTitle", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "processSql", "processWithRenames", "renames", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "ranges", "", "(Lcom/intellij/util/containers/JBIterable;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processWithoutRenames", "open", "insertStatement", "", "getRanges", "getModifiedElementsRanges", "getAfterParentRange", "collectRanges", "", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/util/text/TextRanges;", "modifiedObjects", "Lcom/intellij/database/schemaEditor/model/DeObject;", "model", "Lcom/intellij/database/schemaEditor/model/DeModel;", "getEndOfFile", "correctOffset", "pos", "patch", "file", "processDb", "withRenames", "(Lcom/intellij/util/containers/JBIterable;)Ljava/lang/Boolean;", "createTraverser", "Lcom/intellij/database/view/editors/DdlPreview$ModelTraverser;", "Lcom/intellij/database/view/models/EditorModelBase;", "tweak", "Lcom/intellij/database/view/ModelTraverserEx;", "traverser", "getSettingsPanel", "getCurrentAction", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "update", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "isSql", "obj", "handler", "Lcom/intellij/database/view/DatabaseRefactoringHandler;", "(Lcom/intellij/util/containers/JBIterable;Lcom/intellij/database/view/DatabaseRefactoringHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRenameProcessor", "Lcom/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor;", "(Lcom/intellij/database/view/DatabaseRefactoringHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "AppendDroppedSiblings", "AbortedByUserException", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nGenericEditingResultProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericEditingResultProcessor.kt\ncom/intellij/database/view/ui/GenericEditingResultProcessor\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,625:1\n310#2,11:626\n1#3:637\n1863#4,2:638\n*S KotlinDebug\n*F\n+ 1 GenericEditingResultProcessor.kt\ncom/intellij/database/view/ui/GenericEditingResultProcessor\n*L\n170#1:626,11\n327#1:638,2\n*E\n"})
public class GenericEditingResultProcessor
implements AbstractDbRefactoringDialog.ResultProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final ResultProcessorProvider myProvider;
    @JvmField
    @NotNull
    protected final TableSettings mySettings;
    @Nullable
    private final RangeMarker myInsertPos;
    @NotNull
    private final TableDialogSettings myGenSettings;

    public GenericEditingResultProcessor(@NotNull ResultProcessorProvider provider, @NotNull TableSettings settings, @Nullable RangeMarker insertPos) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.mySettings = new TableSettings(settings);
        Project project = provider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.mySettings.renameInStorage = DbRenamePsiElementProcessor.Companion.getSearchReferencesInStorage(project);
        this.myProvider = provider;
        this.myInsertPos = insertPos;
        this.myGenSettings = new TableDialogSettings((Consumer<? super TableSettings>)((Consumer)arg_0 -> GenericEditingResultProcessor._init_$lambda$1(arg_0 -> GenericEditingResultProcessor._init_$lambda$0(provider, this, arg_0), arg_0)), this.mySettings);
    }

    private final DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myProvider.getContext().getDataSource();
        Intrinsics.checkNotNull((Object)dbDataSource);
        return dbDataSource;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProvider.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Override
    @Nullable
    public JComponent getPreviewWidget() {
        return null;
    }

    @Override
    @Nullable
    public Object process(@NotNull Continuation<? super Unit> $completion) {
        return GenericEditingResultProcessor.process$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object process$suspendImpl(GenericEditingResultProcessor $this, Continuation<? super Unit> $completion) {
        AsyncTask.Frame frame = AsyncTask.Companion.frame($this.getTitle());
        AsyncTask.Companion.withBgIndicatorIfNeeded(frame, $this.getProject(), null);
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)frame.getElement()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, null){
            int label;
            final /* synthetic */ GenericEditingResultProcessor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GenericEditingResultProcessor.access$processImpl(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object processImpl(Continuation<? super Unit> $completion) {
        if (this.mySettings.finalAction == TableSettings.FinalAction.EXEC_IN_DB) {
            Object object = this.processDb($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        SqlDataSource sqlDs = DbImplUtilCore.getMaybeSqlDataSource(this.myProvider.getContext().getDataSource());
        if (sqlDs == null) {
            Object object = this.processSql($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.processDdl(sqlDs);
        return Unit.INSTANCE;
    }

    private final void processDdl(SqlDataSource sqlDs) {
        EditorModelBase editorModelBase = this.myProvider.getEditor().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)editorModelBase, (String)"getModel(...)");
        EditorModelBase editorModel = editorModelBase;
        DdlPreview.ModelTraverser modelTraverser = this.createTraverser(editorModel);
        Intrinsics.checkNotNull((Object)modelTraverser, (String)"null cannot be cast to non-null type com.intellij.database.view.ModelTraverserEx");
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = ((ModelTraverserEx)modelTraverser).prepareCreateTask();
        Intrinsics.checkNotNullExpressionValue((Object)scriptingSingleModelTaskBuilder, (String)"prepareCreateTask(...)");
        ScriptingSingleModelTaskBuilder builder = scriptingSingleModelTaskBuilder;
        Project project = this.myProvider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set<VirtualFile> files2 = DumpToDdlDataSourceActionKt.expandAndDump(project, sqlDs, builder.getModel(), null, (Iterable<? extends BasicElement>)builder.getElements(), false);
        DumpToDdlDataSourceActionKt.selectFile(this.getProject(), files2);
    }

    @NotNull
    protected String getTitle() {
        String string = DatabaseBundle.message("progress.text.refactor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final Object processSql(Continuation<? super Unit> $completion) {
        List<RangeMarker> ranges = this.getRanges();
        if (ranges.isEmpty()) {
            throw new RuntimeException(DatabaseBundle.message("notification.content.unable.to.find.insertion.place", new Object[0]));
        }
        JBIterable<Pair<PsiElement, String>> jBIterable = this.myProvider.collectRenames();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"collectRenames(...)");
        JBIterable<Pair<PsiElement, String>> renames = jBIterable;
        Boolean withRenames = this.withRenames(renames);
        if (withRenames == null) {
            return Unit.INSTANCE;
        }
        if (withRenames.booleanValue()) {
            Object object = this.processWithRenames(renames, ranges, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.processWithoutRenames(ranges);
        return Unit.INSTANCE;
    }

    private final Object processWithRenames(JBIterable<Pair<PsiElement, String>> renames, List<RangeMarker> ranges, Continuation<? super Unit> $completion) {
        JBIterable renames2 = renames;
        Object object = renames2.first();
        Intrinsics.checkNotNull((Object)object);
        Pair pair = (Pair)object;
        renames2 = renames2.skip(1);
        Project project = this.myProvider.getContext().getProject();
        PsiElement psiElement = (PsiElement)pair.first;
        String string = (String)pair.second;
        RenameProcessor processor2 = new RenameProcessor(this, ranges, project, psiElement, string){
            final /* synthetic */ GenericEditingResultProcessor this$0;
            final /* synthetic */ List<RangeMarker> $ranges;
            {
                this.this$0 = $receiver;
                this.$ranges = $ranges;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, true, true);
            }

            protected void execute(UsageInfo[] usages) {
                Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                super.execute(usages);
                WriteCommandAction.runWriteCommandAction((Project)this.this$0.getProject(), null, null, () -> processWithRenames.processor.1.execute$lambda$0(this.this$0, this.$ranges), (PsiFile[])new PsiFile[0]);
                GenericEditingResultProcessor.access$open(this.this$0, this.$ranges);
            }

            private static final void execute$lambda$0(GenericEditingResultProcessor this$0, List $ranges) {
                GenericEditingResultProcessor.access$insertStatement(this$0, $ranges);
            }
        };
        for (Pair rename : renames2) {
            processor2.addElement((PsiElement)rename.first, (String)rename.second);
        }
        processor2.setPreviewUsages(this.myProvider.isPreviewUsages());
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        processor2.setPrepareSuccessfulSwingThreadCallback(new Runnable((CancellableContinuation<? super Unit>)it){
            final /* synthetic */ CancellableContinuation<Unit> $it;
            {
                this.$it = $it;
            }

            public final void run() {
                ((Continuation)this.$it).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        processor2.run();
        Object object2 = cancellable$iv.getResult();
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final void processWithoutRenames(List<RangeMarker> ranges) {
        if (this.insertStatement(ranges)) {
            this.open(ranges);
        }
    }

    private final void open(List<RangeMarker> ranges) {
        Project project = this.myProvider.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile file = FileDocumentManager.getInstance().getFile(ranges.get(0).getDocument());
        if (file != null) {
            FileEditorManager.getInstance((Project)project2).openFile(file, true, true);
        }
    }

    private final boolean insertStatement(List<RangeMarker> ranges) {
        if (ranges.isEmpty()) {
            return false;
        }
        HashSet<Document> visited = new HashSet<Document>();
        for (RangeMarker marker : ranges) {
            if (visited.add(marker.getDocument())) {
                PsiDocumentManager.getInstance((Project)this.myProvider.getContext().getProject()).doPostponedOperationsAndUnblockDocument(marker.getDocument());
            }
            if (marker.isValid()) continue;
            return false;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProvider.getContext().getProject(), null, null, () -> GenericEditingResultProcessor.insertStatement$lambda$3(this, ranges), (PsiFile[])new PsiFile[0]);
        return true;
    }

    @NotNull
    public final List<RangeMarker> getRanges() {
        List<RangeMarker> ranges;
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL && !(ranges = this.getModifiedElementsRanges()).isEmpty()) {
            return ranges;
        }
        if (this.myInsertPos != null && this.myInsertPos.isValid() && this.myInsertPos.getDocument().isWritable()) {
            RangeMarker corrected = this.correctOffset(this.myInsertPos);
            Object[] objectArray = new RangeMarker[]{ObjectUtils.chooseNotNull((Object)corrected, (Object)this.myInsertPos)};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        RangeMarker afterParentRange = this.getAfterParentRange();
        if (afterParentRange != null) {
            Object[] objectArray = new RangeMarker[]{afterParentRange};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        RangeMarker endOfFile = this.getEndOfFile();
        List list = ContainerUtil.createMaybeSingletonList((Object)endOfFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createMaybeSingletonList(...)");
        return list;
    }

    private final List<RangeMarker> getModifiedElementsRanges() {
        EditorModelBase editorModelBase = this.myProvider.getEditor().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)editorModelBase, (String)"getModel(...)");
        EditorModelBase editorModel = editorModelBase;
        JBIterable jBIterable = this.createTraverser(editorModel).traverse().transform(arg_0 -> GenericEditingResultProcessor.getModifiedElementsRanges$lambda$5(GenericEditingResultProcessor::getModifiedElementsRanges$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"transform(...)");
        DeModel deModel = editorModel.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)deModel, (String)"getModel(...)");
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges((JBIterable<? extends DeObject>)jBIterable, deModel);
        Project project = this.myProvider.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (rangesPerFile.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<RangeMarker> result2 = new ArrayList<RangeMarker>();
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            Iterator iterator;
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getValue().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                TextRange range = (TextRange)iterator.next();
                result2.add(document.createRangeMarker(range));
            }
        }
        return result2;
    }

    private final RangeMarker getAfterParentRange() {
        EditorModelBase editorModelBase = this.myProvider.getEditor().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)editorModelBase, (String)"getModel(...)");
        EditorModelBase editorModel = editorModelBase;
        Project project = this.myProvider.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JBIterable<? extends DeObject> jBIterable = editorModel.getModel().getModelRoots();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getModelRoots(...)");
        DeModel deModel = editorModel.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)deModel, (String)"getModel(...)");
        Map<PsiFile, TextRanges> rangesPerFile = this.collectRanges(jBIterable, deModel);
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            TextRange range = (TextRange)entry.getValue().iterator().next();
            int offset = range.getEndOffset();
            return document.createRangeMarker(offset, offset);
        }
        return null;
    }

    private final Map<PsiFile, TextRanges> collectRanges(JBIterable<? extends DeObject> modifiedObjects, DeModel model) {
        LinkedHashMap<PsiFile, TextRanges> rangesPerFile = new LinkedHashMap<PsiFile, TextRanges>();
        for (DeObject modifiedObject : modifiedObjects) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue((Object)((JBTreeTraverser)model.traverser().withRoot((Object)modifiedObject)).iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                SqlElement element;
                DeObject obj2 = (DeObject)iterator.next();
                DatabaseEditorContext databaseEditorContext = this.myProvider.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)databaseEditorContext, (String)"getContext(...)");
                SqlElement sqlElement = element = Companion.getSqlElement(obj2, databaseEditorContext);
                Object file = sqlElement != null ? sqlElement.getContainingFile() : null;
                if (file == null) continue;
                TextRanges textRanges = (TextRanges)rangesPerFile.get(file);
                if (textRanges == null) {
                    TextRanges textRanges2;
                    TextRanges it = textRanges2 = new TextRanges();
                    boolean bl = false;
                    rangesPerFile.put((PsiFile)file, it);
                    textRanges = textRanges2;
                }
                TextRanges ranges = textRanges;
                ranges.union(element.getTextRange());
            }
        }
        return rangesPerFile;
    }

    private final RangeMarker getEndOfFile() {
        VirtualFile file = this.myProvider.getContext().getOrCreateVirtualFile();
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int length = document.getTextLength();
        return document.createRangeMarker(length, length);
    }

    private final RangeMarker correctOffset(RangeMarker pos) {
        ParserDefinition definition;
        SqlLanguageDialect dialect;
        Project project = this.myProvider.getContext().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(pos.getDocument());
        if (file == null) {
            return null;
        }
        PsiElement element = file.findElementAt(pos.getStartOffset());
        if (element == null) {
            return null;
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) == null) {
            return null;
        }
        SqlLanguageDialect sqlLanguageDialect = dialect = DbSqlUtilCore.getSqlDialect(element);
        ParserDefinition parserDefinition = definition = sqlLanguageDialect == null ? null : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)sqlLanguageDialect);
        if (definition != null) {
            PsiElement next;
            TokenSet[] tokenSetArray = new TokenSet[3];
            SqlLanguageDialect sqlLanguageDialect2 = dialect;
            Intrinsics.checkNotNull((Object)sqlLanguageDialect2);
            tokenSetArray[0] = sqlLanguageDialect2.getStatementSeparators();
            tokenSetArray[1] = definition.getCommentTokens();
            tokenSetArray[2] = definition.getWhitespaceTokens();
            TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
            TokenSet skip = tokenSet;
            while ((next = PsiTreeUtil.nextVisibleLeaf((PsiElement)element)) != null && skip.contains(GenericEditingResultProcessor.Companion.getNodeType(next))) {
                element = next;
            }
        }
        int offset = element.getTextRange().getEndOffset();
        return pos.getDocument().createRangeMarker(offset, offset);
    }

    private final void patch(PsiFile file, TextRanges ranges) {
        TokenSet separators = this.myProvider.getContext().getSqlDialect().getStatementSeparators();
        List patches = new ArrayList();
        for (TextRange range : JBIterable.once((Iterator)ranges.gapIterator())) {
            Intrinsics.checkNotNull((Object)range);
            Intrinsics.checkNotNull((Object)separators);
            if (GenericEditingResultProcessor.Companion.shouldPlumb(file, range, separators)) {
                patches.add(range);
                continue;
            }
            TextRange expanded = GenericEditingResultProcessor.Companion.expand(file, range, separators);
            if (expanded == null) continue;
            patches.add(expanded);
        }
        Iterable $this$forEach$iv = patches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextRange it = (TextRange)element$iv;
            boolean bl = false;
            ranges.union(it);
        }
        TextRange last = (TextRange)JBIterable.once((Iterator)ranges.revIterator()).first();
        if (last != null) {
            TextRange textRange = TextRange.create((int)last.getEndOffset(), (int)file.getTextLength());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            Intrinsics.checkNotNull((Object)separators);
            TextRange lastPatch = GenericEditingResultProcessor.Companion.expand(file, textRange, separators);
            if (lastPatch != null) {
                ranges.union(lastPatch);
            }
        }
    }

    private final Object processDb(Continuation<? super Unit> $completion) {
        DeObject edited;
        DatabaseEditorContext databaseEditorContext = this.myProvider.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)databaseEditorContext, (String)"getContext(...)");
        DatabaseEditorContext context = databaseEditorContext;
        DbDataSource dbDataSource = context.getDataSource();
        if (dbDataSource == null) {
            return Unit.INSTANCE;
        }
        DbDataSource dataSource = dbDataSource;
        String error = null;
        if (!DbImplUtilCore.canConnectTo(dataSource)) {
            error = DatabaseBundle.message("notification.content.unable.to.connect.to.data.source", new Object[0]);
        }
        if (!ImportUtil.canModify(dataSource)) {
            error = DatabaseBundle.message("notification.content.unable.to.modify.data.source", new Object[0]);
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
        Project project = this.getProject();
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(this.getDataSource());
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getLocalDataSource(...)");
        DatabaseRefactoringHandler databaseRefactoringHandler = new DatabaseRefactoringHandler(project, localDataSource, context.getSearchPath());
        String string = this.myProvider.statement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statement(...)");
        DatabaseRefactoringHandler handler2 = databaseRefactoringHandler.setStatement(string);
        String string2 = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueId(...)");
        DeModel deModel = this.myProvider.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)deModel, (String)"getModel(...)");
        GenericEditingResultProcessor.Companion.fillContext(string2, deModel, handler2);
        DeObject deObject = edited = this.myProvider.getEditedObject();
        handler2.setElementToFocus(deObject != null ? deObject.getPath() : null);
        JBIterable<Pair<PsiElement, String>> jBIterable = this.myProvider.collectRenames();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"collectRenames(...)");
        JBIterable<Pair<PsiElement, String>> renames = jBIterable;
        Boolean withRenames = this.withRenames(renames);
        if (withRenames == null) {
            return Unit.INSTANCE;
        }
        if (withRenames.booleanValue()) {
            Object object = this.processWithRenames(renames, handler2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = this.processWithoutRenames(handler2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Boolean withRenames(JBIterable<Pair<PsiElement, String>> renames) {
        if (renames.isEmpty()) {
            return false;
        }
        Project project = this.myProvider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DumbService.Companion.isDumb(project)) {
            return true;
        }
        String string = DatabaseBundle.message("dialog.title.indexing.in.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message("dialog.message.usages.won.t.be.renamed.because.indexing.in.progress.proceed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        if (MessageDialogBuilder.Companion.yesNo(string, string2).ask(this.myProvider.getProject())) {
            return false;
        }
        return null;
    }

    @Override
    @NotNull
    public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return this.tweak(new ModelTraverserEx(this.mySettings, model, this.myProvider.getModel(), this.myProvider.getContext().getDataSource()));
    }

    @NotNull
    protected final ModelTraverserEx tweak(@NotNull ModelTraverserEx traverser) {
        Intrinsics.checkNotNullParameter((Object)traverser, (String)"traverser");
        return traverser;
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel() {
        return this.myGenSettings.getComponent();
    }

    @Override
    @Nullable
    public String getCurrentAction() {
        if (this.mySettings.finalAction == TableSettings.FinalAction.APPEND_DDL) {
            return DatabaseBundle.message("action.to.editor.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL) {
            return DatabaseBundle.message("action.replace.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.EXEC_IN_DB) {
            return DatabaseBundle.message("action.execute.text", new Object[0]);
        }
        if (this.mySettings.finalAction == TableSettings.FinalAction.ADD_OBJECT) {
            return DatabaseBundle.message("action.create.1.text", new Object[0]);
        }
        return null;
    }

    @Override
    public void update() {
        JBIterable<? extends DeObject> jBIterable = this.myProvider.getEditor().getModel().getEditedObjects();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getEditedObjects(...)");
        JBIterable<? extends DeObject> editedObjects = jBIterable;
        JBIterable jBIterable2 = ((JBTreeTraverser)this.myProvider.getModel().traverser().withRoots((Iterable)editedObjects)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"traverse(...)");
        JBIterable allObjects = jBIterable2;
        boolean hasNonSql2 = !editedObjects.filter(arg_0 -> GenericEditingResultProcessor.update$lambda$8(new Function1(this){
            final /* synthetic */ GenericEditingResultProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            public final Boolean invoke(DeObject it) {
                Intrinsics.checkNotNull((Object)it);
                return !GenericEditingResultProcessor.access$isSql(this.this$0, it);
            }
        }, arg_0)).isEmpty();
        boolean hasSql = !allObjects.filter(arg_0 -> GenericEditingResultProcessor.update$lambda$10(arg_0 -> GenericEditingResultProcessor.update$lambda$9(this, arg_0), arg_0)).isEmpty();
        DbDataSource dataSource = this.myProvider.getContext().getDataSource();
        boolean dbAvailable = ImportUtil.canConnectToAndModify(dataSource);
        JBIterable<Pair<PsiElement, String>> jBIterable3 = this.myProvider.collectRenames();
        Intrinsics.checkNotNullExpressionValue(jBIterable3, (String)"collectRenames(...)");
        JBIterable<Pair<PsiElement, String>> renames = jBIterable3;
        this.myGenSettings.setAvailability(dbAvailable && (hasNonSql2 || GenericEditingResultProcessor.Companion.newObjects((JBIterable<? extends DeObject>)editedObjects)), hasSql, DbImplUtilCore.getMaybeSqlDataSource(dataSource) != null, !renames.isEmpty());
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.mySettings.finalAction == TableSettings.FinalAction.REPLACE_DDL) {
            EditorModelBase editorModelBase = this.myProvider.getEditor().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)editorModelBase, (String)"getModel(...)");
            JBIterable jBIterable = this.createTraverser(editorModelBase).traverse().transform(arg_0 -> GenericEditingResultProcessor.validate$lambda$12(GenericEditingResultProcessor::validate$lambda$11, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"transform(...)");
            JBIterable modified = jBIterable;
            boolean allSql = modified.filter(arg_0 -> GenericEditingResultProcessor.validate$lambda$14(arg_0 -> GenericEditingResultProcessor.validate$lambda$13(this, arg_0), arg_0)).isEmpty();
            if (!allSql) {
                return new ValidationInfo(DatabaseBundle.message("dialog.message.unable.to.replace.ddl.for.some.objects.they.are.in.db", new Object[0]));
            }
        }
        return null;
    }

    private final boolean isSql(DeObject obj2) {
        DatabaseEditorContext databaseEditorContext = this.myProvider.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)databaseEditorContext, (String)"getContext(...)");
        DatabaseEditorContext context = databaseEditorContext;
        return Companion.getSqlElement(obj2, context) != null;
    }

    @Nullable
    protected final Object processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler2, @NotNull Continuation<? super Unit> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, renames, handler2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GenericEditingResultProcessor this$0;
            final /* synthetic */ JBIterable<Pair<PsiElement, String>> $renames;
            final /* synthetic */ DatabaseRefactoringHandler $handler;
            {
                this.this$0 = $receiver;
                this.$renames = $renames;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block7: {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$coroutineScope = (CoroutineScope)this.L$0;
                            processor = this.this$0.createRenameProcessor(this.$renames, this.$handler);
                            processor.setPreviewUsages(this.this$0.myProvider.isPreviewUsages());
                            codeModification = BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(processor, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ DbRenamePsiElementProcessor.MyRenameProcessor $processor;
                                {
                                    this.$processor = $processor;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            DbRenamePsiElementProcessor.MyRenameProcessor myRenameProcessor = this.$processor;
                                            boolean $i$f$suspendCancellableCoroutine = false;
                                            this.L$0 = myRenameProcessor;
                                            this.label = 1;
                                            Continuation uCont$iv = (Continuation)this;
                                            boolean bl = false;
                                            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                                            cancellable$iv.initCancellability();
                                            CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                                            boolean bl2 = false;
                                            myRenameProcessor.setPrepareSuccessfulSwingThreadCallback(new Runnable((CancellableContinuation<? super Unit>)it){
                                                final /* synthetic */ CancellableContinuation<Unit> $it;
                                                {
                                                    this.$it = $it;
                                                }

                                                public final void run() {
                                                    ((Continuation)this.$it).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                                                }
                                            });
                                            Object object3 = cancellable$iv.getResult();
                                            if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                                            }
                                            Object object4 = object3;
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            boolean $i$f$suspendCancellableCoroutine = false;
                                            DbRenamePsiElementProcessor.MyRenameProcessor cfr_ignored_0 = (DbRenamePsiElementProcessor.MyRenameProcessor)((Object)this.L$0);
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object4 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            processor.run();
                            this.L$0 = processor;
                            this.label = 1;
                            v0 = codeModification.join((Continuation)this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            processor = (DbRenamePsiElementProcessor.MyRenameProcessor)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            v1 = processor.getAsyncStarted();
                            if (v1 == null) break;
                            this.L$0 = null;
                            this.label = 2;
                            v2 = v1.join((Continuation)this);
                            if (v2 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl31
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl31:
                            // 2 sources

                            v3 = Unit.INSTANCE;
                            break block7;
                        }
                    }
                    v3 = null;
                }
                return v3;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    protected DbRenamePsiElementProcessor.MyRenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler2) {
        Intrinsics.checkNotNullParameter(renames, (String)"renames");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Pair r = (Pair)renames.first();
        if (r == null) {
            throw new AssertionError((Object)"No renames");
        }
        Project project = this.getProject();
        Object object = r.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        PsiElement psiElement = (PsiElement)object;
        Object object2 = r.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        String string = (String)object2;
        Iterable iterable = (Iterable)renames.skip(1);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return new DbRenamePsiElementProcessor.MyRenameProcessor(project, psiElement, handler2, string, iterable, (SearchScope)globalSearchScope, this.mySettings.renameInCommentsAndLiterals, this.mySettings.renameTextOccurrences);
    }

    @Nullable
    protected Object processWithoutRenames(@NotNull DatabaseRefactoringHandler handler2, @NotNull Continuation<? super Unit> $completion) {
        return GenericEditingResultProcessor.processWithoutRenames$suspendImpl(this, handler2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object processWithoutRenames$suspendImpl(GenericEditingResultProcessor var0, DatabaseRefactoringHandler var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof processWithoutRenames.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GenericEditingResultProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GenericEditingResultProcessor.processWithoutRenames$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = handler;
                $continuation.label = 1;
                v0 = handler.runStatements(true, (Continuation<? super Boolean>)$continuation);
                ** if (v0 != var7_5) goto lbl19
lbl18:
                // 1 sources

                return var7_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                handler = (DatabaseRefactoringHandler)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    ((Boolean)v0).booleanValue();
                }
                catch (Throwable e) {
                    if (!AsyncUtil.isCancellation(e)) {
                        AsyncUtil.addUnhandledError(handler.getErrorHandler(), e, handler.getDataSource());
                    }
                    v1 = handler.getErrorHandler().getSummary();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSummary(...)");
                    if (!(((CharSequence)v1).length() == 0)) {
                        message = handler.getErrorHandler().getSummary(DatabaseBundle.message("notification.content.cancelled", new Object[0]));
                        throw new RuntimeException(message);
                    }
                    if (handler.isAbortedByUser()) {
                        throw new AbortedByUserException();
                    }
                    throw new ProcessCanceledException();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit _init_$lambda$0(ResultProcessorProvider $provider, GenericEditingResultProcessor this$0, TableSettings it) {
        Project project = $provider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DbRenamePsiElementProcessor.Companion.setSearchReferencesInStorage(project, it.renameInStorage);
        this$0.mySettings.assign(it);
        this$0.myProvider.settingsChanged();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void insertStatement$lambda$3(GenericEditingResultProcessor this$0, List $ranges) {
        String string = this$0.myProvider.statement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statement(...)");
        String statement2 = string;
        statement2 = StringsKt.removeSuffix((String)statement2, (CharSequence)";");
        RangeMarker main = (RangeMarker)$ranges.get(0);
        boolean insertBreak = false;
        if ($ranges.size() == 1 && main.getStartOffset() == main.getEndOffset()) {
            int lineStart = main.getDocument().getLineStartOffset(main.getDocument().getLineNumber(main.getStartOffset()));
            String string2 = main.getDocument().getText(TextRange.create((int)lineStart, (int)main.getStartOffset()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            CharSequence charSequence = string2;
            insertBreak = !new Regex("\\s*").matches(charSequence);
        }
        main.getDocument().replaceString(main.getStartOffset(), main.getEndOffset(), (CharSequence)((insertBreak ? "\n" : "") + statement2));
        for (RangeMarker marker : $ranges.subList(1, $ranges.size())) {
            marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)"");
        }
    }

    private static final DeObject getModifiedElementsRanges$lambda$4(DdlPreview.ObjectAction it) {
        return it.object;
    }

    private static final DeObject getModifiedElementsRanges$lambda$5(Function1 $tmp0, Object p0) {
        return (DeObject)$tmp0.invoke(p0);
    }

    private static final boolean update$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean update$lambda$9(GenericEditingResultProcessor this$0, DeObject it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isSql(it);
    }

    private static final boolean update$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DeObject validate$lambda$11(DdlPreview.ObjectAction it) {
        return it.object;
    }

    private static final DeObject validate$lambda$12(Function1 $tmp0, Object p0) {
        return (DeObject)$tmp0.invoke(p0);
    }

    private static final boolean validate$lambda$13(GenericEditingResultProcessor this$0, DeObject it) {
        Intrinsics.checkNotNull((Object)it);
        return !this$0.isSql(it);
    }

    private static final boolean validate$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @Nullable
    public static final SqlElement getSqlElement(@Nullable DeObject obj2, @NotNull DatabaseEditorContext context) {
        return Companion.getSqlElement(obj2, context);
    }

    @JvmStatic
    @Nullable
    public static final SqlElement getSqlElement(@Nullable BasicElement obj2, @NotNull DatabaseEditorContext context) {
        return Companion.getSqlElement(obj2, context);
    }

    public static final /* synthetic */ Object access$processImpl(GenericEditingResultProcessor $this, Continuation $completion) {
        return $this.processImpl((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processSql(GenericEditingResultProcessor $this, Continuation $completion) {
        return $this.processSql((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$processWithRenames(GenericEditingResultProcessor $this, JBIterable renames, List ranges, Continuation $completion) {
        return $this.processWithRenames((JBIterable<Pair<PsiElement, String>>)renames, ranges, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$open(GenericEditingResultProcessor $this, List ranges) {
        $this.open(ranges);
    }

    public static final /* synthetic */ boolean access$insertStatement(GenericEditingResultProcessor $this, List ranges) {
        return $this.insertStatement(ranges);
    }

    public static final /* synthetic */ Object access$processDb(GenericEditingResultProcessor $this, Continuation $completion) {
        return $this.processDb((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$isSql(GenericEditingResultProcessor $this, DeObject obj2) {
        return $this.isSql(obj2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/view/ui/GenericEditingResultProcessor$AbortedByUserException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.database.impl"})
    public static final class AbortedByUserException
    extends RuntimeException {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings;", "Lcom/intellij/util/Function;", "Lcom/intellij/database/schemaEditor/model/DeObject;", "", "Lcom/intellij/database/view/editors/DdlPreview$ObjectAction;", "settings", "Lcom/intellij/database/view/ui/TableSettings;", "<init>", "(Lcom/intellij/database/view/ui/TableSettings;)V", "myProcessedParents", "", "mySettings", "fun", "obj", "processParent", "Lcom/intellij/util/containers/JBIterable;", "intellij.database.impl"})
    public static final class AppendDroppedSiblings
    implements Function<DeObject, Iterable<? extends DdlPreview.ObjectAction>> {
        @NotNull
        private final Set<DeObject> myProcessedParents;
        @NotNull
        private final TableSettings mySettings;

        public AppendDroppedSiblings(@NotNull TableSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.myProcessedParents = new HashSet();
            this.mySettings = settings;
        }

        @NotNull
        public Iterable<DdlPreview.ObjectAction> fun(@NotNull DeObject obj2) {
            Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
            JBIterable res2 = this.processParent(obj2.getParent());
            if (Companion.isModified(obj2) || this.mySettings.finalAction == TableSettings.FinalAction.APPEND_DDL && this.mySettings.codeType == TableSettings.CodeType.CREATE_ALL_CODE) {
                res2 = this.mySettings.codeType == TableSettings.CodeType.ALTER_CODE ? res2.append((Object)Companion.assignAction(obj2)) : res2.append((Object)new DdlPreview.ObjectAction(DdlPreview.ObjectAction.Action.CREATE, obj2));
            }
            return (Iterable)res2;
        }

        private final JBIterable<DdlPreview.ObjectAction> processParent(DeObject obj2) {
            if (!(obj2 instanceof DeTable) || !((DeTable)obj2).hasEdited() || this.myProcessedParents.contains(obj2)) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            this.myProcessedParents.add(obj2);
            Set set = ((DeTable)obj2).getDasChildren(null).filterMap(arg_0 -> AppendDroppedSiblings.processParent$lambda$1(AppendDroppedSiblings::processParent$lambda$0, arg_0)).toSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
            Set modified = set;
            DeTable deTable = ((DeTable)obj2).getEditedDeObject();
            Intrinsics.checkNotNull((Object)deTable);
            JBIterable jBIterable = deTable.getDasChildren(null).filter(arg_0 -> AppendDroppedSiblings.processParent$lambda$3(arg_0 -> AppendDroppedSiblings.processParent$lambda$2(modified, arg_0), arg_0)).map(arg_0 -> AppendDroppedSiblings.processParent$lambda$5(AppendDroppedSiblings::processParent$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
            return jBIterable;
        }

        private static final DeObject processParent$lambda$0(DeObject it) {
            return it.getEditedDeObject();
        }

        private static final DeObject processParent$lambda$1(Function1 $tmp0, Object p0) {
            return (DeObject)$tmp0.invoke(p0);
        }

        private static final boolean processParent$lambda$2(Set $modified, DeObject it) {
            return !$modified.contains(it);
        }

        private static final boolean processParent$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final DdlPreview.ObjectAction processParent$lambda$4(DeObject it) {
            return new DdlPreview.ObjectAction(DdlPreview.ObjectAction.Action.DROP, it);
        }

        private static final DdlPreview.ObjectAction processParent$lambda$5(Function1 $tmp0, Object p0) {
            return (DdlPreview.ObjectAction)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\"2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010#\u001a\u00020\u00142\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0%H\u0002J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f\u00a8\u0006)"}, d2={"Lcom/intellij/database/view/ui/GenericEditingResultProcessor$Companion;", "", "<init>", "()V", "fillContext", "", "dataSourceId", "", "model", "Lcom/intellij/database/schemaEditor/model/DeModel;", "modifier", "Lcom/intellij/database/view/AbstractDatabaseModifier;", "scheduleIntrospectionScopeUpdate", "scopeUpdater", "Lcom/intellij/database/util/IntrospectionScopeUpdater;", "getNodeType", "Lcom/intellij/psi/tree/IElementType;", "el", "Lcom/intellij/psi/PsiElement;", "shouldPlumb", "", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "seps", "Lcom/intellij/psi/tree/TokenSet;", "expand", "getSqlElement", "Lcom/intellij/sql/psi/SqlElement;", "obj", "Lcom/intellij/database/schemaEditor/model/DeObject;", "context", "Lcom/intellij/database/view/editors/DatabaseEditorContext;", "Lcom/intellij/database/model/basic/BasicElement;", "newObjects", "objects", "Lcom/intellij/util/containers/JBIterable;", "isModified", "assignAction", "Lcom/intellij/database/view/editors/DdlPreview$ObjectAction;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void fillContext(String dataSourceId, DeModel model, AbstractDatabaseModifier modifier) {
            JBIterable jBIterable = ((JBTreeTraverser)model.traverser().expandAndSkip(arg_0 -> Companion.fillContext$lambda$1(arg_0 -> Companion.fillContext$lambda$0(model, arg_0), arg_0))).bfsTraversal();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"bfsTraversal(...)");
            JBIterable modifiedRoots = jBIterable;
            if (modifiedRoots.isEmpty()) {
                modifier.include(IntrospectionTasks.prepareGeneralTask(dataSourceId));
            } else {
                for (DeObject root : modifiedRoots) {
                    BasicElement element;
                    BasicElement basicElement = element = root.unwrap();
                    if (basicElement != null) {
                        modifier.include(basicElement);
                        continue;
                    }
                    modifier.include(root.getPath());
                }
            }
            if (modifier.getDataSource().shouldTrackNamespaces()) {
                this.scheduleIntrospectionScopeUpdate(model, modifier.getScopeUpdater());
            }
        }

        private final void scheduleIntrospectionScopeUpdate(DeModel model, IntrospectionScopeUpdater scopeUpdater) {
            JBIterable jBIterable = ((JBTreeTraverser)model.traverser().expand(arg_0 -> Companion.scheduleIntrospectionScopeUpdate$lambda$3(Companion::scheduleIntrospectionScopeUpdate$lambda$2, arg_0))).filter(DeNamespace.class).filter(arg_0 -> Companion.scheduleIntrospectionScopeUpdate$lambda$5(Companion::scheduleIntrospectionScopeUpdate$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable namespaces2 = jBIterable;
            if (!namespaces2.isEmpty()) {
                for (DeNamespace namespace : namespaces2) {
                    ObjectKind kind;
                    Intrinsics.checkNotNullExpressionValue((Object)namespace.getKind(), (String)"getKind(...)");
                    if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
                    scopeUpdater.toAdd(namespace.getPath());
                }
            }
        }

        private final IElementType getNodeType(PsiElement el) {
            return el == null || el.getNode() == null ? null : el.getNode().getElementType();
        }

        private final boolean shouldPlumb(PsiFile file, TextRange range, TokenSet seps) {
            PsiElement element = file.findElementAt(range.getStartOffset());
            while (element != null && element.getTextOffset() < range.getEndOffset()) {
                CharSequence charSequence;
                IElementType type;
                IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
                if (!seps.contains(type) && !((charSequence = (CharSequence)element.getText()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    return false;
                }
                element = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
            }
            return true;
        }

        private final TextRange expand(PsiFile file, TextRange range, TokenSet seps) {
            PsiElement element = file.findElementAt(range.getStartOffset());
            int expanded = range.getStartOffset();
            while (element != null && element.getTextOffset() < range.getEndOffset()) {
                IElementType type;
                IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
                if (!seps.contains(type)) {
                    CharSequence charSequence = element.getText();
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break;
                    String string = element.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) break;
                }
                expanded = element.getTextRange().getEndOffset();
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
            }
            if (expanded == range.getStartOffset()) {
                return null;
            }
            return TextRange.create((int)range.getStartOffset(), (int)expanded);
        }

        @JvmStatic
        @Nullable
        public final SqlElement getSqlElement(@Nullable DeObject obj2, @NotNull DatabaseEditorContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            DeObject deObject = obj2;
            return this.getSqlElement(deObject != null ? deObject.unwrap() : null, context);
        }

        @JvmStatic
        @Nullable
        public final SqlElement getSqlElement(@Nullable BasicElement obj2, @NotNull DatabaseEditorContext context) {
            Pointer<DasObject> pointer;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (obj2 == null) {
                return null;
            }
            Map<? extends DasObject, Pointer<DasObject>> mapping = context.getMapping();
            if (mapping != null && (pointer = mapping.get(obj2)) != null) {
                Object object = pointer.dereference();
                return object instanceof SqlElement ? (SqlElement)object : null;
            }
            DasObject dasObject = DbSqlUtil.getSqlSourceElement(context.getDataSource(), obj2);
            return dasObject instanceof SqlElement ? (SqlElement)dasObject : null;
        }

        private final boolean newObjects(JBIterable<? extends DeObject> objects) {
            return objects.filter(arg_0 -> Companion.newObjects$lambda$6(newObjects.1.INSTANCE, arg_0)).isEmpty();
        }

        public final boolean isModified(@NotNull DeObject obj2) {
            Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
            DeObject de = obj2.getEditedDeObject();
            return de == null || obj2.isAltered(de);
        }

        @NotNull
        public final DdlPreview.ObjectAction assignAction(@NotNull DeObject obj2) {
            Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
            return new DdlPreview.ObjectAction(obj2.hasEdited() ? DdlPreview.ObjectAction.Action.ALTER : DdlPreview.ObjectAction.Action.CREATE, obj2);
        }

        private static final boolean fillContext$lambda$0(DeModel $model, DeObject obj2) {
            boolean isUpdateRoot = false;
            for (DeObject child : obj2.getDasChildren(null)) {
                if (child.hasEdited()) continue;
                isUpdateRoot = true;
                break;
            }
            if (!isUpdateRoot) {
                DeObject edited = obj2.lightExported ? null : obj2.getEditedDeObject();
                isUpdateRoot = edited != null && obj2.isAltered(edited);
            }
            DatabaseEditorContext databaseEditorContext = $model.getExportHelper().getContext();
            Intrinsics.checkNotNullExpressionValue((Object)databaseEditorContext, (String)"getContext(...)");
            SqlElement element = Companion.getSqlElement(obj2, databaseEditorContext);
            return !isUpdateRoot || element != null;
        }

        private static final boolean fillContext$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean scheduleIntrospectionScopeUpdate$lambda$2(DeObject it) {
            return it.getKind() == ObjectKind.DATABASE;
        }

        private static final boolean scheduleIntrospectionScopeUpdate$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean scheduleIntrospectionScopeUpdate$lambda$4(DeNamespace it) {
            return !it.hasEdited();
        }

        private static final boolean scheduleIntrospectionScopeUpdate$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean newObjects$lambda$6(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

