/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNavigationUtils {
    private static final RecursionGuard<SqlDefinition> ourGuard = RecursionManager.createGuard((String)"findRelatedDbElements");

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement o, boolean strict) {
        if (o == null || !o.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }
        if (o instanceof DbElement) {
            JBIterable jBIterable = JBIterable.of((Object)((DbElement)o));
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable parents = strict ? JBIterable.of((Object)o) : SyntaxTraverser.psiApi().parents((Object)o);
        SqlReferenceExpression ref2 = (SqlReferenceExpression)parents.filter(SqlReferenceExpression.class).first();
        DbDataSource dataSource = null;
        DbElement element = null;
        if (!strict) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)o);
            dataSource = DbImplUtilCore.findDataSource(o.getProject(), file);
            element = DbImplUtilCore.findElement(o.getProject(), file);
        }
        JBIterable<DbElement> result1 = ref2 != null ? SqlNavigationUtils.findRelatedDbElements((PsiReference)ref2.getReference(), null) : JBIterable.empty();
        JBIterable result2 = parents.filter(SqlDefinition.class).filter(SqlDefinition.class).flatMap(parentDef -> SqlNavigationUtils.findRelatedDbElements(null, parentDef));
        JBIterable jBIterable = result1.append((Iterable)result2).append((Object)element).append((Object)dataSource).unique();
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition) {
        if (!(refAt instanceof PsiPolyVariantReference) && definition == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable result2 = (JBIterable)RecursionManager.doPreventingRecursion((Object)ObjectUtils.coalesce((Object)refAt, (Object)definition), (boolean)false, () -> {
            if (refAt instanceof PsiPolyVariantReference) {
                return SqlNavigationUtils.findRelatedDbElementsImpl((PsiPolyVariantReference)refAt);
            }
            return SqlNavigationUtils.findRelatedDbElementsImpl(definition);
        });
        JBIterable jBIterable = result2 != null ? result2 : JBIterable.empty();
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull PsiPolyVariantReference refAt) {
        if (refAt == null) {
            SqlNavigationUtils.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])refAt.multiResolve(false)).flatMap(rr -> {
            PsiElement element = rr.getElement();
            if (element instanceof DbElement) {
                return JBIterable.of((Object)element);
            }
            if (!(element instanceof SqlDefinition)) {
                return JBIterable.empty();
            }
            return SqlNavigationUtils.findRelatedDbElementsImpl((SqlDefinition)element);
        }).filter(DbElement.class);
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull SqlDefinition definition) {
        JBIterable res2;
        if (definition == null) {
            SqlNavigationUtils.$$$reportNull$$$0(7);
        }
        JBIterable jBIterable = (res2 = (JBIterable)ourGuard.doPreventingRecursion((Object)definition, false, () -> SqlNavigationUtils.findRelatedDbElementsUnsafe(definition))) == null ? JBIterable.empty() : res2;
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsUnsafe(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlNavigationUtils.$$$reportNull$$$0(9);
        }
        ObjectKind kind = definition.getKind();
        SqlNameElement element = definition.getNameElement();
        if (element == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        SqlReferenceElementType refType = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getReferenceElementType() : (kind == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        String refText = InjectedLanguageManager.getInstance((Project)definition.getProject()).getUnescapedText((PsiElement)element);
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)element);
        if (newRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        for (PsiElement e : SyntaxTraverser.psiTraverser((PsiElement)newRef)) {
            SqlReferenceImpl.USE_SQL_DATA_SOURCE_MODEL.set((UserDataHolder)e, (Object)true);
        }
        JBIterable result2 = JBIterable.of((Object[])newRef.multiResolve(false)).transform(rr -> rr.getElement()).filter(DbElement.class);
        if (result2.isNotEmpty()) {
            JBIterable jBIterable = result2;
            if (jBIterable == null) {
                SqlNavigationUtils.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        DasObject parent = definition.getDasParent();
        JBIterable parentDefinitions = parent instanceof SqlFileImpl.GroupImpl ? ((SqlFileImpl.GroupImpl)parent).delegates() : JBIterable.of((Object)((SqlDefinition)ObjectUtils.tryCast((Object)parent, SqlDefinition.class)));
        JBIterable jBIterable = parentDefinitions.flatten(parentDef -> SqlNavigationUtils.findRelatedDbElementsImpl(parentDef).flatMap(db -> {
            SqlReferenceExpression ref2 = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, db);
            return SqlNavigationUtils.findRelatedDbElementsImpl((PsiPolyVariantReference)Objects.requireNonNull(ref2).getReference());
        }));
        if (jBIterable == null) {
            SqlNavigationUtils.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlNavigationUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refAt";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlNavigationUtils";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsUnsafe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsUnsafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

