/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.annotators;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.util.DbImplUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseLargeFilesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            DatabaseLargeFilesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            DatabaseLargeFilesAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiFile) {
            RunConfigurationActionFix fix;
            ConfigurationContext context;
            Project project = element.getProject();
            VirtualFile file = ((PsiFile)element).getViewProvider().getVirtualFile();
            if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file) && DbImplUtil.isSqlScriptFile(project, file) && (context = new ConfigurationContext(element)).findExisting() == null && (fix = RunConfigurationActionFix.createFromContext(context)) != null) {
                holder.newAnnotation(HighlightSeverity.INFORMATION, DatabaseBundle.message("sql.run.configuration.you.can.execute.large.script", new Object[0])).withFix((IntentionAction)fix).fileLevel().create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/annotators/DatabaseLargeFilesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RunConfigurationActionFix
    implements IntentionAction {
        private final ConfigurationContext myContext;
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Executor myExecutor;

        private RunConfigurationActionFix(@NotNull ConfigurationContext context, @NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
            if (context == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(2);
            }
            this.myContext = context;
            this.myConfiguration = configuration;
            this.myExecutor = executor;
        }

        @NotNull
        public String getText() {
            @NlsSafe String text = this.myExecutor.getStartActionText(ProgramRunnerUtil.shortenName((String)this.myConfiguration.getName(), (int)0));
            String string = UIUtil.removeMnemonic((String)text);
            if (string == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
            if (project == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(5);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(6);
            }
            new RunContextAction(this.myExecutor){
                {
                    super(arg0);
                    this.perform(myConfiguration, myContext);
                }
            };
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nullable
        static RunConfigurationActionFix createFromContext(@NotNull ConfigurationContext context) {
            if (context == null) {
                RunConfigurationActionFix.$$$reportNull$$$0(7);
            }
            RunnerAndConfigurationSettings configuration = context.getConfiguration();
            Executor executor = DefaultRunExecutor.getRunExecutorInstance();
            if (configuration == null || executor == null) {
                return null;
            }
            return new RunConfigurationActionFix(context, configuration, executor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/annotators/DatabaseLargeFilesAnnotator$RunConfigurationActionFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/annotators/DatabaseLargeFilesAnnotator$RunConfigurationActionFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createFromContext";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

