/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.Dbms;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.common.StringFun;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.SqlFormatterHelper;
import com.intellij.sql.formatter.model.ASTNodeFun;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlFile;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010Z\u001a\u00020&2\u0006\u0010[\u001a\u00020H2\u0006\u0010\\\u001a\u00020HJ\u0016\u0010Z\u001a\u00020&2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^J\u001e\u0010`\u001a\u00020&2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^2\u0006\u0010a\u001a\u00020bJ\u0016\u0010c\u001a\u00020&2\u0006\u0010d\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020bJ\u001e\u0010c\u001a\u00020&2\u0006\u0010e\u001a\u00020;2\u0006\u0010f\u001a\u00020;2\u0006\u0010a\u001a\u00020bJ\u0016\u0010g\u001a\u00020&2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^J\u0016\u0010h\u001a\u00020&2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^J\u0010\u0010i\u001a\u00020j2\b\b\u0002\u0010k\u001a\u00020&J\u0006\u0010l\u001a\u00020jJ\u0006\u0010m\u001a\u00020jJ\u0010\u0010n\u001a\u00020j2\b\b\u0002\u0010o\u001a\u00020&J\u0010\u0010p\u001a\u00020j2\b\b\u0002\u0010o\u001a\u00020&J\u0010\u0010q\u001a\u00020j2\b\b\u0002\u0010k\u001a\u00020&J\u0018\u0010q\u001a\u00020j2\b\b\u0002\u0010k\u001a\u00020&2\u0006\u0010o\u001a\u00020&J\u0010\u0010r\u001a\u00020j2\b\b\u0002\u0010o\u001a\u00020&J*\u0010s\u001a\u00020j2\u0006\u0010t\u001a\u00020u2\u0006\u0010d\u001a\u00020\u000e2\b\b\u0002\u0010k\u001a\u00020&2\b\b\u0002\u0010o\u001a\u00020&J \u0010v\u001a\u00020L2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020&2\u0006\u0010z\u001a\u00020;J,\u0010v\u001a\u00020L2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020&2\b\b\u0002\u0010{\u001a\u00020&2\b\b\u0002\u0010|\u001a\u00020&J,\u0010v\u001a\u00020L2\u0006\u0010}\u001a\u00020;2\b\b\u0002\u0010y\u001a\u00020&2\b\b\u0002\u0010{\u001a\u00020&2\b\b\u0002\u0010|\u001a\u00020&J\u0018\u0010~\u001a\u00020L2\u0006\u0010\u007f\u001a\u00020L2\u0006\u0010|\u001a\u00020&H\u0002J\u000f\u0010\u0080\u0001\u001a\u00020&2\u0006\u0010w\u001a\u00020xJ\u0011\u0010\u0080\u0001\u001a\u00020&2\u0006\u0010}\u001a\u00020;H\u0002J\u0014\u0010\u0081\u0001\u001a\u00020&2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0086\u0004J\t\u0010\u0084\u0001\u001a\u00020;H\u0002J\u0007\u0010\u0085\u0001\u001a\u00020;J\u001b\u0010\u0086\u0001\u001a\u00020L2\u0007\u0010\u0087\u0001\u001a\u00020;2\u0007\u0010\u0088\u0001\u001a\u00020;H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010(R\u0011\u00106\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010(R\u0011\u00108\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010(R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010(R\u0011\u0010@\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010=R\u0011\u0010B\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010=R'\u0010D\u001a\u0018\u0012\u0006\b\u0001\u0012\u00020F\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020H0G0E\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001b\u0010K\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bM\u0010NR\u001b\u0010Q\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u0010P\u001a\u0004\bR\u0010NR\u001b\u0010T\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010P\u001a\u0004\bU\u0010NR\u001b\u0010W\u001a\u00020L8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u0010P\u001a\u0004\bX\u0010N\u00a8\u0006\u0089\u0001"}, d2={"Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "", "text", "", "file", "Lcom/intellij/psi/PsiFile;", "settingsContainer", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settingsClass", "Ljava/lang/Class;", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "mode", "Lcom/intellij/formatting/FormattingMode;", "interestingRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Ljava/lang/Class;Lcom/intellij/formatting/FormattingMode;Lcom/intellij/openapi/util/TextRange;)V", "getText", "()Ljava/lang/CharSequence;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getSettingsContainer", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getSettingsClass", "()Ljava/lang/Class;", "getMode", "()Lcom/intellij/formatting/FormattingMode;", "getInterestingRange", "()Lcom/intellij/openapi/util/TextRange;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "dialectHelper", "Lcom/intellij/sql/formatter/SqlFormatterHelper;", "getDialectHelper", "()Lcom/intellij/sql/formatter/SqlFormatterHelper;", "knownDialect", "", "getKnownDialect", "()Z", "sql", "getSql", "()Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "com", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getCom", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "ind", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "getInd", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "disabled", "getDisabled", "reformatting", "getReformatting", "justAdjust", "getJustAdjust", "margin", "", "getMargin", "()I", "klb", "getKlb", "lengthThresholdMin", "getLengthThresholdMin", "lengthThresholdMax", "getLengthThresholdMax", "dialectSpecificBlocks", "", "Lcom/intellij/psi/tree/IElementType;", "Lkotlin/reflect/KClass;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getDialectSpecificBlocks", "()Ljava/util/Map;", "singleIndentUsingSpaces", "", "getSingleIndentUsingSpaces", "()Ljava/lang/String;", "singleIndentUsingSpaces$delegate", "Lkotlin/Lazy;", "singleIndent", "getSingleIndent", "singleIndent$delegate", "continuationIndentUsingSpaces", "getContinuationIndentUsingSpaces", "continuationIndentUsingSpaces$delegate", "continuationIndent", "getContinuationIndent", "continuationIndent$delegate", "textContainsBreaksBetween", "block1", "block2", "node1", "Lcom/intellij/lang/ASTNode;", "node2", "textContainsBetween", "char", "", "textContains", "range", "from", "till", "textContainsLinesBetween", "onSameLine", "makeBreak", "Lcom/intellij/formatting/Spacing;", "space", "makeSafeSpaceOrBreak", "makeBreakSafeSpace", "makeAutoSpacing", "keepLB", "makeSafeSpacing", "makeSpace", "makeNoSpace", "makeSmartSpacing", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "currIndentOf", "block", "Lcom/intellij/formatting/Block;", "absolute", "plusSpaces", "plus", "continuation", "offset", "appendIndent", "originalIndent", "isInPosition1", "isDialect", "dbms", "Lcom/intellij/database/Dbms;", "getRightMargin", "getIndentSize", "prepareIndentStringUsingTab", "tabSize", "indentSize", "intellij.database.sql.core.impl"})
public final class SqlFormattingContext {
    @NotNull
    private final CharSequence text;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final CodeStyleSettings settingsContainer;
    @NotNull
    private final Class<? extends SqlCodeStyleSettings> settingsClass;
    @NotNull
    private final FormattingMode mode;
    @NotNull
    private final TextRange interestingRange;
    @NotNull
    private final SqlLanguageDialect dialect;
    @Nullable
    private final SqlFormatterHelper dialectHelper;
    private final boolean knownDialect;
    @NotNull
    private final SqlCodeStyleSettings sql;
    @NotNull
    private final CommonCodeStyleSettings com;
    @NotNull
    private final CommonCodeStyleSettings.IndentOptions ind;
    private final boolean disabled;
    private final boolean reformatting;
    private final boolean justAdjust;
    private final int margin;
    private final boolean klb;
    private final int lengthThresholdMin;
    private final int lengthThresholdMax;
    @NotNull
    private final Map<? extends IElementType, KClass<? extends SqlBlock>> dialectSpecificBlocks;
    @NotNull
    private final Lazy singleIndentUsingSpaces$delegate;
    @NotNull
    private final Lazy singleIndent$delegate;
    @NotNull
    private final Lazy continuationIndentUsingSpaces$delegate;
    @NotNull
    private final Lazy continuationIndent$delegate;

    public SqlFormattingContext(@NotNull CharSequence text, @NotNull PsiFile file, @NotNull CodeStyleSettings settingsContainer, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass, @NotNull FormattingMode mode, @NotNull TextRange interestingRange) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)settingsContainer, (String)"settingsContainer");
        Intrinsics.checkNotNullParameter(settingsClass, (String)"settingsClass");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)interestingRange, (String)"interestingRange");
        this.text = text;
        this.file = file;
        this.settingsContainer = settingsContainer;
        this.settingsClass = settingsClass;
        this.mode = mode;
        this.interestingRange = interestingRange;
        PsiFile psiFile = this.file;
        SqlFile sqlFile = psiFile instanceof SqlFile ? (SqlFile)psiFile : null;
        if (sqlFile == null || (sqlFile = sqlFile.getSqlLanguage()) == null) {
            SqlLanguageDialect sqlLanguageDialect = SqlDialects.getGenericDialect();
            sqlFile = sqlLanguageDialect;
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getGenericDialect(...)");
        }
        this.dialect = sqlFile;
        this.dialectHelper = (SqlFormatterHelper)SqlFormatterHelper.EP.forLanguage((Language)this.dialect);
        this.knownDialect = !Intrinsics.areEqual((Object)this.dialect, (Object)SqlDialects.getGenericDialect());
        CustomCodeStyleSettings customCodeStyleSettings = this.settingsContainer.getCustomSettings(this.settingsClass);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        this.sql = (SqlCodeStyleSettings)customCodeStyleSettings;
        CommonCodeStyleSettings commonCodeStyleSettings = this.sql.getCorrespondedCommonSettings();
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCorrespondedCommonSettings(...)");
        this.com = commonCodeStyleSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.sql.getCorrespondedIndentOptions();
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getCorrespondedIndentOptions(...)");
        this.ind = indentOptions;
        this.disabled = this.sql.DISABLE_FORMATTING;
        this.reformatting = this.mode == FormattingMode.REFORMAT && !this.disabled;
        this.justAdjust = !this.reformatting && !this.disabled;
        this.margin = this.getRightMargin();
        this.klb = this.com.KEEP_LINE_BREAKS || this.justAdjust;
        this.lengthThresholdMin = this.margin * 3 / 5;
        this.lengthThresholdMax = this.margin;
        Map map2 = SqlFormattingModelFun.getDIALECT_SPECIFIC_BLOCKS().get(this.dialect.getDbms());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        this.dialectSpecificBlocks = map2;
        this.singleIndentUsingSpaces$delegate = LazyKt.lazy(() -> SqlFormattingContext.singleIndentUsingSpaces_delegate$lambda$0(this));
        this.singleIndent$delegate = LazyKt.lazy(() -> SqlFormattingContext.singleIndent_delegate$lambda$1(this));
        this.continuationIndentUsingSpaces$delegate = LazyKt.lazy(() -> SqlFormattingContext.continuationIndentUsingSpaces_delegate$lambda$2(this));
        this.continuationIndent$delegate = LazyKt.lazy(() -> SqlFormattingContext.continuationIndent_delegate$lambda$3(this));
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final CodeStyleSettings getSettingsContainer() {
        return this.settingsContainer;
    }

    @NotNull
    public final Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        return this.settingsClass;
    }

    @NotNull
    public final FormattingMode getMode() {
        return this.mode;
    }

    @NotNull
    public final TextRange getInterestingRange() {
        return this.interestingRange;
    }

    @NotNull
    public final SqlLanguageDialect getDialect() {
        return this.dialect;
    }

    @Nullable
    public final SqlFormatterHelper getDialectHelper() {
        return this.dialectHelper;
    }

    public final boolean getKnownDialect() {
        return this.knownDialect;
    }

    @NotNull
    public final SqlCodeStyleSettings getSql() {
        return this.sql;
    }

    @NotNull
    public final CommonCodeStyleSettings getCom() {
        return this.com;
    }

    @NotNull
    public final CommonCodeStyleSettings.IndentOptions getInd() {
        return this.ind;
    }

    public final boolean getDisabled() {
        return this.disabled;
    }

    public final boolean getReformatting() {
        return this.reformatting;
    }

    public final boolean getJustAdjust() {
        return this.justAdjust;
    }

    public final int getMargin() {
        return this.margin;
    }

    public final boolean getKlb() {
        return this.klb;
    }

    public final int getLengthThresholdMin() {
        return this.lengthThresholdMin;
    }

    public final int getLengthThresholdMax() {
        return this.lengthThresholdMax;
    }

    @NotNull
    public final Map<? extends IElementType, KClass<? extends SqlBlock>> getDialectSpecificBlocks() {
        return this.dialectSpecificBlocks;
    }

    private final String getSingleIndentUsingSpaces() {
        Lazy lazy = this.singleIndentUsingSpaces$delegate;
        return (String)lazy.getValue();
    }

    private final String getSingleIndent() {
        Lazy lazy = this.singleIndent$delegate;
        return (String)lazy.getValue();
    }

    private final String getContinuationIndentUsingSpaces() {
        Lazy lazy = this.continuationIndentUsingSpaces$delegate;
        return (String)lazy.getValue();
    }

    private final String getContinuationIndent() {
        Lazy lazy = this.continuationIndent$delegate;
        return (String)lazy.getValue();
    }

    public final boolean textContainsBreaksBetween(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        int p1 = block1.getTextRange().getEndOffset();
        int p2 = block2.getTextRange().getStartOffset();
        return this.textContains(p1, p2, '\n');
    }

    public final boolean textContainsBreaksBetween(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        return this.textContainsBetween(node1, node2, '\n');
    }

    public final boolean textContainsBetween(@NotNull ASTNode node1, @NotNull ASTNode node2, char c2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        int end = node2.getStartOffset();
        ASTNode leaf = ASTNodeFun.getNextLeaf(node1);
        while (leaf != null && leaf.getStartOffset() <= end) {
            if (leaf.textContains(c2)) {
                return true;
            }
            leaf = ASTNodeFun.getNextLeaf(leaf);
        }
        return false;
    }

    public final boolean textContains(@NotNull TextRange range, char c2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.textContains(range.getStartOffset(), range.getEndOffset(), c2);
    }

    public final boolean textContains(int from, int till, char c2) {
        if (from >= till) {
            return false;
        }
        return StringUtil.contains((CharSequence)this.text, (int)from, (int)till, (char)c2);
    }

    public final boolean textContainsLinesBetween(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        int p1 = node1.getTextRange().getEndOffset();
        int p2 = node2.getStartOffset();
        int cnt = 0;
        for (int i2 = p1; i2 < p2; ++i2) {
            if (this.text.charAt(i2) != '\n' || ++cnt < 2) continue;
            return true;
        }
        return false;
    }

    public final boolean onSameLine(@NotNull ASTNode node1, @NotNull ASTNode node2) {
        Intrinsics.checkNotNullParameter((Object)node1, (String)"node1");
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node2");
        if (node1 == node2) {
            return true;
        }
        ASTNode a = null;
        ASTNode b = null;
        if (node1.getStartOffset() < node2.getStartOffset()) {
            a = node1;
            b = node2;
        } else {
            a = node2;
            b = node1;
        }
        boolean broke = this.textContainsBreaksBetween(a, b);
        return !broke;
    }

    @NotNull
    public final Spacing makeBreak(boolean space) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)1, (int)1, (boolean)true, (int)this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeBreak$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeBreak(bl);
    }

    @NotNull
    public final Spacing makeSafeSpaceOrBreak() {
        Spacing spacing = Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    @NotNull
    public final Spacing makeBreakSafeSpace() {
        Spacing spacing = Spacing.createSpacing((int)0, (int)1, (int)1, (boolean)true, (int)this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    @NotNull
    public final Spacing makeAutoSpacing(boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)keepLB, (int)(keepLB ? this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE : 0));
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeAutoSpacing$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeAutoSpacing(bl);
    }

    @NotNull
    public final Spacing makeSafeSpacing(boolean keepLB) {
        Spacing spacing = Spacing.createSafeSpacing((boolean)keepLB, (int)(keepLB ? this.sql.IMP_COMMON_KEEP_BLANK_LINES_IN_CODE : 0));
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSafeSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSafeSpacing$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeSafeSpacing(bl);
    }

    @NotNull
    public final Spacing makeSpace(boolean space) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (int)0, (boolean)this.klb, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeSpace(bl);
    }

    @NotNull
    public final Spacing makeSpace(boolean space, boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (int)0, (boolean)keepLB, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return sqlFormattingContext.makeSpace(bl, bl2);
    }

    @NotNull
    public final Spacing makeNoSpace(boolean keepLB) {
        Spacing spacing = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLB, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spacing, (String)"createSpacing(...)");
        return spacing;
    }

    public static /* synthetic */ Spacing makeNoSpace$default(SqlFormattingContext sqlFormattingContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeNoSpace(bl);
    }

    @NotNull
    public final Spacing makeSmartSpacing(@NotNull BlockShape shape, @NotNull TextRange range, boolean space, boolean keepLB) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        switch (WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1: {
                spacing = this.makeSpace(space);
                break;
            }
            case 2: {
                Spacing spacing2 = Spacing.createDependentLFSpacing((int)SqlUtilFun.toInt(space), (int)SqlUtilFun.toInt(space), (TextRange)range, (boolean)keepLB, (int)0);
                spacing = spacing2;
                Intrinsics.checkNotNullExpressionValue((Object)spacing2, (String)"createDependentLFSpacing(...)");
                break;
            }
            case 3: {
                spacing = SqlFormattingContext.makeBreak$default(this, false, 1, null);
                break;
            }
            default: {
                spacing = this.makeAutoSpacing(true);
            }
        }
        return spacing;
    }

    public static /* synthetic */ Spacing makeSmartSpacing$default(SqlFormattingContext sqlFormattingContext, BlockShape blockShape, TextRange textRange, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = sqlFormattingContext.klb;
        }
        return sqlFormattingContext.makeSmartSpacing(blockShape, textRange, bl, bl2);
    }

    @NotNull
    public final String currIndentOf(@NotNull Block block, boolean absolute, int plusSpaces) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingContext.currIndentOf$default(this, block.getTextRange().getStartOffset(), absolute, false, false, 8, null) + StringFun.replicate$default(" ", plusSpaces, null, null, 6, null);
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, Block block, boolean bl, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return sqlFormattingContext.currIndentOf(block, bl, n);
    }

    @NotNull
    public final String currIndentOf(@NotNull Block block, boolean absolute, boolean plus, boolean continuation) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.currIndentOf(block.getTextRange().getStartOffset(), absolute, plus, continuation);
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, Block block, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return sqlFormattingContext.currIndentOf(block, bl, bl2, bl3);
    }

    @NotNull
    public final String currIndentOf(int offset, boolean absolute, boolean plus, boolean continuation) {
        int p1 = offset;
        int p2 = offset;
        while (p1 > 0 && this.text.charAt(p1 - 1) != '\n') {
            if (CharsKt.isWhitespace((char)this.text.charAt(--p1))) continue;
            p2 = p1;
        }
        Object theIndent = ((Object)this.text.subSequence(p1, p2)).toString();
        if (absolute && p2 < offset) {
            theIndent = (String)theIndent + StringFun.replicate$default(" ", offset - p2, null, null, 6, null);
        }
        if (plus) {
            theIndent = this.appendIndent((String)theIndent, continuation);
        }
        return theIndent;
    }

    public static /* synthetic */ String currIndentOf$default(SqlFormattingContext sqlFormattingContext, int n, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            bl3 = false;
        }
        return sqlFormattingContext.currIndentOf(n, bl, bl2, bl3);
    }

    private final String appendIndent(String originalIndent, boolean continuation) {
        if (((CharSequence)originalIndent).length() == 0) {
            return continuation ? this.getContinuationIndent() : this.getSingleIndent();
        }
        if (this.ind.USE_TAB_CHARACTER && StringsKt.contains$default((CharSequence)originalIndent, (char)'\t', (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)originalIndent, (char)' ', (boolean)false, (int)2, null)) {
            return originalIndent + (continuation ? this.getContinuationIndent() : this.getSingleIndent());
        }
        return originalIndent + (continuation ? this.getContinuationIndentUsingSpaces() : this.getSingleIndentUsingSpaces());
    }

    public final boolean isInPosition1(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.isInPosition1(block.getTextRange().getStartOffset());
    }

    private final boolean isInPosition1(int offset) {
        if (offset == 0) {
            return true;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset " + offset);
        }
        if (offset > this.text.length()) {
            return false;
        }
        char c2 = this.text.charAt(offset - 1);
        return c2 == '\n' || c2 == '\r';
    }

    public final boolean isDialect(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return this.dialect.getDbms() == dbms;
    }

    private final int getRightMargin() {
        return this.settingsContainer.getDefaultRightMargin();
    }

    public final int getIndentSize() {
        return this.ind.INDENT_SIZE;
    }

    private final String prepareIndentStringUsingTab(int tabSize, int indentSize) {
        if (tabSize <= indentSize && indentSize % tabSize == 0) {
            int n = indentSize / tabSize;
            return StringFun.replicate('\t', n);
        }
        return StringFun.replicate(' ', indentSize);
    }

    private static final String singleIndentUsingSpaces_delegate$lambda$0(SqlFormattingContext this$0) {
        return StringFun.replicate(' ', this$0.ind.INDENT_SIZE);
    }

    private static final String singleIndent_delegate$lambda$1(SqlFormattingContext this$0) {
        return this$0.ind.USE_TAB_CHARACTER ? this$0.prepareIndentStringUsingTab(this$0.ind.TAB_SIZE, this$0.ind.INDENT_SIZE) : this$0.getSingleIndentUsingSpaces();
    }

    private static final String continuationIndentUsingSpaces_delegate$lambda$2(SqlFormattingContext this$0) {
        return StringFun.replicate(' ', this$0.ind.CONTINUATION_INDENT_SIZE);
    }

    private static final String continuationIndent_delegate$lambda$3(SqlFormattingContext this$0) {
        return this$0.ind.USE_TAB_CHARACTER ? this$0.prepareIndentStringUsingTab(this$0.ind.TAB_SIZE, this$0.ind.CONTINUATION_INDENT_SIZE) : this$0.getContinuationIndentUsingSpaces();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockShape.values().length];
            try {
                nArray[BlockShape.DECIDED_TO_ONE_ROW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDE_LATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockShape.DECIDED_TO_MULTI_ROWS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

