/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlExpandColumnListIntention
extends SqlBaseElementAtCaretIntentionAction
implements PriorityAction {
    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(0);
        }
        return priority;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.expand.column.list", (Object[])new Object[0]);
        if (string == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        DasTableType tableType2;
        SqlReferenceExpression referenceExpression;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(4);
        }
        if ((referenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceExpression.class)) == null) {
            return false;
        }
        SqlReference referenceAt = referenceExpression.getReference();
        String text = referenceAt.getCanonicalText();
        if (!"*".equals(text) && !text.endsWith(".*")) {
            return false;
        }
        SqlElement parent = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, (Class[])new Class[]{SqlClause.class, SqlExpression.class, SqlStatement.class});
        if (!(parent instanceof SqlSelectClause)) {
            return false;
        }
        DasType dasType = referenceExpression.getDasType();
        return dasType instanceof DasTableType && (tableType2 = (DasTableType)dasType).getColumnCount() > 0;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlTableType tableType2;
        SqlReferenceExpression referenceExpression;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(7);
        }
        if ((referenceExpression = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceExpression.class)) == null) {
            return;
        }
        DasType type = referenceExpression.getDasType();
        if (!(type instanceof SqlTableType) || (tableType2 = (SqlTableType)type).getColumnCount() == 0) {
            return;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)referenceExpression);
        String columnListText = SqlExpandColumnListIntention.getAllColumnsList(project, (PsiElement)referenceExpression, tableType2, dialect, referenceExpression.getQualifierExpression() != null);
        if (StringUtil.isEmptyOrSpaces((String)columnListText)) {
            return;
        }
        String templateText = "select " + columnListText + " from t";
        SqlQueryExpression expr = SqlPsiElementFactory.createQueryExpressionFromText(templateText, (SqlLanguageDialect)dialect, project);
        if (expr == null) {
            throw new IncorrectOperationException("Not a query expression " + dialect.getDisplayName() + ": " + templateText);
        }
        List expressions = expr.getSelectClause().getExpressions();
        referenceExpression.getParent().addRangeBefore((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1), (PsiElement)referenceExpression);
        referenceExpression.delete();
    }

    @NotNull
    public static String getAllColumnsList(@NotNull Project project, @Nullable PsiElement element, @NotNull SqlTableType tableType2, @NotNull SqlLanguageDialectEx dialect) {
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(8);
        }
        if (tableType2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(9);
        }
        if (dialect == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(10);
        }
        return SqlExpandColumnListIntention.getAllColumnsList(project, element, tableType2, dialect, false);
    }

    @NotNull
    public static String getAllColumnsList(@NotNull Project project, @Nullable PsiElement element, @NotNull SqlTableType tableType2, @NotNull SqlLanguageDialectEx dialect, boolean forceQualification) {
        SqlQueryExpression queryExpression;
        if (project == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(11);
        }
        if (tableType2 == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(12);
        }
        if (dialect == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(13);
        }
        SqlTableExpression tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression();
        SqlTableType asteriskType = tableExpression == null ? null : tableExpression.getDasType();
        SqlEditorOptions options = SqlEditorOptions.getInstance();
        PairFunction forceQualify = (t, i2) -> {
            if (forceQualification) {
                return true;
            }
            ObjectKind qualifierKind = DasUtil.getKind((DasObject)ObjectUtils.tryCast((Object)t.getColumnQualifier(i2.intValue()), DasObject.class));
            SqlEditorOptions.QualificationType qualification = DbSqlUtilCore.getQualificationByParentKind(qualifierKind).and(options.getRefactoringQualification());
            return qualification.shouldQualify(1);
        };
        List<String> columnNames = asteriskType == null ? DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType2, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)forceQualify) : DbSqlUtil.getUnambiguousColumnNames(project, dialect.getDatabaseDialect(), tableType2, asteriskType, (PairFunction<? super SqlTableType, ? super Integer, Boolean>)forceQualify);
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, dialect).withDialect(dialect.getDatabaseDialect());
        int len = tableType2.getColumnCount();
        for (int i3 = 0; i3 < len; ++i3) {
            if (i3 > 0) {
                builder.symbol(",").space();
            }
            builder.plain(columnNames.get(i3));
        }
        String string = builder.getStatement();
        if (string == null) {
            SqlExpandColumnListIntention.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlExpandColumnListIntention";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllColumnsList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAllColumnsList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

