/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.slicer;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/slicer/SqlSliceUsageCellRenderer;", "Lcom/intellij/slicer/SliceUsageCellRendererBase;", "<init>", "()V", "customizeCellRendererFor", "", "sliceUsage", "Lcom/intellij/slicer/SliceUsage;", "intellij.database.sql.impl"})
public final class SqlSliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        Intrinsics.checkNotNullParameter((Object)sliceUsage, (String)"sliceUsage");
        PsiElement element = sliceUsage.getElement();
        if (element instanceof DbElement) {
            ObjectKind objectKind = ((DbElement)element).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            ObjectKind kind = objectKind;
            String text = element instanceof DbTableChild ? ((DbTableChild)element).getText() : ((DbElement)element).getName();
            this.append(StringUtil.capitalize((String)DbPresentation.getPresentableName(kind, DbImplUtil.getDbms((DbElement)element))) + " " + text, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return;
        }
        TextChunk[] textChunkArray = sliceUsage.getPresentation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)textChunkArray, (String)"getText(...)");
        TextChunk[] text = textChunkArray;
        int n = text.length;
        for (int i2 = 0; i2 < n; ++i2) {
            TextChunk textChunk;
            Intrinsics.checkNotNullExpressionValue((Object)text[i2], (String)"get(...)");
            this.append(textChunk.getText(), textChunk.getSimpleAttributesIgnoreBackground());
            if (i2 != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
    }
}

