/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.persistence.AbstractFilePersistenceStrategy;
import java.io.File;

public class FilePersistenceStrategy
extends AbstractFilePersistenceStrategy {
    private final String illegalChars;

    public FilePersistenceStrategy(File baseDirectory) {
        this(baseDirectory, new XStream(new DomDriver()));
    }

    public FilePersistenceStrategy(File baseDirectory, XStream xstream) {
        this(baseDirectory, xstream, "utf-8", "<>?:/\\\"|*%");
    }

    public FilePersistenceStrategy(File baseDirectory, XStream xstream, String encoding, String illegalChars) {
        super(baseDirectory, xstream, encoding);
        this.illegalChars = illegalChars;
    }

    protected boolean isValid(File dir, String name2) {
        return super.isValid(dir, name2) && name2.indexOf(64) > 0;
    }

    protected Object extractKey(String name2) {
        String key2 = this.unescape(name2.substring(0, name2.length() - 4));
        if ("null@null".equals(key2)) {
            return null;
        }
        int idx = key2.indexOf(64);
        if (idx < 0) {
            ConversionException exception = new ConversionException("No valid key");
            exception.add("key", key2);
            throw exception;
        }
        Class type = this.getMapper().realClass(key2.substring(0, idx));
        Converter converter = this.getConverterLookup().lookupConverterForType(type);
        if (converter instanceof SingleValueConverter) {
            SingleValueConverter svConverter = (SingleValueConverter)((Object)converter);
            return svConverter.fromString(key2.substring(idx + 1));
        }
        ConversionException exception = new ConversionException("No SingleValueConverter available for key type");
        exception.add("key-type", type.getName());
        throw exception;
    }

    protected String unescape(String name2) {
        StringBuffer buffer = new StringBuffer();
        int idx = name2.indexOf(37);
        while (idx >= 0) {
            buffer.append(name2.substring(0, idx));
            int c2 = Integer.parseInt(name2.substring(idx + 1, idx + 3), 16);
            buffer.append((char)c2);
            name2 = name2.substring(idx + 3);
            idx = name2.indexOf(37);
        }
        buffer.append(name2);
        return buffer.toString();
    }

    protected String getName(Object key2) {
        if (key2 == null) {
            return "null@null.xml";
        }
        Class<?> type = key2.getClass();
        Converter converter = this.getConverterLookup().lookupConverterForType(type);
        if (converter instanceof SingleValueConverter) {
            SingleValueConverter svConverter = (SingleValueConverter)((Object)converter);
            return this.getMapper().serializedClass(type) + '@' + this.escape(svConverter.toString(key2)) + ".xml";
        }
        ConversionException exception = new ConversionException("No SingleValueConverter available for key type");
        exception.add("key-type", type.getName());
        throw exception;
    }

    protected String escape(String key2) {
        StringBuffer buffer = new StringBuffer();
        char[] array = key2.toCharArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            char c2 = array[i2];
            if (c2 >= ' ' && this.illegalChars.indexOf(c2) < 0) {
                buffer.append(c2);
                continue;
            }
            buffer.append("%" + Integer.toHexString(c2).toUpperCase());
        }
        return buffer.toString();
    }
}

