/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.geojson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ParseException;

public class GeoJsonReader {
    private GeometryFactory gf;

    public GeoJsonReader() {
    }

    public GeoJsonReader(GeometryFactory geometryFactory) {
        this.gf = geometryFactory;
    }

    public Geometry read(String json) throws ParseException {
        Geometry result2 = this.read(new StringReader(json));
        return result2;
    }

    public Geometry read(Reader reader) throws ParseException {
        Map geometryMap = null;
        JSONParser parser2 = new JSONParser();
        try {
            Object obj2 = parser2.parse(reader);
            geometryMap = (Map)obj2;
        }
        catch (ClassCastException e) {
            throw new ParseException("Could not parse Geometry from Json string.");
        }
        catch (org.json.simple.parser.ParseException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        GeometryFactory geometryFactory = null;
        geometryFactory = this.gf == null ? this.getGeometryFactory(geometryMap) : this.gf;
        Geometry result2 = this.create(geometryMap, geometryFactory);
        return result2;
    }

    private Geometry create(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Geometry result2 = null;
        String type = (String)geometryMap.get("type");
        if (type == null) {
            throw new ParseException("Could not parse Geometry from Json string.  No 'type' property found.");
        }
        if ("Point".equals(type)) {
            result2 = this.createPoint(geometryMap, geometryFactory);
        } else if ("LineString".equals(type)) {
            result2 = this.createLineString(geometryMap, geometryFactory);
        } else if ("Polygon".equals(type)) {
            result2 = this.createPolygon(geometryMap, geometryFactory);
        } else if ("MultiPoint".equals(type)) {
            result2 = this.createMultiPoint(geometryMap, geometryFactory);
        } else if ("MultiLineString".equals(type)) {
            result2 = this.createMultiLineString(geometryMap, geometryFactory);
        } else if ("MultiPolygon".equals(type)) {
            result2 = this.createMultiPolygon(geometryMap, geometryFactory);
        } else if ("GeometryCollection".equals(type)) {
            result2 = this.createGeometryCollection(geometryMap, geometryFactory);
        } else if ("Feature".equals(type)) {
            result2 = this.createFeature(geometryMap, geometryFactory);
        } else if ("FeatureCollection".equals(type)) {
            result2 = this.createFeatureCollection(geometryMap, geometryFactory);
        } else {
            throw new ParseException("Could not parse Geometry from GeoJson string.  Unsupported 'type':" + type);
        }
        return result2;
    }

    private Geometry createFeatureCollection(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        try {
            List features = (List)geometryMap.get("features");
            Geometry[] geometries = new Geometry[features.size()];
            int i2 = 0;
            for (Map featureMap : features) {
                geometries[i2] = this.createFeature(featureMap, geometryFactory);
                ++i2;
            }
            return geometryFactory.createGeometryCollection(geometries);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse FeatureCollection from GeoJson string.", e);
        }
    }

    private Geometry createFeature(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        try {
            Map innerGeometryMap = (Map)geometryMap.get("geometry");
            return this.create(innerGeometryMap, geometryFactory);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse Feature from GeoJson string.", e);
        }
    }

    private Geometry createGeometryCollection(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        GeometryCollection result2 = null;
        try {
            List geometriesList = (List)geometryMap.get("geometries");
            Geometry[] geometries = new Geometry[geometriesList.size()];
            int i2 = 0;
            for (Map map2 : geometriesList) {
                geometries[i2] = this.create(map2, geometryFactory);
                ++i2;
            }
            result2 = geometryFactory.createGeometryCollection(geometries);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse GeometryCollection from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createMultiPolygon(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiPolygon result2 = null;
        try {
            List polygonsList = (List)geometryMap.get("coordinates");
            Polygon[] polygons = new Polygon[polygonsList.size()];
            int p2 = 0;
            for (List ringsList : polygonsList) {
                ArrayList<CoordinateSequence> rings = new ArrayList<CoordinateSequence>();
                for (List coordinates : ringsList) {
                    rings.add(this.createCoordinateSequence(coordinates));
                }
                if (rings.isEmpty()) continue;
                LinearRing outer = geometryFactory.createLinearRing((CoordinateSequence)rings.get(0));
                LinearRing[] inner = null;
                if (rings.size() > 1) {
                    inner = new LinearRing[rings.size() - 1];
                    for (int i2 = 1; i2 < rings.size(); ++i2) {
                        inner[i2 - 1] = geometryFactory.createLinearRing((CoordinateSequence)rings.get(i2));
                    }
                }
                polygons[p2] = geometryFactory.createPolygon(outer, inner);
                ++p2;
            }
            result2 = geometryFactory.createMultiPolygon(polygons);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiPolygon from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createMultiLineString(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiLineString result2 = null;
        try {
            List linesList = (List)geometryMap.get("coordinates");
            LineString[] lineStrings = new LineString[linesList.size()];
            int i2 = 0;
            for (List coordinates : linesList) {
                lineStrings[i2] = geometryFactory.createLineString(this.createCoordinateSequence(coordinates));
                ++i2;
            }
            result2 = geometryFactory.createMultiLineString(lineStrings);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiLineString from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createMultiPoint(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiPoint result2 = null;
        try {
            List coordinatesList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinates = this.createCoordinateSequence(coordinatesList);
            result2 = geometryFactory.createMultiPoint(coordinates);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiPoint from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createPolygon(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Polygon result2 = null;
        try {
            List ringsList = (List)geometryMap.get("coordinates");
            if (ringsList == null || ringsList.isEmpty()) {
                return geometryFactory.createPolygon();
            }
            ArrayList<CoordinateSequence> rings = new ArrayList<CoordinateSequence>();
            for (List coordinates : ringsList) {
                rings.add(this.createCoordinateSequence(coordinates));
            }
            LinearRing outer = geometryFactory.createLinearRing((CoordinateSequence)rings.get(0));
            LinearRing[] inner = null;
            if (rings.size() > 1) {
                inner = new LinearRing[rings.size() - 1];
                for (int i2 = 1; i2 < rings.size(); ++i2) {
                    inner[i2 - 1] = geometryFactory.createLinearRing((CoordinateSequence)rings.get(i2));
                }
            }
            result2 = geometryFactory.createPolygon(outer, inner);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse Polygon from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createLineString(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        LineString result2 = null;
        try {
            List coordinatesList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinates = this.createCoordinateSequence(coordinatesList);
            result2 = geometryFactory.createLineString(coordinates);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse LineString from GeoJson string.", e);
        }
        return result2;
    }

    private Geometry createPoint(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Point result2 = null;
        try {
            List coordinateList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinate = this.createCoordinate(coordinateList);
            result2 = geometryFactory.createPoint(coordinate);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse Point from GeoJson string.", e);
        }
        return result2;
    }

    private GeometryFactory getGeometryFactory(Map<String, Object> geometryMap) throws ParseException {
        GeometryFactory result2 = null;
        Map crsMap = (Map)geometryMap.get("crs");
        Integer srid = null;
        if (crsMap != null) {
            try {
                Map propertiesMap = (Map)crsMap.get("properties");
                String name2 = (String)propertiesMap.get("name");
                String[] split = name2.split(":");
                String epsg = split[1];
                srid = Integer.valueOf(epsg);
            }
            catch (RuntimeException e) {
                throw new ParseException("Could not parse SRID from Geojson 'crs' object.", e);
            }
        }
        if (srid == null) {
            srid = 4326;
        }
        result2 = new GeometryFactory(new PrecisionModel(), srid);
        return result2;
    }

    private CoordinateSequence createCoordinateSequence(List<List<Number>> coordinates) {
        CoordinateArraySequence result2 = null;
        if (coordinates == null) {
            coordinates = Collections.EMPTY_LIST;
        }
        result2 = new CoordinateArraySequence(coordinates.size());
        for (int i2 = 0; i2 < coordinates.size(); ++i2) {
            List ordinates = (List)coordinates.get(i2);
            if (ordinates.size() > 0) {
                result2.setOrdinate(i2, 0, ((Number)ordinates.get(0)).doubleValue());
            }
            if (ordinates.size() > 1) {
                result2.setOrdinate(i2, 1, ((Number)ordinates.get(1)).doubleValue());
            }
            if (ordinates.size() <= 2) continue;
            result2.setOrdinate(i2, 2, ((Number)ordinates.get(2)).doubleValue());
        }
        return result2;
    }

    private CoordinateSequence createCoordinate(List<Number> ordinates) {
        if (ordinates == null || ordinates.size() == 0) {
            return new CoordinateArraySequence(0);
        }
        CoordinateArraySequence result2 = new CoordinateArraySequence(1);
        if (ordinates.size() > 0) {
            result2.setOrdinate(0, 0, ordinates.get(0).doubleValue());
        }
        if (ordinates.size() > 1) {
            result2.setOrdinate(0, 1, ordinates.get(1).doubleValue());
        }
        if (ordinates.size() > 2) {
            result2.setOrdinate(0, 2, ordinates.get(2).doubleValue());
        }
        return result2;
    }
}

