/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestRecognitionUtilsKt;
import com.intellij.httpClient.http.request.highlighting.AddRequestSeparatorFix;
import com.intellij.httpClient.http.request.highlighting.ReplacementInfo;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"registerProblemsIfExist", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientRequestSyntaxAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientRequestSyntaxAnnotator.kt\ncom/intellij/httpClient/http/request/highlighting/HttpClientRequestSyntaxAnnotatorKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,109:1\n1317#2,2:110\n*S KotlinDebug\n*F\n+ 1 HttpClientRequestSyntaxAnnotator.kt\ncom/intellij/httpClient/http/request/highlighting/HttpClientRequestSyntaxAnnotatorKt\n*L\n44#1:110,2\n*E\n"})
public final class HttpClientRequestSyntaxAnnotatorKt {
    private static final void registerProblemsIfExist(PsiElement psiElement, AnnotationHolder holder) {
        PsiElement parent = psiElement.getParent();
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Sequence $this$forEach$iv = HttpRequestRecognitionUtilsKt.findAllPossibleHttpRequests$default(string, project, false, 4, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            Pair pair = parent instanceof PsiErrorElement ? TuplesKt.to((Object)HighlightSeverity.INFORMATION, (Object)((PsiErrorElement)parent).getErrorDescription()) : TuplesKt.to((Object)HighlightSeverity.WEAK_WARNING, (Object)RestClientBundle.message("http.client.code.style.inspection.add.request.separator.message", new Object[0]));
            HighlightSeverity severity = (HighlightSeverity)pair.component1();
            Object object = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
            String description = (String)object;
            IntRange range = matchResult.getRange();
            int elementOffset = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement);
            int startIndexInDocument = elementOffset + range.getFirst();
            int endIndexInDocument = elementOffset + range.getLast() + 1;
            ReplacementInfo replacementInfo = new ReplacementInfo(((Object)StringsKt.trim((CharSequence)matchResult.getValue())).toString(), startIndexInDocument, endIndexInDocument);
            TextRange highlightingTextRange = new TextRange(startIndexInDocument + HttpRequestRecognitionUtilsKt.emptySpacesCount(matchResult), endIndexInDocument);
            holder.newAnnotation(severity, description).range(highlightingTextRange).withFix((IntentionAction)new AddRequestSeparatorFix(psiElement, replacementInfo)).create();
        }
    }

    public static final /* synthetic */ void access$registerProblemsIfExist(PsiElement psiElement, AnnotationHolder holder) {
        HttpClientRequestSyntaxAnnotatorKt.registerProblemsIfExist(psiElement, holder);
    }
}

