/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.http.request.RequestNavigator;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class RestClientRequestNavigatorBase
implements RequestNavigator {
    protected static final Logger LOG = Logger.getInstance(RestClientRequestNavigatorBase.class);

    RestClientRequestNavigatorBase() {
    }

    public boolean accept(@NotNull NavigatorHttpRequest request) {
        if (request == null) {
            RestClientRequestNavigatorBase.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void navigate(@NotNull Project project, @NotNull NavigatorHttpRequest request, @NotNull String hint) {
        if (project == null) {
            RestClientRequestNavigatorBase.$$$reportNull$$$0(1);
        }
        if (request == null) {
            RestClientRequestNavigatorBase.$$$reportNull$$$0(2);
        }
        if (hint == null) {
            RestClientRequestNavigatorBase.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        LanguageFileType fileType = HttpRequestLanguage.INSTANCE.getAssociatedFileType();
        String ext = fileType == null ? "" : fileType.getDefaultExtension();
        String fileName = PathUtil.makeFileName((String)hint, (String)ext);
        try {
            NavigatablePsiElement psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("http.request.navigator.update.scratch.file", new Object[0])).withGlobalUndo().withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).shouldRecordActionForActiveDocument(false).compute(() -> {
                VirtualFile file;
                ScratchFileService fileService = ScratchFileService.getInstance();
                try {
                    file = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_if_missing);
                }
                catch (IOException e) {
                    throw new Exception(UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}), e);
                }
                fileService.getScratchesMapping().setMapping(file, (Object)HttpRequestLanguage.INSTANCE);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof HttpRequestPsiFile)) {
                    throw new Exception(RestClientBundle.message("http.request.navigator.invalid.file", fileName));
                }
                HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks(psiFile);
                NavigatablePsiElement existingRequest = RestClientRequestNavigatorBase.findRequest(blocks, request);
                if (existingRequest != null) {
                    return existingRequest;
                }
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document = manager.getDocument(psiFile);
                if (document == null) {
                    throw new Exception(RestClientBundle.message("http.request.navigator.invalid.file.document", fileName));
                }
                RestClientRequestNavigatorBase.appendSeparatorIfNeeded(blocks, document);
                document.insertString(document.getTextLength(), (CharSequence)RestClientRequestNavigatorBase.getRequestText(request));
                manager.commitDocument(document);
                HttpRequestBlock[] updatedBlocks = HttpRequestPsiUtils.getRequestBlocks(psiFile);
                if (updatedBlocks.length > 0) {
                    return updatedBlocks[updatedBlocks.length - 1];
                }
                return psiFile;
            });
            if (psiElement != null) {
                this.performNavigation(psiElement);
            }
        }
        catch (Throwable e) {
            LOG.info(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]));
        }
    }

    protected abstract void performNavigation(@NotNull NavigatablePsiElement var1);

    private static NavigatablePsiElement findRequest(HttpRequestBlock[] blocks, NavigatorHttpRequest request) {
        if (blocks == null) {
            return null;
        }
        for (HttpRequestBlock block : blocks) {
            String path;
            HttpRequest httpRequest = block.getRequest();
            Object requestHttpUrl = httpRequest.getHttpUrl(HttpRequestVariableSubstitutor.empty());
            if (requestHttpUrl == null) continue;
            HttpRequestTarget requestTarget = httpRequest.getRequestTarget();
            if (requestTarget != null && StringUtil.isEmpty((String)(path = requestTarget.getHttpPath(HttpRequestVariableSubstitutor.empty()))) && request.getUrl().endsWith("/")) {
                requestHttpUrl = (String)requestHttpUrl + "/";
            }
            if (!request.getUrl().equalsIgnoreCase((String)requestHttpUrl)) continue;
            return httpRequest;
        }
        return null;
    }

    private static void appendSeparatorIfNeeded(HttpRequestBlock[] blocks, Document document) {
        HttpRequestBlock lastRequest;
        PsiElement nextSeparator;
        if (blocks != null && blocks.length > 0 && (nextSeparator = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)(lastRequest = blocks[blocks.length - 1]), HttpRequestElementTypes.REQUEST_SEPARATOR, true)) == null) {
            int endOffset = blocks[blocks.length - 1].getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)("\n\n" + HttpRequestPsiConverter.getSeparator() + "\n\n"));
            return;
        }
        int endOffset = document.getTextLength();
        if (endOffset > 0 && !document.getText(new TextRange(endOffset - 1, endOffset)).equals("\n")) {
            document.insertString(endOffset, (CharSequence)"\n\n");
        }
    }

    private static String getRequestText(@NotNull NavigatorHttpRequest request) {
        if (request == null) {
            RestClientRequestNavigatorBase.$$$reportNull$$$0(4);
        }
        RestClientRequest restClientRequest = new RestClientRequest();
        restClientRequest.httpMethod = request.getRequestMethod();
        restClientRequest.urlBase = request.getUrl();
        restClientRequest.urlPath = "";
        restClientRequest.headers = ContainerUtil.map((Collection)request.getHeaders(), header -> new RestClientRequest.KeyValuePair((String)header.first, (String)header.second));
        restClientRequest.parametersEnabled = true;
        restClientRequest.parameters = ContainerUtil.map((Collection)request.getParams(), param -> new RestClientRequest.KeyValuePair((String)param.first, (String)param.second));
        return HttpRequestPsiConverter.toPsiHttpRequest(restClientRequest);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/RestClientRequestNavigatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

