/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=JSTrimWhitespaceNode.class)
public final class JSTrimWhitespaceNodeGen
extends JSTrimWhitespaceNode
implements Introspection.Provider {
    private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_1_");
    private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
    private static final InlinedConditionProfile INLINED_IS_FAST_NON_WHITESPACE = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_1_UPDATER.subUpdater(0, 2)));
    private static final InlinedConditionProfile INLINED_IS_FAST_WHITESPACE = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_1_UPDATER.subUpdater(2, 2)));
    private static final InlinedBranchProfile INLINED_STRING_STARTS_WITH_WHITESPACE_BRANCH_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(3, 1)));
    private static final InlinedBranchProfile INLINED_STRING_ENDS_WITH_WHITESPACE_BRANCH_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, STATE_0_UPDATER.subUpdater(4, 1)));
    private static final InlinedConditionProfile INLINED_STRING_IS_EMPTY_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, STATE_0_UPDATER.subUpdater(5, 2)));
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private int state_1_;
    @Node.Child
    private TruffleString.ReadCharUTF16Node readChar;
    @Node.Child
    private TruffleString.SubstringByteIndexNode string_substringNode_;

    private JSTrimWhitespaceNodeGen() {
    }

    @Override
    public TruffleString executeString(TruffleString arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 7) != 0) {
            TruffleString.SubstringByteIndexNode substringNode__;
            TruffleString.ReadCharUTF16Node readChar_1;
            TruffleString.ReadCharUTF16Node readChar_;
            if ((state_0 & 1) != 0 && JSGuards.stringLength(arg0Value) == 0) {
                return JSTrimWhitespaceNode.doStringZero(arg0Value);
            }
            if ((state_0 & 2) != 0 && (readChar_ = this.readChar) != null && JSGuards.stringLength(arg0Value) > 0 && !this.startsOrEndsWithWhitespace(readChar_, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE)) {
                return JSTrimWhitespaceNode.doStringNoWhitespace(arg0Value, readChar_, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE);
            }
            if ((state_0 & 4) != 0 && (readChar_1 = this.readChar) != null && (substringNode__ = this.string_substringNode_) != null && JSGuards.stringLength(arg0Value) > 0 && this.startsOrEndsWithWhitespace(readChar_1, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE)) {
                return this.doString(arg0Value, readChar_1, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE, substringNode__, INLINED_STRING_STARTS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_ENDS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_IS_EMPTY_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private TruffleString executeAndSpecialize(TruffleString arg0Value) {
        TruffleString.SubstringByteIndexNode substringNode__;
        TruffleString.ReadCharUTF16Node readChar_1;
        TruffleString.ReadCharUTF16Node readChar_;
        int state_0 = this.state_0_;
        if (JSGuards.stringLength(arg0Value) == 0) {
            this.state_0_ = state_0 |= 1;
            return JSTrimWhitespaceNode.doStringZero(arg0Value);
        }
        boolean StringNoWhitespace_duplicateFound_ = false;
        if ((state_0 & 2) != 0 && (readChar_ = this.readChar) != null && JSGuards.stringLength(arg0Value) > 0 && !this.startsOrEndsWithWhitespace(readChar_, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE)) {
            StringNoWhitespace_duplicateFound_ = true;
        }
        if (!StringNoWhitespace_duplicateFound_ && JSGuards.stringLength(arg0Value) > 0) {
            TruffleString.ReadCharUTF16Node readChar__shared = this.readChar;
            if (readChar__shared != null) {
                readChar_ = readChar__shared;
            } else {
                readChar_ = this.insert(TruffleString.ReadCharUTF16Node.create());
                if (readChar_ == null) {
                    throw new IllegalStateException("Specialization 'doStringNoWhitespace(TruffleString, ReadCharUTF16Node, InlinedConditionProfile, InlinedConditionProfile)' contains a shared cache with name 'readRawNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (!this.startsOrEndsWithWhitespace(readChar_, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE) && (state_0 & 2) == 0) {
                if (this.readChar == null) {
                    this.readChar = readChar_;
                }
                this.state_0_ = state_0 |= 2;
                StringNoWhitespace_duplicateFound_ = true;
            }
        }
        if (StringNoWhitespace_duplicateFound_) {
            return JSTrimWhitespaceNode.doStringNoWhitespace(arg0Value, this.readChar, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE);
        }
        boolean String_duplicateFound_ = false;
        if ((state_0 & 4) != 0 && (readChar_1 = this.readChar) != null && (substringNode__ = this.string_substringNode_) != null && JSGuards.stringLength(arg0Value) > 0 && this.startsOrEndsWithWhitespace(readChar_1, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE)) {
            String_duplicateFound_ = true;
        }
        if (!String_duplicateFound_ && JSGuards.stringLength(arg0Value) > 0) {
            TruffleString.ReadCharUTF16Node readChar_1_shared = this.readChar;
            if (readChar_1_shared != null) {
                readChar_1 = readChar_1_shared;
            } else {
                readChar_1 = this.insert(TruffleString.ReadCharUTF16Node.create());
                if (readChar_1 == null) {
                    throw new IllegalStateException("Specialization 'doString(TruffleString, ReadCharUTF16Node, InlinedConditionProfile, InlinedConditionProfile, SubstringByteIndexNode, InlinedBranchProfile, InlinedBranchProfile, InlinedConditionProfile)' contains a shared cache with name 'readRawNode' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                }
            }
            if (this.startsOrEndsWithWhitespace(readChar_1, arg0Value, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE) && (state_0 & 4) == 0) {
                if (this.readChar == null) {
                    this.readChar = readChar_1;
                }
                TruffleString.SubstringByteIndexNode substringNode__2 = this.insert(TruffleString.SubstringByteIndexNode.create());
                Objects.requireNonNull(substringNode__2, "Specialization 'doString(TruffleString, ReadCharUTF16Node, InlinedConditionProfile, InlinedConditionProfile, SubstringByteIndexNode, InlinedBranchProfile, InlinedBranchProfile, InlinedConditionProfile)' cache 'substringNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                this.string_substringNode_ = substringNode__2;
                this.state_0_ = state_0 |= 4;
                String_duplicateFound_ = true;
            }
        }
        if (String_duplicateFound_) {
            return this.doString(arg0Value, this.readChar, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE, this.string_substringNode_, INLINED_STRING_STARTS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_ENDS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_IS_EMPTY_);
        }
        throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        int counter = 0;
        if ((counter += Integer.bitCount(state_0 & 7)) == 1) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        TruffleString.SubstringByteIndexNode substringNode__;
        TruffleString.ReadCharUTF16Node readChar_1;
        TruffleString.ReadCharUTF16Node readChar_;
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doStringZero";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doStringNoWhitespace";
        if ((state_0 & 2) != 0 && (readChar_ = this.readChar) != null) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.readChar, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state_0 & 4) != 0 && (readChar_1 = this.readChar) != null && (substringNode__ = this.string_substringNode_) != null) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.readChar, INLINED_IS_FAST_NON_WHITESPACE, INLINED_IS_FAST_WHITESPACE, this.string_substringNode_, INLINED_STRING_STARTS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_ENDS_WITH_WHITESPACE_BRANCH_, INLINED_STRING_IS_EMPTY_));
            s[2] = cached;
        }
        if (s[1] == null) {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create(data);
    }

    @NeverDefault
    public static JSTrimWhitespaceNode create() {
        return new JSTrimWhitespaceNodeGen();
    }

    @NeverDefault
    public static JSTrimWhitespaceNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSTrimWhitespaceNode.class)
    @DenyReplace
    private static final class Uncached
    extends JSTrimWhitespaceNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString executeString(TruffleString arg0Value) {
            if (JSGuards.stringLength(arg0Value) == 0) {
                return JSTrimWhitespaceNode.doStringZero(arg0Value);
            }
            if (JSGuards.stringLength(arg0Value) > 0 && !this.startsOrEndsWithWhitespace(TruffleString.ReadCharUTF16Node.getUncached(), arg0Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached())) {
                return JSTrimWhitespaceNode.doStringNoWhitespace(arg0Value, TruffleString.ReadCharUTF16Node.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
            }
            if (JSGuards.stringLength(arg0Value) > 0 && this.startsOrEndsWithWhitespace(TruffleString.ReadCharUTF16Node.getUncached(), arg0Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached())) {
                return this.doString(arg0Value, TruffleString.ReadCharUTF16Node.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.SubstringByteIndexNode.getUncached(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached());
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }
}

