/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class GetTemporalCalendarWithISODefaultNode
extends JavaScriptBaseNode {
    protected final JSContext ctx;
    @Node.Child
    protected PropertyGetNode getCalendarNode;

    protected GetTemporalCalendarWithISODefaultNode(JSContext context) {
        this.ctx = context;
    }

    public abstract JSDynamicObject execute(Object var1);

    @Specialization
    protected JSDynamicObject getTemporalCalendarWithISODefault(Object item, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isCalendarProfile, @Cached InlinedConditionProfile isNullishProfile, @Cached(value="create(ctx)") ToTemporalCalendarNode toTemporalCalendarNode) {
        if (isCalendarProfile.profile(this, item instanceof TemporalCalendar)) {
            return ((TemporalCalendar)item).getCalendar();
        }
        Object calendar = this.getCalendar((JSDynamicObject)item);
        assert (calendar != null);
        if (isNullishProfile.profile(this, calendar == Undefined.instance)) {
            return TemporalUtil.getISO8601Calendar(this.ctx, this.getRealm(), this, errorBranch);
        }
        return toTemporalCalendarNode.execute(calendar);
    }

    private Object getCalendar(JSDynamicObject obj) {
        if (this.getCalendarNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarNode = this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.ctx));
        }
        return this.getCalendarNode.getValue(obj);
    }
}

