/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSStringObject
extends JSNonProxyObject {
    private final TruffleString string;

    protected JSStringObject(Shape shape, TruffleString string) {
        super(shape);
        this.string = string;
    }

    public TruffleString getString() {
        return this.string;
    }

    public static JSStringObject create(Shape shape, TruffleString value2) {
        return new JSStringObject(shape, value2);
    }

    public static JSStringObject create(JSRealm realm, JSObjectFactory factory, TruffleString value2) {
        return factory.initProto(new JSStringObject(factory.getShape(realm), value2), realm);
    }

    @Override
    public TruffleString getClassName() {
        return JSString.CLASS_NAME;
    }

    @ExportMessage
    public boolean isString() {
        return true;
    }

    @ExportMessage
    public String asString() {
        return Strings.toJavaString(JSString.getString(this));
    }
}

