/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public abstract class RegexLexer {
    private static final TBitSet PREDEFINED_CHAR_CLASSES = TBitSet.valueOf(68, 83, 87, 100, 115, 119);
    private static final TBitSet WHITESPACE = TBitSet.valueOf(9, 10, 11, 12, 13, 32);
    public final RegexSource source;
    protected final String pattern;
    private final Encodings.Encoding encoding;
    private final CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();
    protected int position = 0;
    protected Map<String, Integer> namedCaptureGroups = null;
    private int curStartIndex = 0;
    private int charClassCurAtomStartIndex = 0;
    private int nGroups = 1;
    private boolean identifiedAllGroups = false;

    public RegexLexer(RegexSource source) {
        this.source = source;
        this.pattern = source.getPattern();
        this.encoding = source.getEncoding();
    }

    protected abstract boolean featureEnabledIgnoreCase();

    protected abstract boolean featureEnabledAZPositionAssertions();

    protected abstract boolean featureEnabledBoundedQuantifierEmptyMin();

    protected abstract boolean featureEnabledCharClassFirstBracketIsLiteral();

    protected abstract boolean featureEnabledForwardReferences();

    protected abstract boolean featureEnabledGroupComments();

    protected abstract boolean featureEnabledLineComments();

    protected abstract boolean featureEnabledOctalEscapes();

    protected abstract boolean featureEnabledUnicodePropertyEscapes();

    protected abstract void caseFold(CodePointSetAccumulator var1);

    protected abstract CodePointSet getDotCodePointSet();

    protected abstract CodePointSet getIdStart();

    protected abstract CodePointSet getIdContinue();

    protected abstract int getMaxBackReferenceDigits();

    protected abstract CodePointSet getPredefinedCharClass(char var1);

    protected abstract RegexSyntaxException handleBoundedQuantifierOutOfOrder();

    protected abstract Token handleBoundedQuantifierSyntaxError();

    protected abstract RegexSyntaxException handleCCRangeOutOfOrder(int var1);

    protected abstract void handleCCRangeWithPredefCharClass(int var1);

    protected abstract RegexSyntaxException handleEmptyGroupName();

    protected abstract RegexSyntaxException handleGroupRedefinition(String var1, int var2, int var3);

    protected abstract void handleIncompleteEscapeX();

    protected abstract void handleInvalidBackReference(int var1);

    protected abstract void handleInvalidBackReference(String var1);

    protected abstract RegexSyntaxException handleInvalidGroupBeginQ();

    protected abstract void handleOctalOutOfRange();

    protected abstract void handleUnfinishedEscape();

    protected abstract void handleUnfinishedGroupComment();

    protected abstract RegexSyntaxException handleUnfinishedGroupQ();

    protected abstract void handleUnmatchedRightBrace();

    protected abstract RegexSyntaxException handleUnmatchedLeftBracket();

    protected abstract void handleUnmatchedRightBracket();

    protected abstract int parseCodePointInGroupName() throws RegexSyntaxException;

    protected abstract Token parseCustomEscape(char var1);

    protected abstract int parseCustomEscapeChar(char var1, boolean var2);

    protected abstract int parseCustomEscapeCharFallback(int var1, boolean var2);

    protected abstract Token parseCustomGroupBeginQ(char var1);

    protected abstract Token parseGroupLt();

    protected boolean findChars(char ... chars) {
        if (this.atEnd()) {
            return false;
        }
        int i = ArrayUtils.indexOf(this.pattern, this.position, this.pattern.length(), chars);
        if (i < 0) {
            this.position = this.pattern.length();
            return false;
        }
        this.position = i;
        return true;
    }

    protected void advance() {
        this.advance(1);
    }

    protected void retreat() {
        this.advance(-1);
    }

    public boolean hasNext() {
        if (this.featureEnabledLineComments()) {
            int p;
            do {
                p = this.position;
                this.skipWhitespace();
                if (this.consumingLookahead("#")) {
                    this.skipComment('\n');
                    continue;
                }
                if (!this.featureEnabledGroupComments() || !this.consumingLookahead("(?#") || this.skipComment(')')) continue;
                this.handleUnfinishedGroupComment();
            } while (p != this.position);
        }
        if (this.featureEnabledGroupComments()) {
            while (this.consumingLookahead("(?#")) {
                if (this.skipComment(')')) continue;
                this.handleUnfinishedGroupComment();
            }
        }
        return !this.atEnd();
    }

    private boolean skipComment(char terminator) {
        while (this.findChars('\\', terminator)) {
            if (this.consumeChar() == '\\' && !this.atEnd()) {
                this.advance();
                continue;
            }
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (!this.atEnd() && RegexLexer.isWhitespace(this.curChar())) {
            this.advance();
        }
    }

    private static boolean isWhitespace(char curChar) {
        return WHITESPACE.get(curChar);
    }

    public Token next() throws RegexSyntaxException {
        this.curStartIndex = this.position;
        Token t = this.getNext();
        t.setPosition(this.curStartIndex);
        this.setSourceSection(t, this.curStartIndex, this.position);
        return t;
    }

    public int getLastTokenPosition() {
        return this.curStartIndex;
    }

    protected int getLastAtomPosition() {
        return Math.max(this.curStartIndex, this.charClassCurAtomStartIndex);
    }

    protected char curChar() {
        return this.pattern.charAt(this.position);
    }

    protected char consumeChar() {
        char c = this.pattern.charAt(this.position);
        this.advance();
        return c;
    }

    protected void advance(int len) {
        this.position += len;
    }

    protected boolean lookahead(String match) {
        if (this.pattern.length() - this.position < match.length()) {
            return false;
        }
        return this.pattern.regionMatches(this.position, match, 0, match.length());
    }

    protected boolean lookahead(Predicate<Character> predicate, int length2) {
        if (this.pattern.length() - this.position < length2) {
            return false;
        }
        for (int i = this.position; i < this.position + length2; ++i) {
            if (predicate.test(Character.valueOf(this.pattern.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean consumingLookahead(char terminator) {
        if (this.atEnd()) {
            return false;
        }
        if (this.curChar() == terminator) {
            this.advance();
            return true;
        }
        return false;
    }

    protected boolean consumingLookahead(String match) {
        boolean matches = this.lookahead(match);
        if (matches) {
            this.position += match.length();
        }
        return matches;
    }

    protected boolean consumingLookahead(Predicate<Character> predicate, int length2) {
        boolean matches = this.lookahead(predicate, length2);
        if (matches) {
            this.position += length2;
        }
        return matches;
    }

    protected boolean lookbehind(char c) {
        if (this.position < 1) {
            return false;
        }
        return this.pattern.charAt(this.position - 1) == c;
    }

    protected boolean isEscaped() {
        int backslashPosition;
        for (backslashPosition = this.position - 1; backslashPosition >= 0 && this.pattern.charAt(backslashPosition) == '\\'; --backslashPosition) {
        }
        return (this.position - backslashPosition) % 2 == 0;
    }

    protected int count(Predicate<Character> predicate) {
        return this.count(predicate, this.position, this.pattern.length());
    }

    protected int countUpTo(Predicate<Character> predicate, int max) {
        return this.count(predicate, this.position, (int)Math.min((long)this.position + (long)max, (long)this.pattern.length()));
    }

    protected int countFrom(Predicate<Character> predicate, int fromIndex) {
        return this.count(predicate, fromIndex, this.pattern.length());
    }

    protected int count(Predicate<Character> predicate, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (predicate.test(Character.valueOf(this.pattern.charAt(i)))) continue;
            return i - fromIndex;
        }
        return toIndex - fromIndex;
    }

    protected boolean atEnd() {
        return this.position >= this.pattern.length();
    }

    private void setSourceSection(Token t, int startIndex, int endIndex) {
        if (this.source.getOptions().isDumpAutomataWithSourceSections()) {
            t.setSourceSection(this.source.getSource().createSection(startIndex + 1, endIndex - startIndex));
        }
    }

    public int totalNumberOfCaptureGroups() throws RegexSyntaxException {
        if (!this.identifiedAllGroups) {
            this.identifyCaptureGroups();
            this.identifiedAllGroups = true;
        }
        return this.nGroups;
    }

    public int numberOfCaptureGroupsSoFar() {
        assert (!this.identifiedAllGroups);
        return this.nGroups;
    }

    public Map<String, Integer> getNamedCaptureGroups() throws RegexSyntaxException {
        if (!this.identifiedAllGroups) {
            this.identifyCaptureGroups();
            this.identifiedAllGroups = true;
        }
        return this.namedCaptureGroups;
    }

    protected boolean hasNamedCaptureGroups() throws RegexSyntaxException {
        return this.getNamedCaptureGroups() != null;
    }

    private void registerCaptureGroup() {
        if (!this.identifiedAllGroups) {
            ++this.nGroups;
        }
    }

    protected void registerNamedCaptureGroup(String name) {
        if (!this.identifiedAllGroups) {
            if (this.namedCaptureGroups == null) {
                this.namedCaptureGroups = new HashMap<String, Integer>();
            }
            if (this.namedCaptureGroups.containsKey(name)) {
                throw this.handleGroupRedefinition(name, this.nGroups, this.namedCaptureGroups.get(name));
            }
            this.namedCaptureGroups.put(name, this.nGroups);
        }
        this.registerCaptureGroup();
    }

    private void identifyCaptureGroups() throws RegexSyntaxException {
        boolean insideCharClass = false;
        int restoreIndex = this.position;
        block6: while (this.findChars('\\', '[', ']', '(')) {
            switch (this.consumeChar()) {
                case '\\': {
                    this.advance();
                    continue block6;
                }
                case '[': {
                    insideCharClass = true;
                    continue block6;
                }
                case ']': {
                    insideCharClass = false;
                    continue block6;
                }
                case '(': {
                    if (insideCharClass) continue block6;
                    this.parseGroupBegin();
                    continue block6;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        this.position = restoreIndex;
    }

    protected Token charClass(int codePoint) {
        if (this.featureEnabledIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.appendRange(codePoint, codePoint);
            return this.charClass(false);
        }
        return Token.createCharClass(CodePointSet.create(codePoint), true);
    }

    private Token charClass(CodePointSet codePointSet) {
        if (this.featureEnabledIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.addSet(codePointSet);
            return this.charClass(false);
        }
        return Token.createCharClass(codePointSet);
    }

    private Token charClass(boolean invert) {
        boolean wasSingleChar;
        boolean bl = wasSingleChar = !invert && this.curCharClass.matchesSingleChar();
        if (this.featureEnabledIgnoreCase()) {
            this.caseFold(this.curCharClass);
        }
        CodePointSet cps = this.curCharClass.toCodePointSet();
        return Token.createCharClass(invert ? cps.createInverse(this.encoding) : cps, wasSingleChar);
    }

    private Token getNext() throws RegexSyntaxException {
        char c = this.consumeChar();
        switch (c) {
            case '.': {
                return Token.createCharClass(this.getDotCodePointSet());
            }
            case '^': {
                return Token.createCaret();
            }
            case '$': {
                return Token.createDollar();
            }
            case '*': 
            case '+': 
            case '?': 
            case '{': {
                return this.parseQuantifier(c);
            }
            case '}': {
                this.handleUnmatchedRightBrace();
                return this.charClass(c);
            }
            case '|': {
                return Token.createAlternation();
            }
            case '(': {
                return this.parseGroupBegin();
            }
            case ')': {
                return Token.createGroupEnd();
            }
            case '[': {
                return this.parseCharClass();
            }
            case ']': {
                this.handleUnmatchedRightBracket();
                return this.charClass(c);
            }
            case '\\': {
                return this.parseEscape();
            }
        }
        return this.charClass(this.toCodePoint(c));
    }

    private Token parseEscape() throws RegexSyntaxException {
        char c;
        Token custom;
        if (this.atEnd()) {
            this.handleUnfinishedEscape();
        }
        if ((custom = this.parseCustomEscape(c = this.consumeChar())) != null) {
            return custom;
        }
        if ('1' <= c && c <= '9') {
            int restoreIndex = this.position;
            int backRefNumber = this.parseIntSaturated(c - 48, this.countDecimalDigits(this.getMaxBackReferenceDigits() - 1), Integer.MAX_VALUE);
            if (backRefNumber < (this.featureEnabledForwardReferences() ? this.totalNumberOfCaptureGroups() : this.nGroups)) {
                return Token.createBackReference(backRefNumber, false);
            }
            this.handleInvalidBackReference(backRefNumber);
            this.position = restoreIndex;
        }
        if (this.featureEnabledAZPositionAssertions()) {
            if (c == 'A') {
                return Token.createA();
            }
            if (c == 'Z') {
                return Token.createZ();
            }
        }
        switch (c) {
            case 'b': {
                return Token.createWordBoundary();
            }
            case 'B': {
                return Token.createNonWordBoundary();
            }
        }
        if (RegexLexer.isPredefCharClass(c)) {
            return Token.createCharClass(this.getPredefinedCharClass(c));
        }
        if (this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P')) {
            return this.charClass(this.parseUnicodeCharacterProperty(c == 'P'));
        }
        return this.charClass(this.parseEscapeChar(c, false));
    }

    private Token parseGroupBegin() throws RegexSyntaxException {
        if (this.consumingLookahead("?")) {
            if (this.atEnd()) {
                throw this.handleUnfinishedGroupQ();
            }
            char c = this.consumeChar();
            Token custom = this.parseCustomGroupBeginQ(c);
            if (custom != null) {
                return custom;
            }
            switch (c) {
                case '=': {
                    return Token.createLookAheadAssertionBegin(false);
                }
                case '!': {
                    return Token.createLookAheadAssertionBegin(true);
                }
                case ':': {
                    return Token.createNonCaptureGroupBegin();
                }
                case '<': {
                    if (this.consumingLookahead("=")) {
                        return Token.createLookBehindAssertionBegin(false);
                    }
                    if (this.consumingLookahead("!")) {
                        return Token.createLookBehindAssertionBegin(true);
                    }
                    return this.parseGroupLt();
                }
            }
            throw this.handleInvalidGroupBeginQ();
        }
        this.registerCaptureGroup();
        return Token.createCaptureGroupBegin();
    }

    protected ParseGroupNameResult parseGroupName(char terminator) throws RegexSyntaxException {
        StringBuilder sb = new StringBuilder();
        if (this.atEnd() || this.curChar() == terminator) {
            return new ParseGroupNameResult(ParseGroupNameResultState.empty, "");
        }
        int codePoint = this.parseCodePointInGroupName();
        boolean validFirstChar = this.getIdStart().contains(codePoint);
        boolean validRest = true;
        sb.appendCodePoint(codePoint);
        while (!this.atEnd() && this.curChar() != terminator) {
            codePoint = this.parseCodePointInGroupName();
            validRest &= this.getIdContinue().contains(codePoint);
            sb.appendCodePoint(codePoint);
        }
        String groupName = sb.toString();
        if (!this.consumingLookahead(terminator)) {
            return new ParseGroupNameResult(ParseGroupNameResultState.unterminated, groupName);
        }
        if (!validFirstChar) {
            return new ParseGroupNameResult(ParseGroupNameResultState.invalidStart, groupName);
        }
        if (!validRest) {
            return new ParseGroupNameResult(ParseGroupNameResultState.invalidRest, groupName);
        }
        return new ParseGroupNameResult(ParseGroupNameResultState.valid, groupName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Token parseQuantifier(char c) throws RegexSyntaxException {
        boolean bl;
        int max;
        int min;
        block11: {
            block12: {
                if (c != '{') break block12;
                if (this.lookahead("}")) {
                    return this.handleBoundedQuantifierSyntaxError();
                }
                int resetIndex = this.position;
                int lengthMin = this.countDecimalDigits();
                if (lengthMin == 0) {
                    if (!this.featureEnabledBoundedQuantifierEmptyMin()) return this.handleBoundedQuantifierSyntaxError();
                    min = 0;
                } else {
                    min = this.parseIntSaturated(0, lengthMin, -1);
                }
                if (this.consumingLookahead(",}")) {
                    max = -1;
                    break block11;
                } else if (this.consumingLookahead("}")) {
                    max = min;
                    break block11;
                } else {
                    if (!this.consumingLookahead(",")) {
                        return this.handleBoundedQuantifierSyntaxError();
                    }
                    int lengthMax = this.countDecimalDigits();
                    max = this.parseIntSaturated(0, lengthMax, -1);
                    if (!this.consumingLookahead("}")) {
                        return this.handleBoundedQuantifierSyntaxError();
                    }
                    if (this.isQuantifierOutOfOrder(min, max, resetIndex, lengthMin, lengthMax)) {
                        throw this.handleBoundedQuantifierOutOfOrder();
                    }
                }
                break block11;
            }
            min = c == '+' ? 1 : 0;
            int n = max = c == '?' ? 1 : -1;
        }
        if (!this.consumingLookahead("?")) {
            bl = true;
            return Token.createQuantifier(min, max, bl);
        }
        bl = false;
        return Token.createQuantifier(min, max, bl);
    }

    private boolean isQuantifierOutOfOrder(int parsedMin, int parsedMax, int startMin, int lengthMin, int lengthMax) {
        if (Integer.compareUnsigned(parsedMin, parsedMax) > 0) {
            return true;
        }
        if (parsedMin == -1 && parsedMax == -1) {
            int nZerosMax;
            int lengthMaxTrunc;
            int startMax = startMin + lengthMin + 1;
            int nZerosMin = this.countZeros(startMin);
            int lengthMinTrunc = lengthMin - nZerosMin;
            return lengthMinTrunc > (lengthMaxTrunc = lengthMax - (nZerosMax = this.countZeros(startMax))) || lengthMinTrunc == lengthMaxTrunc && this.pattern.substring(startMin + nZerosMin, startMin + lengthMin).compareTo(this.pattern.substring(startMax + nZerosMax, startMax + lengthMax)) > 0;
        }
        return false;
    }

    protected int parseIntSaturated(int firstDigit, int length2, int returnOnOverflow) {
        int fromIndex = this.position;
        this.position += length2;
        int ret = firstDigit;
        for (int i = fromIndex; i < fromIndex + length2; ++i) {
            int nextDigit = this.pattern.charAt(i) - 48;
            if (ret > 0xCCCCCCC) {
                return returnOnOverflow;
            }
            if ((ret *= 10) > Integer.MAX_VALUE - nextDigit) {
                return returnOnOverflow;
            }
            ret += nextDigit;
        }
        return ret;
    }

    protected int countDecimalDigits() {
        return this.count(RegexLexer::isDecimalDigit);
    }

    private int countDecimalDigits(int maxLength) {
        return this.countUpTo(RegexLexer::isDecimalDigit, maxLength);
    }

    private int countZeros(int fromIndex) {
        return this.countFrom(c -> c.charValue() == '0', fromIndex);
    }

    private Token parseCharClass() throws RegexSyntaxException {
        boolean invert = this.consumingLookahead("^");
        this.curCharClass.clear();
        int startPos = this.position;
        while (!this.atEnd()) {
            char c = this.consumeChar();
            if (!(c != ']' || this.featureEnabledCharClassFirstBracketIsLiteral() && this.position == startPos + 1)) {
                return this.charClass(invert);
            }
            this.parseCharClassRange(c);
        }
        throw this.handleUnmatchedLeftBracket();
    }

    private CodePointSet parseCharClassAtomPredefCharClass(char c) throws RegexSyntaxException {
        if (c == '\\') {
            if (this.atEnd()) {
                this.handleUnfinishedEscape();
            }
            if (this.isEscapeCharClass(this.curChar())) {
                return this.parseEscapeCharClass(this.consumeChar());
            }
        }
        return null;
    }

    private int parseCharClassAtomCodePoint(char c) throws RegexSyntaxException {
        if (c == '\\') {
            assert (!this.atEnd());
            assert (!this.isEscapeCharClass(this.curChar()));
            return this.parseEscapeChar(this.consumeChar(), true);
        }
        return this.toCodePoint(c);
    }

    private void parseCharClassRange(char c) throws RegexSyntaxException {
        int firstAtomCP;
        int startPos = this.position - 1;
        this.charClassCurAtomStartIndex = this.position - 1;
        CodePointSet firstAtomCC = this.parseCharClassAtomPredefCharClass(c);
        int n = firstAtomCP = firstAtomCC == null ? this.parseCharClassAtomCodePoint(c) : -1;
        if (this.consumingLookahead("-")) {
            if (this.atEnd() || this.lookahead("]")) {
                this.addCharClassAtom(firstAtomCC, firstAtomCP);
                this.curCharClass.addRange(45, 45);
            } else {
                int secondAtomCP;
                char nextC = this.consumeChar();
                this.charClassCurAtomStartIndex = this.position - 1;
                CodePointSet secondAtomCC = this.parseCharClassAtomPredefCharClass(nextC);
                int n2 = secondAtomCP = secondAtomCC == null ? this.parseCharClassAtomCodePoint(nextC) : -1;
                if (firstAtomCC != null || secondAtomCC != null) {
                    this.handleCCRangeWithPredefCharClass(startPos);
                    this.addCharClassAtom(firstAtomCC, firstAtomCP);
                    this.addCharClassAtom(secondAtomCC, secondAtomCP);
                    this.curCharClass.addRange(45, 45);
                } else {
                    if (secondAtomCP < firstAtomCP) {
                        throw this.handleCCRangeOutOfOrder(startPos);
                    }
                    this.curCharClass.addRange(firstAtomCP, secondAtomCP);
                }
            }
        } else {
            this.addCharClassAtom(firstAtomCC, firstAtomCP);
        }
    }

    private void addCharClassAtom(CodePointSet preDefCharClass, int codePoint) {
        if (preDefCharClass != null) {
            this.curCharClass.addSet(preDefCharClass);
        } else {
            this.curCharClass.addRange(codePoint, codePoint);
        }
    }

    private CodePointSet parseEscapeCharClass(char c) throws RegexSyntaxException {
        if (RegexLexer.isPredefCharClass(c)) {
            return this.getPredefinedCharClass(c);
        }
        if (this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P')) {
            return this.parseUnicodeCharacterProperty(c == 'P');
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private CodePointSet parseUnicodeCharacterProperty(boolean invert) throws RegexSyntaxException {
        if (!this.consumingLookahead("{")) {
            throw this.syntaxError("Invalid Unicode property escape");
        }
        int namePos = this.position;
        while (!this.atEnd() && this.curChar() != '}') {
            this.advance();
        }
        if (!this.consumingLookahead("}")) {
            throw this.syntaxError("Ends with an unfinished Unicode property escape");
        }
        try {
            CodePointSet propertySet = this.encoding.getFullSet().createIntersection(UnicodeProperties.getProperty(this.pattern.substring(namePos, this.position - 1)), this.curCharClass.getTmp());
            return invert ? propertySet.createInverse(this.encoding) : propertySet;
        }
        catch (IllegalArgumentException e) {
            throw this.syntaxError(e.getMessage());
        }
    }

    private int parseEscapeChar(char c, boolean inCharClass) throws RegexSyntaxException {
        int custom = this.parseCustomEscapeChar(c, inCharClass);
        if (custom >= 0) {
            return custom;
        }
        switch (c) {
            case 'b': {
                assert (inCharClass);
                return 8;
            }
            case 'f': {
                return 12;
            }
            case 'n': {
                return 10;
            }
            case 'r': {
                return 13;
            }
            case 't': {
                return 9;
            }
            case 'v': {
                return 11;
            }
            case 'x': {
                if (!this.consumingLookahead(RegexLexer::isHexDigit, 2)) {
                    this.handleIncompleteEscapeX();
                    return c;
                }
                return Integer.parseInt(this.pattern, this.position - 2, this.position, 16);
            }
        }
        if (this.featureEnabledOctalEscapes() && RegexLexer.isOctalDigit(c)) {
            return this.parseOctal(c - 48);
        }
        return this.parseCustomEscapeCharFallback(this.toCodePoint(c), inCharClass);
    }

    private int toCodePoint(char c) {
        if (this.encoding != Encodings.UTF_16_RAW && Character.isHighSurrogate(c)) {
            return this.finishSurrogatePair(c);
        }
        return c;
    }

    protected int finishSurrogatePair(char c) {
        assert (Character.isHighSurrogate(c));
        if (!this.atEnd() && Character.isLowSurrogate(this.curChar())) {
            return Character.toCodePoint(c, this.consumeChar());
        }
        return c;
    }

    protected int parseOctal(int firstDigit) {
        int ret = firstDigit;
        for (int i = 0; !this.atEnd() && RegexLexer.isOctalDigit(this.curChar()) && i < 2; ++i) {
            if (ret * 8 > 255) {
                this.handleOctalOutOfRange();
                return ret;
            }
            ret *= 8;
            ret += this.consumeChar() - 48;
        }
        return ret;
    }

    private boolean isEscapeCharClass(char c) {
        return RegexLexer.isPredefCharClass(c) || this.featureEnabledUnicodePropertyEscapes() && (c == 'p' || c == 'P');
    }

    public RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.getLastAtomPosition());
    }

    private static boolean isPredefCharClass(char c) {
        return PREDEFINED_CHAR_CLASSES.get(c);
    }

    protected static boolean isDecimalDigit(int c) {
        return 48 <= c && c <= 57;
    }

    protected static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }

    protected static boolean isHexDigit(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static final class ParseGroupNameResult {
        public final ParseGroupNameResultState state;
        public final String groupName;

        ParseGroupNameResult(ParseGroupNameResultState state, String groupName) {
            this.state = state;
            this.groupName = groupName;
        }
    }

    protected static enum ParseGroupNameResultState {
        empty,
        unterminated,
        invalidStart,
        invalidRest,
        valid;

    }

    @FunctionalInterface
    protected static interface ErrorHandler
    extends Runnable {
    }
}

