/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.ibm.icu.lang.UCharacter;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.chardata.UnicodeCharacterAliases;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.errors.PyErrorMessages;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonLocaleData;
import com.oracle.truffle.regex.tregex.parser.flavors.PythonREMode;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class PythonRegexLexer
extends RegexLexer {
    private static final CodePointSet ASCII_WHITESPACE = CodePointSet.createNoDedup(9, 13, 32, 32);
    private static final CodePointSet ASCII_NON_WHITESPACE = CodePointSet.createNoDedup(0, 8, 14, 31, 33, 0x10FFFF);
    private static final CodePointSet XID_START = UnicodeProperties.getProperty("XID_Start").union(CodePointSet.create(95));
    private static final CodePointSet XID_CONTINUE = UnicodeProperties.getProperty("XID_Continue");
    private static final Map<Character, CodePointSet> UNICODE_CHAR_CLASS_SETS;
    private static final CodePointSet PYTHON_DOT;
    private final PythonREMode mode;
    private final Deque<PythonFlags> flagsStack = new ArrayDeque<PythonFlags>();
    private PythonFlags globalFlags;
    private final CodePointSetAccumulator caseFoldTmp = new CodePointSetAccumulator();
    private PythonLocaleData localeData;

    public PythonRegexLexer(RegexSource source, PythonREMode mode) {
        super(source);
        this.mode = mode;
        this.globalFlags = new PythonFlags(source.getFlags());
        this.parseInlineGlobalFlags();
        if (this.globalFlags.isVerbose() && source.getFlags().indexOf(120) == -1) {
            this.globalFlags = new PythonFlags(source.getFlags()).addFlag(120);
            this.parseInlineGlobalFlags();
        }
        this.globalFlags = this.globalFlags.fixFlags(source, mode);
    }

    private static int lookupCharacterByName(String characterName) {
        String normalizedName = characterName.trim().toUpperCase(Locale.ROOT);
        if (UnicodeCharacterAliases.CHARACTER_ALIASES.containsKey(normalizedName)) {
            return (Integer)UnicodeCharacterAliases.CHARACTER_ALIASES.get(normalizedName);
        }
        return UCharacter.getCharFromName((String)characterName);
    }

    public PythonLocaleData getLocaleData() {
        if (this.localeData == null) {
            try {
                this.localeData = PythonLocaleData.getLocaleData(this.source.getOptions().getPythonLocale());
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedRegexException(e.getMessage(), this.source);
            }
        }
        return this.localeData;
    }

    private void parseInlineGlobalFlags() {
        ArrayDeque<Boolean> groupVerbosityStack = new ArrayDeque<Boolean>();
        groupVerbosityStack.push(this.globalFlags.isVerbose());
        while (this.findChars('[', '(', ')', '#')) {
            if (this.isEscaped()) {
                this.advance();
                continue;
            }
            switch (this.consumeChar()) {
                case '[': {
                    this.advance();
                    while (this.findChars(']') && this.isEscaped()) {
                        this.advance();
                    }
                    break;
                }
                case '(': {
                    if (this.consumingLookahead("?") && !this.atEnd()) {
                        char ch = this.consumeChar();
                        if (ch == '#') {
                            while (this.findChars(')') && this.isEscaped()) {
                                this.advance();
                            }
                            break;
                        }
                        PythonFlags positiveFlags = PythonFlags.EMPTY_INSTANCE;
                        while (!this.atEnd() && PythonFlags.isValidFlagChar(ch)) {
                            positiveFlags = this.addFlag(positiveFlags, ch);
                            ch = this.consumeChar();
                        }
                        if (!positiveFlags.equals(PythonFlags.EMPTY_INSTANCE) || ch == '-') {
                            switch (ch) {
                                case ')': {
                                    this.globalFlags = this.globalFlags.addFlags(positiveFlags);
                                    break;
                                }
                                case ':': {
                                    groupVerbosityStack.push((Boolean)groupVerbosityStack.peek() != false || positiveFlags.isVerbose());
                                    break;
                                }
                                case '-': {
                                    if (this.atEnd()) break;
                                    ch = this.consumeChar();
                                    PythonFlags negativeFlags = PythonFlags.EMPTY_INSTANCE;
                                    while (!this.atEnd() && PythonFlags.isValidFlagChar(ch)) {
                                        negativeFlags = negativeFlags.addFlag(ch);
                                        ch = this.consumeChar();
                                    }
                                    groupVerbosityStack.push(((Boolean)groupVerbosityStack.peek() != false || positiveFlags.isVerbose()) && !negativeFlags.isVerbose());
                                    break;
                                }
                            }
                            break;
                        }
                        groupVerbosityStack.push((Boolean)groupVerbosityStack.peek());
                        break;
                    }
                    groupVerbosityStack.push((Boolean)groupVerbosityStack.peek());
                    break;
                }
                case ')': {
                    if (groupVerbosityStack.size() <= 1) break;
                    groupVerbosityStack.pop();
                    break;
                }
                case '#': {
                    if (!((Boolean)groupVerbosityStack.peek()).booleanValue() || !this.findChars('\n')) break;
                    this.advance();
                }
            }
        }
        this.position = 0;
    }

    PythonFlags getGlobalFlags() {
        return this.globalFlags;
    }

    PythonFlags getLocalFlags() {
        return this.flagsStack.isEmpty() ? this.globalFlags : this.flagsStack.peek();
    }

    public void popLocalFlags() {
        this.flagsStack.pop();
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.getLocalFlags().isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return true;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return true;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return true;
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return false;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return true;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return this.getLocalFlags().isVerbose();
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return true;
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return false;
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.getLocalFlags().isDotAll() ? Constants.DOT_ALL : PYTHON_DOT;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return XID_CONTINUE;
    }

    @Override
    protected CodePointSet getIdStart() {
        return XID_START;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return 2;
    }

    @Override
    protected void caseFold(CodePointSetAccumulator charClass) {
        if (this.getLocalFlags().isLocale()) {
            this.getLocaleData().caseFold(charClass, this.caseFoldTmp);
        } else {
            CaseFoldTable.CaseFoldingAlgorithm caseFolding = this.getLocalFlags().isUnicode(this.mode) ? CaseFoldTable.CaseFoldingAlgorithm.PythonUnicode : CaseFoldTable.CaseFoldingAlgorithm.PythonAscii;
            CaseFoldTable.applyCaseFold(charClass, this.caseFoldTmp, caseFolding);
        }
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        if (this.getLocalFlags().isUnicode(this.mode)) {
            return UNICODE_CHAR_CLASS_SETS.get(Character.valueOf(c));
        }
        switch (c) {
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 's': {
                if (this.mode == PythonREMode.Bytes || this.getLocalFlags().isAscii()) {
                    return ASCII_WHITESPACE;
                }
                return Constants.WHITE_SPACE;
            }
            case 'S': {
                if (this.mode == PythonREMode.Bytes || this.getLocalFlags().isAscii()) {
                    return ASCII_NON_WHITESPACE;
                }
                return Constants.NON_WHITE_SPACE;
            }
            case 'w': {
                if (this.getLocalFlags().isLocale()) {
                    return this.getLocaleData().getWordCharacters();
                }
                return Constants.WORD_CHARS;
            }
            case 'W': {
                if (this.getLocalFlags().isLocale()) {
                    return this.getLocaleData().getNonWordCharacters();
                }
                return Constants.NON_WORD_CHARS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private RegexSyntaxException handleBadCharacterInGroupName(RegexLexer.ParseGroupNameResult result2) {
        return this.syntaxErrorAtRel(PyErrorMessages.badCharacterInGroupName(result2.groupName), result2.groupName.length() + 1);
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxErrorAtAbs("min repeat greater than max repeat", this.getLastTokenPosition() + 1);
    }

    @Override
    protected Token handleBoundedQuantifierSyntaxError() throws RegexSyntaxException {
        this.position = this.getLastTokenPosition() + 1;
        return this.charClass(123);
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int rangeStart) {
        return this.syntaxErrorAtAbs(PyErrorMessages.badCharacterRange(this.pattern.substring(rangeStart, this.position)), rangeStart);
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int rangeStart) {
        throw this.syntaxErrorAtAbs(PyErrorMessages.badCharacterRange(this.pattern.substring(rangeStart, this.position)), rangeStart);
    }

    @Override
    protected RegexSyntaxException handleEmptyGroupName() {
        return this.syntaxErrorHere("missing group name");
    }

    @Override
    protected RegexSyntaxException handleGroupRedefinition(String name, int newId, int oldId) {
        return this.syntaxErrorAtRel(PyErrorMessages.redefinitionOfGroupName(name, newId, oldId), name.length() + 1);
    }

    @Override
    protected void handleIncompleteEscapeX() {
        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + this.count(x$0 -> RegexLexer.isHexDigit(x$0)))));
    }

    @Override
    protected void handleInvalidBackReference(int reference) {
        String ref = Integer.toString(reference);
        throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(ref), ref.length());
    }

    @Override
    protected void handleInvalidBackReference(String reference) {
        throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(reference), reference.length());
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        this.retreat();
        return this.syntaxErrorAtAbs(PyErrorMessages.unknownExtensionQ(this.curChar()), this.getLastTokenPosition() + 1);
    }

    @Override
    protected void handleOctalOutOfRange() {
        throw this.syntaxError(PyErrorMessages.invalidOctalEscape(this.substring(4)));
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("bad escape (end of pattern)");
    }

    @Override
    protected void handleUnfinishedGroupComment() {
        throw this.syntaxError("missing ), unterminated comment");
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxErrorHere("unexpected end of pattern");
    }

    @Override
    protected void handleUnmatchedRightBrace() {
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxErrorAtAbs("unterminated character set", this.getLastTokenPosition());
    }

    @Override
    protected void handleUnmatchedRightBracket() {
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    @Override
    protected Token parseCustomEscape(char c) {
        if (PythonRegexLexer.isOctalDigit(c) && this.lookahead(x$0 -> RegexLexer.isOctalDigit(x$0), 2)) {
            int codePoint = (c - 48) * 64 + (this.consumeChar() - 48) * 8 + (this.consumeChar() - 48);
            if (codePoint > 255) {
                this.handleOctalOutOfRange();
            }
            return this.charClass(codePoint);
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 'a': {
                return 7;
            }
            case 'U': 
            case 'u': {
                if (this.mode == PythonREMode.Str) {
                    int escapeLength = switch (c) {
                        case 'u' -> 4;
                        case 'U' -> 8;
                        default -> throw CompilerDirectives.shouldNotReachHere();
                    };
                    int length2 = this.countUpTo(x$0 -> RegexLexer.isHexDigit(x$0), escapeLength);
                    if (length2 != escapeLength) {
                        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + length2)));
                    }
                    this.advance(length2);
                    try {
                        int codePoint = Integer.parseInt(this.pattern, this.position - length2, this.position, 16);
                        if (codePoint > 0x10FFFF) {
                            throw this.syntaxError(PyErrorMessages.invalidUnicodeEscape(this.substring(2 + length2)));
                        }
                        return codePoint;
                    }
                    catch (NumberFormatException e) {
                        throw this.syntaxError(PyErrorMessages.incompleteEscape(this.substring(2 + length2)));
                    }
                }
                throw this.syntaxError(PyErrorMessages.badEscape(c));
            }
            case 'N': {
                if (this.mode != PythonREMode.Str) {
                    throw this.syntaxError(PyErrorMessages.badEscape(c));
                }
                if (!this.consumingLookahead("{")) {
                    throw this.syntaxErrorHere(PyErrorMessages.missing("{"));
                }
                int nameStart = this.position;
                int nameEnd = this.pattern.indexOf(125, this.position);
                if (this.atEnd() || nameEnd == this.position) {
                    throw this.syntaxErrorHere(PyErrorMessages.missing("character name"));
                }
                if (nameEnd < 0) {
                    throw this.syntaxErrorHere(PyErrorMessages.missingUnterminatedName('}'));
                }
                String characterName = this.pattern.substring(nameStart, nameEnd);
                this.position = nameEnd + 1;
                int codePoint = PythonRegexLexer.lookupCharacterByName(characterName);
                if (codePoint == -1) {
                    throw this.syntaxError(PyErrorMessages.undefinedCharacterName(characterName));
                }
                return codePoint;
            }
        }
        return -1;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57) {
            throw this.syntaxError(PyErrorMessages.badEscape(c));
        }
        return c;
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        switch (charAfterQuestionMark) {
            case 'P': {
                this.mustHaveMore();
                char ch2 = this.consumeChar();
                switch (ch2) {
                    case '<': {
                        int pos = this.position;
                        RegexLexer.ParseGroupNameResult result2 = this.parseGroupName('>');
                        switch (result2.state) {
                            case empty: {
                                throw this.syntaxErrorHere("missing group name");
                            }
                            case unterminated: {
                                throw this.syntaxErrorAtAbs("missing >, unterminated name", pos);
                            }
                            case invalidStart: 
                            case invalidRest: {
                                throw this.handleBadCharacterInGroupName(result2);
                            }
                            case valid: {
                                this.registerNamedCaptureGroup(result2.groupName);
                                break;
                            }
                            default: {
                                throw CompilerDirectives.shouldNotReachHere();
                            }
                        }
                        return Token.createCaptureGroupBegin();
                    }
                    case '=': {
                        return this.parseNamedBackReference();
                    }
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownExtensionP(ch2), 3);
            }
            case '(': {
                return this.parseConditionalBackReference();
            }
            case '-': 
            case 'L': 
            case 'a': 
            case 'i': 
            case 'm': 
            case 's': 
            case 't': 
            case 'u': 
            case 'x': {
                return this.parseInlineFlags(charAfterQuestionMark);
            }
        }
        return null;
    }

    @Override
    protected Token parseGroupLt() {
        if (this.atEnd()) {
            throw this.syntaxErrorHere("unexpected end of pattern");
        }
        throw this.syntaxErrorAtAbs(PyErrorMessages.unknownExtensionLt(this.curChar()), this.getLastTokenPosition() + 1);
    }

    private Token parseConditionalBackReference() {
        boolean namedReference;
        int groupNumber;
        RegexLexer.ParseGroupNameResult result2 = this.parseGroupName(')');
        switch (result2.state) {
            case empty: {
                throw this.syntaxErrorHere("missing group name");
            }
            case unterminated: {
                throw this.syntaxErrorAtRel("missing ), unterminated name", result2.groupName.length());
            }
            case invalidStart: 
            case invalidRest: {
                this.position -= result2.groupName.length() + 1;
                assert (this.lookahead(result2.groupName + ")"));
                int groupNumberLength = this.countDecimalDigits();
                if (groupNumberLength != result2.groupName.length()) {
                    this.position += result2.groupName.length() + 1;
                    throw this.handleBadCharacterInGroupName(result2);
                }
                groupNumber = this.parseIntSaturated(0, result2.groupName.length(), -1);
                namedReference = false;
                assert (this.curChar() == ')');
                this.advance();
                if (groupNumber == 0) {
                    throw this.syntaxErrorAtRel("bad group number", result2.groupName.length() + 1);
                }
                if (groupNumber != -1) break;
                throw this.syntaxErrorAtRel(PyErrorMessages.invalidGroupReference(result2.groupName), result2.groupName.length() + 1);
            }
            case valid: {
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(result2.groupName)) {
                    groupNumber = (Integer)this.namedCaptureGroups.get(result2.groupName);
                    namedReference = true;
                    break;
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownGroupName(result2.groupName), result2.groupName.length() + 1);
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
        return Token.createConditionalBackReference(groupNumber, namedReference);
    }

    private Token parseInlineFlags(int ch0) {
        int ch = ch0;
        PythonFlags positiveFlags = PythonFlags.EMPTY_INSTANCE;
        while (PythonFlags.isValidFlagChar(ch)) {
            positiveFlags = this.addFlag(positiveFlags, ch);
            ch = this.consumeChar();
        }
        switch (ch) {
            case 41: {
                return Token.createInlineFlags(positiveFlags, true);
            }
            case 58: {
                if (positiveFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn on global flag", 1);
                }
                return this.parseLocalFlags(positiveFlags, PythonFlags.EMPTY_INSTANCE);
            }
            case 45: {
                if (positiveFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn on global flag", 1);
                }
                if (this.atEnd()) {
                    throw this.syntaxErrorHere("missing flag");
                }
                ch = this.consumeChar();
                if (!PythonFlags.isValidFlagChar(ch)) {
                    if (Character.isAlphabetic(ch)) {
                        throw this.syntaxErrorAtRel("unknown flag", 1);
                    }
                    throw this.syntaxErrorAtRel("missing flag", 1);
                }
                PythonFlags negativeFlags = PythonFlags.EMPTY_INSTANCE;
                while (PythonFlags.isValidFlagChar(ch)) {
                    negativeFlags = negativeFlags.addFlag(ch);
                    if (PythonFlags.isTypeFlagChar(ch)) {
                        throw this.syntaxErrorHere("bad inline flags: cannot turn off flags 'a', 'u' and 'L'");
                    }
                    if (this.atEnd()) {
                        throw this.syntaxErrorHere("missing :");
                    }
                    ch = this.consumeChar();
                }
                if (ch != 58) {
                    if (Character.isAlphabetic(ch)) {
                        throw this.syntaxErrorAtRel("unknown flag", 1);
                    }
                    throw this.syntaxErrorAtRel("missing :", 1);
                }
                if (negativeFlags.includesGlobalFlags()) {
                    throw this.syntaxErrorAtRel("bad inline flags: cannot turn off global flag", 1);
                }
                return this.parseLocalFlags(positiveFlags, negativeFlags);
            }
        }
        if (Character.isAlphabetic(ch)) {
            throw this.syntaxErrorAtRel("unknown flag", 1);
        }
        throw this.syntaxErrorAtRel("missing -, : or )", 1);
    }

    private PythonFlags addFlag(PythonFlags flagsArg, int ch) {
        PythonFlags flags = flagsArg.addFlag(ch);
        if (this.mode == PythonREMode.Str && ch == 76) {
            throw this.syntaxErrorHere("bad inline flags: cannot use 'L' flag with a str pattern");
        }
        if (this.mode == PythonREMode.Bytes && ch == 117) {
            throw this.syntaxErrorHere("bad inline flags: cannot use 'u' flag with a bytes pattern");
        }
        if (flags.numberOfTypeFlags() > 1) {
            throw this.syntaxErrorHere("bad inline flags: flags 'a', 'u' and 'L' are incompatible");
        }
        if (this.atEnd()) {
            throw this.syntaxErrorHere("missing -, : or )");
        }
        return flags;
    }

    private Token parseLocalFlags(PythonFlags positiveFlags, PythonFlags negativeFlags) {
        if (positiveFlags.overlaps(negativeFlags)) {
            throw this.syntaxErrorAtRel("bad inline flags: flag turned on and off", 1);
        }
        PythonFlags newFlags = this.getLocalFlags().addFlags(positiveFlags).delFlags(negativeFlags);
        if (positiveFlags.numberOfTypeFlags() > 0) {
            PythonFlags otherTypes = PythonFlags.TYPE_FLAGS_INSTANCE.delFlags(positiveFlags);
            newFlags = newFlags.delFlags(otherTypes);
        }
        this.flagsStack.push(newFlags);
        return Token.createInlineFlags(newFlags, false);
    }

    private void mustHaveMore() {
        if (this.atEnd()) {
            throw this.syntaxErrorHere("unexpected end of pattern");
        }
    }

    private Token parseNamedBackReference() {
        RegexLexer.ParseGroupNameResult result2 = this.parseGroupName(')');
        switch (result2.state) {
            case empty: {
                throw this.syntaxErrorHere("missing group name");
            }
            case unterminated: {
                throw this.syntaxErrorAtRel("missing ), unterminated name", result2.groupName.length());
            }
            case invalidStart: 
            case invalidRest: {
                throw this.handleBadCharacterInGroupName(result2);
            }
            case valid: {
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(result2.groupName)) {
                    return Token.createBackReference((Integer)this.namedCaptureGroups.get(result2.groupName), true);
                }
                throw this.syntaxErrorAtRel(PyErrorMessages.unknownGroupName(result2.groupName), result2.groupName.length() + 1);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private String substring(int length2) {
        return this.pattern.substring(this.getLastAtomPosition(), this.getLastAtomPosition() + length2);
    }

    public RegexSyntaxException syntaxErrorAtAbs(String msg, int i) {
        return RegexSyntaxException.createPattern(this.source, msg, i);
    }

    private RegexSyntaxException syntaxErrorAtRel(String msg, int i) {
        return RegexSyntaxException.createPattern(this.source, msg, this.position - i);
    }

    public RegexSyntaxException syntaxErrorHere(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.position);
    }

    static {
        PYTHON_DOT = CodePointSet.createNoDedup(0, 9, 11, 0x10FFFF);
        UNICODE_CHAR_CLASS_SETS = new HashMap<Character, CodePointSet>();
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('d'), UnicodeProperties.getProperty("General_Category=Decimal_Number"));
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('D'), UnicodeProperties.getProperty("General_Category=Decimal_Number").createInverse(Encodings.UTF_32));
        CodePointSet unicodeSpaces = UnicodeProperties.getProperty("White_Space");
        CodePointSet spaces = unicodeSpaces.union(CodePointSet.createNoDedup(28, 31));
        CodePointSet nonSpaces = spaces.createInverse(Encodings.UTF_32);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('s'), spaces);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('S'), nonSpaces);
        CodePointSet alpha = UnicodeProperties.getProperty("General_Category=Letter");
        CodePointSet numericExtras = CodePointSet.createNoDedup(63851, 63859, 63864, 63922, 63953, 63955, 63997, 194704);
        CodePointSet numeric = UnicodeProperties.getProperty("General_Category=Number").union(numericExtras);
        CodePointSet wordChars = alpha.union(numeric).union(CodePointSet.create(95));
        CodePointSet nonWordChars = wordChars.createInverse(Encodings.UTF_32);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('w'), wordChars);
        UNICODE_CHAR_CLASS_SETS.put(Character.valueOf('W'), nonWordChars);
    }
}

