/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator.diagnostic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002JJ\u0010\u0013\u001a\u00020\t\"\u000e\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0015*\u00060\u0010j\u0002`\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00140\u00172\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u001b\u001a\u00020\t*\u00060\u0010j\u0002`\u00112\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatisticsDumper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dumpStatistics", "", "chunkName", "", "exportStatistics", "Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;", "getPresentableStatistics", "appendPerIndexDirectorySizesStatistics", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendPerFileTypeStatistics", "appendKeyValues", "V", "", "data", "", "valueToString", "Lkotlin/Function1;", "appendPerIndexStatistics", "appendIndexStatistics", "indexId", "Lcom/intellij/util/indexing/ID;", "numberOfIndexedFiles", "", "isEmptyData", "", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexExportStatisticsDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexExportStatisticsDumper.kt\ncom/intellij/indexing/shared/generator/diagnostic/IndexExportStatisticsDumper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n477#2:115\n423#2:116\n477#2:121\n423#2:122\n477#2:127\n423#2:128\n1246#3,4:117\n1246#3,4:123\n1246#3,4:129\n1062#3:133\n1863#3,2:134\n1863#3,2:136\n1863#3,2:138\n14#4:140\n*S KotlinDebug\n*F\n+ 1 IndexExportStatisticsDumper.kt\ncom/intellij/indexing/shared/generator/diagnostic/IndexExportStatisticsDumper\n*L\n58#1:115\n58#1:116\n62#1:121\n62#1:122\n66#1:127\n66#1:128\n58#1:117,4\n62#1:123,4\n66#1:129,4\n70#1:133\n70#1:134,2\n85#1:136,2\n93#1:138,2\n14#1:140\n*E\n"})
public final class IndexExportStatisticsDumper {
    @NotNull
    public static final IndexExportStatisticsDumper INSTANCE = new IndexExportStatisticsDumper();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ObjectMapper jacksonMapper;

    private IndexExportStatisticsDumper() {
    }

    public final void dumpStatistics(@NotNull String chunkName, @NotNull IndexExportStatistics exportStatistics) {
        Intrinsics.checkNotNullParameter((Object)chunkName, (String)"chunkName");
        Intrinsics.checkNotNullParameter((Object)exportStatistics, (String)"exportStatistics");
        LOG.info("Statistics for " + chunkName + "\n" + this.getPresentableStatistics(exportStatistics));
        try {
            String timestamp = IndexDiagnosticDumperUtils.INSTANCE.getDiagnosticTimestampFormat().format(LocalDateTime.now());
            Path targetPath = IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir().resolve("shared-indexes-export-stats-" + timestamp + ".json");
            Path path = targetPath.getParent();
            if (path != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                v3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
            } else {
                v3 = null;
            }
            Intrinsics.checkNotNull((Object)targetPath);
            String string = jacksonMapper.writeValueAsString((Object)exportStatistics);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            PathsKt.writeText$default((Path)targetPath, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
        catch (Exception e) {
            LOG.error("Failed to dump exporter statistics", (Throwable)e);
        }
    }

    private final String getPresentableStatistics(IndexExportStatistics exportStatistics) {
        StringBuilder stringBuilder;
        StringBuilder $this$getPresentableStatistics_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$getPresentableStatistics_u24lambda_u240.append("Shared index generation statistics");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$getPresentableStatistics_u24lambda_u240.append("Indexing time " + StringUtil.formatDuration((long)exportStatistics.getIndexingTimeMs().get()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$getPresentableStatistics_u24lambda_u240.append("Total time " + StringUtil.formatDuration((long)exportStatistics.getTotalTimeMs().get()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$getPresentableStatistics_u24lambda_u240.append("Index size " + StringUtil.formatFileSize((long)exportStatistics.getIndexSizeBytes().get()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$getPresentableStatistics_u24lambda_u240.append("Total number of indexed files: " + exportStatistics.getTotalNumberOfIndexedFiles());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$getPresentableStatistics_u24lambda_u240.append("Total size of indexed files: " + StringUtil.formatFileSize((long)exportStatistics.getTotalSizeOfIndexedFiles().get()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getPresentableStatistics_u24lambda_u240.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = $this$getPresentableStatistics_u24lambda_u240.append("Per file type statistics");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        INSTANCE.appendPerFileTypeStatistics($this$getPresentableStatistics_u24lambda_u240, exportStatistics);
        Intrinsics.checkNotNullExpressionValue((Object)$this$getPresentableStatistics_u24lambda_u240.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder9 = $this$getPresentableStatistics_u24lambda_u240.append("Per index directories sizes statistics");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        INSTANCE.appendPerIndexDirectorySizesStatistics($this$getPresentableStatistics_u24lambda_u240, exportStatistics);
        Intrinsics.checkNotNullExpressionValue((Object)$this$getPresentableStatistics_u24lambda_u240.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder10 = $this$getPresentableStatistics_u24lambda_u240.append("Per index data statistics");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        INSTANCE.appendPerIndexStatistics($this$getPresentableStatistics_u24lambda_u240, exportStatistics);
        Intrinsics.checkNotNullExpressionValue((Object)$this$getPresentableStatistics_u24lambda_u240.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendPerIndexDirectorySizesStatistics(StringBuilder $this$appendPerIndexDirectorySizesStatistics, IndexExportStatistics exportStatistics) {
        String string;
        Map.Entry it$iv$iv;
        boolean bl;
        Map map;
        Object it;
        Map map2;
        Map.Entry entry;
        Map $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        StringBuilder stringBuilder = $this$appendPerIndexDirectorySizesStatistics.append("Sizes of file based indexes: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Map map3 = exportStatistics.getFbIndexToDirectorySize();
        StringBuilder stringBuilder2 = $this$appendPerIndexDirectorySizesStatistics;
        IndexExportStatisticsDumper indexExportStatisticsDumper = this;
        boolean $i$f$mapKeys = false;
        void var5_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ID)it.getKey()).getName(), (String)"getName(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            map = map2;
            bl = false;
            it = it$iv$iv.getValue();
            map.put(string, it);
        }
        map2 = destination$iv$iv;
        indexExportStatisticsDumper.appendKeyValues(stringBuilder2, map2, IndexExportStatisticsDumper::appendPerIndexDirectorySizesStatistics$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendPerIndexDirectorySizesStatistics.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$appendPerIndexDirectorySizesStatistics.append("Sizes of stub indexes: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        $this$mapKeys$iv = exportStatistics.getStubIndexToDirectorySize();
        stringBuilder2 = $this$appendPerIndexDirectorySizesStatistics;
        indexExportStatisticsDumper = this;
        $i$f$mapKeys = false;
        $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((ID)it.getKey()).getName(), (String)"getName(...)");
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map = map2;
            bl = false;
            entry = it$iv$iv.getValue();
            map.put(string, entry);
        }
        map2 = destination$iv$iv;
        indexExportStatisticsDumper.appendKeyValues(stringBuilder2, map2, IndexExportStatisticsDumper::appendPerIndexDirectorySizesStatistics$lambda$4);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendPerFileTypeStatistics(StringBuilder $this$appendPerFileTypeStatistics, IndexExportStatistics exportStatistics) {
        Map map;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map2 = exportStatistics.getFileTypeToNumberOfIndexedFiles();
        StringBuilder stringBuilder = $this$appendPerFileTypeStatistics;
        IndexExportStatisticsDumper indexExportStatisticsDumper = this;
        boolean $i$f$mapKeys = false;
        void var5_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((FileType)it.getKey()).getName(), (String)"getName(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = map;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string, entry);
        }
        map = destination$iv$iv;
        IndexExportStatisticsDumper.appendKeyValues$default(indexExportStatisticsDumper, stringBuilder, map, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final <V extends Comparable<? super V>> void appendKeyValues(StringBuilder $this$appendKeyValues, Map<String, ? extends V> data, Function1<? super V, String> valueToString) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv = data.entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            StringBuilder stringBuilder = $this$appendKeyValues.append("    " + key + ": " + valueToString.invoke((Object)value));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
    }

    static /* synthetic */ void appendKeyValues$default(IndexExportStatisticsDumper indexExportStatisticsDumper, StringBuilder stringBuilder, Map map, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = IndexExportStatisticsDumper::appendKeyValues$lambda$6;
        }
        indexExportStatisticsDumper.appendKeyValues(stringBuilder, map, function1);
    }

    private final void appendPerIndexStatistics(StringBuilder $this$appendPerIndexStatistics, IndexExportStatistics exportStatistics) {
        Integer filesNumber;
        ID indexId;
        Map.Entry entry;
        Iterable $this$forEach$iv;
        StringBuilder stringBuilder = $this$appendPerIndexStatistics.append("File based indices (" + exportStatistics.getFbIndexToNumberOfIndexedFiles().size() + "): ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getValue()));
            }
        };
        Comparator comparator = ((Comparator)new Comparator((Comparator)object, exportStatistics){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ IndexExportStatistics $exportStatistics$inlined;
            {
                this.$this_thenBy = $receiver;
                this.$exportStatistics$inlined = indexExportStatistics;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = IndexExportStatisticsDumper.access$appendPerIndexStatistics$isEmpty(this.$exportStatistics$inlined, (ID)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(IndexExportStatisticsDumper.access$appendPerIndexStatistics$isEmpty(this.$exportStatistics$inlined, (ID)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1)));
                }
                return n;
            }
        }).reversed();
        Iterable iterable = exportStatistics.getFbIndexToNumberOfIndexedFiles().entrySet();
        Intrinsics.checkNotNull(comparator);
        object = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            indexId = (ID)entry.getKey();
            filesNumber = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)indexId);
            Intrinsics.checkNotNull((Object)filesNumber);
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, indexId, filesNumber, IndexExportStatisticsDumper.appendPerIndexStatistics$isEmpty(exportStatistics, indexId));
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendPerIndexStatistics.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = $this$appendPerIndexStatistics.append("Stub indices (" + exportStatistics.getStubIndexToNumberOfIndexedFiles().size() + "): ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)exportStatistics.getStubIndexToNumberOfIndexedFiles().entrySet(), comparator);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Map.Entry)element$iv;
            boolean bl = false;
            indexId = (ID)entry.getKey();
            filesNumber = (Integer)entry.getValue();
            Intrinsics.checkNotNull((Object)indexId);
            Intrinsics.checkNotNull((Object)filesNumber);
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, indexId, filesNumber, IndexExportStatisticsDumper.appendPerIndexStatistics$isEmpty(exportStatistics, indexId));
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendPerIndexStatistics.append('\n'), (String)"append(...)");
    }

    private final void appendIndexStatistics(StringBuilder $this$appendIndexStatistics, ID<?, ?> indexId, int numberOfIndexedFiles, boolean isEmptyData) {
        $this$appendIndexStatistics.append("    ").append("Generator for ").append(indexId).append(" indexed ").append(numberOfIndexedFiles).append(" files");
        if (isEmptyData) {
            $this$appendIndexStatistics.append(" (empty indexed data)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendIndexStatistics.append('\n'), (String)"append(...)");
    }

    private static final String appendPerIndexDirectorySizesStatistics$lambda$2(Long size) {
        Intrinsics.checkNotNull((Object)size);
        String string = StringUtil.formatFileSize((long)size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        return string;
    }

    private static final String appendPerIndexDirectorySizesStatistics$lambda$4(Long size) {
        Intrinsics.checkNotNull((Object)size);
        String string = StringUtil.formatFileSize((long)size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        return string;
    }

    private static final String appendKeyValues$lambda$6(Comparable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final boolean appendPerIndexStatistics$isEmpty(IndexExportStatistics $exportStatistics, ID<?, ?> indexId) {
        return $exportStatistics.getEmptyFbiIndexes().contains(indexId) || $exportStatistics.getEmptyStubIndexes().contains(indexId);
    }

    public static final /* synthetic */ boolean access$appendPerIndexStatistics$isEmpty(IndexExportStatistics $exportStatistics, ID indexId) {
        return IndexExportStatisticsDumper.appendPerIndexStatistics$isEmpty($exportStatistics, indexId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexExportStatisticsDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        jacksonMapper = ExtensionsKt.jacksonObjectMapper();
    }
}

