/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.google.common.collect.Maps;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.settings.NodeInstalledPackage;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeInstalledPackagesProvider {
    private static final NodeInstalledPackagesProvider INSTANCE = new NodeInstalledPackagesProvider();
    private static final String[] FILE_EXTENSIONS = new String[]{".js", ".coffee", ".json", ".node"};

    @NotNull
    public static NodeInstalledPackagesProvider getInstance() {
        NodeInstalledPackagesProvider nodeInstalledPackagesProvider = INSTANCE;
        if (nodeInstalledPackagesProvider == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(0);
        }
        return nodeInstalledPackagesProvider;
    }

    @NotNull
    public Collection<NodeInstalledPackage> listInstalledPackages(@Nullable File currentDir, @Nullable NodeJsLocalInterpreter interpreter2) {
        HashMap packageByNameMap = Maps.newHashMap();
        if (currentDir != null) {
            NodeInstalledPackagesProvider.addPackagesFromNodeModulesDir(packageByNameMap, currentDir);
        }
        if (interpreter2 != null) {
            NodeInstalledPackagesProvider.addGloballyInstalledPackages(packageByNameMap, interpreter2);
        }
        Collection<NodeInstalledPackage> collection = packageByNameMap.values();
        if (collection == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static void addGloballyInstalledPackages(@NotNull Map<String, NodeInstalledPackage> packageByNameMap, @NotNull NodeJsLocalInterpreter interpreter2) {
        VirtualFile dir;
        if (packageByNameMap == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(2);
        }
        if (interpreter2 == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(3);
        }
        if ((dir = interpreter2.getGlobalNodeModulesVirtualDir()) != null && dir.isValid()) {
            File ioDir = new File(dir.getPath());
            NodeInstalledPackagesProvider.addPackagesFromDirectory(ioDir, packageByNameMap, true, null);
        }
    }

    private static void addPackagesFromNodeModulesDir(@NotNull Map<String, NodeInstalledPackage> packageByNameMap, @NotNull File currentDir) {
        File nodeModulesDir;
        if (packageByNameMap == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(4);
        }
        if (currentDir == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(5);
        }
        if ((nodeModulesDir = new File(currentDir, "node_modules")).isDirectory()) {
            File packageJsonIoFile = new File(currentDir, "package.json");
            VirtualFile packageJsonFile = packageJsonIoFile.isFile() ? LocalFileSystem.getInstance().findFileByIoFile(packageJsonIoFile) : null;
            PackageJsonData data = packageJsonFile != null ? PackageJsonData.getOrCreate(packageJsonFile) : null;
            NodeInstalledPackagesProvider.addPackagesFromDirectory(nodeModulesDir, packageByNameMap, false, data);
        }
    }

    private static void addPackagesFromDirectory(@NotNull File dir, @NotNull Map<String, NodeInstalledPackage> packageByNameMap, boolean global, @Nullable PackageJsonData data) {
        File[] children;
        if (dir == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(6);
        }
        if (packageByNameMap == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(7);
        }
        for (File child : children = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY)) {
            File[] grandChildren;
            if (!child.isDirectory()) continue;
            NodeInstalledPackagesProvider.tryAdd(child, child.getName(), packageByNameMap, global, data);
            if (!child.getName().startsWith("@")) continue;
            for (File grandChild : grandChildren = (File[])ObjectUtils.notNull((Object)child.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY)) {
                NodeInstalledPackagesProvider.tryAdd(grandChild, child.getName() + "/" + grandChild.getName(), packageByNameMap, global, data);
            }
        }
    }

    private static void tryAdd(@NotNull File dir, @NotNull String packageName, @NotNull Map<String, NodeInstalledPackage> packageByNameMap, boolean global, @Nullable PackageJsonData data) {
        if (dir == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(8);
        }
        if (packageName == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(9);
        }
        if (packageByNameMap == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(10);
        }
        if (NodeInstalledPackagesProvider.canLoadDirectory(dir) && (data == null || data.isDependencyOfAnyType(packageName)) && !packageByNameMap.containsKey(packageName)) {
            SemVer semVer = NodePackageVersionUtil.getPackageVersion(dir.toPath());
            String rawVersion = semVer != null ? semVer.getRawVersion() : null;
            packageByNameMap.put(packageName, new NodeInstalledPackage(packageName, rawVersion, dir, global));
        }
    }

    private static boolean canLoadDirectory(@NotNull File dir) {
        if (dir == null) {
            NodeInstalledPackagesProvider.$$$reportNull$$$0(11);
        }
        if (NodePackageUtil.validateNpmPackageName(dir.getName()) != null) {
            return false;
        }
        File packageJson = new File(dir, "package.json");
        if (packageJson.isFile()) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS) {
            File file = new File(dir, "index" + ext);
            if (!file.isFile()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeInstalledPackagesProvider";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageByNameMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDir";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listInstalledPackages";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeInstalledPackagesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addGloballyInstalledPackages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesFromNodeModulesDir";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesFromDirectory";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryAdd";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canLoadDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

