/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSLinterPackage {
    private static final String PACKAGE = "node.js.selected.package.";
    private static final String AUTODETECT_STORED_VALUE = "(autodetect)";
    private static final String PACKAGE_DETECTED = "node.js.detected.package.";
    @TestOnly
    public static final Key<String> TEST_DEFAULT_NPM_PACKAGE = Key.create((String)"JavaScript.Npm.Default.Npm.Package");
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myPackageName;
    private final boolean mySupportsAutodetect;
    private final NodePackageDescriptor myPackageDescriptor;
    @NotNull
    private NodePackageRef myNodePackage;
    @NotNull
    private final String myPackageKey;

    public JSLinterPackage(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            JSLinterPackage.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            JSLinterPackage.$$$reportNull$$$0(1);
        }
        this(project, packageName, false);
    }

    public JSLinterPackage(@NotNull Project project, @NotNull String packageName, boolean supportsAutodetect) {
        if (project == null) {
            JSLinterPackage.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            JSLinterPackage.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myPackageName = packageName;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myPackageKey = PACKAGE + this.myPackageName;
        this.mySupportsAutodetect = supportsAutodetect;
        this.myPackageDescriptor = new NodePackageDescriptor(packageName);
        this.myNodePackage = supportsAutodetect ? AutodetectLinterPackage.INSTANCE : NodePackageRef.create(this.myPackageDescriptor.createPackage(""));
    }

    @Deprecated(forRemoval=true)
    public void force(@Nullable NodeJsInterpreterRef interpreter2, @NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            JSLinterPackage.$$$reportNull$$$0(4);
        }
        this.force(NodePackageRef.create(nodePackage));
    }

    @Deprecated(forRemoval=true)
    public void force(@Nullable NodeJsInterpreterRef interpreter2, @NotNull NodePackageRef nodePackageRef) {
        if (nodePackageRef == null) {
            JSLinterPackage.$$$reportNull$$$0(5);
        }
        this.force(nodePackageRef);
    }

    public void force(@NotNull NodePackageRef nodePackageRef) {
        if (nodePackageRef == null) {
            JSLinterPackage.$$$reportNull$$$0(6);
        }
        String packageValue = nodePackageRef == AutodetectLinterPackage.INSTANCE ? AUTODETECT_STORED_VALUE : nodePackageRef.getIdentifier();
        this.myPropertiesComponent.setValue(this.myPackageKey, packageValue);
        this.myNodePackage = nodePackageRef;
    }

    public void readOrDetect() {
        this.force(this.readOrDetectPackage());
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreter() {
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        if (nodeJsInterpreterRef == null) {
            JSLinterPackage.$$$reportNull$$$0(7);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodePackageRef getPackage() {
        NodePackageRef nodePackageRef = this.myNodePackage;
        if (nodePackageRef == null) {
            JSLinterPackage.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    @NotNull
    private NodePackageRef readOrDetectPackage() {
        String packagePath = this.myPropertiesComponent.getValue(this.myPackageKey, "");
        if (StringUtil.equals((CharSequence)packagePath, (CharSequence)AUTODETECT_STORED_VALUE)) {
            NodePackageRef nodePackageRef = AutodetectLinterPackage.INSTANCE;
            if (nodePackageRef == null) {
                JSLinterPackage.$$$reportNull$$$0(9);
            }
            return nodePackageRef;
        }
        boolean detected = this.myPropertiesComponent.getBoolean(PACKAGE_DETECTED + this.myPackageName);
        if (StringUtil.isEmptyOrSpaces((String)packagePath) || !this.myProject.isDefault() && !detected) {
            if (this.mySupportsAutodetect) {
                if (!this.myProject.isDefault()) {
                    this.myPropertiesComponent.setValue(PACKAGE_DETECTED + this.myPackageName, true);
                }
                NodePackageRef nodePackageRef = AutodetectLinterPackage.INSTANCE;
                if (nodePackageRef == null) {
                    JSLinterPackage.$$$reportNull$$$0(10);
                }
                return nodePackageRef;
            }
            NodePackage pkg = this.myPackageDescriptor.findUnambiguousDependencyPackage(this.myProject);
            if (pkg == null && (pkg = this.findDefaultPackage()) == null) {
                pkg = this.myPackageDescriptor.createPackage(packagePath);
            }
            if (!this.myProject.isDefault()) {
                this.myPropertiesComponent.setValue(PACKAGE_DETECTED + this.myPackageName, true);
            }
            NodePackageRef nodePackageRef = NodePackageRef.create(pkg);
            if (nodePackageRef == null) {
                JSLinterPackage.$$$reportNull$$$0(11);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(this.myPackageDescriptor.createPackage(packagePath));
        if (nodePackageRef == null) {
            JSLinterPackage.$$$reportNull$$$0(12);
        }
        return nodePackageRef;
    }

    @Nullable
    private NodePackage findDefaultPackage() {
        String testPath;
        NodePackage pkg = ApplicationManager.getApplication().isUnitTestMode() && (testPath = (String)this.myProject.getUserData(TEST_DEFAULT_NPM_PACKAGE)) != null ? (StringUtil.isEmptyOrSpaces((String)testPath) ? null : this.myPackageDescriptor.createPackage(testPath)) : NodePackage.findDefaultPackage(this.myProject, this.myPackageName, NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter());
        return pkg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRef";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/JSLinterPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/JSLinterPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readOrDetectPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "force";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

