/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestNamePattern {
    private static final Logger LOG = Logger.getInstance(JSTestNamePattern.class);
    private final List<Range> myRanges;
    private AtomicReference<Pattern> myPatternRef;

    public JSTestNamePattern(@NotNull List<Range> ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(0);
        }
        this.myRanges = ImmutableList.copyOf(ranges);
    }

    @NotNull
    public List<Range> getRanges() {
        List<Range> list = this.myRanges;
        if (list == null) {
            JSTestNamePattern.$$$reportNull$$$0(1);
        }
        return list;
    }

    public String toString() {
        return this.myRanges.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSTestNamePattern that = (JSTestNamePattern)o;
        return this.myRanges.equals(that.myRanges);
    }

    public int hashCode() {
        return this.myRanges.hashCode();
    }

    public boolean matches(@NotNull String text) {
        Pattern pattern;
        if (text == null) {
            JSTestNamePattern.$$$reportNull$$$0(2);
        }
        return (pattern = this.getPattern()) != null && pattern.matcher(text).matches();
    }

    @Nullable
    public Literal getSingleLiteralRange() {
        return this.myRanges.size() == 1 ? (Literal)ObjectUtils.tryCast((Object)this.myRanges.get(0), Literal.class) : null;
    }

    @Nullable
    private Pattern getPattern() {
        AtomicReference<Pattern> patternRef = this.myPatternRef;
        if (patternRef == null) {
            this.myPatternRef = patternRef = new AtomicReference<Pattern>(this.createPattern());
        }
        return patternRef.get();
    }

    @Nullable
    private Pattern createPattern() {
        String patternStr = this.myRanges.stream().map(r -> r.getJavaPattern()).collect(Collectors.joining());
        try {
            return Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException e) {
            LOG.info("Cannot create pattern from " + patternStr, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static JSTestNamePattern literalPattern(@NotNull String name) {
        if (name == null) {
            JSTestNamePattern.$$$reportNull$$$0(3);
        }
        return new JSTestNamePattern(Collections.singletonList(new Literal(name)));
    }

    @NotNull
    public static List<JSTestNamePattern> toLiteralList(@NotNull List<String> names) {
        if (names == null) {
            JSTestNamePattern.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.map(names, s -> JSTestNamePattern.literalPattern(s));
        if (list == null) {
            JSTestNamePattern.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static JSTestNamePattern normalizeAndCreate(@NotNull List<Range> ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(6);
        }
        ArrayList<Range> result2 = new ArrayList<Range>();
        Literal currentLiteralRange = null;
        AnyText currentAnyRange = null;
        for (Range range : ranges) {
            if (range instanceof Literal) {
                Literal literalRange = (Literal)range;
                currentLiteralRange = currentLiteralRange != null ? new Literal(currentLiteralRange.getLiteral() + literalRange.getLiteral()) : literalRange;
                ContainerUtil.addIfNotNull(result2, (Object)currentAnyRange);
                currentAnyRange = null;
                continue;
            }
            AnyText anyRange = (AnyText)range;
            currentAnyRange = currentAnyRange != null ? new AnyText(currentAnyRange.myDebugPattern + "+" + anyRange.myDebugPattern) : anyRange;
            if (currentLiteralRange != null && !currentLiteralRange.getLiteral().isEmpty()) {
                result2.add(currentLiteralRange);
            }
            currentLiteralRange = null;
        }
        ContainerUtil.addIfNotNull(result2, currentAnyRange);
        if (currentLiteralRange != null && !currentLiteralRange.getLiteral().isEmpty()) {
            result2.add(currentLiteralRange);
        }
        return new JSTestNamePattern(result2);
    }

    @NotNull
    public static JSTestNamePattern pattern(Range ... ranges) {
        if (ranges == null) {
            JSTestNamePattern.$$$reportNull$$$0(7);
        }
        return new JSTestNamePattern(Arrays.asList(ranges));
    }

    @NotNull
    public static Literal literalRange(@NotNull String name) {
        if (name == null) {
            JSTestNamePattern.$$$reportNull$$$0(8);
        }
        return new Literal(name);
    }

    @NotNull
    public static AnyText anyRange(@NotNull String debugPattern) {
        if (debugPattern == null) {
            JSTestNamePattern.$$$reportNull$$$0(9);
        }
        return new AnyText(debugPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JSTestNamePattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JSTestNamePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toLiteralList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "literalPattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toLiteralList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndCreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pattern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "literalRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "anyRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    public static class Literal
    implements Range {
        private final String myLiteral;

        public Literal(@NotNull String literal) {
            if (literal == null) {
                Literal.$$$reportNull$$$0(0);
            }
            this.myLiteral = literal;
        }

        @NotNull
        public String getLiteral() {
            String string = this.myLiteral;
            if (string == null) {
                Literal.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Literal literal = (Literal)o;
            return this.myLiteral.equals(literal.myLiteral);
        }

        public int hashCode() {
            return Objects.hash(this.myLiteral);
        }

        public String toString() {
            return "literal(" + this.myLiteral + ")";
        }

        @Override
        @NotNull
        public String getJavaPattern() {
            String string = Pattern.quote(this.myLiteral);
            if (string == null) {
                Literal.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/util/JSTestNamePattern$Literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/util/JSTestNamePattern$Literal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLiteral";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavaPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Range {
        @NotNull
        public String getJavaPattern();
    }

    public static class AnyText
    implements Range {
        private final String myDebugPattern;

        public AnyText(@NotNull String debugPattern) {
            if (debugPattern == null) {
                AnyText.$$$reportNull$$$0(0);
            }
            this.myDebugPattern = debugPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnyText text = (AnyText)o;
            return this.myDebugPattern.equals(text.myDebugPattern);
        }

        public int hashCode() {
            return Objects.hash(this.myDebugPattern);
        }

        public String toString() {
            return "any(" + this.myDebugPattern + ")";
        }

        @Override
        @NotNull
        public String getJavaPattern() {
            return ".*";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugPattern", "com/intellij/javascript/testFramework/util/JSTestNamePattern$AnyText", "<init>"));
        }
    }
}

