/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.actions;

import com.intellij.lang.ecmascript6.actions.JSImportDescriptorBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutorBase;
import com.intellij.lang.javascript.modules.imports.JSCompositeImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

public class ES6AddImportExecutor
extends JSAddImportExecutorBase {
    private static final Logger LOGGER = Logger.getInstance(ES6AddImportExecutor.class);

    public ES6AddImportExecutor(@NotNull PsiElement place) {
        if (place == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(0);
        }
        super(place);
    }

    @Deprecated
    public void execute(@NotNull String importedName, @NotNull JSElement elementToImport) {
        JSImportDescriptor descriptor;
        if (importedName == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(2);
        }
        if ((descriptor = new JSImportDescriptorBuilder(this.getPlace()).createDescriptor(importedName, (PsiElement)elementToImport, JSImportPlaceInfo.ImportContext.SIMPLE)) == null) {
            return;
        }
        this.createImportOrUpdateExisting(descriptor);
    }

    @Override
    protected void createImportOrUpdateExistingInner(@NotNull JSImportDescriptor descriptor) {
        if (descriptor == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(3);
        }
        JSImportExportType type = descriptor.getImportType();
        PsiElement place = this.getPlace();
        if (type.isComposite()) {
            if (descriptor instanceof JSCompositeImportDescriptor && DialectDetector.isTypeScript(place)) {
                for (JSImportDescriptor nested : ((JSCompositeImportDescriptor)descriptor).getDescriptors()) {
                    this.createImportOrUpdateExisting(nested);
                }
            }
            return;
        }
        PsiElement scope2 = this.prepareScopeToAdd(place, !type.isNamespace());
        if (scope2 == null) {
            return;
        }
        if (this.tryToUseExistingImport(descriptor, scope2)) {
            this.postProcessScope(place, descriptor, scope2);
            return;
        }
        if (scope2 instanceof XmlFile) {
            LOGGER.error("Trying to insert import to plain XmlFile");
            return;
        }
        PsiElement importPsi = ES6AddImportExecutor.createTypeScriptOrES6Import(descriptor, scope2);
        if (importPsi instanceof ES6ImportDeclaration && !type.isBare()) {
            ES6CreateImportUtil.findPlaceAndInsertES6Import(scope2, importPsi, descriptor.getModuleName(), null);
        } else {
            ES6CreateImportUtil.findPlaceAndInsertAnyImport(scope2, importPsi);
        }
        this.postProcessScope(place, descriptor, scope2);
    }

    protected void postProcessScope(@NotNull PsiElement place, @NotNull JSImportDescriptor info, @NotNull PsiElement scope2) {
        if (place == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(4);
        }
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    private static PsiElement createTypeScriptOrES6Import(@NotNull JSImportDescriptor info, @NotNull PsiElement scope2) {
        if (info == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(7);
        }
        if (scope2 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(8);
        }
        JSSourceElement jSSourceElement = ES6ImportPsiUtil.createImportOrExport(scope2, info);
        if (jSSourceElement == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(9);
        }
        return jSSourceElement;
    }

    private boolean tryToUseExistingImport(@NotNull JSImportDescriptor descriptor, @NotNull PsiElement scope2) {
        ES6ImportExportDeclaration grandParent;
        PsiElement place;
        PsiElement parent;
        if (descriptor == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = parent = (place = this.getPlace()) instanceof ES6ImportExportDeclarationPart ? place : place.getParent();
        if (parent instanceof ES6ImportExportDeclarationPart && (grandParent = ((ES6ImportExportDeclarationPart)parent).getDeclaration()) instanceof ES6ImportDeclaration && grandParent.getFromClause() == null) {
            String quote = JSCodeStyleSettings.getQuote(scope2);
            String name = quote + descriptor.getModuleName() + quote;
            if (parent instanceof ES6ImportSpecifier || parent instanceof ES6ImportedBinding && descriptor.getImportType() == ES6ImportPsiUtil.ImportExportType.DEFAULT) {
                ES6CreateImportUtil.insertFromClause((ES6ImportExportDeclarationPart)parent, grandParent, name);
                return true;
            }
            PsiElement newImport = ES6AddImportExecutor.createTypeScriptOrES6Import(descriptor, scope2);
            WriteCommandAction.writeCommandAction((Project)grandParent.getProject(), (PsiFile[])new PsiFile[]{grandParent.getContainingFile()}).withName(JavaScriptBundle.message("add.import.specifier.to.import", new Object[0])).run(() -> grandParent.replace(newImport));
            return true;
        }
        JSImportExportType importType = descriptor.getImportType();
        if (JSCodeStyleSettings.isMergeImports(place) && importType.isES6()) {
            ES6ImportDeclaration possibleImport = ES6ImportPsiUtil.findExistingES6Import(scope2, descriptor);
            return possibleImport != null && ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(possibleImport, descriptor);
        }
        return false;
    }

    @Override
    @NotNull
    public String getImportStatementText(@NotNull JSImportDescriptor descriptor) {
        if (descriptor == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(12);
        }
        if (descriptor instanceof JSCompositeImportDescriptor) {
            String join = StringUtil.join(((JSCompositeImportDescriptor)descriptor).getDescriptors(), el -> "\"" + el.getModuleName() + "\"", (String)", ");
            String string = "import " + descriptor.getEffectiveName() + " (" + join + ")";
            if (string == null) {
                ES6AddImportExecutor.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = ES6ImportPsiUtil.createImportOrExportText(this.getPlace(), descriptor, false);
        if (string == null) {
            ES6AddImportExecutor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/actions/ES6AddImportExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/actions/ES6AddImportExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeScriptOrES6Import";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrUpdateExistingInner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "postProcessScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptOrES6Import";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToUseExistingImport";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getImportStatementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13, 14 -> new IllegalStateException(string);
        };
    }
}

