/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfig;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerNotifier;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerStampedConfig;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J6\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J \u0010$\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J(\u0010%\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H$J\u0012\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\n\u0010+\u001a\u0004\u0018\u00010!H\u0002J \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-*\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0014\u0010.\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00060"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "bundlerId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "marker", "getMarker", "()Ljava/lang/String;", "loadConfig", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerStampedConfig;", "configPath", "timestamp", "", "workingDir", "parseJsonResult", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "result", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "showErrorNotification", "", "output", "Lcom/intellij/execution/process/ProcessOutput;", "getErrorMessage", "getErrorDetails", "run", "Lkotlin/Pair;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "path", "explicitWorkingDir", "createTargetRun", "configureCommandLine", "isESM", "", "getWorkingDir", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInterpreter", "convertPathsToLocal", "", "convertPathToLocal", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerConfigExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigExecutor.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n61#2,5:189\n14#2:198\n1557#3:194\n1628#3,3:195\n*S KotlinDebug\n*F\n+ 1 WebBundlerConfigExecutor.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor\n*L\n52#1:189,5\n169#1:198\n148#1:194\n148#1:195,3\n*E\n"})
public abstract class WebBundlerConfigExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String bundlerId;
    @NotNull
    private final String marker;
    @NotNull
    public static final String EXECUTION_TIMEOUT_KEY = "webpack.execution.timeout.ms";
    public static final int VERSION = 9;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ERROR_REGEX;

    public WebBundlerConfigExecutor(@NotNull Project project, @NotNull String bundlerId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)bundlerId, (String)"bundlerId");
        this.project = project;
        this.bundlerId = bundlerId;
        this.marker = "!!!" + ApplicationNamesInfo.getInstance().getFullProductName() + " bundler loader!!!";
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getMarker() {
        return this.marker;
    }

    @NotNull
    public final WebBundlerStampedConfig loadConfig(@NotNull String configPath, long timestamp, @Nullable String workingDir) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        if (((CharSequence)configPath).length() == 0) {
            LOG.warn("Empty path provided to " + this.bundlerId + " executor");
            return new WebBundlerStampedConfig(null, 0L, 9, null, null, this.bundlerId, 27, null);
        }
        NodeJsInterpreter interpreter2 = this.getInterpreter();
        if (interpreter2 == null) {
            Object[] objectArray = new Object[]{PathUtil.getFileName((String)configPath)};
            String string = JavaScriptBundle.message("web.bundler.failed.to.load", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
            WebBundlerNotifier.INSTANCE.notify(this.project, string, messageType, configPath, this.bundlerId, NodeSettingsConfigurable.createConfigureInterpreterAction(this.project, null));
            return new WebBundlerStampedConfig(null, 0L, 9, configPath, workingDir, this.bundlerId, 3, null);
        }
        Pair pair = (Pair)NodeProgressUtil.withInvisibleProgress(() -> WebBundlerConfigExecutor.loadConfig$lambda$0(this, interpreter2, configPath, workingDir));
        NodeTargetRun targetRun = (NodeTargetRun)pair.component1();
        ProcessOutput run = (ProcessOutput)pair.component2();
        if (run.getExitCode() == 0) {
            String string;
            String string2 = run.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String stdOut = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("stdout: " + stdOut + "\nstderr: " + run.getStderr(), e$iv);
            }
            int lastNewLine = StringsKt.lastIndexOf$default((CharSequence)stdOut, (String)this.marker, (int)0, (boolean)false, (int)6, null);
            int startIndex = lastNewLine + this.marker.length() + 1;
            if (lastNewLine >= 0 && stdOut.length() >= startIndex) {
                String string3 = stdOut.substring(startIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = stdOut;
            }
            String result2 = string;
            try {
                WebBundlerConfig config = this.parseJsonResult(result2, targetRun);
                return new WebBundlerStampedConfig(config, timestamp, 9, configPath, workingDir, this.bundlerId);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage() + "\nstdout: " + run.getStdout() + "\nstderr: " + run.getStderr(), (Throwable)e);
                this.showErrorNotification(configPath, run);
                return new WebBundlerStampedConfig(new WebBundlerConfig(null, null, 3, null), timestamp, 9, configPath, workingDir, this.bundlerId);
            }
        }
        LOG.warn("Failed to evaluate " + this.bundlerId + " config. exit code: " + run.getExitCode() + (run.isTimeout() ? ", timed out" : "") + "\nstdout: " + run.getStdout() + "\nstderr: " + run.getStderr());
        this.showErrorNotification(configPath, run);
        return new WebBundlerStampedConfig(new WebBundlerConfig(null, null, 3, null), timestamp, 9, configPath, workingDir, this.bundlerId);
    }

    @NotNull
    protected abstract WebBundlerConfig parseJsonResult(@NotNull String var1, @NotNull NodeTargetRun var2);

    private final void showErrorNotification(String configPath, ProcessOutput output) {
        String string = this.getErrorMessage(configPath, output);
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
        WebBundlerNotifier.notify$default(WebBundlerNotifier.INSTANCE, this.project, string, messageType, configPath, this.bundlerId, null, 32, null);
    }

    @NlsContexts.NotificationContent
    private final String getErrorMessage(String configPath, ProcessOutput output) {
        Object[] objectArray = new Object[]{"<a href=\"#\">" + PathUtil.getFileName((String)configPath) + "</a>"};
        String string = JavaScriptBundle.message("web.bundler.cannot.analyze", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        HtmlBuilder builder2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().addRaw(message)).append((HtmlChunk)HtmlChunk.br());
        String details = this.getErrorDetails(output);
        if (((CharSequence)details).length() > 0) {
            Object[] objectArray2 = new Object[]{details};
            v1 = builder2.append((HtmlChunk)HtmlChunk.p().addText(JavaScriptBundle.message("web.bundler.error.details", objectArray2)));
        } else {
            v1 = builder2.append((HtmlChunk)HtmlChunk.p().addText(JavaScriptBundle.message("web.bundler.possible.reasons", new Object[0])));
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    protected String getErrorDetails(@NotNull ProcessOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string = output.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        char[] cArray = new char[]{'\n', '\r'};
        for (String part : StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
            MatchResult match = Regex.find$default((Regex)ERROR_REGEX, (CharSequence)part, (int)0, (int)2, null);
            if (match == null) continue;
            String string2 = part.substring(match.getRange().getLast() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return "";
    }

    private final Pair<NodeTargetRun, ProcessOutput> run(Project project, NodeJsInterpreter interpreter2, String path2, String explicitWorkingDir) {
        VirtualFile packageJson = Companion.findPackageJson(path2);
        String string = explicitWorkingDir;
        if (string == null) {
            string = this.getWorkingDir(packageJson);
        }
        String workingDir = string;
        VirtualFile virtualFile = packageJson;
        boolean isESM = virtualFile != null ? PackageJsonData.getOrCreate(virtualFile).isModuleType() : false;
        NodeTargetRun targetRun = this.createTargetRun(interpreter2, project, workingDir);
        LOG.info("Execute " + this.bundlerId + " config: path=" + path2 + ", working directory=" + workingDir);
        this.configureCommandLine(targetRun, path2, workingDir, isESM);
        KillableProcessHandler processHandler = targetRun.startProcessEx().getProcessHandler();
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess(Registry.Companion.intValue(EXECUTION_TIMEOUT_KEY, 20000), true);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput processOutput2 = processOutput;
        return new Pair((Object)targetRun, (Object)processOutput2);
    }

    private final NodeTargetRun createTargetRun(NodeJsInterpreter interpreter2, Project project, String workingDir) {
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, project, null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        targetRun.getCommandLineBuilder().setWorkingDirectory(targetRun.path(workingDir));
        targetRun.getCommandLineBuilder().addEnvironmentVariable("NODE_ENV", "development");
        return targetRun;
    }

    protected abstract void configureCommandLine(@NotNull NodeTargetRun var1, @NotNull String var2, @NotNull String var3, boolean var4);

    private final String getWorkingDir(VirtualFile packageJson) {
        String string;
        VirtualFile virtualFile = packageJson;
        if (virtualFile != null) {
            String string2 = virtualFile.getParent().getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        } else {
            String string3 = this.project.getBasePath();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string;
    }

    private final NodeJsInterpreter getInterpreter() {
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(this.project).getInterpreter();
        return interpreter2 != null && interpreter2.validate(this.project) == null ? interpreter2 : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Collection<String> convertPathsToLocal(@NotNull Collection<String> $this$convertPathsToLocal, @NotNull NodeTargetRun targetRun) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$convertPathsToLocal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        Iterable $this$map$iv = $this$convertPathsToLocal;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertPathToLocal((String)it, targetRun));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final String convertPathToLocal(@NotNull String $this$convertPathToLocal, @NotNull NodeTargetRun targetRun) {
        Intrinsics.checkNotNullParameter((Object)$this$convertPathToLocal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
        Promise<String> promise = targetRun.convertTargetPathToLocal($this$convertPathToLocal);
        if (promise.getState() == Promise.State.PENDING) {
            throw new RuntimeException("Still pending for " + $this$convertPathToLocal);
        }
        try {
            Object object = promise.blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert target path to local: " + $this$convertPathToLocal, e);
        }
    }

    private static final Pair loadConfig$lambda$0(WebBundlerConfigExecutor this$0, NodeJsInterpreter $interpreter, String $configPath, String $workingDir) {
        return this$0.run(this$0.project, $interpreter, $configPath, $workingDir);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebBundlerConfigExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ERROR_REGEX = new Regex("Error(\\s\\[\\w+])?:");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigExecutor$Companion;", "", "<init>", "()V", "EXECUTION_TIMEOUT_KEY", "", "VERSION", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ERROR_REGEX", "Lkotlin/text/Regex;", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "from", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile findPackageJson(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.findPackageJson(VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)path2)));
        }

        @Nullable
        public final VirtualFile findPackageJson(@Nullable VirtualFile from) {
            if (from == null) {
                return null;
            }
            VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(from);
            while (packageJson != null && JSLibraryUtil.hasDirectoryInPath(packageJson, "node_modules", null)) {
                packageJson = PackageJsonUtil.findUpPackageJson(packageJson.getParent().getParent());
            }
            return packageJson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

