/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum JSLanguageLevel {
    ES5(JavascriptLanguage.INSTANCE, "js.language.version.combo.es5", null),
    ES6(JavaScriptSupportLoader.ECMA_SCRIPT_6, "js.language.version.combo.es6", "js.language.version.combo.es6.description"),
    FLOW(JavaScriptSupportLoader.FLOW_JS, "js.language.version.combo.flow", "js.language.version.combo.flow.description");

    public static final Map<String, JSLanguageLevel> OBSOLETE_LEVELS;
    public static final JSLanguageLevel DEFAULT;
    private final @NotNull Supplier<@Nls String> myLabel;
    private final @NotNull Supplier<@Nls String> myDescription;
    private final JSLanguageDialect myDialect;

    private JSLanguageLevel(@PropertyKey(resourceBundle="messages.JavaScriptBundle") @Nullable @PropertyKey(resourceBundle="messages.JavaScriptBundle") @Nullable JSLanguageDialect dialect, String resourceId, String descriptionId) {
        if (dialect == null) {
            JSLanguageLevel.$$$reportNull$$$0(0);
        }
        this.myLabel = JavaScriptBundle.messagePointer(resourceId, new Object[0]);
        this.myDescription = descriptionId != null ? JavaScriptBundle.messagePointer(descriptionId, new Object[0]) : () -> "";
        this.myDialect = dialect;
    }

    @Nls
    public String toString() {
        return this.myLabel.get();
    }

    public String getId() {
        return super.toString();
    }

    @NotNull
    public JSLanguageDialect getDialect() {
        JSLanguageDialect jSLanguageDialect = this.myDialect;
        if (jSLanguageDialect == null) {
            JSLanguageLevel.$$$reportNull$$$0(1);
        }
        return jSLanguageDialect;
    }

    @Nls
    public String getDescription() {
        return this.myDescription.get();
    }

    @Nullable
    public static JSLanguageLevel ofElement(@NotNull PsiElement element) {
        JSLanguageDialect dialect;
        if (element == null) {
            JSLanguageLevel.$$$reportNull$$$0(2);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(element)) != null && dialect.getOptionHolder().isJavaScript()) {
            JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(element.getContainingFile(), element.getProject());
            if (level.getDialect().isAtLeast(dialect)) {
                return level;
            }
            JSLanguageLevel value = JSLanguageLevel.ofDialect(dialect);
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    @Nullable
    public static JSLanguageLevel ofDialect(@Nullable JSLanguageDialect dialect) {
        for (JSLanguageLevel value : JSLanguageLevel.values()) {
            if (value.getDialect() != dialect) continue;
            return value;
        }
        return null;
    }

    public boolean isAtLeast(@NotNull JSLanguageLevel level) {
        if (level == null) {
            JSLanguageLevel.$$$reportNull$$$0(3);
        }
        if (level == this) {
            return true;
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ES5 -> false;
            case ES6 -> ES5.isAtLeast(level);
            case FLOW -> ES6.isAtLeast(level);
        };
    }

    public boolean isES6Compatible() {
        return this.isAtLeast(ES6);
    }

    public boolean isXmlEnabled() {
        return this.getDialect().getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    @NotNull
    public static JSLanguageLevel ofId(@Nullable String id) {
        for (JSLanguageLevel level : JSLanguageLevel.values()) {
            if (!level.getId().equals(id)) continue;
            JSLanguageLevel jSLanguageLevel = level;
            if (jSLanguageLevel == null) {
                JSLanguageLevel.$$$reportNull$$$0(4);
            }
            return jSLanguageLevel;
        }
        if (id == null) {
            JSLanguageLevel jSLanguageLevel = DEFAULT;
            if (jSLanguageLevel == null) {
                JSLanguageLevel.$$$reportNull$$$0(5);
            }
            return jSLanguageLevel;
        }
        JSLanguageLevel jSLanguageLevel = OBSOLETE_LEVELS.getOrDefault(id, DEFAULT);
        if (jSLanguageLevel == null) {
            JSLanguageLevel.$$$reportNull$$$0(6);
        }
        return jSLanguageLevel;
    }

    @NotNull
    public static List<JSLanguageLevel> getVisibleLevels() {
        return new ArrayList<JSLanguageLevel>(Arrays.asList(JSLanguageLevel.values()));
    }

    @NotNull
    public static JSLanguageLevel getLevelForJSX() {
        JSLanguageLevel jSLanguageLevel = ES6;
        if (jSLanguageLevel == null) {
            JSLanguageLevel.$$$reportNull$$$0(7);
        }
        return jSLanguageLevel;
    }

    static {
        OBSOLETE_LEVELS = Map.of("JS_1_5", ES5, "JS_1_6", ES6, "JS_1_7", ES6, "JS_1_8", ES6, "JS_1_8_5", ES6, "E4X", ES6, "JSX", ES6, "NASHORN", ES6);
        DEFAULT = ES6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ofId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevelForJSX";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ofElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

