/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBraceMatcher
implements PairedBraceMatcher,
BraceMatcherTerminationAspect {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(JSTokenTypes.LPAR, JSTokenTypes.RPAR, false), new BracePair(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, false), new BracePair(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, true), new BracePair(JSTokenTypes.XML_LBRACE, JSTokenTypes.XML_RBRACE, false), new BracePair(JSDocTokenTypes.DOC_LBRACE, JSDocTokenTypes.DOC_RBRACE, false), new BracePair(JSDocTokenTypes.DOC_LPAR, JSDocTokenTypes.DOC_RPAR, false), new BracePair(JSDocTokenTypes.DOC_LBRACKET, JSDocTokenTypes.DOC_RBRACKET, false), new BracePair(JSDocTokenTypes.DOC_LT, JSDocTokenTypes.DOC_GT, false)};
    private static final TokenSet TRIGGER_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.SEMICOLON, JSTokenTypes.COMMA, JSTokenTypes.RPAR, JSTokenTypes.RBRACKET, JSTokenTypes.RBRACE, JSTokenTypes.STRING_TEMPLATE_PART, JSTokenTypes.BACKQUOTE, JSDocTokenTypes.DOC_WHITESPACE_HIGHLIGHTING, JSDocTokenTypes.DOC_COMMENT_DATA, JSDocTokenTypes.DOC_NAMEPATH_PART, JSDocTokenTypes.DOC_RBRACE, JSDocTokenTypes.DOC_RPAR, JSDocTokenTypes.DOC_RBRACKET, JSDocTokenTypes.DOC_GT, JSTokenTypes.XML_RBRACE, JSTokenTypes.XML_ATTR_VALUE_END, JSTokenTypes.XML_END_TAG_START});

    public BracePair @NotNull [] getPairs() {
        if (PAIRS == null) {
            JSBraceMatcher.$$$reportNull$$$0(0);
        }
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType tokenType) {
        if (lbraceType == null) {
            JSBraceMatcher.$$$reportNull$$$0(1);
        }
        return TRIGGER_TOKENS.contains(tokenType) || JSExtendedLanguagesTokenSetProvider.WHITE_SPACES.contains(tokenType) || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.GT && JSTokenTypes.LBRACES.contains(lbraceType) || null == tokenType;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSBlockStatement) {
            parent = parent.getParent();
        }
        return parent.getTextRange().getStartOffset();
    }

    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (braceType == null) {
            JSBraceMatcher.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            JSBraceMatcher.$$$reportNull$$$0(3);
        }
        IElementType currType = iterator.getTokenType();
        if (forward && currType == JSTokenTypes.RPAR && braceType != JSTokenTypes.LPAR) {
            int retreatCount = 0;
            iterator.retreat();
            ++retreatCount;
            currType = iterator.getTokenType();
            if (currType == JSTokenTypes.WHITE_SPACE) {
                iterator.retreat();
                ++retreatCount;
                currType = iterator.getTokenType();
            }
            for (int i = retreatCount; i > 0; --i) {
                iterator.advance();
            }
            if (currType == braceType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopMatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

