/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptVariableImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.impl.TypeScriptParameterStubImpl;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.function.JSParameterTypeDecoratorDelegate;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptParameterImpl
extends JSParameterImpl
implements TypeScriptParameter,
JSParameterTypeDecorator {
    public TypeScriptParameterImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean isConst() {
        JSAttributeList list;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (list = this.getAttributeList()) != null) {
            return list.hasModifier(JSAttributeList.ModifierType.READONLY);
        }
        return super.isConst();
    }

    public TypeScriptParameterImpl(JSParameterStub stub) {
        super(stub, TypeScriptStubElementTypes.TYPESCRIPT_PARAMETER);
    }

    @Override
    public boolean shouldSerializeType() {
        if (!super.shouldSerializeType()) {
            return false;
        }
        JSFunction getter = this.findAssociatedGetter();
        return getter == null || getter.getReturnTypeElement() == null;
    }

    @Override
    public JSType calculateDeclarationTypeStubSafe() {
        JSType type = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (type != null) {
            return this.isRest() ? TypeScriptParameterImpl.getFromRestType(type) : type;
        }
        JSType dest = TypeScriptVariableImpl.calculateDestructuringTypeStubSafe(this);
        if (dest != null) {
            return dest;
        }
        return this.tryGetTypeFromPairedAccessor();
    }

    @Override
    @Nullable
    protected JSType applyDestructuringForInitializer(@NotNull JSDestructuringContext context2, @Nullable JSType type) {
        if (context2 == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(0);
        }
        return JSWidenType.createWidening(super.applyDestructuringForInitializer(context2, type), this);
    }

    @Nullable
    private JSFunction findAssociatedGetter() {
        JSFunction function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class});
        if (function == null || !function.isSetProperty()) {
            return null;
        }
        PsiElement context2 = function.getContext();
        if (!(context2 instanceof JSElement)) {
            return null;
        }
        for (PsiElement element : JSStubBasedPsiTreeUtil.getChildrenByType(context2, JSElementTypes.FUNCTIONS)) {
            JSFunction getter;
            if (!(element instanceof JSFunction) || !(getter = (JSFunction)element).isGetProperty() || !ES6PsiUtil.checkNamesEquivalent(getter, function)) continue;
            return getter;
        }
        return null;
    }

    @Nullable
    private JSType tryGetTypeFromPairedAccessor() {
        JSFunction getter = this.findAssociatedGetter();
        return getter != null ? getter.getReturnType() : null;
    }

    private static JSType getFromRestType(@NotNull JSType type) {
        JSGenericTypeImpl genericType;
        if (type == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(1);
        }
        if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
            return ((JSArrayType)type).getType();
        }
        if (type instanceof JSGenericTypeImpl && JSArrayType.isGenericArray(genericType = (JSGenericTypeImpl)type)) {
            return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
        }
        return new JSRestTypeImpl(type, type.getSource());
    }

    @Override
    @Nullable
    public JSType doGetExplicitlyDeclaredType() {
        return this.calculateDeclarationTypeStubSafe();
    }

    @Override
    public boolean isOptional() {
        TypeScriptParameterStubImpl parameterStub = (TypeScriptParameterStubImpl)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        return this.calculateIsOptional();
    }

    @Override
    public boolean calculateIsOptional() {
        if (this.isDeclaredOptional()) {
            return true;
        }
        if (this.getInitializer() == null) {
            return false;
        }
        return this.isOptionalForParameterWithInitializer();
    }

    public boolean isDeclaredOptional() {
        return this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    private boolean isOptionalForParameterWithInitializer() {
        JSFunction function = this.getDeclaringFunction();
        if (function == null) {
            return true;
        }
        boolean checkCurrent = false;
        for (JSParameterListElement parameter : function.getParameters()) {
            if (parameter == this) {
                checkCurrent = true;
                continue;
            }
            if (!checkCurrent) continue;
            if (parameter.isOptional() || parameter.isRest()) break;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JSClass parentClass;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (parentClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class)) != null) {
            JSAttributeList.AccessType accessType = this.getAccessType();
            Object object = accessType == JSAttributeList.AccessType.PRIVATE ? new LocalSearchScope((PsiElement)parentClass) : parentClass.getUseScope();
            if (object == null) {
                TypeScriptParameterImpl.$$$reportNull$$$0(2);
            }
            return object;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(3);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getExplicitAccessType();
            if (type != null) {
                JSAttributeList.AccessType accessType = type;
                if (accessType == null) {
                    TypeScriptParameterImpl.$$$reportNull$$$0(4);
                }
                return accessType;
            }
            if (TypeScriptPsiUtil.isFieldParameter(this)) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    TypeScriptParameterImpl.$$$reportNull$$$0(5);
                }
                return accessType;
            }
        }
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(6);
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        JSType overridden = this.getSimpleType();
        return this.isOptional() ? JSTypeGuardUtil.wrapWithUndefined(overridden, null) : overridden;
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        JSType type;
        JSType newType;
        if (childTransform == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(7);
        }
        if ((newType = JSTypeUtils.transformTypeHierarchySafe(type = this.getSimpleType(), childTransform)) == type) {
            TypeScriptParameterImpl typeScriptParameterImpl = this;
            if (typeScriptParameterImpl == null) {
                TypeScriptParameterImpl.$$$reportNull$$$0(8);
            }
            return typeScriptParameterImpl;
        }
        return childTransform instanceof JSTypeBaseImpl.SourceTransformer ? new JSParameterTypeDecoratorImpl(this.getName(), newType, this.isOptional(), this.isRest(), this.isExplicitlyDeclared()) : new JSParameterTypeDecoratorDelegate(this, newType);
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        TypeScriptParameterImpl typeScriptParameterImpl = this;
        if (typeScriptParameterImpl == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(9);
        }
        return typeScriptParameterImpl;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    protected boolean isTypeStrict() {
        return true;
    }

    @Override
    public boolean calculateIsTypeStrict() {
        return true;
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return false;
    }

    @Override
    public boolean isDecoratorRest() {
        return this.isRest();
    }

    @Override
    public boolean calcIsTypeRest() {
        return this.isRest();
    }

    @Override
    public boolean isExplicitlyDeclared() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyDestructuringForInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFromRestType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }
}

