/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvidersRegistry;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webSymbols.declarations.WebSymbolDeclarationProvider;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralExpressionImpl
extends JSImplicitElementProviderImpl<JSLiteralExpressionStub>
implements JSLiteralExpression,
PsiLanguageInjectionHost,
HintedReferenceHost {
    public static final String BIG_INT_SUFFIX = "n";
    public static final BigInteger INT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final TokenSet BACKQUOTES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.BACKQUOTE});
    public static final int MAX_LITERAL_PROCESSING_SIZE = 4096;
    private static final Key<CachedValue<PsiReference[]>> REFERENCES_KEY = new Key("js.literal.expression.references");

    public JSLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, JSStubElementTypes.LITERAL_EXPRESSION);
    }

    protected JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub, IStubElementType type) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(stub, type);
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public PsiReference @NotNull [] getReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (hints != PsiReferenceService.Hints.NO_HINTS) {
            PsiReference[] psiReferenceArray = this.createRefs(hints);
            if (psiReferenceArray == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, REFERENCES_KEY, () -> new CachedValueProvider.Result((Object)this.createRefs(PsiReferenceService.Hints.NO_HINTS), new Object[]{this}));
        if (psiReferenceArray == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    private PsiReference[] createRefs(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        JSElementIndexingData indexingData;
        if (hints == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if ((indexingData = this.getIndexingData()) != null && !ContainerUtil.isEmpty(indexingData.getImplicitElements())) {
            return PsiReference.EMPTY_ARRAY;
        }
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        if (kind.isNumeric() || kind.isBoolean() || kind == JSLiteralExpressionKind.NULL) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] result2 = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)hints);
        if (result2.length == 0 && this.getTextLength() < 4096 && kind != JSLiteralExpressionKind.TEMPLATE_WITH_ARGS && this.isQuotedLiteral()) {
            JSStringLiteralValueReferenceSet refSet = new JSStringLiteralValueReferenceSet((PsiElement)this);
            refSet.update(this.getText(), 0);
            Object[] references = refSet.getReferences();
            return references.length == 0 || ContainerUtil.and((Object[])references, it -> it.isSoft()) && (this.hasSymbolReferences() || this.hasSymbolDeclarations()) || this.hasInjections() ? PsiReference.EMPTY_ARRAY : references;
        }
        return result2.length == 0 || this.hasInjections() ? PsiReference.EMPTY_ARRAY : result2;
    }

    public boolean shouldAskParentForReferences(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        return true;
    }

    private boolean hasInjections() {
        Ref result2 = new Ref();
        InjectedLanguageManager.getInstance((Project)this.getProject()).enumerate((PsiElement)this, (injectedPsi, places) -> result2.set((Object)true));
        return Boolean.TRUE == result2.get();
    }

    private boolean hasSymbolDeclarations() {
        return !WebSymbolDeclarationProvider.getAllDeclarations((PsiElement)this, (int)-1).isEmpty();
    }

    private boolean hasSymbolReferences() {
        return !PsiSymbolReferenceService.getService().getReferences((PsiElement)this).isEmpty();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLiteralExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        if (this instanceof JSStringTemplateExpression) {
            return this.getNode().getChildren(BACKQUOTES).length == 2;
        }
        return this.isQuotedLiteral() || this.isRegExpLiteral();
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<JSLiteralExpressionImpl> createLiteralTextEscaper() {
        return new JSStringLiteralEscaper<JSLiteralExpressionImpl>(this){

            protected boolean isRegExpLiteral() {
                return ((JSLiteralExpressionImpl)this.myHost).isRegExpLiteral();
            }

            public boolean isOneLine() {
                return !(JSLiteralExpressionImpl.this instanceof JSStringTemplateExpression);
            }

            @NotNull
            public TextRange getRelevantTextRange() {
                int length = ((JSLiteralExpressionImpl)this.myHost).getTextLength();
                if (((JSLiteralExpressionImpl)this.myHost).isQuotedLiteral() && length >= 2) {
                    TextRange textRange = TextRange.from((int)1, (int)(length - 2));
                    if (textRange == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRelevantTextRange();
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$1", "getRelevantTextRange"));
            }
        };
    }

    public static boolean isQuotedLiteral(ASTNode node) {
        return node.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && node.findChildByType(JSTokenTypes.STRING_LITERALS) != null;
    }

    @Override
    @NotNull
    public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind inexactKind = JSLiteralExpressionImpl.getExpressionKindImpl(this);
        if (inexactKind != JSLiteralExpressionKind.OTHER_NUMERIC || !computeExactNumericKind) {
            JSLiteralExpressionKind jSLiteralExpressionKind = inexactKind;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(10);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionImpl.getNumericExpressionKind(this.getText());
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(11);
        }
        return jSLiteralExpressionKind;
    }

    @NotNull
    private static JSLiteralExpressionKind getExpressionKindImpl(@NotNull JSLiteralExpressionImpl literalExpression) {
        ASTNode node;
        ASTNode firstChild;
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        if ((firstChild = (node = literalExpression.getNode()).getFirstChildNode()) == null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.UNKNOWN;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(13);
            }
            return jSLiteralExpressionKind;
        }
        IElementType elementType = firstChild.getElementType();
        JSLiteralExpressionKind customKind = JSInheritedLanguagesHelper.getCustomLiteralKind(literalExpression, elementType);
        if (customKind != null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = customKind;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(14);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.TRUE_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.TRUE;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(15);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.FALSE_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.FALSE;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(16);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.NUMERIC_LITERAL) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.OTHER_NUMERIC;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(17);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.REGEXP_LITERAL) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.REGEXP;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(18);
            }
            return jSLiteralExpressionKind;
        }
        if (elementType == JSTokenTypes.NULL_KEYWORD) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.NULL;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(19);
            }
            return jSLiteralExpressionKind;
        }
        if (JSLiteralExpressionImpl.isQuotedLiteral(node)) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.QUOTED;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(20);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.UNKNOWN;
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(21);
        }
        return jSLiteralExpressionKind;
    }

    public static JSLiteralExpressionKind getNumericExpressionKind(@NonNls String text) {
        if (StringUtil.startsWithChar((CharSequence)text, (char)'-')) {
            text = text.substring(1);
        }
        for (Map.Entry<Condition<String>, JSLiteralExpressionKind> entry : JSStringUtil.NUMERIC_MATCHERS.entrySet()) {
            if (!entry.getKey().value((Object)text)) continue;
            JSLiteralExpressionKind value = entry.getValue();
            return StringUtil.endsWith((CharSequence)text, (CharSequence)BIG_INT_SUFFIX) ? value.toBigInt() : value;
        }
        return JSLiteralExpressionKind.OTHER_NUMERIC;
    }

    @Override
    public JSExpression replace(@NotNull JSExpression other) {
        if (other == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(22);
        }
        return JSChangeUtil.replaceExpression(this, other);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        return ((JSLiteralImplicitElementProvidersRegistry)ApplicationManager.getApplication().getService(JSLiteralImplicitElementProvidersRegistry.class)).calculateIndexingData(this);
    }

    @Override
    @Nullable
    public String getValueAsPropertyName() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        String text = this.getText();
        if ("undefined".equals(text)) {
            return text;
        }
        if (kind == JSLiteralExpressionKind.NULL) {
            return "null";
        }
        Object value = this.getValue();
        if (value instanceof Boolean || value instanceof BigInteger) {
            return value.toString();
        }
        if (value instanceof Number) {
            return JSPsiImplUtils.convertECMAScriptNumberToString(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getValue() {
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        JSLiteralExpressionKind kind = this.getExpressionKind(true);
        if (kind.isNumeric()) {
            try {
                double t;
                if (kind.isBigInteger()) {
                    return JSNumberParser.tryParseBigInt(expressionText, kind);
                }
                Double numericValue = JSNumberParser.tryParseNumericValue(expressionText, true);
                if (numericValue != null && !numericValue.isInfinite() && !numericValue.isNaN() && numericValue > -9.223372036854776E18 && numericValue < 9.223372036854776E18 && numericValue.equals(t = Math.ceil(numericValue))) {
                    return numericValue.longValue();
                }
                return numericValue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (kind == JSLiteralExpressionKind.TRUE) {
            return true;
        }
        if (kind == JSLiteralExpressionKind.FALSE) {
            return false;
        }
        if (kind == JSLiteralExpressionKind.QUOTED) {
            return this.getStringValue();
        }
        return expressionText;
    }

    @Override
    @Nullable
    public String getStringValue() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        if (kind.isNumeric() || kind == JSLiteralExpressionKind.TRUE || kind == JSLiteralExpressionKind.FALSE || kind == JSLiteralExpressionKind.XML) {
            return null;
        }
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        if (JSLiteralExpression.isQuotedLiteral(kind)) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(expressionText);
        }
        if (this.isRegExpLiteral()) {
            return null;
        }
        return expressionText;
    }

    @Override
    @Nullable
    public String getSignificantValue() {
        JSLiteralExpressionStub stub = (JSLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSignificantValue();
        }
        List<FrameworkIndexingHandler> extensions = FrameworkIndexingHandler.getExtensions((PsiElement)this);
        for (int i = 0; i < extensions.size(); ++i) {
            if (!extensions.get(i).hasSignificantValue(this)) continue;
            return this.getText();
        }
        return null;
    }

    public static boolean isNullExpression(@NotNull ASTNode literalExpression) {
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(23);
        }
        return literalExpression.findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKind";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKindImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRefs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionKindImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isNullExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }

    private static final class JSStringLiteralValueReferenceSet
    extends JSReferenceSet {
        private JSStringLiteralValueReferenceSet(@NotNull PsiElement element) {
            if (element == null) {
                JSStringLiteralValueReferenceSet.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected PsiReference @NotNull [] reparse(@NotNull String value, int offset) {
            if (value == null) {
                JSStringLiteralValueReferenceSet.$$$reportNull$$$0(1);
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new JSLiteralTextReference((JSReferenceSet)this, value, offset)};
            if (psiReferenceArray == null) {
                JSStringLiteralValueReferenceSet.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$JSStringLiteralValueReferenceSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$JSStringLiteralValueReferenceSet";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reparse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reparse";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

