/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedElementImpl<T extends NamedStub<?> & JSStubElement<?>>
extends JSStubElementImpl<T>
implements JSPsiNamedElementBase,
JSNamedElement {
    public JSNamedElementImpl(ASTNode node) {
        super(node);
    }

    public JSNamedElementImpl(T t, IStubElementType type) {
        super(t, type);
    }

    @Override
    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            JSNamedElementImpl.$$$reportNull$$$0(0);
        }
        if ((nameNode = this.findNameIdentifier()) == null || name.equals(nameNode.getText())) {
            return this;
        }
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext(name, nameNode);
        nameNode.getTreeParent().replaceChild(nameNode, nameElement);
        return this;
    }

    @Override
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode identifierNode = this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
        return identifierNode != null ? identifierNode.getText() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSNamedElementImpl", "setName"));
    }
}

