/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeFacts;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSNarrowTypeByTypeofOperation
extends JSConditionalTypeOperationBase {
    @NotNull
    private final String myValue;

    public JSNarrowTypeByTypeofOperation(@NotNull JSTypeOperation prev, @NotNull String value, boolean assumeTrue) {
        if (prev == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(0);
        }
        if (value == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(1);
        }
        super(prev, assumeTrue);
        this.myValue = value;
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type) {
        if (context2 == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)this.myValue)) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        JSTypeFacts.SimpleFact fact = JSTypeFacts.getFactsForPrimitiveType(this.myValue, this.myAssumeTrue);
        JSType primitiveType = JSNarrowTypeByTypeofOperation.buildNamedType(this.myValue, context2.getDefaultTypeSource());
        if (JSTypeUtils.isAnyType(type) && primitiveType instanceof JSPrimitiveFunctionType) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (JSTypeUtils.isNullOrUndefinedType(type) && type.isJavaScript()) {
            JSType jSType = primitiveType;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        JSType mapped = this.myAssumeTrue ? TypeScriptTypeRelations.mapType(type, (Function<? super JSType, ? extends JSType>)((Function)el -> JSNarrowTypeByTypeofOperation.narrowTypeForTypeof(el, primitiveType, context2))) : type;
        JSType jSType = JSTypeFacts.TYPE_FACTS.getTypeWithFact(mapped, fact, context2.getContextElement(), context2.strictNullChecks());
        if (jSType == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @NotNull
    private static JSType narrowTypeForTypeof(@NotNull JSType type, @NotNull JSType targetType, @NotNull JSApplyTypeOperationContext context2) {
        JSType constraint;
        if (type == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(8);
        }
        if (targetType == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(10);
        }
        if (!(targetType instanceof JSPrimitiveType) && !(targetType instanceof JSPrimitiveFunctionType)) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        if (type instanceof JSAnyType) {
            JSType jSType = targetType;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(type, targetType, context2.getSubtypingProcessingContext())) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(13);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(targetType, type, context2.getSubtypingProcessingContext())) {
            JSType jSType = targetType;
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isInstantiable(type) && ((constraint = TypeScriptTypeRelations.getBaseConstraintOfType(type, context2.getContextElement())) == null || TypeScriptTypeRelations.isTypeSubtypeOf(targetType, constraint, context2.getSubtypingProcessingContext()))) {
            JSType jSType = JSCompositeTypeFactory.createIntersectionType(List.of(type, targetType), context2.getDefaultTypeSource());
            if (jSType == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @NotNull
    private static JSType buildNamedType(@NotNull String name, @NotNull JSTypeSource source) {
        if (name == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(17);
        }
        if (source == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(18);
        }
        JSType jSType = JSNamedTypeFactory.createType(name, source.isStrict() ? source : JSTypeSourceFactory.copyTypeSource(source, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context2) {
        if (context2 == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(20);
        }
        boolean isPrimitiveType = JSTypeGuardUtil.isPrimitiveType(this.myValue);
        boolean isUndefinedOrObject = this.myValue.equals("undefined") || this.myValue.equals("object");
        Set<JSDecoratedType.TypeDecoration> prev = super.inferTypeDecoratorsImpl(context2);
        if (!isPrimitiveType || !this.myAssumeTrue || isUndefinedOrObject) {
            Set<JSDecoratedType.TypeDecoration> set = prev;
            if (set == null) {
                JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<JSDecoratedType.TypeDecoration> set = this.mergeSimilarDecorators(JSTypeGuardChecker.NOTNULL_UNDEFINED_PRIMITIVE, prev);
        if (set == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByTypeofOperation.$$$reportNull$$$0(23);
        }
        return Objects.equals(this.myValue, ((JSNarrowTypeByTypeofOperation)sameTypeOperation).myValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 19, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByTypeofOperation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByTypeofOperation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeForTypeof";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamedType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeForTypeof";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildNamedType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 19, 21, 22 -> new IllegalStateException(string);
        };
    }
}

