/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.SelectTargetsToConvertToClass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertToClassProcessor
extends BaseRefactoringProcessor {
    public static final String DEFINE_PROPERTY = "defineProperty";
    public static final String DEFINE_PROPERTIES = "defineProperties";
    public static final String CREATE = "create";
    public static final String SET_PROTOTYPE = "setPrototypeOf";
    public static final Set<String> OBJECT_METHODS = Set.of("defineProperties", "defineProperty", "create", "setPrototypeOf");
    private final ClassInheritanceNode myRoot;
    private ClassInheritanceNode[] mySelectedNodes;
    private boolean myGenerateTheWholeTree;
    private final Map<PsiElement, Integer> myConflictsOrder;
    private List<UsageInfo> myNotConvertedUsages;
    private List<PsiElement> myReplaced;

    public JSConvertToClassProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback, @NotNull JSFunction function) {
        if (project == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(0);
        }
        if (function == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(1);
        }
        super(project, prepareSuccessfulCallback);
        this.myRoot = new ClassInheritanceNode(function);
        this.myConflictsOrder = new HashMap<PsiElement, Integer>();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(2);
        }
        return new JSConvertToClassUsageViewDescriptor(this.mySelectedNodes);
    }

    protected UsageInfo @NotNull [] findUsages() {
        this.myRoot.findUsages(this.myRefactoringScope);
        UsageInfo[] usageInfoArray = this.myRoot.getInfos();
        if (usageInfoArray == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        this.myRoot.process(this.myRefactoringScope, null, true, new HashSet<JSFunction>());
        if (!this.selectNodes(refUsages)) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Arrays.sort(this.mySelectedNodes, Comparator.comparing(o -> o.getFunction().getQualifiedName()));
            for (ClassInheritanceNode node : this.mySelectedNodes) {
                conflicts.putAllValues(node.getConflicts());
                for (PsiElement element : node.getConflictShowOrder()) {
                    this.myConflictsOrder.put(element, this.myConflictsOrder.size());
                }
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(5);
        }
        return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true){

            protected void init() {
                HashMap<String, PsiElement> map2 = new HashMap<String, PsiElement>();
                for (Map.Entry entry : this.myElementConflictDescription.entrySet()) {
                    for (String s : (Collection)entry.getValue()) {
                        map2.put(s, (PsiElement)entry.getKey());
                    }
                }
                Arrays.sort(this.myConflictDescriptions, Comparator.comparing(o -> {
                    PsiElement key = (PsiElement)map2.get(o);
                    return key == null ? 0 : JSConvertToClassProcessor.this.myConflictsOrder.getOrDefault(key, 0);
                }));
                super.init();
            }
        };
    }

    private boolean selectNodes(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.myGenerateTheWholeTree) {
            this.mySelectedNodes = new ClassInheritanceNode[]{this.myRoot};
            return true;
        }
        if (this.myRoot.getParent() != null || !this.myRoot.getDescendants().isEmpty()) {
            SelectTargetsToConvertToClass selector = new SelectTargetsToConvertToClass(this.myRoot);
            selector.setSelectAll(this.myRoot.hasInheritanceConflicts());
            selector.process();
            this.mySelectedNodes = selector.getCheckedNodes();
            if (this.mySelectedNodes == null) {
                return false;
            }
        } else {
            this.mySelectedNodes = new ClassInheritanceNode[]{this.myRoot};
        }
        this.filterUsages(refUsages);
        return true;
    }

    private void filterUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(7);
        }
        ArrayList filteredUsages = new ArrayList();
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            Set<JSExpression> assignments = node.getDataProcessor().getInheritanceBuilder().getInheritanceAssignments();
            List<UsageInfo> notConvertedWithoutDuplicates = node.getDataProcessor().getConversionResults().getNotConvertedWithoutDuplicates();
            List list = ContainerUtil.filter((Object[])node.getInfos(), t -> {
                if (notConvertedWithoutDuplicates.contains(t)) {
                    return false;
                }
                JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), JSSourceElement.class);
                if (sourceElement == null) {
                    return true;
                }
                for (JSExpression assignment : assignments) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)sourceElement, (PsiElement)assignment, (boolean)false)) continue;
                    return false;
                }
                return true;
            });
            filteredUsages.addAll(list);
        }
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(8);
        }
        return usages.length > 0;
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(9);
        }
        if (usageView == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(10);
        }
        super.customizeUsagesView(viewDescriptor, usageView);
        UsageViewPresentation presentation = usageView.getPresentation();
        presentation.setShowCancelButton(true);
        presentation.setTargetsNodeText(JavaScriptBundle.message("list.item.function.to.be.converted.to.class", new Object[0]));
        presentation.setCodeUsagesString(JavaScriptBundle.message("list.item.declarations.function.members.to.be.converted.to.class.members", new Object[0]));
        presentation.setToolwindowTitle(JavaScriptBundle.message("tab.title.convert.to.class", new Object[0]));
        presentation.setTabText(JavaScriptBundle.message("tab.title.refactoring.preview", new Object[0]));
        if (this.containsReflectionProperties()) {
            JPanel panel = new JPanel(new GridBagLayout());
            JTextArea area = new JTextArea(JavaScriptBundle.message("javascript.refactoring.function.to.es6.class.defineProperty.warning.text", new Object[0]));
            area.setFont(StartupUiUtil.getLabelFont());
            area.setLineWrap(true);
            area.setOpaque(false);
            JBLabel label = new JBLabel(AllIcons.General.BalloonWarning, 2);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.ipadx = JBUIScale.scale((int)5);
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            panel.add((Component)label, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            panel.add((Component)area, gbc);
            panel.setBackground(MessageType.WARNING.getPopupBackground());
            usageView.setAdditionalComponent((JComponent)panel);
        }
    }

    private boolean containsReflectionProperties() {
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            for (UsageInfo info : node.getInfos()) {
                JSSourceElement sourceElement;
                PsiReference reference = info.getReference();
                if (!(reference instanceof JSReferenceExpression) || (sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)((JSReferenceExpression)reference), JSSourceElement.class)) == null) continue;
                Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)sourceElement, JSCallExpression.class);
                for (JSCallExpression expression : expressions) {
                    if (expression.getMethodExpression() == null || !JSConvertToClassProcessor.checkForObjectMethod(expression.getMethodExpression(), Set.of(DEFINE_PROPERTY, DEFINE_PROPERTIES, CREATE))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(11);
        }
        this.myReplaced = new ArrayList<PsiElement>();
        this.myNotConvertedUsages = new ArrayList<UsageInfo>();
        for (ClassInheritanceNode node : this.mySelectedNodes) {
            JSItemToClassDataProcessor processor = node.getDataProcessor();
            JSItemToClassConvertor convertor = new JSItemToClassConvertor(processor);
            this.myNotConvertedUsages.addAll(convertor.process(ContainerUtil.mapNotNull((Object[])usages, usage -> usage.getElement())));
            this.myReplaced.add(JSConvertToClassProcessor.replaceWithClassElement(convertor, node.getFunction()));
        }
        this.myNotConvertedUsages = ContainerUtil.filter(this.myNotConvertedUsages, u -> u.getElement() != null && !this.myReplaced.contains(u.getElement()));
    }

    protected void execute(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(12);
        }
        super.execute(usages);
        if (this.myNotConvertedUsages != null && this.myReplaced != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.showNotConverted(this.myNotConvertedUsages, this.myReplaced));
        }
    }

    public void generateTheWholeTree() {
        this.myGenerateTheWholeTree = true;
    }

    private static PsiElement replaceWithClassElement(JSItemToClassConvertor convertor, JSFunction function) {
        JSStatement statement;
        JSElement replace = null;
        if (function.getParent() instanceof JSVariable) {
            JSStatement statement2 = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)function, JSStatement.class);
            if (statement2 != null) {
                replace = statement2.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement2);
                JSVariable parent = (JSVariable)function.getParent();
                parent.delete();
            }
        } else if (function.getParent() instanceof JSAssignmentExpression && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)function, JSStatement.class)) != null) {
            replace = statement.getParent().addBefore((PsiElement)convertor.getClazz(), (PsiElement)statement);
            JSConvertToClassProcessor.removeExpression(null, (JSAssignmentExpression)function.getParent());
        }
        if (replace == null) {
            replace = JSChangeUtil.replaceElement(function, convertor.getClazz());
        }
        return replace;
    }

    private void showNotConverted(List<UsageInfo> list, Collection<PsiElement> replace) {
        if (list.isEmpty()) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setShowCancelButton(false);
        presentation.setTargetsNodeText(JavaScriptBundle.message("list.item.function.converted.to.class", new Object[0]));
        presentation.setCodeUsagesString(JavaScriptBundle.message("list.item.declarations.that.were.not.converted", new Object[0]));
        presentation.setToolwindowTitle(JavaScriptBundle.message("tab.title.convert.to.class", new Object[0]));
        presentation.setTabText(JavaScriptBundle.message("tab.title.refactoring.result", new Object[0]));
        List usages = ContainerUtil.map(list, info -> new UsageInfo2UsageAdapter(info));
        UsageViewManager.getInstance((Project)this.myProject).showUsages((UsageTarget[])ContainerUtil.map2Array(replace, UsageTarget.class, item -> new PsiElement2UsageTargetAdapter(item)), usages.toArray(Usage.EMPTY_ARRAY), presentation);
    }

    public static void removeExpression(@Nullable String name, @NotNull JSExpression expression) {
        Object object;
        JSExpression jSExpression;
        JSExpression[] arguments;
        if (expression == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(13);
        }
        if (expression instanceof JSCallExpression && JSConvertToClassProcessor.checkForObjectMethod(((JSCallExpression)expression).getMethodExpression(), Set.of(DEFINE_PROPERTIES, CREATE)) && (arguments = ((JSCallExpression)expression).getArguments()).length == 2 && (jSExpression = arguments[1]) instanceof JSObjectLiteralExpression) {
            object = (JSObjectLiteralExpression)jSExpression;
            JSProperty property = object.findProperty(name);
            if (property != null) {
                property.delete();
            }
            if (object.getProperties().length != 0) {
                return;
            }
        }
        if ((object = expression.getParent()) instanceof JSCommaExpression) {
            JSCommaExpression comma = (JSCommaExpression)object;
            JSExpression other = comma.getLOperand() == expression ? comma.getROperand() : comma.getLOperand();
            comma.replace((PsiElement)other);
        } else if (expression.getParent() instanceof JSExpressionStatement) {
            expression.getParent().delete();
        } else {
            expression.getParent().deleteChildRange((PsiElement)expression, (PsiElement)expression);
        }
    }

    static PsiReference getTopReference(@NotNull PsiReference reference) {
        PsiElement current;
        if (reference == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(14);
        }
        if (reference instanceof PsiElement) {
            current = (PsiElement)reference;
        } else {
            return null;
        }
        while (current instanceof JSReferenceExpression) {
            if (!(current.getParent() instanceof PsiReference)) {
                return (PsiReference)current;
            }
            current = current.getParent();
        }
        return null;
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull String name) {
        if (methodExpression == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(15);
        }
        if (name == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(16);
        }
        return JSConvertToClassProcessor.checkForObjectMethod(methodExpression, Set.of(name));
    }

    static boolean checkForObjectMethod(@NotNull JSExpression methodExpression, @NotNull Set<String> names) {
        if (methodExpression == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(17);
        }
        if (names == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(18);
        }
        return methodExpression instanceof JSReferenceExpression && names.contains(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && "Object".equals(((JSReferenceExpression)methodExpression).getQualifier().getText());
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaScriptBundle.message("javascript.refactoring.function.to.es6.class.command", JSFormatUtil.formatMethod(this.myRoot.getFunction(), 1, 0));
        if (string == null) {
            JSConvertToClassProcessor.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSConvertToClassProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeUsagesView";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTopReference";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkForObjectMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 19 -> new IllegalStateException(string);
        };
    }
}

