/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPullUp;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHandler;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpParameters;
import com.intellij.lang.javascript.refactoring.ui.JSClassCellRenderer;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfoStorage;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPullUpDialog
extends DialogWrapper {
    private final Validator myValidator;
    private JSMemberSelectionPanel myMemberSelectionPanel;
    private MyJSMemberInfoModel myMemberInfoModel;
    private final JSClass myClass;
    @NotNull
    private final List<JSClass> mySuperClasses;
    private final JSMemberInfoStorage myMemberInfoStorage;
    private List<JSMemberInfo> myMemberInfos;
    @Nullable
    private DocCommentPanel myDocCommentPanel;
    private ComboBox<JSClass> myClassCombo;

    public JSPullUpDialog(@NotNull JSClass aClass, @NotNull List<JSClass> superClasses, @NotNull JSMemberInfoStorage memberInfoStorage, Validator validator) {
        if (aClass == null) {
            JSPullUpDialog.$$$reportNull$$$0(0);
        }
        if (superClasses == null) {
            JSPullUpDialog.$$$reportNull$$$0(1);
        }
        if (memberInfoStorage == null) {
            JSPullUpDialog.$$$reportNull$$$0(2);
        }
        super(aClass.getProject(), true);
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myMemberInfoStorage = memberInfoStorage;
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getClassMemberInfos(aClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
        this.myValidator = validator;
        this.setTitle(JSPullUpHandler.getRefactoringName());
        this.init();
    }

    @NotNull
    public JSPullUpParameters getParameters() {
        return new JSPullUpParameters(this.getSubClass(), this.getSuperClass(), JSMemberInfo.getSelected(this.myMemberInfos, this.myClass, (Condition<? super JSMemberInfo>)((Condition)this.myMemberInfoModel::isMemberEnabled)), this.myDocCommentPanel != null ? this.myDocCommentPanel.getPolicy() : 2);
    }

    @NotNull
    public JSClass getSubClass() {
        JSClass jSClass = this.myClass;
        if (jSClass == null) {
            JSPullUpDialog.$$$reportNull$$$0(3);
        }
        return jSClass;
    }

    @NotNull
    public JSClass getSuperClass() {
        JSClass jSClass = Objects.requireNonNull((JSClass)this.myClassCombo.getSelectedItem());
        if (jSClass == null) {
            JSPullUpDialog.$$$reportNull$$$0(4);
        }
        return jSClass;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBInsets.create((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        this.myClassCombo = new ComboBox((Object[])((JSClass[])ContainerUtil.toArray(this.mySuperClasses, JSClass.ARRAY_FACTORY)));
        this.myClassCombo.setRenderer((ListCellRenderer)new JSClassCellRenderer());
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{JSRefactoringUtil.getKindAndLongName(this.myClass)}));
        classComboLabel.setLabelFor((Component)this.myClassCombo);
        JSClass nearestBase = JSInheritanceUtil.findNearestBaseClass(this.myClass, false);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.myClassCombo.setSelectedIndex(indexToSelect);
        this.myClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (DialectDetector.isActionScript(JSPullUpDialog.this.myClass)) {
                        JSPullUpDialog.this.updateJSMemberInfo();
                    }
                    if (JSPullUpDialog.this.myMemberSelectionPanel != null) {
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(JSPullUpDialog.this.myMemberInfos);
                        JSPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.myClassCombo, gbConstraints);
        return panel;
    }

    private void updateJSMemberInfo() {
        JSClass targetClass = this.getSuperClass();
        this.myMemberInfos = new ArrayList<JSMemberInfo>(this.myMemberInfoStorage.getIntermediateMemberInfosList(targetClass));
        JSMemberInfo.sortByOffset(this.myMemberInfos);
    }

    @Nullable
    protected String getHelpId() {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement(this.myClass);
        if (optionHolder != null && optionHolder.isTypeScript) {
            return "refactoring.typescript.pull.members.up";
        }
        if (optionHolder != null && optionHolder.isECMA6) {
            return "refactoring.javascript.pull.members.up";
        }
        return super.getHelpId();
    }

    protected void doOKAction() {
        JSPullUpParameters parameters = this.getParameters();
        MultiMap<PsiElement, String> conflicts = this.myValidator.checkConflicts(parameters, JSInterfaceContainmentVerifier.create(Arrays.asList(parameters.members)));
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(parameters.subClass.getProject(), conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                this.close(1);
            }
            if (ok) {
                this.close(0);
            }
        } else {
            this.close(0);
        }
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        boolean isJavaScript = DialectDetector.isJavaScript(this.myClass);
        String abstractColumnTitle = isJavaScript || this.myClass.isInterface() ? null : RefactoringBundle.message((String)"make.abstract");
        this.myMemberSelectionPanel = new JSMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pulled.up"), this.myMemberInfos, abstractColumnTitle);
        this.myMemberInfoModel = new MyJSMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.myMemberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)this.myMemberSelectionPanel, "Center");
        if (DialectDetector.isActionScript(this.myClass)) {
            this.myDocCommentPanel = new DocCommentPanel(JavaScriptBundle.message("javascript.refactoring.asdoc.for.abstracts", new Object[0]));
            UIUtil.setEnabled((Component)this.myDocCommentPanel, (!this.myClass.isInterface() ? 1 : 0) != 0, (boolean)true);
            panel.add((Component)this.myDocCommentPanel, "East");
        }
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoStorage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static interface Validator {
        public MultiMap<PsiElement, String> checkConflicts(JSPullUpParameters var1, JSInterfaceContainmentVerifier var2);
    }

    private class MyJSMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        MyJSMemberInfoModel() {
            super(JSPullUpDialog.this.myClass, JSPullUpDialog.this.getSuperClass(), false, JSInterfaceContainmentVerifier.create(JSPullUpDialog.this.myMemberInfos));
        }

        public boolean isMemberEnabled(JSMemberInfo member) {
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            JSAttributeListOwner element = (JSAttributeListOwner)member.getMember();
            if (element == null) {
                return true;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getDuplicatedMemberInfos(currentSuperClass).contains((Object)member)) {
                return false;
            }
            if (JSPullUpDialog.this.myMemberInfoStorage.getExtending(currentSuperClass).contains(element)) {
                return false;
            }
            if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
                return currentSuperClass.isInterface();
            }
            if (currentSuperClass.isInterface()) {
                if (element instanceof JSClass && ((JSClass)element).isInterface()) {
                    return true;
                }
                if (DialectDetector.isActionScript((PsiElement)element) && element instanceof JSVariable) {
                    return false;
                }
                if (element instanceof JSFunction) {
                    return !JSPsiImplUtils.hasModifier(element, JSAttributeList.ModifierType.STATIC);
                }
                return true;
            }
            return true;
        }

        public boolean isAbstractEnabled(JSMemberInfo member) {
            JSClass currentSuper = JSPullUpDialog.this.getSuperClass();
            if (!(member.getMember() instanceof JSFunction)) {
                return false;
            }
            if (member.isStatic()) {
                return false;
            }
            return !DialectDetector.isActionScript(currentSuper) && !currentSuper.isInterface();
        }

        public boolean isAbstractWhenDisabled(JSMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                MyJSMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (member.isChecked()) {
                return 0;
            }
            JSClass currentSuperClass = JSPullUpDialog.this.getSuperClass();
            if (currentSuperClass.isInterface()) {
                JSAttributeListOwner element = (JSAttributeListOwner)member.getMember();
                if (element != null && JSPsiImplUtils.hasModifier(element, JSAttributeList.ModifierType.STATIC)) {
                    return super.checkForProblems((MemberInfoBase)member);
                }
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        public Boolean isFixedAbstract(JSMemberInfo member) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/memberPullUp/JSPullUpDialog$MyJSMemberInfoModel", "checkForProblems"));
        }
    }
}

