/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.MessageStreamLoggerKt;
import com.intellij.lang.javascript.service.MessageStreamLoggerServiceKt;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\r\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "", "logPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getLogPath$intellij_javascript_impl", "()Ljava/nio/file/Path;", "writer", "Ljava/io/PrintWriter;", "getWriter", "()Ljava/io/PrintWriter;", "writer$delegate", "Lkotlin/Lazy;", "logInbound", "", "jsonBody", "", "logOutbound", "logError", "message", "formatCurrentTime", "", "close", "close$intellij_javascript_impl", "intellij.javascript.impl"})
public final class MessageStreamLogger {
    @NotNull
    private final Path logPath;
    @NotNull
    private final Lazy writer$delegate;

    public MessageStreamLogger(@NotNull Path logPath) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        this.logPath = logPath;
        this.writer$delegate = LazyKt.lazy(() -> MessageStreamLogger.writer_delegate$lambda$0(this));
    }

    @NotNull
    public final Path getLogPath$intellij_javascript_impl() {
        return this.logPath;
    }

    private final PrintWriter getWriter() {
        Lazy lazy = this.writer$delegate;
        return (PrintWriter)lazy.getValue();
    }

    public final void logInbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(this.formatCurrentTime() + " IN  " + jsonBody + "\n");
    }

    public final void logOutbound(@NotNull CharSequence jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        this.getWriter().write(this.formatCurrentTime() + " OUT " + jsonBody + "\n");
    }

    public final void logError(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getWriter().write(this.formatCurrentTime() + " ERR " + message + "\n");
    }

    private final String formatCurrentTime() {
        String string = MessageStreamLoggerKt.access$getTIMESTAMP_FORMAT$p().format(MessageStreamLoggerServiceKt.millisToDate(System.currentTimeMillis()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final void close$intellij_javascript_impl() {
        this.getWriter().close();
    }

    private static final PrintWriter writer_delegate$lambda$0(MessageStreamLogger this$0) {
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        return new PrintWriter(new BufferedOutputStream(Files.newOutputStream(this$0.logPath, openOptionArray)));
    }
}

