/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.CallingBackColoredTreeCellRenderer;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceConsole;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable {
    public static final String EMPTY_TEXT = " ";
    private static final int IGNORE_CODE = -1;
    private static final int MAX_ERRORS_COUNT = 100;
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    private volatile boolean myDisposed;
    @Nullable
    protected volatile ToolWindow myToolWindow;
    @NotNull
    protected final String myHelpId;
    @NotNull
    private final LayeredIcon myIcon;
    @NotNull
    private final Icon myErrorIcon;
    @NotNull
    private final NotNullLazyValue<AnAction[]> myCommonActions;
    @NotNull
    @NlsContexts.TabTitle
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSAnnotationError> myLastResult;
    protected final Map<String, JSLanguageServiceConsole> myServiceConsoles;
    private final Set<String> myDisconnectedConsoles;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull @NlsContexts.TabTitle String toolWindowName, @NotNull String helpId, @NotNull Icon icon, AnAction ... commonPanelActions) {
        if (project == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        if (toolWindowName == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        if (helpId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
        }
        this(project, toolWindowName, helpId, icon, (NotNullLazyValue<AnAction[]>)NotNullLazyValue.createConstantValue((Object)(commonPanelActions == null ? AnAction.EMPTY_ARRAY : commonPanelActions)));
    }

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull @NlsContexts.TabTitle String toolWindowName, @NotNull String helpId, @NotNull Icon icon, @NotNull NotNullLazyValue<AnAction[]> commonPanelActions) {
        if (project == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        if (toolWindowName == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(5);
        }
        if (helpId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(6);
        }
        if (icon == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(7);
        }
        if (commonPanelActions == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(8);
        }
        this.myDisposed = false;
        this.myServiceConsoles = new ConcurrentHashMap<String, JSLanguageServiceConsole>();
        this.myDisconnectedConsoles = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myCommonActions = commonPanelActions;
        this.myIcon = JSLanguageServiceToolWindowManager.createIcon(icon, false);
        this.myErrorIcon = JSLanguageServiceToolWindowManager.createIcon(icon, true);
    }

    private static LayeredIcon createIcon(@Nullable Icon rawIcon, boolean error) {
        if (rawIcon == null) {
            return null;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(rawIcon, 0);
        Icon errorPoint = AllIcons.Ide.ErrorPoint;
        icon.setIcon(error ? errorPoint : EmptyIcon.create((Icon)errorPoint), 1, 4);
        return icon;
    }

    public boolean needActivateProgressPanel() {
        return false;
    }

    public void setProgressText(@Nullable @NlsContexts.ProgressText String text) {
        ThreadingAssertions.assertEventDispatchThread();
        NewErrorTreeViewPanel myErrorPanel = this.myCurrentErrorTreeViewPanel;
        if (myErrorPanel != null) {
            myErrorPanel.setProgressText(StringUtil.notNullize((String)text));
            if (StringUtil.isEmpty((String)text)) {
                myErrorPanel.clearProgressData();
            }
        }
    }

    public synchronized void connectToProcessHandler(@NotNull @NlsSafe String serviceId, @NotNull ProcessHandler handler) {
        if (serviceId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(9);
        }
        if (handler == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed() || !this.myProject.isOpen() || this.myDisposed) {
            return;
        }
        this.init();
        this.cleanErrorsPanel();
        JSLanguageServiceQueue.Holder.LOGGER.debug("Creating language service " + this.myToolWindowName);
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            ConsoleViewImpl console = this.createConsole();
            console.attachToProcess(handler);
            JSConsoleViewPanel consolePanel = new JSConsoleViewPanel(this.myProject, this.myHelpId, null, (ConsoleView)console, this.getConsoleActions());
            JSLanguageServiceConsole oldConsole = this.myServiceConsoles.get(serviceId);
            if (oldConsole != null) {
                if (!this.myDisconnectedConsoles.remove(serviceId)) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Old console wasn't disconnected. Tool window: " + this.myToolWindowName + " id: " + serviceId);
                    try {
                        this.disconnectFromProcessHandler(serviceId, false);
                    }
                    catch (Exception e) {
                        JSLanguageServiceQueue.Holder.LOGGER.debug("Error while dispose: " + serviceId);
                    }
                }
                JSLanguageServiceToolWindowManager.disposePreviousConsole(oldConsole);
            }
            this.myServiceConsoles.put(serviceId, new JSLanguageServiceConsole(serviceId, toolWindow, console, consolePanel));
            this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
        }
    }

    protected AnAction @Nullable [] getConsoleActions() {
        return (AnAction[])this.myCommonActions.getValue();
    }

    @NotNull
    protected ConsoleViewImpl createConsole() {
        return new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false);
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public void lazyInit(@NotNull Condition<? super JSLanguageServiceToolWindowManager> checkInit) {
        if (checkInit == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(11);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (checkInit.value((Object)this)) {
                this.init();
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
        });
    }

    public synchronized void init() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myInitialized || this.myToolWindow == null) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.getToolWindow(this.myToolWindowName);
            if (toolWindow == null && !ApplicationManager.getApplication().isUnitTestMode()) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Tool window with id " + this.myToolWindowName + " isn't registered");
                this.myInitialized = true;
                return;
            }
            this.myToolWindow = toolWindow;
            this.myInitialized = true;
            JSLanguageServiceQueue.Holder.LOGGER.debug("Initialized tool window " + this.myToolWindowName);
            this.initDefaultPanels(toolWindow);
        }
    }

    protected void initDefaultPanels(ToolWindow toolWindow) {
        this.createCurrentTreeViewPanel();
    }

    protected void createCurrentTreeViewPanel() {
        if (this.myCurrentErrorTreeViewPanel != null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && toolWindow != null) {
            ContentImpl content = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)content);
        }
    }

    private ContentImpl createCurrentErrorContent(ToolWindow toolWindow) {
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getCurrentErrorsTitle(), false);
        contentImpl.setHelpId(this.myHelpId);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getCurrentErrorsTitle() {
        String string = JavaScriptBundle.message("tab.title.errors", new Object[0]);
        if (string == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    protected final NewErrorTreeViewPanel getCurrentErrorTreeViewPanel() {
        return this.myCurrentErrorTreeViewPanel;
    }

    @NotNull
    @NlsContexts.TabTitle
    protected String getProjectErrorsTitle() {
        String string = JavaScriptBundle.message("tab.title.project.errors", new Object[0]);
        if (string == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createCurrentErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel panel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, () -> {
            this.myLastResult = null;
        }, this.getErrorPanelLeftActions(), this.getErrorPanelRightActions(false)){

            @Override
            @Nullable
            public Object getTagAt(MouseEvent e) {
                List<JSAnnotationError> result2 = JSLanguageServiceToolWindowManager.this.myLastResult;
                if (result2 == null || result2.size() < 100) {
                    return null;
                }
                Tree component = (Tree)e.getComponent();
                Component deepest = component.getDeepestRendererComponentAt(e.getX(), e.getY());
                if (!(deepest instanceof CallingBackColoredTreeCellRenderer)) {
                    return null;
                }
                TreePath path2 = this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path2 == null) {
                    return null;
                }
                Rectangle rectangle = this.myTree.getPathBounds(path2);
                if (rectangle == null) {
                    return null;
                }
                int dx = e.getX() - rectangle.x;
                return ((CallingBackColoredTreeCellRenderer)deepest).getFragmentTagAt(dx);
            }

            public void close() {
                JSLanguageServiceToolWindowManager.this.closeCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
            }
        };
        if (this.needActivateProgressPanel()) {
            panel.setProgressText(EMPTY_TEXT);
        }
        this.updateCurrentErrorsEmptyText(panel);
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = panel;
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(14);
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    protected void closeCurrentErrorsPanel(ToolWindow toolWindow, Ref<ContentImpl> content) {
        toolWindow.hide(() -> {
            this.myLastResult = null;
            toolWindow.setIcon((Icon)this.myIcon);
            ContentImpl contentImpl = (ContentImpl)content.get();
            if (contentImpl != null) {
                toolWindow.getContentManager().removeContent((Content)contentImpl, true);
            }
            ContentImpl newContentImpl = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
        });
    }

    protected AnAction[] getErrorPanelRightActions(boolean all) {
        return AnAction.EMPTY_ARRAY;
    }

    protected AnAction[] getErrorPanelLeftActions() {
        return (AnAction[])this.myCommonActions.getValue();
    }

    public void setName(@Nullable @NlsContexts.TabTitle String newName) {
        ThreadingAssertions.assertEventDispatchThread();
        this.init();
        this.setNameNoInit(newName);
        this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
    }

    private void setNameNoInit(@Nullable @NlsContexts.TabTitle String newName) {
        ToolWindow window = this.myToolWindow;
        if (window != null) {
            String fullName = StringUtil.isEmptyOrSpaces((String)newName) ? this.myToolWindowName : this.myToolWindowName + EMPTY_TEXT + newName;
            window.setStripeTitle(fullName);
        }
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            this.init();
            toolWindow = this.myToolWindow;
        }
        if (toolWindow == null) {
            return null;
        }
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createProjectErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getProjectErrorsTitle(), false);
        contentImpl.setHelpId(this.myHelpId);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createProjectErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        return new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.getErrorPanelLeftActions(), this.getErrorPanelRightActions(true)){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
    }

    public void disconnectFromProcessHandler(@NotNull String serviceId, boolean closeAssociatedConsoleView) {
        JSLanguageServiceConsole console;
        if (serviceId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(15);
        }
        if ((console = this.myServiceConsoles.get(serviceId)) != null) {
            if (closeAssociatedConsoleView) {
                this.myServiceConsoles.remove(serviceId);
                JSLanguageServiceToolWindowManager.disposePreviousConsole(console);
            } else if (this.myDisconnectedConsoles.add(serviceId)) {
                console.print("\nDisconnected");
            }
            this.setProgressText(null);
        }
    }

    private static void disposePreviousConsole(@NotNull JSLanguageServiceConsole console) {
        if (console == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(16);
        }
        Disposer.dispose((Disposable)console);
    }

    public void logProjectErrors(@NotNull List<JSAnnotationError> results, boolean setActive) {
        NewErrorTreeViewPanel panel;
        if (results == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(17);
        }
        if ((panel = this.createProjectErrorsPanel()) == null) {
            return;
        }
        this.logErrorsImpl(panel, results, false);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    protected NewErrorTreeViewPanel createOrGetCurrentTreeViewPanel() {
        this.init();
        return this.myCurrentErrorTreeViewPanel;
    }

    public void logCurrentErrors(@NotNull List<JSAnnotationError> results, boolean setActive) {
        ArrayList<JSAnnotationError> list;
        if (results == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.createOrGetCurrentTreeViewPanel();
        if (errorTreeViewPanel == null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && !(list = new ArrayList<JSAnnotationError>(results)).equals(this.myLastResult)) {
            this.logErrorsImpl(errorTreeViewPanel, list, true);
            this.myLastResult = list;
            if (toolWindow != null) {
                LayeredIcon newIcon;
                Icon oldIcon = toolWindow.getIcon();
                Object object = newIcon = list.size() > 0 && list.stream().anyMatch(el -> "error".equals(el.getCategory())) ? this.myErrorIcon : this.myIcon;
                if (oldIcon != newIcon) {
                    toolWindow.setIcon((Icon)newIcon);
                }
            }
        }
        if (toolWindow != null && setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSAnnotationError> list, boolean limit) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (int i = 0; i < list.size(); ++i) {
            int category;
            JSAnnotationError compilerResult = list.get(i);
            if (limit && i == 100) {
                this.addShowAll(errorTreeViewPanel, list.size());
                break;
            }
            String path2 = compilerResult.getAbsoluteFilePath();
            VirtualFile file = null;
            if (path2 != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
            }
            if ((category = JSLanguageServiceToolWindowManager.parseCategory(compilerResult)) == -1) continue;
            this.doAddMessage(errorTreeViewPanel, compilerResult, file, category);
        }
        errorTreeViewPanel.updateTree();
    }

    private void addShowAll(NewErrorTreeViewPanel errorTreeViewPanel, int total) {
        ErrorViewStructure structure = errorTreeViewPanel.getErrorViewStructure();
        structure.addSimpleMessageElement((ErrorTreeElement)new JSToolWindowMessageElement(errorTreeViewPanel, total));
    }

    private static int parseCategory(@NotNull JSAnnotationError compilerResult) {
        String category;
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(19);
        }
        if ((category = compilerResult.getCategory()) == null) {
            return 4;
        }
        return switch (StringUtil.toLowerCase((String)category)) {
            case "info", "suggestion" -> 3;
            case "warning" -> 5;
            default -> 4;
        };
    }

    protected void doAddMessage(@NotNull NewErrorTreeViewPanel errorTreeViewPanel, @NotNull JSAnnotationError compilerResult, @Nullable VirtualFile file, int category) {
        if (errorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(20);
        }
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(21);
        }
        String description = StringUtil.notNullize((String)compilerResult.getDescription());
        String[] messages = description.split("\n");
        errorTreeViewPanel.addMessage(category, messages, file, compilerResult.getLine(), compilerResult.getColumn(), null);
    }

    public synchronized void dispose() {
        this.disposeConsoles();
        this.resetToolWindow();
        this.myDisposed = true;
    }

    private synchronized void disposeConsoles() {
        for (JSLanguageServiceConsole console : this.myServiceConsoles.values()) {
            if (console == null) continue;
            try {
                Disposer.dispose((Disposable)console);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.myServiceConsoles.clear();
    }

    public void cleanErrorsPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        NewErrorTreeViewPanel panel = this.myCurrentErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
            this.myLastResult = null;
            this.updateCurrentErrorsEmptyText(panel);
        }
    }

    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.hasActiveConsoles()) {
            JSLanguageServiceToolWindowManager.setNotStartedText(panel);
            return;
        }
        panel.getEmptyText().setText(JSLanguageServiceErrorTreeViewPanel.getDefaultNoErrorsText());
    }

    protected final boolean hasActiveConsoles() {
        return this.myServiceConsoles.size() - this.myDisconnectedConsoles.size() > 0;
    }

    private static void setNotStartedText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(23);
        }
        StatusText text = panel.getEmptyText();
        text.clear();
        text.setText(JavaScriptBundle.message("javascript.language.service.tracking.is.not.started", new Object[0]));
    }

    public synchronized void resetToolWindow() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myServiceConsoles.isEmpty()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ThreadingAssertions.assertEventDispatchThread();
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }

    public synchronized void partiallyResetToolWindow() {
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (this.hasActiveConsoles()) {
            return;
        }
        window.setIcon((Icon)this.myIcon);
        this.cleanErrorsPanel();
        this.setNameNoInit(null);
    }

    @Nullable
    public ErrorTreeElement getSelectedElement() {
        JComponent contentComponent;
        Content selectedContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null && (selectedContent = toolWindow.getContentManager().getSelectedContent()) != null && (contentComponent = selectedContent.getComponent()) instanceof JSLanguageServiceErrorTreeViewPanel) {
            return ((JSLanguageServiceErrorTreeViewPanel)((Object)contentComponent)).getSelectedErrorTreeElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonPanelActions";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkInit";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerResult";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTreeViewPanel";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentErrorsTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurrentErrorsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "connectToProcessHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lazyInit";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disconnectFromProcessHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disposePreviousConsole";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logProjectErrors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logCurrentErrors";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseCategory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doAddMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setNotStartedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    private class JSToolWindowMessageElement
    extends NavigatableMessageElement {
        private final NewErrorTreeViewPanel myErrorTreeViewPanel;
        private Runnable myTag;
        private final CustomizeColoredTreeCellRenderer myLeftTreeCellRenderer;

        private void loadAll() {
            JSLanguageServiceToolWindowManager.this.logErrorsImpl(this.myErrorTreeViewPanel, JSLanguageServiceToolWindowManager.this.myLastResult, false);
        }

        public JSToolWindowMessageElement(final NewErrorTreeViewPanel errorTreeViewPanel, final int total) {
            super(ErrorTreeElementKind.INFO, null, ArrayUtil.EMPTY_STRING_ARRAY, new Navigatable(){

                public void navigate(boolean requestFocus) {
                    JSLanguageServiceToolWindowManager.this.logErrorsImpl(errorTreeViewPanel, JSLanguageServiceToolWindowManager.this.myLastResult, false);
                }

                public boolean canNavigate() {
                    return true;
                }
            }, "", "");
            this.myTag = () -> {
                this.loadAll();
                this.myTag = null;
            };
            this.myLeftTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

                public void customizeCellRenderer(SimpleColoredComponent renderer, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    renderer.setIcon(AllIcons.General.Information);
                    renderer.append(JavaScriptBundle.message("js.tool.window.limit", 100));
                    renderer.append(JSLanguageServiceToolWindowManager.EMPTY_TEXT);
                    renderer.append(JavaScriptBundle.message("js.tool.window.limit.all", total), SimpleTextAttributes.LINK_BOLD_ATTRIBUTES, (Object)JSToolWindowMessageElement.this.myTag);
                }
            };
            this.myErrorTreeViewPanel = errorTreeViewPanel;
        }

        @Nullable
        public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
            return this.myLeftTreeCellRenderer;
        }
    }
}

