/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"getServiceNavigationTargets", "", "Lcom/intellij/psi/PsiElement;", "expression", "Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;", "(Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;)[Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
public final class TypeScriptServiceResolveFacadeImplKt {
    @Nullable
    public static final PsiElement[] getServiceNavigationTargets(@NotNull JSPsiReferenceElement expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiFile psiFile = expression.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile virtualFile = psiFile;
        if (virtualFile instanceof VirtualFileWindow) {
            return null;
        }
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(project, (VirtualFile)virtualFile);
        if (typeScriptService == null) {
            return null;
        }
        TypeScriptService service = typeScriptService;
        if (!service.isServiceFallbackResolveEnabled()) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        PsiElement identifier = TypeScriptCompilerService.Companion.adjustIntoIdentifier((PsiElement)expression);
        if (identifier instanceof JSPsiReferenceElement) {
            identifier = (PsiElement)ObjectUtils.coalesce((Object)((JSPsiReferenceElement)identifier).getReferenceNameElement(), (Object)identifier);
        }
        return service.getElementDefinitions(document2, identifier);
    }
}

