/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isSupported", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.javascript.impl"})
public final class TypeScriptInlayHintsSupportedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String ENABLED_KEY = "typescript.service.provideInlayHints.enabled";

    public TypeScriptInlayHintsSupportedService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isSupported(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.Companion.get(ENABLED_KEY).asBoolean()) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(this.project, virtualFile2);
        if (typeScriptService == null) {
            return false;
        }
        TypeScriptService service = typeScriptService;
        if (!(service instanceof TypeScriptCompilerService) || !service.supportsInlayHints(file)) {
            return false;
        }
        if (((Boolean)ReadAction.compute(() -> TypeScriptInlayHintsSupportedService.isSupported$lambda$0(service, virtualFile2))).booleanValue()) {
            return false;
        }
        SemVer semVer = service.getServiceVersion();
        if (semVer == null) {
            return true;
        }
        SemVer version2 = semVer;
        return version2.getMajor() >= 5 || version2.getMajor() == 4 && version2.getMinor() >= 4;
    }

    private static final Boolean isSupported$lambda$0(TypeScriptService $service, VirtualFile $virtualFile) {
        return $service.isDisabledByContext($virtualFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$Companion;", "", "<init>", "()V", "ENABLED_KEY", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

